"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, List, Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class PostAtsCandidatesPositiveResponsePhoneNumberTypedDict(TypedDict):
    phone_number: str
    type: NotRequired[Nullable[str]]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""


class PostAtsCandidatesPositiveResponsePhoneNumber(BaseModel):
    phone_number: str

    type: OptionalNullable[str] = UNSET
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type"]
        nullable_fields = ["type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesPositiveResponseEmailAddressTypedDict(TypedDict):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""
    email_address: NotRequired[Nullable[str]]


class PostAtsCandidatesPositiveResponseEmailAddress(BaseModel):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""

    email_address: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email_address"]
        nullable_fields = ["email_address", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesPositiveResponseSocialMediaTypedDict(TypedDict):
    link: NotRequired[Nullable[str]]
    type: NotRequired[Nullable[str]]
    username: NotRequired[Nullable[str]]


class PostAtsCandidatesPositiveResponseSocialMedia(BaseModel):
    link: OptionalNullable[str] = UNSET

    type: OptionalNullable[str] = UNSET

    username: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["link", "type", "username"]
        nullable_fields = ["link", "type", "username"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesPositiveResponseLocationTypedDict(TypedDict):
    r"""Location of the candidate."""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class PostAtsCandidatesPositiveResponseLocation(BaseModel):
    r"""Location of the candidate."""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostAtsCandidatesPositiveResponseOutcome = Literal[
    "PENDING",
    "HIRED",
    "DECLINED",
]
r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
Kombo will always try to deliver this information as reliably as possible.
"""


class PostAtsCandidatesPositiveResponseCurrentStageTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    name: Nullable[str]
    r"""The application stage name. For example, \"Initial Screening\"."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    index: Nullable[int]


class PostAtsCandidatesPositiveResponseCurrentStage(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    name: Nullable[str]
    r"""The application stage name. For example, \"Initial Screening\"."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    index: Nullable[int]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "remote_id", "index"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesPositiveResponseJobTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    name: Nullable[str]
    r"""Title of the job."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""


class PostAtsCandidatesPositiveResponseJob(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    name: Nullable[str]
    r"""Title of the job."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesPositiveResponseApplicationTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    outcome: Nullable[PostAtsCandidatesPositiveResponseOutcome]
    r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
    Kombo will always try to deliver this information as reliably as possible.
    """
    rejection_reason_name: Nullable[str]
    r"""Reason for the rejection of the candidate."""
    rejected_at: Nullable[datetime]
    r"""The time that the application was rejected.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_url: Nullable[str]
    r"""URL to the application in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated application URL is available, so you might need to fall back to the candidate URL."""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    current_stage: Nullable[PostAtsCandidatesPositiveResponseCurrentStageTypedDict]
    job: Nullable[PostAtsCandidatesPositiveResponseJobTypedDict]


class PostAtsCandidatesPositiveResponseApplication(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    outcome: Nullable[PostAtsCandidatesPositiveResponseOutcome]
    r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
    Kombo will always try to deliver this information as reliably as possible.
    """

    rejection_reason_name: Nullable[str]
    r"""Reason for the rejection of the candidate."""

    rejected_at: Nullable[datetime]
    r"""The time that the application was rejected.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_url: Nullable[str]
    r"""URL to the application in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated application URL is available, so you might need to fall back to the candidate URL."""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    current_stage: Nullable[PostAtsCandidatesPositiveResponseCurrentStage]

    job: Nullable[PostAtsCandidatesPositiveResponseJob]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "remote_id",
            "outcome",
            "rejection_reason_name",
            "rejected_at",
            "remote_url",
            "remote_created_at",
            "remote_updated_at",
            "current_stage",
            "job",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesPositiveResponseTagTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    name: Nullable[str]
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""


class PostAtsCandidatesPositiveResponseTag(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    name: Nullable[str]

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesPositiveResponseDataTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""First name of the candidate."""
    last_name: Nullable[str]
    r"""Last name of the candidate."""
    company: Nullable[str]
    r"""The current company of the candidate."""
    title: Nullable[str]
    r"""The current job title of the candidate."""
    confidential: Nullable[bool]
    r"""Whether the candidate’s profile is confidential in the ATS."""
    source: Nullable[str]
    r"""The hiring source of the candidate. If you're a job board or recruiting service, you can use this to validate which candidates applied through your service and ensure that the correct referral compensation is paid out."""
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    remote_url: Nullable[str]
    r"""URL to the candidate profile in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated candidate profile URL is available, so you might need to fall back to the application URL."""
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    applications: List[PostAtsCandidatesPositiveResponseApplicationTypedDict]
    tags: List[PostAtsCandidatesPositiveResponseTagTypedDict]
    phone_numbers: NotRequired[
        Nullable[List[PostAtsCandidatesPositiveResponsePhoneNumberTypedDict]]
    ]
    r"""A list of phone numbers of the candidate."""
    email_addresses: NotRequired[
        Nullable[List[PostAtsCandidatesPositiveResponseEmailAddressTypedDict]]
    ]
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""
    social_media: NotRequired[
        Nullable[List[PostAtsCandidatesPositiveResponseSocialMediaTypedDict]]
    ]
    r"""List of social media accounts of the candidate."""
    location: NotRequired[Nullable[PostAtsCandidatesPositiveResponseLocationTypedDict]]
    r"""Location of the candidate."""


class PostAtsCandidatesPositiveResponseData(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""First name of the candidate."""

    last_name: Nullable[str]
    r"""Last name of the candidate."""

    company: Nullable[str]
    r"""The current company of the candidate."""

    title: Nullable[str]
    r"""The current job title of the candidate."""

    confidential: Nullable[bool]
    r"""Whether the candidate’s profile is confidential in the ATS."""

    source: Nullable[str]
    r"""The hiring source of the candidate. If you're a job board or recruiting service, you can use this to validate which candidates applied through your service and ensure that the correct referral compensation is paid out."""

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    remote_url: Nullable[str]
    r"""URL to the candidate profile in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated candidate profile URL is available, so you might need to fall back to the application URL."""

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    applications: List[PostAtsCandidatesPositiveResponseApplication]

    tags: List[PostAtsCandidatesPositiveResponseTag]

    phone_numbers: OptionalNullable[
        List[PostAtsCandidatesPositiveResponsePhoneNumber]
    ] = UNSET
    r"""A list of phone numbers of the candidate."""

    email_addresses: OptionalNullable[
        List[PostAtsCandidatesPositiveResponseEmailAddress]
    ] = UNSET
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""

    social_media: OptionalNullable[
        List[PostAtsCandidatesPositiveResponseSocialMedia]
    ] = UNSET
    r"""List of social media accounts of the candidate."""

    location: OptionalNullable[PostAtsCandidatesPositiveResponseLocation] = UNSET
    r"""Location of the candidate."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "phone_numbers",
            "email_addresses",
            "social_media",
            "location",
        ]
        nullable_fields = [
            "first_name",
            "last_name",
            "company",
            "title",
            "confidential",
            "source",
            "phone_numbers",
            "email_addresses",
            "social_media",
            "location",
            "custom_fields",
            "remote_url",
            "remote_created_at",
            "remote_updated_at",
            "remote_deleted_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesPositiveResponseWarningTypedDict(TypedDict):
    message: str


class PostAtsCandidatesPositiveResponseWarning(BaseModel):
    message: str


class PostAtsCandidatesPositiveResponseTypedDict(TypedDict):
    data: PostAtsCandidatesPositiveResponseDataTypedDict
    warnings: List[PostAtsCandidatesPositiveResponseWarningTypedDict]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""
    status: Literal["success"]


class PostAtsCandidatesPositiveResponse(BaseModel):
    data: PostAtsCandidatesPositiveResponseData

    warnings: List[PostAtsCandidatesPositiveResponseWarning]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
