"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import (
    Annotated,
    NotRequired,
    TypeAliasType,
    TypedDict,
    deprecated,
)


PostAtsCandidatesRequestBodyAdditionalEmailAddressType = Literal[
    "PERSONAL",
    "WORK",
    "OTHER",
]


class PostAtsCandidatesRequestBodyAdditionalEmailAddressTypedDict(TypedDict):
    type: PostAtsCandidatesRequestBodyAdditionalEmailAddressType
    email_address: str


class PostAtsCandidatesRequestBodyAdditionalEmailAddress(BaseModel):
    type: PostAtsCandidatesRequestBodyAdditionalEmailAddressType

    email_address: str


PostAtsCandidatesRequestBodyAdditionalPhoneNumberType = Literal[
    "PERSONAL",
    "WORK",
    "OTHER",
]


class PostAtsCandidatesRequestBodyAdditionalPhoneNumberTypedDict(TypedDict):
    type: PostAtsCandidatesRequestBodyAdditionalPhoneNumberType
    phone_number: str


class PostAtsCandidatesRequestBodyAdditionalPhoneNumber(BaseModel):
    type: PostAtsCandidatesRequestBodyAdditionalPhoneNumberType

    phone_number: str


class PostAtsCandidatesRequestBodyLocationTypedDict(TypedDict):
    r"""The location of the candidate."""

    country: str
    r"""The uppercase two-letter ISO country (e.g., `DE`). For systems that use codes in formats other than `ISO 3166-1 alpha-2`, Kombo transforms the ISO Codes to the appropriate value."""
    city: NotRequired[str]
    state: NotRequired[str]
    zip_code: NotRequired[str]


class PostAtsCandidatesRequestBodyLocation(BaseModel):
    r"""The location of the candidate."""

    country: str
    r"""The uppercase two-letter ISO country (e.g., `DE`). For systems that use codes in formats other than `ISO 3166-1 alpha-2`, Kombo transforms the ISO Codes to the appropriate value."""

    city: Optional[str] = None

    state: Optional[str] = None

    zip_code: Optional[str] = None


PostAtsCandidatesRequestBodyGender = Literal[
    "MALE",
    "FEMALE",
    "OTHER",
]
r"""The gender of the candidate. Must be one of `MALE`, `FEMALE`, or `OTHER`."""


PostAtsCandidatesRequestBodyPeriod = Literal[
    "MONTH",
    "YEAR",
]
r"""The period of the salary expectations. Must be one of `MONTH` or `YEAR`."""


class PostAtsCandidatesRequestBodySalaryExpectationsTypedDict(TypedDict):
    r"""The salary expectations of the applicant. We will automatically convert the amount to a format that is suitable for the ATS you are using. For example, if you are using monthly salary expectations, we will convert the amount to a yearly salary if the ATS expects yearly salary expectations."""

    period: PostAtsCandidatesRequestBodyPeriod
    r"""The period of the salary expectations. Must be one of `MONTH` or `YEAR`."""
    amount: float
    r"""The amount of the salary expectations."""


class PostAtsCandidatesRequestBodySalaryExpectations(BaseModel):
    r"""The salary expectations of the applicant. We will automatically convert the amount to a format that is suitable for the ATS you are using. For example, if you are using monthly salary expectations, we will convert the amount to a yearly salary if the ATS expects yearly salary expectations."""

    period: PostAtsCandidatesRequestBodyPeriod
    r"""The period of the salary expectations. Must be one of `MONTH` or `YEAR`."""

    amount: float
    r"""The amount of the salary expectations."""


class PostAtsCandidatesRequestBodySocialLinkTypedDict(TypedDict):
    url: str


class PostAtsCandidatesRequestBodySocialLink(BaseModel):
    url: str


class PostAtsCandidatesRequestBodyCandidateTypedDict(TypedDict):
    first_name: str
    r"""The first name of the candidate."""
    last_name: str
    r"""The last name of the candidate."""
    email_address: str
    r"""The primary email address this application will be created with."""
    additional_email_addresses: NotRequired[
        List[PostAtsCandidatesRequestBodyAdditionalEmailAddressTypedDict]
    ]
    company: NotRequired[str]
    r"""The company where the candidate is currently working."""
    title: NotRequired[str]
    r"""The current job title of the candidate."""
    phone_number: NotRequired[str]
    r"""The phone number of the candidate."""
    additional_phone_numbers: NotRequired[
        List[PostAtsCandidatesRequestBodyAdditionalPhoneNumberTypedDict]
    ]
    location: NotRequired[PostAtsCandidatesRequestBodyLocationTypedDict]
    r"""The location of the candidate."""
    gender: NotRequired[PostAtsCandidatesRequestBodyGender]
    r"""The gender of the candidate. Must be one of `MALE`, `FEMALE`, or `OTHER`."""
    availability_date: NotRequired[datetime]
    r"""The date the candidate is available to start working.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    salary_expectations: NotRequired[
        PostAtsCandidatesRequestBodySalaryExpectationsTypedDict
    ]
    r"""The salary expectations of the applicant. We will automatically convert the amount to a format that is suitable for the ATS you are using. For example, if you are using monthly salary expectations, we will convert the amount to a yearly salary if the ATS expects yearly salary expectations."""
    social_links: NotRequired[List[PostAtsCandidatesRequestBodySocialLinkTypedDict]]
    r"""A list of social media links of the candidate. The links must be valid URLs."""


class PostAtsCandidatesRequestBodyCandidate(BaseModel):
    first_name: str
    r"""The first name of the candidate."""

    last_name: str
    r"""The last name of the candidate."""

    email_address: str
    r"""The primary email address this application will be created with."""

    additional_email_addresses: Optional[
        List[PostAtsCandidatesRequestBodyAdditionalEmailAddress]
    ] = None

    company: Optional[str] = None
    r"""The company where the candidate is currently working."""

    title: Optional[str] = None
    r"""The current job title of the candidate."""

    phone_number: Optional[str] = None
    r"""The phone number of the candidate."""

    additional_phone_numbers: Optional[
        List[PostAtsCandidatesRequestBodyAdditionalPhoneNumber]
    ] = None

    location: Optional[PostAtsCandidatesRequestBodyLocation] = None
    r"""The location of the candidate."""

    gender: Optional[PostAtsCandidatesRequestBodyGender] = None
    r"""The gender of the candidate. Must be one of `MALE`, `FEMALE`, or `OTHER`."""

    availability_date: Optional[datetime] = None
    r"""The date the candidate is available to start working.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    salary_expectations: Optional[PostAtsCandidatesRequestBodySalaryExpectations] = None
    r"""The salary expectations of the applicant. We will automatically convert the amount to a format that is suitable for the ATS you are using. For example, if you are using monthly salary expectations, we will convert the amount to a yearly salary if the ATS expects yearly salary expectations."""

    social_links: Optional[List[PostAtsCandidatesRequestBodySocialLink]] = None
    r"""A list of social media links of the candidate. The links must be valid URLs."""


class PostAtsCandidatesRequestBodyApplicationTypedDict(TypedDict):
    r"""Currently, every candidate has one application. If you are interested in talent pools, please contact Kombo."""

    job_id: str
    r"""The Kombo ID or Remote ID of the Job this candidate should apply to. If you want to use the ID of the integrated system (remote_id) you need to prefix the ID with \"remote:\". You can use the remote ID if you do not want to sync jobs."""
    stage_id: NotRequired[str]
    r"""Stage this candidate should be in. If left out, the default stage for this job will be used."""


class PostAtsCandidatesRequestBodyApplication(BaseModel):
    r"""Currently, every candidate has one application. If you are interested in talent pools, please contact Kombo."""

    job_id: str
    r"""The Kombo ID or Remote ID of the Job this candidate should apply to. If you want to use the ID of the integrated system (remote_id) you need to prefix the ID with \"remote:\". You can use the remote ID if you do not want to sync jobs."""

    stage_id: Optional[str] = None
    r"""Stage this candidate should be in. If left out, the default stage for this job will be used."""


class PostAtsCandidatesRequestBodyAnswerTypedDict(TypedDict):
    r"""Answer to a `FILE` question."""

    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""
    content_type: NotRequired[str]
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """
    data_url: NotRequired[str]
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """
    data: NotRequired[str]
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PostAtsCandidatesRequestBodyAnswer(BaseModel):
    r"""Answer to a `FILE` question."""

    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""

    content_type: Optional[str] = None
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """

    data_url: Optional[str] = None
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """

    data: Optional[str] = None
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


PostAtsCandidatesRequestBodyAnswerUnionTypedDict = TypeAliasType(
    "PostAtsCandidatesRequestBodyAnswerUnionTypedDict",
    Union[
        PostAtsCandidatesRequestBodyAnswerTypedDict,
        str,
        bool,
        float,
        List[str],
        datetime,
    ],
)
r"""Answer to a question. This will be validated based on the question format and throw an error if the answer is invalid. Here is a description of each question type and the required answer format:

`TEXT` - Simply provide a \"string\" answer.

`SINGLE_SELECT` - Provide the ID of the answer as a string.

`MULTI_SELECT` - Provide a string array containing the question IDs of the selected options.

`BOOLEAN` - Either `true` or `false`.

`NUMBER` - A number.

`DATE` - Provide the answer as an ISO 8601 date string.

`FILE` - Please select Option 6 in the dropdown above to see the required format.
"""


PostAtsCandidatesRequestBodyAnswerUnion = TypeAliasType(
    "PostAtsCandidatesRequestBodyAnswerUnion",
    Union[PostAtsCandidatesRequestBodyAnswer, str, bool, float, List[str], datetime],
)
r"""Answer to a question. This will be validated based on the question format and throw an error if the answer is invalid. Here is a description of each question type and the required answer format:

`TEXT` - Simply provide a \"string\" answer.

`SINGLE_SELECT` - Provide the ID of the answer as a string.

`MULTI_SELECT` - Provide a string array containing the question IDs of the selected options.

`BOOLEAN` - Either `true` or `false`.

`NUMBER` - A number.

`DATE` - Provide the answer as an ISO 8601 date string.

`FILE` - Please select Option 6 in the dropdown above to see the required format.
"""


class PostAtsCandidatesRequestBodyScreeningQuestionAnswerTypedDict(TypedDict):
    question_id: str
    r"""ID of the question returned by the Kombo API. We'll report a warning in the logs if the question can't be found on the job."""
    answer: PostAtsCandidatesRequestBodyAnswerUnionTypedDict
    r"""Answer to a question. This will be validated based on the question format and throw an error if the answer is invalid. Here is a description of each question type and the required answer format:

    `TEXT` - Simply provide a \"string\" answer.

    `SINGLE_SELECT` - Provide the ID of the answer as a string.

    `MULTI_SELECT` - Provide a string array containing the question IDs of the selected options.

    `BOOLEAN` - Either `true` or `false`.

    `NUMBER` - A number.

    `DATE` - Provide the answer as an ISO 8601 date string.

    `FILE` - Please select Option 6 in the dropdown above to see the required format.
    """


class PostAtsCandidatesRequestBodyScreeningQuestionAnswer(BaseModel):
    question_id: str
    r"""ID of the question returned by the Kombo API. We'll report a warning in the logs if the question can't be found on the job."""

    answer: PostAtsCandidatesRequestBodyAnswerUnion
    r"""Answer to a question. This will be validated based on the question format and throw an error if the answer is invalid. Here is a description of each question type and the required answer format:

    `TEXT` - Simply provide a \"string\" answer.

    `SINGLE_SELECT` - Provide the ID of the answer as a string.

    `MULTI_SELECT` - Provide a string array containing the question IDs of the selected options.

    `BOOLEAN` - Either `true` or `false`.

    `NUMBER` - A number.

    `DATE` - Provide the answer as an ISO 8601 date string.

    `FILE` - Please select Option 6 in the dropdown above to see the required format.
    """


PostAtsCandidatesRequestBodyAttachmentType = Literal[
    "CV",
    "COVER_LETTER",
    "OTHER",
]
r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""


class PostAtsCandidatesRequestBodyAttachmentTypedDict(TypedDict):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""
    type: PostAtsCandidatesRequestBodyAttachmentType
    r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""
    content_type: NotRequired[str]
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """
    data_url: NotRequired[str]
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """
    data: NotRequired[str]
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PostAtsCandidatesRequestBodyAttachment(BaseModel):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""

    type: PostAtsCandidatesRequestBodyAttachmentType
    r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""

    content_type: Optional[str] = None
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """

    data_url: Optional[str] = None
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """

    data: Optional[str] = None
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


@deprecated(
    "warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
)
class PostAtsCandidatesRequestBodySourceTypedDict(TypedDict):
    r"""**(⚠️ Deprecated - Use [automatic source writing](/ats/features/application-attribution#automatic-attribution) instead)** Optional source information that will be attached to the candidate. If
    you're a job board or recruiting service, you can use this to make sure your
    customers can see which candidates came from you.

    This is deprecated because writing sources requires users to do some setup in most ATSs.
    """

    name: NotRequired[str]
    r"""Name of the source (e.g., `\"Example Job Board\"`)."""
    unified_key: NotRequired[str]
    id: NotRequired[str]


@deprecated(
    "warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
)
class PostAtsCandidatesRequestBodySource(BaseModel):
    r"""**(⚠️ Deprecated - Use [automatic source writing](/ats/features/application-attribution#automatic-attribution) instead)** Optional source information that will be attached to the candidate. If
    you're a job board or recruiting service, you can use this to make sure your
    customers can see which candidates came from you.

    This is deprecated because writing sources requires users to do some setup in most ATSs.
    """

    name: Optional[str] = None
    r"""Name of the source (e.g., `\"Example Job Board\"`)."""

    unified_key: Optional[str] = None

    id: Optional[str] = None


class PostAtsCandidatesRequestBodySourcedByTypedDict(TypedDict):
    r"""Credit the recruiter or team member who sourced this candidate.

    While the `source` field tracks the channel/platform (e.g., \"Awesome Jobboard\"), the `sourced_by` field tracks the individual person responsible for finding the candidate.
    """

    user_id: str
    r"""The Kombo ID or Remote ID of the User. Use the Kombo ID directly, or prefix the remote ID with \"remote:\" to reference the user by their ID in the remote system."""


class PostAtsCandidatesRequestBodySourcedBy(BaseModel):
    r"""Credit the recruiter or team member who sourced this candidate.

    While the `source` field tracks the channel/platform (e.g., \"Awesome Jobboard\"), the `sourced_by` field tracks the individual person responsible for finding the candidate.
    """

    user_id: str
    r"""The Kombo ID or Remote ID of the User. Use the Kombo ID directly, or prefix the remote ID with \"remote:\" to reference the user by their ID in the remote system."""


class PostAtsCandidatesRequestBodyGdprConsentTypedDict(TypedDict):
    r"""Optional GDPR consent information required in some jurisdictions (like the Czech Republic or Slovakia)."""

    expires_at: NotRequired[datetime]
    r"""Until when the candidate has granted the company they're applying to permission to process their personal data.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    given: NotRequired[bool]
    r"""Whether the candidate has given consent."""


class PostAtsCandidatesRequestBodyGdprConsent(BaseModel):
    r"""Optional GDPR consent information required in some jurisdictions (like the Czech Republic or Slovakia)."""

    expires_at: Optional[datetime] = None
    r"""Until when the candidate has granted the company they're applying to permission to process their personal data.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    given: Optional[bool] = None
    r"""Whether the candidate has given consent."""


class PostAtsCandidatesRequestBodySuccessfactorsTypedDict(TypedDict):
    r"""Fields specific to SAP SuccessFactors."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to SuccessFactor's `Candidate` object."""
    job_application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to SuccessFactor's `JobApplication` object."""
    copy_job_application_attachments: NotRequired[bool]
    r"""If set to true, we will copy custom attachments from the JobApplication to the Candidate."""
    update_existing_candidate: NotRequired[Nullable[bool]]
    r"""When the candidate already exists, whether to update the Candidate with the remote fields found under the Candidate entity."""


class PostAtsCandidatesRequestBodySuccessfactors(BaseModel):
    r"""Fields specific to SAP SuccessFactors."""

    candidate: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="Candidate")
    ] = None
    r"""Fields that we will pass through to SuccessFactor's `Candidate` object."""

    job_application: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="JobApplication")
    ] = None
    r"""Fields that we will pass through to SuccessFactor's `JobApplication` object."""

    copy_job_application_attachments: Annotated[
        Optional[bool], pydantic.Field(alias="copyJobApplicationAttachments")
    ] = None
    r"""If set to true, we will copy custom attachments from the JobApplication to the Candidate."""

    update_existing_candidate: OptionalNullable[bool] = UNSET
    r"""When the candidate already exists, whether to update the Candidate with the remote fields found under the Candidate entity."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "Candidate",
            "JobApplication",
            "copyJobApplicationAttachments",
            "update_existing_candidate",
        ]
        nullable_fields = ["update_existing_candidate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesRequestBodyPersonioTypedDict(TypedDict):
    r"""Fields specific to Personio."""

    application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Personio's `application` object."""


class PostAtsCandidatesRequestBodyPersonio(BaseModel):
    r"""Fields specific to Personio."""

    application: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Personio's `application` object."""


class PostAtsCandidatesRequestBodyTalentsoftTypedDict(TypedDict):
    r"""Fields specific to TalentSoft."""

    applicant: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to TalentSoft's `applicant` object."""
    application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to TalentSoft's `application` object."""


class PostAtsCandidatesRequestBodyTalentsoft(BaseModel):
    r"""Fields specific to TalentSoft."""

    applicant: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to TalentSoft's `applicant` object."""

    application: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to TalentSoft's `application` object."""


class PostAtsCandidatesRequestBodyTeamtailorApplicationTypedDict(TypedDict):
    attributes: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Teamtailor's attributes section `Job application` object."""


class PostAtsCandidatesRequestBodyTeamtailorApplication(BaseModel):
    attributes: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Teamtailor's attributes section `Job application` object."""


class PostAtsCandidatesRequestBodyTeamtailorTypedDict(TypedDict):
    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Teamtailor's `Candidate` object."""
    application: NotRequired[PostAtsCandidatesRequestBodyTeamtailorApplicationTypedDict]


class PostAtsCandidatesRequestBodyTeamtailor(BaseModel):
    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Teamtailor's `Candidate` object."""

    application: Optional[PostAtsCandidatesRequestBodyTeamtailorApplication] = None


class PostAtsCandidatesRequestBodyPostHeadersTypedDict(TypedDict):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: NotRequired[Nullable[str]]
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""


class PostAtsCandidatesRequestBodyPostHeaders(BaseModel):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: Annotated[
        OptionalNullable[str], pydantic.Field(alias="On-Behalf-Of")
    ] = UNSET
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["On-Behalf-Of"]
        nullable_fields = ["On-Behalf-Of"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesRequestBodyGreenhouseTypedDict(TypedDict):
    r"""Fields specific to Greenhouse."""

    post_headers: NotRequired[PostAtsCandidatesRequestBodyPostHeadersTypedDict]
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsCandidatesRequestBodyGreenhouse(BaseModel):
    r"""Fields specific to Greenhouse."""

    post_headers: Optional[PostAtsCandidatesRequestBodyPostHeaders] = None
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsCandidatesRequestBodyLeverTypedDict(TypedDict):
    r"""Fields specific to Lever."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Lever's `Candidate` object. Note: make sure to submit the keys and values in the correct form data format."""


class PostAtsCandidatesRequestBodyLever(BaseModel):
    r"""Fields specific to Lever."""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Lever's `Candidate` object. Note: make sure to submit the keys and values in the correct form data format."""


class PostAtsCandidatesRequestBodyWorkableTypedDict(TypedDict):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: NotRequired[str]
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsCandidatesRequestBodyWorkable(BaseModel):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: Optional[str] = None
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsCandidatesRequestBodySocialSuffixReferenceTypedDict(TypedDict):
    r"""The WID of the social suffix reference for the candidate"""

    predefined_name_component_id: str


class PostAtsCandidatesRequestBodySocialSuffixReference(BaseModel):
    r"""The WID of the social suffix reference for the candidate"""

    predefined_name_component_id: Annotated[
        str, pydantic.Field(alias="Predefined_Name_Component_ID")
    ]


class PostAtsCandidatesRequestBodyNameDetailDataTypedDict(TypedDict):
    middle_name: NotRequired[str]
    r"""The candidate's middle name"""
    social_suffix_reference: NotRequired[
        PostAtsCandidatesRequestBodySocialSuffixReferenceTypedDict
    ]
    r"""The WID of the social suffix reference for the candidate"""


class PostAtsCandidatesRequestBodyNameDetailData(BaseModel):
    middle_name: Annotated[Optional[str], pydantic.Field(alias="Middle_Name")] = None
    r"""The candidate's middle name"""

    social_suffix_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodySocialSuffixReference],
        pydantic.Field(alias="Social_Suffix_Reference"),
    ] = None
    r"""The WID of the social suffix reference for the candidate"""


class PostAtsCandidatesRequestBodyLanguageReferenceTypedDict(TypedDict):
    r"""Used to set the candidate's primary language"""

    wid: str


class PostAtsCandidatesRequestBodyLanguageReference(BaseModel):
    r"""Used to set the candidate's primary language"""

    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsCandidatesRequestBodyGlobalPersonalInformationDataTypedDict(TypedDict):
    date_of_birth: NotRequired[str]


class PostAtsCandidatesRequestBodyGlobalPersonalInformationData(BaseModel):
    date_of_birth: Annotated[Optional[str], pydantic.Field(alias="Date_of_Birth")] = (
        None
    )


class PostAtsCandidatesRequestBodyJobAppliedToDataTypedDict(TypedDict):
    global_personal_information_data: NotRequired[
        PostAtsCandidatesRequestBodyGlobalPersonalInformationDataTypedDict
    ]


class PostAtsCandidatesRequestBodyJobAppliedToData(BaseModel):
    global_personal_information_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyGlobalPersonalInformationData],
        pydantic.Field(alias="Global_Personal_Information_Data"),
    ] = None


class PostAtsCandidatesRequestBodyFieldOfStudyReferenceTypedDict(TypedDict):
    wid: str


class PostAtsCandidatesRequestBodyFieldOfStudyReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsCandidatesRequestBodyDegreeReferenceTypedDict(TypedDict):
    wid: str


class PostAtsCandidatesRequestBodyDegreeReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsCandidatesRequestBodyEducationDatumTypedDict(TypedDict):
    school_name: NotRequired[str]
    first_year_attended: NotRequired[float]
    last_year_attended: NotRequired[float]
    field_of_study_reference: NotRequired[
        PostAtsCandidatesRequestBodyFieldOfStudyReferenceTypedDict
    ]
    degree_reference: NotRequired[PostAtsCandidatesRequestBodyDegreeReferenceTypedDict]
    grade_average: NotRequired[str]


class PostAtsCandidatesRequestBodyEducationDatum(BaseModel):
    school_name: Annotated[Optional[str], pydantic.Field(alias="School_Name")] = None

    first_year_attended: Annotated[
        Optional[float], pydantic.Field(alias="First_Year_Attended")
    ] = None

    last_year_attended: Annotated[
        Optional[float], pydantic.Field(alias="Last_Year_Attended")
    ] = None

    field_of_study_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyFieldOfStudyReference],
        pydantic.Field(alias="Field_of_Study_Reference"),
    ] = None

    degree_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyDegreeReference],
        pydantic.Field(alias="Degree_Reference"),
    ] = None

    grade_average: Annotated[Optional[str], pydantic.Field(alias="Grade_Average")] = (
        None
    )


class PostAtsCandidatesRequestBodySkillDatumTypedDict(TypedDict):
    skill_name: NotRequired[str]


class PostAtsCandidatesRequestBodySkillDatum(BaseModel):
    skill_name: Annotated[Optional[str], pydantic.Field(alias="Skill_Name")] = None


class PostAtsCandidatesRequestBodyLanguageDatumLanguageReferenceTypedDict(TypedDict):
    wid: NotRequired[str]


class PostAtsCandidatesRequestBodyLanguageDatumLanguageReference(BaseModel):
    wid: Annotated[Optional[str], pydantic.Field(alias="WID")] = None


class PostAtsCandidatesRequestBodyLanguageProficiencyReferenceTypedDict(TypedDict):
    wid: str


class PostAtsCandidatesRequestBodyLanguageProficiencyReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsCandidatesRequestBodyLanguageAbilityTypeReferenceTypedDict(TypedDict):
    wid: str


class PostAtsCandidatesRequestBodyLanguageAbilityTypeReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsCandidatesRequestBodyLanguageAbilityDataTypedDict(TypedDict):
    language_proficiency_reference: NotRequired[
        PostAtsCandidatesRequestBodyLanguageProficiencyReferenceTypedDict
    ]
    language_ability_type_reference: NotRequired[
        PostAtsCandidatesRequestBodyLanguageAbilityTypeReferenceTypedDict
    ]


class PostAtsCandidatesRequestBodyLanguageAbilityData(BaseModel):
    language_proficiency_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyLanguageProficiencyReference],
        pydantic.Field(alias="Language_Proficiency_Reference"),
    ] = None

    language_ability_type_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyLanguageAbilityTypeReference],
        pydantic.Field(alias="Language_Ability_Type_Reference"),
    ] = None


class PostAtsCandidatesRequestBodyLanguageAbilityTypedDict(TypedDict):
    language_ability_data: NotRequired[
        PostAtsCandidatesRequestBodyLanguageAbilityDataTypedDict
    ]


class PostAtsCandidatesRequestBodyLanguageAbility(BaseModel):
    language_ability_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyLanguageAbilityData],
        pydantic.Field(alias="Language_Ability_Data"),
    ] = None


class PostAtsCandidatesRequestBodyLanguageTypedDict(TypedDict):
    language_ability: List[PostAtsCandidatesRequestBodyLanguageAbilityTypedDict]
    native: NotRequired[bool]


class PostAtsCandidatesRequestBodyLanguage(BaseModel):
    language_ability: Annotated[
        List[PostAtsCandidatesRequestBodyLanguageAbility],
        pydantic.Field(alias="Language_Ability"),
    ]

    native: Annotated[Optional[bool], pydantic.Field(alias="Native")] = None


class PostAtsCandidatesRequestBodyLanguageDatumTypedDict(TypedDict):
    language_reference: NotRequired[
        PostAtsCandidatesRequestBodyLanguageDatumLanguageReferenceTypedDict
    ]
    language: NotRequired[PostAtsCandidatesRequestBodyLanguageTypedDict]


class PostAtsCandidatesRequestBodyLanguageDatum(BaseModel):
    language_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyLanguageDatumLanguageReference],
        pydantic.Field(alias="Language_Reference"),
    ] = None

    language: Annotated[
        Optional[PostAtsCandidatesRequestBodyLanguage], pydantic.Field(alias="Language")
    ] = None


class PostAtsCandidatesRequestBodyExperienceDatumTypedDict(TypedDict):
    company_name: str
    title: str
    start_date: datetime
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    location: NotRequired[str]
    end_date: NotRequired[datetime]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    currently_work_here: NotRequired[bool]
    description: NotRequired[str]


class PostAtsCandidatesRequestBodyExperienceDatum(BaseModel):
    company_name: Annotated[str, pydantic.Field(alias="Company_Name")]

    title: Annotated[str, pydantic.Field(alias="Title")]

    start_date: Annotated[datetime, pydantic.Field(alias="Start_Date")]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    location: Annotated[Optional[str], pydantic.Field(alias="Location")] = None

    end_date: Annotated[Optional[datetime], pydantic.Field(alias="End_Date")] = None
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    currently_work_here: Annotated[
        Optional[bool], pydantic.Field(alias="Currently_Work_Here")
    ] = None

    description: Annotated[Optional[str], pydantic.Field(alias="Description")] = None


class PostAtsCandidatesRequestBodyResumeDataTypedDict(TypedDict):
    education_data: NotRequired[
        List[PostAtsCandidatesRequestBodyEducationDatumTypedDict]
    ]
    skill_data: NotRequired[List[PostAtsCandidatesRequestBodySkillDatumTypedDict]]
    language_data: NotRequired[List[PostAtsCandidatesRequestBodyLanguageDatumTypedDict]]
    experience_data: NotRequired[
        List[PostAtsCandidatesRequestBodyExperienceDatumTypedDict]
    ]


class PostAtsCandidatesRequestBodyResumeData(BaseModel):
    education_data: Annotated[
        Optional[List[PostAtsCandidatesRequestBodyEducationDatum]],
        pydantic.Field(alias="Education_Data"),
    ] = None

    skill_data: Annotated[
        Optional[List[PostAtsCandidatesRequestBodySkillDatum]],
        pydantic.Field(alias="Skill_Data"),
    ] = None

    language_data: Annotated[
        Optional[List[PostAtsCandidatesRequestBodyLanguageDatum]],
        pydantic.Field(alias="Language_Data"),
    ] = None

    experience_data: Annotated[
        Optional[List[PostAtsCandidatesRequestBodyExperienceDatum]],
        pydantic.Field(alias="Experience_Data"),
    ] = None


class PostAtsCandidatesRequestBodyJobApplicationDataTypedDict(TypedDict):
    job_applied_to_data: NotRequired[
        PostAtsCandidatesRequestBodyJobAppliedToDataTypedDict
    ]
    resume_data: NotRequired[PostAtsCandidatesRequestBodyResumeDataTypedDict]


class PostAtsCandidatesRequestBodyJobApplicationData(BaseModel):
    job_applied_to_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyJobAppliedToData],
        pydantic.Field(alias="Job_Applied_To_Data"),
    ] = None

    resume_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyResumeData],
        pydantic.Field(alias="Resume_Data"),
    ] = None


class PostAtsCandidatesRequestBodyCountryRegionReferenceTypedDict(TypedDict):
    country_region_id: str


class PostAtsCandidatesRequestBodyCountryRegionReference(BaseModel):
    country_region_id: Annotated[str, pydantic.Field(alias="Country_Region_ID")]


class PostAtsCandidatesRequestBodyCountryCityReferenceTypedDict(TypedDict):
    wid: str


class PostAtsCandidatesRequestBodyCountryCityReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsCandidatesRequestBodyLocationDataTypedDict(TypedDict):
    address_line_1: NotRequired[str]
    address_line_2: NotRequired[str]
    region_subdivision_1: NotRequired[str]
    country_region_reference: NotRequired[
        PostAtsCandidatesRequestBodyCountryRegionReferenceTypedDict
    ]
    country_city_reference: NotRequired[
        PostAtsCandidatesRequestBodyCountryCityReferenceTypedDict
    ]


class PostAtsCandidatesRequestBodyLocationData(BaseModel):
    address_line_1: Annotated[Optional[str], pydantic.Field(alias="Address_Line_1")] = (
        None
    )

    address_line_2: Annotated[Optional[str], pydantic.Field(alias="Address_Line_2")] = (
        None
    )

    region_subdivision_1: Annotated[
        Optional[str], pydantic.Field(alias="Region_Subdivision_1")
    ] = None

    country_region_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyCountryRegionReference],
        pydantic.Field(alias="Country_Region_Reference"),
    ] = None

    country_city_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyCountryCityReference],
        pydantic.Field(alias="Country_City_Reference"),
    ] = None


class PostAtsCandidatesRequestBodyContactDataTypedDict(TypedDict):
    location_data: NotRequired[PostAtsCandidatesRequestBodyLocationDataTypedDict]


class PostAtsCandidatesRequestBodyContactData(BaseModel):
    location_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyLocationData],
        pydantic.Field(alias="Location_Data"),
    ] = None


class PostAtsCandidatesRequestBodyWorkerReferenceTypedDict(TypedDict):
    r"""Reference to the Worker (employee) to link the candidate to. Provide either WID or Employee_ID."""

    wid: NotRequired[str]
    employee_id: NotRequired[str]


class PostAtsCandidatesRequestBodyWorkerReference(BaseModel):
    r"""Reference to the Worker (employee) to link the candidate to. Provide either WID or Employee_ID."""

    wid: Annotated[Optional[str], pydantic.Field(alias="WID")] = None

    employee_id: Annotated[Optional[str], pydantic.Field(alias="Employee_ID")] = None


class PostAtsCandidatesRequestBodyCandidateDataTypedDict(TypedDict):
    name_detail_data: NotRequired[PostAtsCandidatesRequestBodyNameDetailDataTypedDict]
    language_reference: NotRequired[
        PostAtsCandidatesRequestBodyLanguageReferenceTypedDict
    ]
    r"""Used to set the candidate's primary language"""
    job_application_data: NotRequired[
        PostAtsCandidatesRequestBodyJobApplicationDataTypedDict
    ]
    contact_data: NotRequired[PostAtsCandidatesRequestBodyContactDataTypedDict]
    worker_reference: NotRequired[PostAtsCandidatesRequestBodyWorkerReferenceTypedDict]
    r"""Reference to the Worker (employee) to link the candidate to. Provide either WID or Employee_ID."""


class PostAtsCandidatesRequestBodyCandidateData(BaseModel):
    name_detail_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyNameDetailData],
        pydantic.Field(alias="Name_Detail_Data"),
    ] = None

    language_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyLanguageReference],
        pydantic.Field(alias="Language_Reference"),
    ] = None
    r"""Used to set the candidate's primary language"""

    job_application_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyJobApplicationData],
        pydantic.Field(alias="Job_Application_Data"),
    ] = None

    contact_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyContactData],
        pydantic.Field(alias="Contact_Data"),
    ] = None

    worker_reference: Annotated[
        Optional[PostAtsCandidatesRequestBodyWorkerReference],
        pydantic.Field(alias="Worker_Reference"),
    ] = None
    r"""Reference to the Worker (employee) to link the candidate to. Provide either WID or Employee_ID."""


class PostAtsCandidatesRequestBodyWorkdayTypedDict(TypedDict):
    r"""Fields specific to Workday. The remote fields schema follows the documentation at https://community.workday.com/sites/default/files/file-hosting/productionapi/Recruiting/v43.0/Put_Candidate.html. Only defined fields are supported, if you need additional field support please reach out to Kombo support."""

    candidate_data: NotRequired[PostAtsCandidatesRequestBodyCandidateDataTypedDict]
    override_source_reference_wid: NotRequired[str]
    r"""Used to override the automatic source WID."""


class PostAtsCandidatesRequestBodyWorkday(BaseModel):
    r"""Fields specific to Workday. The remote fields schema follows the documentation at https://community.workday.com/sites/default/files/file-hosting/productionapi/Recruiting/v43.0/Put_Candidate.html. Only defined fields are supported, if you need additional field support please reach out to Kombo support."""

    candidate_data: Annotated[
        Optional[PostAtsCandidatesRequestBodyCandidateData],
        pydantic.Field(alias="Candidate_Data"),
    ] = None

    override_source_reference_wid: Annotated[
        Optional[str], pydantic.Field(alias="Override_Source_Reference_WID")
    ] = None
    r"""Used to override the automatic source WID."""


class PostAtsCandidatesRequestBodyZohorecruitTypedDict(TypedDict):
    r"""Fields specific to Zoho Recruit."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Zoho Recruit's `Candidate` object."""


class PostAtsCandidatesRequestBodyZohorecruit(BaseModel):
    r"""Fields specific to Zoho Recruit."""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Zoho Recruit's `Candidate` object."""


class PostAtsCandidatesRequestBodyBullhornTypedDict(TypedDict):
    r"""Fields specific to Bullhorn."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Bullhorn's `Candidate` object."""
    job_submission: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Bullhorn's `JobSubmission` object."""


class PostAtsCandidatesRequestBodyBullhorn(BaseModel):
    r"""Fields specific to Bullhorn."""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Bullhorn's `Candidate` object."""

    job_submission: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Bullhorn's `JobSubmission` object."""


class PostAtsCandidatesRequestBodySmartrecruitersTypedDict(TypedDict):
    r"""Fields specific to SmartRecruiters."""

    candidate_with_questions: NotRequired[Dict[str, Any]]
    r"""**(⚠️ Deprecated - Use the `candidate` field instead.)** Fields that we will pass through to the SmartRecruiters's `Candidate` object when created with screening question answers. This API is used: https://developers.smartrecruiters.com/reference/createcandidate-1"""
    candidate_without_questions: NotRequired[Dict[str, Any]]
    r"""**(⚠️ Deprecated - Use the `candidate` field instead.)** Fields that we will pass through to the SmartRecruiters's `Candidate` object when created with screening question answers. This API is used: https://developers.smartrecruiters.com/reference/candidatesaddtojob-1"""
    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to the SmartRecruiters's `Candidate` object. This API is used: https://developers.smartrecruiters.com/reference/createcandidate-1"""


class PostAtsCandidatesRequestBodySmartrecruiters(BaseModel):
    r"""Fields specific to SmartRecruiters."""

    candidate_with_questions: Annotated[
        Optional[Dict[str, Any]],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""**(⚠️ Deprecated - Use the `candidate` field instead.)** Fields that we will pass through to the SmartRecruiters's `Candidate` object when created with screening question answers. This API is used: https://developers.smartrecruiters.com/reference/createcandidate-1"""

    candidate_without_questions: Annotated[
        Optional[Dict[str, Any]],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""**(⚠️ Deprecated - Use the `candidate` field instead.)** Fields that we will pass through to the SmartRecruiters's `Candidate` object when created with screening question answers. This API is used: https://developers.smartrecruiters.com/reference/candidatesaddtojob-1"""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to the SmartRecruiters's `Candidate` object. This API is used: https://developers.smartrecruiters.com/reference/createcandidate-1"""


class PostAtsCandidatesRequestBodyTalentadoreTypedDict(TypedDict):
    r"""Fields specific to Talentadore."""

    applications: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to the Talentadore's when creating applications."""


class PostAtsCandidatesRequestBodyTalentadore(BaseModel):
    r"""Fields specific to Talentadore."""

    applications: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to the Talentadore's when creating applications."""


class PostAtsCandidatesRequestBodyGuidecomTypedDict(TypedDict):
    r"""Fields specific to GuideCom."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to GuideCom's `Candidate` object."""


class PostAtsCandidatesRequestBodyGuidecom(BaseModel):
    r"""Fields specific to GuideCom."""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to GuideCom's `Candidate` object."""


class PostAtsCandidatesRequestBodyDvinciTypedDict(TypedDict):
    r"""Fields specific to d.vinci."""

    application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to d.vinci's application object. This API is used: https://static.dvinci-easy.com/files/d.vinci%20application-apply-api.html#jobs__id__applyApi_post"""


class PostAtsCandidatesRequestBodyDvinci(BaseModel):
    r"""Fields specific to d.vinci."""

    application: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to d.vinci's application object. This API is used: https://static.dvinci-easy.com/files/d.vinci%20application-apply-api.html#jobs__id__applyApi_post"""


class PostAtsCandidatesRequestBodyHrworksTypedDict(TypedDict):
    r"""Fields specific to GuideCom."""

    job_application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to HRWorks's `Job Application` object. This API is used: https://developers.hrworks.de/docs/hrworks-api-v2/53021f035f62d-post-job-applications"""


class PostAtsCandidatesRequestBodyHrworks(BaseModel):
    r"""Fields specific to GuideCom."""

    job_application: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="jobApplication")
    ] = None
    r"""Fields that we will pass through to HRWorks's `Job Application` object. This API is used: https://developers.hrworks.de/docs/hrworks-api-v2/53021f035f62d-post-job-applications"""


class PostAtsCandidatesRequestBodyJobylonApplicationTypedDict(TypedDict):
    r"""Fields that we will pass through to Jobylon's create application [endpoint](https://developer.jobylon.com/push-api-and-webhooks#-xL0v)'s request body."""

    message: NotRequired[str]
    r"""The `message` field of Jobylon's create application endpoint's request body."""


class PostAtsCandidatesRequestBodyJobylonApplication(BaseModel):
    r"""Fields that we will pass through to Jobylon's create application [endpoint](https://developer.jobylon.com/push-api-and-webhooks#-xL0v)'s request body."""

    message: Optional[str] = None
    r"""The `message` field of Jobylon's create application endpoint's request body."""


class PostAtsCandidatesRequestBodyJobylonTypedDict(TypedDict):
    r"""Fields specific to Jobylon."""

    application: NotRequired[PostAtsCandidatesRequestBodyJobylonApplicationTypedDict]
    r"""Fields that we will pass through to Jobylon's create application [endpoint](https://developer.jobylon.com/push-api-and-webhooks#-xL0v)'s request body."""


class PostAtsCandidatesRequestBodyJobylon(BaseModel):
    r"""Fields specific to Jobylon."""

    application: Optional[PostAtsCandidatesRequestBodyJobylonApplication] = None
    r"""Fields that we will pass through to Jobylon's create application [endpoint](https://developer.jobylon.com/push-api-and-webhooks#-xL0v)'s request body."""


class PostAtsCandidatesRequestBodyStepTypedDict(TypedDict):
    id: int
    r"""The ID of the workflow step to assign to the candidate."""


class PostAtsCandidatesRequestBodyStep(BaseModel):
    id: int
    r"""The ID of the workflow step to assign to the candidate."""


class PostAtsCandidatesRequestBodyWorkflowTypedDict(TypedDict):
    step: NotRequired[PostAtsCandidatesRequestBodyStepTypedDict]


class PostAtsCandidatesRequestBodyWorkflow(BaseModel):
    step: Optional[PostAtsCandidatesRequestBodyStep] = None


class PostAtsCandidatesRequestBodyAvatureTypedDict(TypedDict):
    r"""Fields specific to Avature."""

    workflow: NotRequired[PostAtsCandidatesRequestBodyWorkflowTypedDict]


class PostAtsCandidatesRequestBodyAvature(BaseModel):
    r"""Fields specific to Avature."""

    workflow: Optional[PostAtsCandidatesRequestBodyWorkflow] = None


class PostAtsCandidatesRequestBodyRecruiteeCandidateTypedDict(TypedDict):
    cover_letter_text: NotRequired[str]
    r"""The cover letter text as a string. This will be visible on the main candidate page. Can be provided together with the `cover_letter` attachment, which will end up in a separate `file` section."""


class PostAtsCandidatesRequestBodyRecruiteeCandidate(BaseModel):
    cover_letter_text: Optional[str] = None
    r"""The cover letter text as a string. This will be visible on the main candidate page. Can be provided together with the `cover_letter` attachment, which will end up in a separate `file` section."""


class PostAtsCandidatesRequestBodyRecruiteeTypedDict(TypedDict):
    r"""Fields specific to Recruitee."""

    candidate: NotRequired[PostAtsCandidatesRequestBodyRecruiteeCandidateTypedDict]


class PostAtsCandidatesRequestBodyRecruitee(BaseModel):
    r"""Fields specific to Recruitee."""

    candidate: Optional[PostAtsCandidatesRequestBodyRecruiteeCandidate] = None


class PostAtsCandidatesRequestBodyUmantisTypedDict(TypedDict):
    r"""Fields specific to Abacus Umantis."""

    person: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Abacus Umantis's \"Create a person\" endpoint's `attributes` when creating a candidate."""


class PostAtsCandidatesRequestBodyUmantis(BaseModel):
    r"""Fields specific to Abacus Umantis."""

    person: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Abacus Umantis's \"Create a person\" endpoint's `attributes` when creating a candidate."""


class PostAtsCandidatesRequestBodyPilogaCandidateTypedDict(TypedDict):
    r"""Additional candidate fields for P&I Loga that will be mapped to the application form."""

    street: NotRequired[str]
    r"""The street address of the candidate."""


class PostAtsCandidatesRequestBodyPilogaCandidate(BaseModel):
    r"""Additional candidate fields for P&I Loga that will be mapped to the application form."""

    street: Optional[str] = None
    r"""The street address of the candidate."""


class PostAtsCandidatesRequestBodyPilogaTypedDict(TypedDict):
    r"""Fields specific to P&I Loga."""

    candidate: NotRequired[PostAtsCandidatesRequestBodyPilogaCandidateTypedDict]
    r"""Additional candidate fields for P&I Loga that will be mapped to the application form."""


class PostAtsCandidatesRequestBodyPiloga(BaseModel):
    r"""Fields specific to P&I Loga."""

    candidate: Optional[PostAtsCandidatesRequestBodyPilogaCandidate] = None
    r"""Additional candidate fields for P&I Loga that will be mapped to the application form."""


class PostAtsCandidatesRequestBodyRemoteFieldsTypedDict(TypedDict):
    r"""Additional fields that we will pass through to specific ATS systems."""

    successfactors: NotRequired[PostAtsCandidatesRequestBodySuccessfactorsTypedDict]
    r"""Fields specific to SAP SuccessFactors."""
    personio: NotRequired[PostAtsCandidatesRequestBodyPersonioTypedDict]
    r"""Fields specific to Personio."""
    talentsoft: NotRequired[PostAtsCandidatesRequestBodyTalentsoftTypedDict]
    r"""Fields specific to TalentSoft."""
    teamtailor: NotRequired[PostAtsCandidatesRequestBodyTeamtailorTypedDict]
    greenhouse: NotRequired[PostAtsCandidatesRequestBodyGreenhouseTypedDict]
    r"""Fields specific to Greenhouse."""
    lever: NotRequired[PostAtsCandidatesRequestBodyLeverTypedDict]
    r"""Fields specific to Lever."""
    workable: NotRequired[PostAtsCandidatesRequestBodyWorkableTypedDict]
    r"""Workable specific remote fields for ATS actions."""
    workday: NotRequired[PostAtsCandidatesRequestBodyWorkdayTypedDict]
    r"""Fields specific to Workday. The remote fields schema follows the documentation at https://community.workday.com/sites/default/files/file-hosting/productionapi/Recruiting/v43.0/Put_Candidate.html. Only defined fields are supported, if you need additional field support please reach out to Kombo support."""
    zohorecruit: NotRequired[PostAtsCandidatesRequestBodyZohorecruitTypedDict]
    r"""Fields specific to Zoho Recruit."""
    bullhorn: NotRequired[PostAtsCandidatesRequestBodyBullhornTypedDict]
    r"""Fields specific to Bullhorn."""
    smartrecruiters: NotRequired[PostAtsCandidatesRequestBodySmartrecruitersTypedDict]
    r"""Fields specific to SmartRecruiters."""
    talentadore: NotRequired[PostAtsCandidatesRequestBodyTalentadoreTypedDict]
    r"""Fields specific to Talentadore."""
    guidecom: NotRequired[PostAtsCandidatesRequestBodyGuidecomTypedDict]
    r"""Fields specific to GuideCom."""
    dvinci: NotRequired[PostAtsCandidatesRequestBodyDvinciTypedDict]
    r"""Fields specific to d.vinci."""
    hrworks: NotRequired[PostAtsCandidatesRequestBodyHrworksTypedDict]
    r"""Fields specific to GuideCom."""
    jobylon: NotRequired[PostAtsCandidatesRequestBodyJobylonTypedDict]
    r"""Fields specific to Jobylon."""
    avature: NotRequired[PostAtsCandidatesRequestBodyAvatureTypedDict]
    r"""Fields specific to Avature."""
    recruitee: NotRequired[PostAtsCandidatesRequestBodyRecruiteeTypedDict]
    r"""Fields specific to Recruitee."""
    umantis: NotRequired[PostAtsCandidatesRequestBodyUmantisTypedDict]
    r"""Fields specific to Abacus Umantis."""
    piloga: NotRequired[PostAtsCandidatesRequestBodyPilogaTypedDict]
    r"""Fields specific to P&I Loga."""


class PostAtsCandidatesRequestBodyRemoteFields(BaseModel):
    r"""Additional fields that we will pass through to specific ATS systems."""

    successfactors: Optional[PostAtsCandidatesRequestBodySuccessfactors] = None
    r"""Fields specific to SAP SuccessFactors."""

    personio: Optional[PostAtsCandidatesRequestBodyPersonio] = None
    r"""Fields specific to Personio."""

    talentsoft: Optional[PostAtsCandidatesRequestBodyTalentsoft] = None
    r"""Fields specific to TalentSoft."""

    teamtailor: Optional[PostAtsCandidatesRequestBodyTeamtailor] = None

    greenhouse: Optional[PostAtsCandidatesRequestBodyGreenhouse] = None
    r"""Fields specific to Greenhouse."""

    lever: Optional[PostAtsCandidatesRequestBodyLever] = None
    r"""Fields specific to Lever."""

    workable: Optional[PostAtsCandidatesRequestBodyWorkable] = None
    r"""Workable specific remote fields for ATS actions."""

    workday: Optional[PostAtsCandidatesRequestBodyWorkday] = None
    r"""Fields specific to Workday. The remote fields schema follows the documentation at https://community.workday.com/sites/default/files/file-hosting/productionapi/Recruiting/v43.0/Put_Candidate.html. Only defined fields are supported, if you need additional field support please reach out to Kombo support."""

    zohorecruit: Optional[PostAtsCandidatesRequestBodyZohorecruit] = None
    r"""Fields specific to Zoho Recruit."""

    bullhorn: Optional[PostAtsCandidatesRequestBodyBullhorn] = None
    r"""Fields specific to Bullhorn."""

    smartrecruiters: Optional[PostAtsCandidatesRequestBodySmartrecruiters] = None
    r"""Fields specific to SmartRecruiters."""

    talentadore: Optional[PostAtsCandidatesRequestBodyTalentadore] = None
    r"""Fields specific to Talentadore."""

    guidecom: Optional[PostAtsCandidatesRequestBodyGuidecom] = None
    r"""Fields specific to GuideCom."""

    dvinci: Optional[PostAtsCandidatesRequestBodyDvinci] = None
    r"""Fields specific to d.vinci."""

    hrworks: Optional[PostAtsCandidatesRequestBodyHrworks] = None
    r"""Fields specific to GuideCom."""

    jobylon: Optional[PostAtsCandidatesRequestBodyJobylon] = None
    r"""Fields specific to Jobylon."""

    avature: Optional[PostAtsCandidatesRequestBodyAvature] = None
    r"""Fields specific to Avature."""

    recruitee: Optional[PostAtsCandidatesRequestBodyRecruitee] = None
    r"""Fields specific to Recruitee."""

    umantis: Optional[PostAtsCandidatesRequestBodyUmantis] = None
    r"""Fields specific to Abacus Umantis."""

    piloga: Optional[PostAtsCandidatesRequestBodyPiloga] = None
    r"""Fields specific to P&I Loga."""


class PostAtsCandidatesRequestBodyTypedDict(TypedDict):
    candidate: PostAtsCandidatesRequestBodyCandidateTypedDict
    application: PostAtsCandidatesRequestBodyApplicationTypedDict
    r"""Currently, every candidate has one application. If you are interested in talent pools, please contact Kombo."""
    screening_question_answers: NotRequired[
        List[PostAtsCandidatesRequestBodyScreeningQuestionAnswerTypedDict]
    ]
    r"""Array of answers to screening questions. Currently, not all question types are supported, and unsupported ones will not be submitted.

    The available questions for a job can be retrieved from the get jobs endpoint. The answers will be validated based on the format of the questions. Make sure to follow this schema to avoid errors.
    """
    attachments: NotRequired[List[PostAtsCandidatesRequestBodyAttachmentTypedDict]]
    r"""An array of the attachments you would like upload."""
    source: NotRequired[PostAtsCandidatesRequestBodySourceTypedDict]
    r"""**(⚠️ Deprecated - Use [automatic source writing](/ats/features/application-attribution#automatic-attribution) instead)** Optional source information that will be attached to the candidate. If
    you're a job board or recruiting service, you can use this to make sure your
    customers can see which candidates came from you.

    This is deprecated because writing sources requires users to do some setup in most ATSs.
    """
    sourced_by: NotRequired[PostAtsCandidatesRequestBodySourcedByTypedDict]
    r"""Credit the recruiter or team member who sourced this candidate.

    While the `source` field tracks the channel/platform (e.g., \"Awesome Jobboard\"), the `sourced_by` field tracks the individual person responsible for finding the candidate.
    """
    gdpr_consent: NotRequired[PostAtsCandidatesRequestBodyGdprConsentTypedDict]
    r"""Optional GDPR consent information required in some jurisdictions (like the Czech Republic or Slovakia)."""
    remote_fields: NotRequired[PostAtsCandidatesRequestBodyRemoteFieldsTypedDict]
    r"""Additional fields that we will pass through to specific ATS systems."""


class PostAtsCandidatesRequestBody(BaseModel):
    candidate: PostAtsCandidatesRequestBodyCandidate

    application: PostAtsCandidatesRequestBodyApplication
    r"""Currently, every candidate has one application. If you are interested in talent pools, please contact Kombo."""

    screening_question_answers: Optional[
        List[PostAtsCandidatesRequestBodyScreeningQuestionAnswer]
    ] = None
    r"""Array of answers to screening questions. Currently, not all question types are supported, and unsupported ones will not be submitted.

    The available questions for a job can be retrieved from the get jobs endpoint. The answers will be validated based on the format of the questions. Make sure to follow this schema to avoid errors.
    """

    attachments: Optional[List[PostAtsCandidatesRequestBodyAttachment]] = None
    r"""An array of the attachments you would like upload."""

    source: Annotated[
        Optional[PostAtsCandidatesRequestBodySource],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""**(⚠️ Deprecated - Use [automatic source writing](/ats/features/application-attribution#automatic-attribution) instead)** Optional source information that will be attached to the candidate. If
    you're a job board or recruiting service, you can use this to make sure your
    customers can see which candidates came from you.

    This is deprecated because writing sources requires users to do some setup in most ATSs.
    """

    sourced_by: Optional[PostAtsCandidatesRequestBodySourcedBy] = None
    r"""Credit the recruiter or team member who sourced this candidate.

    While the `source` field tracks the channel/platform (e.g., \"Awesome Jobboard\"), the `sourced_by` field tracks the individual person responsible for finding the candidate.
    """

    gdpr_consent: Optional[PostAtsCandidatesRequestBodyGdprConsent] = None
    r"""Optional GDPR consent information required in some jurisdictions (like the Czech Republic or Slovakia)."""

    remote_fields: Optional[PostAtsCandidatesRequestBodyRemoteFields] = None
    r"""Additional fields that we will pass through to specific ATS systems."""
