"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class PostAtsImportTrackedApplicationPositiveResponseErecruiterApplicationAndCandidateRemoteIdsTypedDict(
    TypedDict
):
    candidate_remote_id: str
    application_remote_id: str
    id_type: Literal["application_and_candidate_remote_ids"]
    r"""Uses the `Api/Applications/{applicantId}` endpoint to retrieve the relevant application based on the candidate ID."""


class PostAtsImportTrackedApplicationPositiveResponseErecruiterApplicationAndCandidateRemoteIds(
    BaseModel
):
    candidate_remote_id: str

    application_remote_id: str

    ID_TYPE: Annotated[
        Annotated[
            Literal["application_and_candidate_remote_ids"],
            AfterValidator(validate_const("application_and_candidate_remote_ids")),
        ],
        pydantic.Field(alias="id_type"),
    ] = "application_and_candidate_remote_ids"
    r"""Uses the `Api/Applications/{applicantId}` endpoint to retrieve the relevant application based on the candidate ID."""


class PostAtsImportTrackedApplicationPositiveResponseErecruiterApplicationAndJobRemoteIdsTypedDict(
    TypedDict
):
    application_remote_id: str
    job_remote_id: str
    id_type: Literal["application_and_job_remote_ids"]
    r"""Uses the `Api/Applications/ByJob/{jobId}` endpoint to retrieve the relevant application based on the job ID."""


class PostAtsImportTrackedApplicationPositiveResponseErecruiterApplicationAndJobRemoteIds(
    BaseModel
):
    application_remote_id: str

    job_remote_id: str

    ID_TYPE: Annotated[
        Annotated[
            Literal["application_and_job_remote_ids"],
            AfterValidator(validate_const("application_and_job_remote_ids")),
        ],
        pydantic.Field(alias="id_type"),
    ] = "application_and_job_remote_ids"
    r"""Uses the `Api/Applications/ByJob/{jobId}` endpoint to retrieve the relevant application based on the job ID."""


PostAtsImportTrackedApplicationPositiveResponseErecruiterUnionTypedDict = TypeAliasType(
    "PostAtsImportTrackedApplicationPositiveResponseErecruiterUnionTypedDict",
    Union[
        PostAtsImportTrackedApplicationPositiveResponseErecruiterApplicationAndJobRemoteIdsTypedDict,
        PostAtsImportTrackedApplicationPositiveResponseErecruiterApplicationAndCandidateRemoteIdsTypedDict,
    ],
)


PostAtsImportTrackedApplicationPositiveResponseErecruiterUnion = TypeAliasType(
    "PostAtsImportTrackedApplicationPositiveResponseErecruiterUnion",
    Union[
        PostAtsImportTrackedApplicationPositiveResponseErecruiterApplicationAndJobRemoteIds,
        PostAtsImportTrackedApplicationPositiveResponseErecruiterApplicationAndCandidateRemoteIds,
    ],
)


class PostAtsImportTrackedApplicationPositiveResponseSuccessfactorsApplicationRemoteIDTypedDict(
    TypedDict
):
    application_remote_id: str
    id_type: Literal["application_remote_id"]
    r"""Uses the `/JobApplication` ODATA endpoint to retrieve the relevant application based on the application ID."""


class PostAtsImportTrackedApplicationPositiveResponseSuccessfactorsApplicationRemoteID(
    BaseModel
):
    application_remote_id: str

    ID_TYPE: Annotated[
        Annotated[
            Literal["application_remote_id"],
            AfterValidator(validate_const("application_remote_id")),
        ],
        pydantic.Field(alias="id_type"),
    ] = "application_remote_id"
    r"""Uses the `/JobApplication` ODATA endpoint to retrieve the relevant application based on the application ID."""


PostAtsImportTrackedApplicationPositiveResponseSuccessfactorsUnionTypedDict = PostAtsImportTrackedApplicationPositiveResponseSuccessfactorsApplicationRemoteIDTypedDict


PostAtsImportTrackedApplicationPositiveResponseSuccessfactorsUnion = (
    PostAtsImportTrackedApplicationPositiveResponseSuccessfactorsApplicationRemoteID
)


class PostAtsImportTrackedApplicationPositiveResponseRecruiteePlacementIDTypedDict(
    TypedDict
):
    placement_id: str
    id_type: Literal["placement_id"]
    r"""Uses the `/candidates` endpoint to retrieve all candidates, to find the relevant application based on the placement ID."""


class PostAtsImportTrackedApplicationPositiveResponseRecruiteePlacementID(BaseModel):
    placement_id: str

    ID_TYPE: Annotated[
        Annotated[
            Literal["placement_id"], AfterValidator(validate_const("placement_id"))
        ],
        pydantic.Field(alias="id_type"),
    ] = "placement_id"
    r"""Uses the `/candidates` endpoint to retrieve all candidates, to find the relevant application based on the placement ID."""


PostAtsImportTrackedApplicationPositiveResponseRecruiteeUnionTypedDict = (
    PostAtsImportTrackedApplicationPositiveResponseRecruiteePlacementIDTypedDict
)


PostAtsImportTrackedApplicationPositiveResponseRecruiteeUnion = (
    PostAtsImportTrackedApplicationPositiveResponseRecruiteePlacementID
)


class PostAtsImportTrackedApplicationPositiveResponseGreenhouseApplicationIDTypedDict(
    TypedDict
):
    application_id: str
    id_type: Literal["application_id"]
    r"""Uses the `/applications/{id}` endpoint to retrieve the application."""


class PostAtsImportTrackedApplicationPositiveResponseGreenhouseApplicationID(BaseModel):
    application_id: str

    ID_TYPE: Annotated[
        Annotated[
            Literal["application_id"], AfterValidator(validate_const("application_id"))
        ],
        pydantic.Field(alias="id_type"),
    ] = "application_id"
    r"""Uses the `/applications/{id}` endpoint to retrieve the application."""


PostAtsImportTrackedApplicationPositiveResponseGreenhouseUnionTypedDict = (
    PostAtsImportTrackedApplicationPositiveResponseGreenhouseApplicationIDTypedDict
)


PostAtsImportTrackedApplicationPositiveResponseGreenhouseUnion = (
    PostAtsImportTrackedApplicationPositiveResponseGreenhouseApplicationID
)


class PostAtsImportTrackedApplicationPositiveResponseOnlyfyApplicationIDTypedDict(
    TypedDict
):
    application_id: str
    id_type: Literal["application_id"]
    r"""Uses the `/v1/application/{id}` endpoint to retrieve the application."""


class PostAtsImportTrackedApplicationPositiveResponseOnlyfyApplicationID(BaseModel):
    application_id: str

    ID_TYPE: Annotated[
        Annotated[
            Literal["application_id"], AfterValidator(validate_const("application_id"))
        ],
        pydantic.Field(alias="id_type"),
    ] = "application_id"
    r"""Uses the `/v1/application/{id}` endpoint to retrieve the application."""


PostAtsImportTrackedApplicationPositiveResponseOnlyfyUnionTypedDict = (
    PostAtsImportTrackedApplicationPositiveResponseOnlyfyApplicationIDTypedDict
)


PostAtsImportTrackedApplicationPositiveResponseOnlyfyUnion = (
    PostAtsImportTrackedApplicationPositiveResponseOnlyfyApplicationID
)


class PostAtsImportTrackedApplicationPositiveResponseSmartrecruitersCandidateAndJobRemoteIdsTypedDict(
    TypedDict
):
    candidate_remote_id: str
    job_remote_id: str
    id_type: Literal["candidate_and_job_remote_ids"]
    r"""Uses the `/candidates/{candidateId}/jobs/{jobId}` endpoint to retrieve the application."""


class PostAtsImportTrackedApplicationPositiveResponseSmartrecruitersCandidateAndJobRemoteIds(
    BaseModel
):
    candidate_remote_id: str

    job_remote_id: str

    ID_TYPE: Annotated[
        Annotated[
            Literal["candidate_and_job_remote_ids"],
            AfterValidator(validate_const("candidate_and_job_remote_ids")),
        ],
        pydantic.Field(alias="id_type"),
    ] = "candidate_and_job_remote_ids"
    r"""Uses the `/candidates/{candidateId}/jobs/{jobId}` endpoint to retrieve the application."""


PostAtsImportTrackedApplicationPositiveResponseSmartrecruitersUnionTypedDict = PostAtsImportTrackedApplicationPositiveResponseSmartrecruitersCandidateAndJobRemoteIdsTypedDict


PostAtsImportTrackedApplicationPositiveResponseSmartrecruitersUnion = PostAtsImportTrackedApplicationPositiveResponseSmartrecruitersCandidateAndJobRemoteIds


class ImportedIDTypedDict(TypedDict):
    erecruiter: NotRequired[
        PostAtsImportTrackedApplicationPositiveResponseErecruiterUnionTypedDict
    ]
    successfactors: NotRequired[
        PostAtsImportTrackedApplicationPositiveResponseSuccessfactorsUnionTypedDict
    ]
    recruitee: NotRequired[
        PostAtsImportTrackedApplicationPositiveResponseRecruiteeUnionTypedDict
    ]
    greenhouse: NotRequired[
        PostAtsImportTrackedApplicationPositiveResponseGreenhouseUnionTypedDict
    ]
    onlyfy: NotRequired[
        PostAtsImportTrackedApplicationPositiveResponseOnlyfyUnionTypedDict
    ]
    smartrecruiters: NotRequired[
        PostAtsImportTrackedApplicationPositiveResponseSmartrecruitersUnionTypedDict
    ]


class ImportedID(BaseModel):
    erecruiter: Optional[
        PostAtsImportTrackedApplicationPositiveResponseErecruiterUnion
    ] = None

    successfactors: Optional[
        PostAtsImportTrackedApplicationPositiveResponseSuccessfactorsUnion
    ] = None

    recruitee: Optional[
        PostAtsImportTrackedApplicationPositiveResponseRecruiteeUnion
    ] = None

    greenhouse: Optional[
        PostAtsImportTrackedApplicationPositiveResponseGreenhouseUnion
    ] = None

    onlyfy: Optional[PostAtsImportTrackedApplicationPositiveResponseOnlyfyUnion] = None

    smartrecruiters: Optional[
        PostAtsImportTrackedApplicationPositiveResponseSmartrecruitersUnion
    ] = None


class PostAtsImportTrackedApplicationPositiveResponseDataTypedDict(TypedDict):
    id: str
    tracked_at: Nullable[datetime]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    imported_id: ImportedIDTypedDict


class PostAtsImportTrackedApplicationPositiveResponseData(BaseModel):
    id: str

    tracked_at: Nullable[datetime]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    imported_id: ImportedID

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["tracked_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsImportTrackedApplicationPositiveResponseWarningTypedDict(TypedDict):
    message: str


class PostAtsImportTrackedApplicationPositiveResponseWarning(BaseModel):
    message: str


class PostAtsImportTrackedApplicationPositiveResponseTypedDict(TypedDict):
    data: PostAtsImportTrackedApplicationPositiveResponseDataTypedDict
    warnings: List[PostAtsImportTrackedApplicationPositiveResponseWarningTypedDict]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""
    status: Literal["success"]


class PostAtsImportTrackedApplicationPositiveResponse(BaseModel):
    data: PostAtsImportTrackedApplicationPositiveResponseData

    warnings: List[PostAtsImportTrackedApplicationPositiveResponseWarning]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
