"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PostAtsJobsJobIDApplicationsPositiveResponseOutcome = Literal[
    "PENDING",
    "HIRED",
    "DECLINED",
]
r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
Kombo will always try to deliver this information as reliably as possible.
"""


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer7TypedDict(TypedDict):
    raw: NotRequired[Nullable[Any]]
    r"""We pass the original question data along so you can handle it."""


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer7(BaseModel):
    raw: OptionalNullable[Any] = UNSET
    r"""We pass the original question data along so you can handle it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["raw"]
        nullable_fields = ["raw"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionUnknownTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["UNKNOWN"]
    r"""When we're not able to map a specific question type yet, we will return this type. Every `UNKNOWN` question will also be parsed and unified by us at some point."""


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionUnknown(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["UNKNOWN"], AfterValidator(validate_const("UNKNOWN"))],
        pydantic.Field(alias="type"),
    ] = "UNKNOWN"
    r"""When we're not able to map a specific question type yet, we will return this type. Every `UNKNOWN` question will also be parsed and unified by us at some point."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer7TypedDict(
    TypedDict
):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer7TypedDict
    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionUnknownTypedDict


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer7(BaseModel):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer7

    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionUnknown


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer6TypedDict(TypedDict):
    date_: Nullable[datetime]


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer6(BaseModel):
    date_: Annotated[Nullable[datetime], pydantic.Field(alias="date")]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["date"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionDateTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["DATE"]


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionDate(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["DATE"], AfterValidator(validate_const("DATE"))],
        pydantic.Field(alias="type"),
    ] = "DATE"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer6TypedDict(
    TypedDict
):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer6TypedDict
    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionDateTypedDict


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer6(BaseModel):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer6

    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionDate


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer5TypedDict(TypedDict):
    number: Nullable[float]


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer5(BaseModel):
    number: Nullable[float]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["number"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionNumberTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["NUMBER"]


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionNumber(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["NUMBER"], AfterValidator(validate_const("NUMBER"))],
        pydantic.Field(alias="type"),
    ] = "NUMBER"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer5TypedDict(
    TypedDict
):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer5TypedDict
    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionNumberTypedDict


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer5(BaseModel):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer5

    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionNumber


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer4TypedDict(TypedDict):
    checked: Nullable[bool]


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer4(BaseModel):
    checked: Nullable[bool]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["checked"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionBooleanTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["BOOLEAN"]


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionBoolean(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["BOOLEAN"], AfterValidator(validate_const("BOOLEAN"))],
        pydantic.Field(alias="type"),
    ] = "BOOLEAN"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer4TypedDict(
    TypedDict
):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer4TypedDict
    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionBooleanTypedDict


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer4(BaseModel):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer4

    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionBoolean


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer3TypedDict(TypedDict):
    choices: NotRequired[List[str]]


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer3(BaseModel):
    choices: Optional[List[str]] = None


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionMultiSelectTypedDict(
    TypedDict
):
    remote_id: Nullable[str]
    title: str
    type: Literal["MULTI_SELECT"]


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionMultiSelect(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[
            Literal["MULTI_SELECT"], AfterValidator(validate_const("MULTI_SELECT"))
        ],
        pydantic.Field(alias="type"),
    ] = "MULTI_SELECT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer3TypedDict(
    TypedDict
):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer3TypedDict
    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionMultiSelectTypedDict


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer3(BaseModel):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer3

    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionMultiSelect


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer2TypedDict(TypedDict):
    choice: Nullable[str]


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer2(BaseModel):
    choice: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["choice"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionSingleSelectTypedDict(
    TypedDict
):
    remote_id: Nullable[str]
    title: str
    type: Literal["SINGLE_SELECT"]


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionSingleSelect(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[
            Literal["SINGLE_SELECT"], AfterValidator(validate_const("SINGLE_SELECT"))
        ],
        pydantic.Field(alias="type"),
    ] = "SINGLE_SELECT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer2TypedDict(
    TypedDict
):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer2TypedDict
    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionSingleSelectTypedDict


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer2(BaseModel):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer2

    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionSingleSelect


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer1TypedDict(TypedDict):
    content: Nullable[str]


class PostAtsJobsJobIDApplicationsPositiveResponseAnswer1(BaseModel):
    content: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionTextTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["TEXT"]


class PostAtsJobsJobIDApplicationsPositiveResponseQuestionText(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["TEXT"], AfterValidator(validate_const("TEXT"))],
        pydantic.Field(alias="type"),
    ] = "TEXT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer1TypedDict(
    TypedDict
):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer1TypedDict
    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionTextTypedDict


class PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer1(BaseModel):
    answer: PostAtsJobsJobIDApplicationsPositiveResponseAnswer1

    question: PostAtsJobsJobIDApplicationsPositiveResponseQuestionText


PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswerUnionTypedDict = TypeAliasType(
    "PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswerUnionTypedDict",
    Union[
        PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer1TypedDict,
        PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer2TypedDict,
        PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer3TypedDict,
        PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer4TypedDict,
        PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer5TypedDict,
        PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer6TypedDict,
        PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer7TypedDict,
    ],
)


PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswerUnion = (
    TypeAliasType(
        "PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswerUnion",
        Union[
            PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer1,
            PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer2,
            PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer3,
            PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer4,
            PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer5,
            PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer6,
            PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswer7,
        ],
    )
)


class PostAtsJobsJobIDApplicationsPositiveResponseCurrentStageTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    name: Nullable[str]
    r"""The application stage name. For example, \"Initial Screening\"."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    index: Nullable[int]


class PostAtsJobsJobIDApplicationsPositiveResponseCurrentStage(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    name: Nullable[str]
    r"""The application stage name. For example, \"Initial Screening\"."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    index: Nullable[int]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "remote_id", "index"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseJobTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    name: Nullable[str]
    r"""Title of the job."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""


class PostAtsJobsJobIDApplicationsPositiveResponseJob(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    name: Nullable[str]
    r"""Title of the job."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponsePhoneNumberTypedDict(TypedDict):
    phone_number: str
    type: NotRequired[Nullable[str]]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""


class PostAtsJobsJobIDApplicationsPositiveResponsePhoneNumber(BaseModel):
    phone_number: str

    type: OptionalNullable[str] = UNSET
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type"]
        nullable_fields = ["type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseEmailAddressTypedDict(TypedDict):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""
    email_address: NotRequired[Nullable[str]]


class PostAtsJobsJobIDApplicationsPositiveResponseEmailAddress(BaseModel):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""

    email_address: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email_address"]
        nullable_fields = ["email_address", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseSocialMediaTypedDict(TypedDict):
    link: NotRequired[Nullable[str]]
    type: NotRequired[Nullable[str]]
    username: NotRequired[Nullable[str]]


class PostAtsJobsJobIDApplicationsPositiveResponseSocialMedia(BaseModel):
    link: OptionalNullable[str] = UNSET

    type: OptionalNullable[str] = UNSET

    username: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["link", "type", "username"]
        nullable_fields = ["link", "type", "username"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseLocationTypedDict(TypedDict):
    r"""Location of the candidate."""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class PostAtsJobsJobIDApplicationsPositiveResponseLocation(BaseModel):
    r"""Location of the candidate."""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseTagTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    name: Nullable[str]
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""


class PostAtsJobsJobIDApplicationsPositiveResponseTag(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    name: Nullable[str]

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseCandidateTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""First name of the candidate."""
    last_name: Nullable[str]
    r"""Last name of the candidate."""
    company: Nullable[str]
    r"""The current company of the candidate."""
    title: Nullable[str]
    r"""The current job title of the candidate."""
    confidential: Nullable[bool]
    r"""Whether the candidate’s profile is confidential in the ATS."""
    source: Nullable[str]
    r"""The hiring source of the candidate. If you're a job board or recruiting service, you can use this to validate which candidates applied through your service and ensure that the correct referral compensation is paid out."""
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    remote_url: Nullable[str]
    r"""URL to the candidate profile in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated candidate profile URL is available, so you might need to fall back to the application URL."""
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    tags: List[PostAtsJobsJobIDApplicationsPositiveResponseTagTypedDict]
    phone_numbers: NotRequired[
        Nullable[List[PostAtsJobsJobIDApplicationsPositiveResponsePhoneNumberTypedDict]]
    ]
    r"""A list of phone numbers of the candidate."""
    email_addresses: NotRequired[
        Nullable[
            List[PostAtsJobsJobIDApplicationsPositiveResponseEmailAddressTypedDict]
        ]
    ]
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""
    social_media: NotRequired[
        Nullable[List[PostAtsJobsJobIDApplicationsPositiveResponseSocialMediaTypedDict]]
    ]
    r"""List of social media accounts of the candidate."""
    location: NotRequired[
        Nullable[PostAtsJobsJobIDApplicationsPositiveResponseLocationTypedDict]
    ]
    r"""Location of the candidate."""


class PostAtsJobsJobIDApplicationsPositiveResponseCandidate(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""First name of the candidate."""

    last_name: Nullable[str]
    r"""Last name of the candidate."""

    company: Nullable[str]
    r"""The current company of the candidate."""

    title: Nullable[str]
    r"""The current job title of the candidate."""

    confidential: Nullable[bool]
    r"""Whether the candidate’s profile is confidential in the ATS."""

    source: Nullable[str]
    r"""The hiring source of the candidate. If you're a job board or recruiting service, you can use this to validate which candidates applied through your service and ensure that the correct referral compensation is paid out."""

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    remote_url: Nullable[str]
    r"""URL to the candidate profile in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated candidate profile URL is available, so you might need to fall back to the application URL."""

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    tags: List[PostAtsJobsJobIDApplicationsPositiveResponseTag]

    phone_numbers: OptionalNullable[
        List[PostAtsJobsJobIDApplicationsPositiveResponsePhoneNumber]
    ] = UNSET
    r"""A list of phone numbers of the candidate."""

    email_addresses: OptionalNullable[
        List[PostAtsJobsJobIDApplicationsPositiveResponseEmailAddress]
    ] = UNSET
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""

    social_media: OptionalNullable[
        List[PostAtsJobsJobIDApplicationsPositiveResponseSocialMedia]
    ] = UNSET
    r"""List of social media accounts of the candidate."""

    location: OptionalNullable[PostAtsJobsJobIDApplicationsPositiveResponseLocation] = (
        UNSET
    )
    r"""Location of the candidate."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "phone_numbers",
            "email_addresses",
            "social_media",
            "location",
        ]
        nullable_fields = [
            "first_name",
            "last_name",
            "company",
            "title",
            "confidential",
            "source",
            "phone_numbers",
            "email_addresses",
            "social_media",
            "location",
            "custom_fields",
            "remote_url",
            "remote_created_at",
            "remote_updated_at",
            "remote_deleted_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseDataTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    outcome: Nullable[PostAtsJobsJobIDApplicationsPositiveResponseOutcome]
    r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
    Kombo will always try to deliver this information as reliably as possible.
    """
    rejection_reason_name: Nullable[str]
    r"""Reason for the rejection of the candidate."""
    rejected_at: Nullable[datetime]
    r"""The time that the application was rejected.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    current_stage_id: Nullable[str]
    r"""ID of the current application stage"""
    job_id: Nullable[str]
    r"""The Kombo ID of the job which the candidate applied to. The ID can be used to retrieve the job from the `get jobs` endpoint."""
    candidate_id: Nullable[str]
    r"""The Kombo ID of the candidate who applied to the job. The ID can be used to retrieve the candidate from the `get candidates` endpoint."""
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    remote_url: Nullable[str]
    r"""URL to the application in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated application URL is available, so you might need to fall back to the candidate URL."""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    current_stage: Nullable[
        PostAtsJobsJobIDApplicationsPositiveResponseCurrentStageTypedDict
    ]
    job: Nullable[PostAtsJobsJobIDApplicationsPositiveResponseJobTypedDict]
    candidate: Nullable[PostAtsJobsJobIDApplicationsPositiveResponseCandidateTypedDict]
    screening_question_answers: NotRequired[
        Nullable[
            List[
                PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswerUnionTypedDict
            ]
        ]
    ]
    r"""A list of answers to screening questions. The screening answer type `FILE` is currently unsupported."""


class PostAtsJobsJobIDApplicationsPositiveResponseData(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    outcome: Nullable[PostAtsJobsJobIDApplicationsPositiveResponseOutcome]
    r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
    Kombo will always try to deliver this information as reliably as possible.
    """

    rejection_reason_name: Nullable[str]
    r"""Reason for the rejection of the candidate."""

    rejected_at: Nullable[datetime]
    r"""The time that the application was rejected.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    current_stage_id: Nullable[str]
    r"""ID of the current application stage"""

    job_id: Nullable[str]
    r"""The Kombo ID of the job which the candidate applied to. The ID can be used to retrieve the job from the `get jobs` endpoint."""

    candidate_id: Nullable[str]
    r"""The Kombo ID of the candidate who applied to the job. The ID can be used to retrieve the candidate from the `get candidates` endpoint."""

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    remote_url: Nullable[str]
    r"""URL to the application in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated application URL is available, so you might need to fall back to the candidate URL."""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    current_stage: Nullable[PostAtsJobsJobIDApplicationsPositiveResponseCurrentStage]

    job: Nullable[PostAtsJobsJobIDApplicationsPositiveResponseJob]

    candidate: Nullable[PostAtsJobsJobIDApplicationsPositiveResponseCandidate]

    screening_question_answers: OptionalNullable[
        List[PostAtsJobsJobIDApplicationsPositiveResponseScreeningQuestionAnswerUnion]
    ] = UNSET
    r"""A list of answers to screening questions. The screening answer type `FILE` is currently unsupported."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["screening_question_answers"]
        nullable_fields = [
            "remote_id",
            "outcome",
            "rejection_reason_name",
            "rejected_at",
            "current_stage_id",
            "job_id",
            "candidate_id",
            "screening_question_answers",
            "custom_fields",
            "remote_url",
            "remote_deleted_at",
            "remote_created_at",
            "remote_updated_at",
            "current_stage",
            "job",
            "candidate",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsPositiveResponseWarningTypedDict(TypedDict):
    message: str


class PostAtsJobsJobIDApplicationsPositiveResponseWarning(BaseModel):
    message: str


class PostAtsJobsJobIDApplicationsPositiveResponseTypedDict(TypedDict):
    data: PostAtsJobsJobIDApplicationsPositiveResponseDataTypedDict
    warnings: List[PostAtsJobsJobIDApplicationsPositiveResponseWarningTypedDict]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""
    status: Literal["success"]


class PostAtsJobsJobIDApplicationsPositiveResponse(BaseModel):
    data: PostAtsJobsJobIDApplicationsPositiveResponseData

    warnings: List[PostAtsJobsJobIDApplicationsPositiveResponseWarning]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
