"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import (
    Annotated,
    NotRequired,
    TypeAliasType,
    TypedDict,
    deprecated,
)


PostAtsJobsJobIDApplicationsRequestBodyAdditionalEmailAddressType = Literal[
    "PERSONAL",
    "WORK",
    "OTHER",
]


class PostAtsJobsJobIDApplicationsRequestBodyAdditionalEmailAddressTypedDict(TypedDict):
    type: PostAtsJobsJobIDApplicationsRequestBodyAdditionalEmailAddressType
    email_address: str


class PostAtsJobsJobIDApplicationsRequestBodyAdditionalEmailAddress(BaseModel):
    type: PostAtsJobsJobIDApplicationsRequestBodyAdditionalEmailAddressType

    email_address: str


PostAtsJobsJobIDApplicationsRequestBodyAdditionalPhoneNumberType = Literal[
    "PERSONAL",
    "WORK",
    "OTHER",
]


class PostAtsJobsJobIDApplicationsRequestBodyAdditionalPhoneNumberTypedDict(TypedDict):
    type: PostAtsJobsJobIDApplicationsRequestBodyAdditionalPhoneNumberType
    phone_number: str


class PostAtsJobsJobIDApplicationsRequestBodyAdditionalPhoneNumber(BaseModel):
    type: PostAtsJobsJobIDApplicationsRequestBodyAdditionalPhoneNumberType

    phone_number: str


class PostAtsJobsJobIDApplicationsRequestBodyLocationTypedDict(TypedDict):
    r"""The location of the candidate."""

    country: str
    r"""The uppercase two-letter ISO country (e.g., `DE`). For systems that use codes in formats other than `ISO 3166-1 alpha-2`, Kombo transforms the ISO Codes to the appropriate value."""
    city: NotRequired[str]
    state: NotRequired[str]
    zip_code: NotRequired[str]


class PostAtsJobsJobIDApplicationsRequestBodyLocation(BaseModel):
    r"""The location of the candidate."""

    country: str
    r"""The uppercase two-letter ISO country (e.g., `DE`). For systems that use codes in formats other than `ISO 3166-1 alpha-2`, Kombo transforms the ISO Codes to the appropriate value."""

    city: Optional[str] = None

    state: Optional[str] = None

    zip_code: Optional[str] = None


PostAtsJobsJobIDApplicationsRequestBodyGender = Literal[
    "MALE",
    "FEMALE",
    "OTHER",
]
r"""The gender of the candidate. Must be one of `MALE`, `FEMALE`, or `OTHER`."""


PostAtsJobsJobIDApplicationsRequestBodyPeriod = Literal[
    "MONTH",
    "YEAR",
]
r"""The period of the salary expectations. Must be one of `MONTH` or `YEAR`."""


class PostAtsJobsJobIDApplicationsRequestBodySalaryExpectationsTypedDict(TypedDict):
    r"""The salary expectations of the applicant. We will automatically convert the amount to a format that is suitable for the ATS you are using. For example, if you are using monthly salary expectations, we will convert the amount to a yearly salary if the ATS expects yearly salary expectations."""

    period: PostAtsJobsJobIDApplicationsRequestBodyPeriod
    r"""The period of the salary expectations. Must be one of `MONTH` or `YEAR`."""
    amount: float
    r"""The amount of the salary expectations."""


class PostAtsJobsJobIDApplicationsRequestBodySalaryExpectations(BaseModel):
    r"""The salary expectations of the applicant. We will automatically convert the amount to a format that is suitable for the ATS you are using. For example, if you are using monthly salary expectations, we will convert the amount to a yearly salary if the ATS expects yearly salary expectations."""

    period: PostAtsJobsJobIDApplicationsRequestBodyPeriod
    r"""The period of the salary expectations. Must be one of `MONTH` or `YEAR`."""

    amount: float
    r"""The amount of the salary expectations."""


class PostAtsJobsJobIDApplicationsRequestBodySocialLinkTypedDict(TypedDict):
    url: str


class PostAtsJobsJobIDApplicationsRequestBodySocialLink(BaseModel):
    url: str


class PostAtsJobsJobIDApplicationsRequestBodyCandidateTypedDict(TypedDict):
    first_name: str
    r"""The first name of the candidate."""
    last_name: str
    r"""The last name of the candidate."""
    email_address: str
    r"""The primary email address this application will be created with."""
    additional_email_addresses: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodyAdditionalEmailAddressTypedDict]
    ]
    company: NotRequired[str]
    r"""The company where the candidate is currently working."""
    title: NotRequired[str]
    r"""The current job title of the candidate."""
    phone_number: NotRequired[str]
    r"""The phone number of the candidate."""
    additional_phone_numbers: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodyAdditionalPhoneNumberTypedDict]
    ]
    location: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyLocationTypedDict]
    r"""The location of the candidate."""
    gender: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyGender]
    r"""The gender of the candidate. Must be one of `MALE`, `FEMALE`, or `OTHER`."""
    availability_date: NotRequired[datetime]
    r"""The date the candidate is available to start working.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    salary_expectations: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodySalaryExpectationsTypedDict
    ]
    r"""The salary expectations of the applicant. We will automatically convert the amount to a format that is suitable for the ATS you are using. For example, if you are using monthly salary expectations, we will convert the amount to a yearly salary if the ATS expects yearly salary expectations."""
    social_links: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodySocialLinkTypedDict]
    ]
    r"""A list of social media links of the candidate. The links must be valid URLs."""


class PostAtsJobsJobIDApplicationsRequestBodyCandidate(BaseModel):
    first_name: str
    r"""The first name of the candidate."""

    last_name: str
    r"""The last name of the candidate."""

    email_address: str
    r"""The primary email address this application will be created with."""

    additional_email_addresses: Optional[
        List[PostAtsJobsJobIDApplicationsRequestBodyAdditionalEmailAddress]
    ] = None

    company: Optional[str] = None
    r"""The company where the candidate is currently working."""

    title: Optional[str] = None
    r"""The current job title of the candidate."""

    phone_number: Optional[str] = None
    r"""The phone number of the candidate."""

    additional_phone_numbers: Optional[
        List[PostAtsJobsJobIDApplicationsRequestBodyAdditionalPhoneNumber]
    ] = None

    location: Optional[PostAtsJobsJobIDApplicationsRequestBodyLocation] = None
    r"""The location of the candidate."""

    gender: Optional[PostAtsJobsJobIDApplicationsRequestBodyGender] = None
    r"""The gender of the candidate. Must be one of `MALE`, `FEMALE`, or `OTHER`."""

    availability_date: Optional[datetime] = None
    r"""The date the candidate is available to start working.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    salary_expectations: Optional[
        PostAtsJobsJobIDApplicationsRequestBodySalaryExpectations
    ] = None
    r"""The salary expectations of the applicant. We will automatically convert the amount to a format that is suitable for the ATS you are using. For example, if you are using monthly salary expectations, we will convert the amount to a yearly salary if the ATS expects yearly salary expectations."""

    social_links: Optional[List[PostAtsJobsJobIDApplicationsRequestBodySocialLink]] = (
        None
    )
    r"""A list of social media links of the candidate. The links must be valid URLs."""


PostAtsJobsJobIDApplicationsRequestBodyAttachmentType = Literal[
    "CV",
    "COVER_LETTER",
    "OTHER",
]
r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""


class PostAtsJobsJobIDApplicationsRequestBodyAttachmentTypedDict(TypedDict):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""
    type: PostAtsJobsJobIDApplicationsRequestBodyAttachmentType
    r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""
    content_type: NotRequired[str]
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """
    data_url: NotRequired[str]
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """
    data: NotRequired[str]
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PostAtsJobsJobIDApplicationsRequestBodyAttachment(BaseModel):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""

    type: PostAtsJobsJobIDApplicationsRequestBodyAttachmentType
    r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""

    content_type: Optional[str] = None
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """

    data_url: Optional[str] = None
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """

    data: Optional[str] = None
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


@deprecated(
    "warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
)
class PostAtsJobsJobIDApplicationsRequestBodySourceTypedDict(TypedDict):
    r"""**(⚠️ Deprecated - Use [automatic source writing](/ats/features/application-attribution#automatic-attribution) instead)** Optional source information that will be attached to the candidate. If
    you're a job board or recruiting service, you can use this to make sure your
    customers can see which candidates came from you.

    This is deprecated because writing sources requires users to do some setup in most ATSs.
    """

    name: NotRequired[str]
    r"""Name of the source (e.g., `\"Example Job Board\"`)."""
    unified_key: NotRequired[str]
    id: NotRequired[str]


@deprecated(
    "warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
)
class PostAtsJobsJobIDApplicationsRequestBodySource(BaseModel):
    r"""**(⚠️ Deprecated - Use [automatic source writing](/ats/features/application-attribution#automatic-attribution) instead)** Optional source information that will be attached to the candidate. If
    you're a job board or recruiting service, you can use this to make sure your
    customers can see which candidates came from you.

    This is deprecated because writing sources requires users to do some setup in most ATSs.
    """

    name: Optional[str] = None
    r"""Name of the source (e.g., `\"Example Job Board\"`)."""

    unified_key: Optional[str] = None

    id: Optional[str] = None


class PostAtsJobsJobIDApplicationsRequestBodySourcedByTypedDict(TypedDict):
    r"""Credit the recruiter or team member who sourced this candidate.

    While the `source` field tracks the channel/platform (e.g., \"Awesome Jobboard\"), the `sourced_by` field tracks the individual person responsible for finding the candidate.
    """

    user_id: str
    r"""The Kombo ID or Remote ID of the User. Use the Kombo ID directly, or prefix the remote ID with \"remote:\" to reference the user by their ID in the remote system."""


class PostAtsJobsJobIDApplicationsRequestBodySourcedBy(BaseModel):
    r"""Credit the recruiter or team member who sourced this candidate.

    While the `source` field tracks the channel/platform (e.g., \"Awesome Jobboard\"), the `sourced_by` field tracks the individual person responsible for finding the candidate.
    """

    user_id: str
    r"""The Kombo ID or Remote ID of the User. Use the Kombo ID directly, or prefix the remote ID with \"remote:\" to reference the user by their ID in the remote system."""


class PostAtsJobsJobIDApplicationsRequestBodyGdprConsentTypedDict(TypedDict):
    r"""Optional GDPR consent information required in some jurisdictions (like the Czech Republic or Slovakia)."""

    expires_at: NotRequired[datetime]
    r"""Until when the candidate has granted the company they're applying to permission to process their personal data.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    given: NotRequired[bool]
    r"""Whether the candidate has given consent."""


class PostAtsJobsJobIDApplicationsRequestBodyGdprConsent(BaseModel):
    r"""Optional GDPR consent information required in some jurisdictions (like the Czech Republic or Slovakia)."""

    expires_at: Optional[datetime] = None
    r"""Until when the candidate has granted the company they're applying to permission to process their personal data.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    given: Optional[bool] = None
    r"""Whether the candidate has given consent."""


class PostAtsJobsJobIDApplicationsRequestBodySuccessfactorsTypedDict(TypedDict):
    r"""Fields specific to SAP SuccessFactors."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to SuccessFactor's `Candidate` object."""
    job_application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to SuccessFactor's `JobApplication` object."""
    copy_job_application_attachments: NotRequired[bool]
    r"""If set to true, we will copy custom attachments from the JobApplication to the Candidate."""
    update_existing_candidate: NotRequired[Nullable[bool]]
    r"""When the candidate already exists, whether to update the Candidate with the remote fields found under the Candidate entity."""


class PostAtsJobsJobIDApplicationsRequestBodySuccessfactors(BaseModel):
    r"""Fields specific to SAP SuccessFactors."""

    candidate: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="Candidate")
    ] = None
    r"""Fields that we will pass through to SuccessFactor's `Candidate` object."""

    job_application: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="JobApplication")
    ] = None
    r"""Fields that we will pass through to SuccessFactor's `JobApplication` object."""

    copy_job_application_attachments: Annotated[
        Optional[bool], pydantic.Field(alias="copyJobApplicationAttachments")
    ] = None
    r"""If set to true, we will copy custom attachments from the JobApplication to the Candidate."""

    update_existing_candidate: OptionalNullable[bool] = UNSET
    r"""When the candidate already exists, whether to update the Candidate with the remote fields found under the Candidate entity."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "Candidate",
            "JobApplication",
            "copyJobApplicationAttachments",
            "update_existing_candidate",
        ]
        nullable_fields = ["update_existing_candidate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsRequestBodyPersonioTypedDict(TypedDict):
    r"""Fields specific to Personio."""

    application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Personio's `application` object."""


class PostAtsJobsJobIDApplicationsRequestBodyPersonio(BaseModel):
    r"""Fields specific to Personio."""

    application: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Personio's `application` object."""


class PostAtsJobsJobIDApplicationsRequestBodyTalentsoftTypedDict(TypedDict):
    r"""Fields specific to TalentSoft."""

    applicant: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to TalentSoft's `applicant` object."""
    application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to TalentSoft's `application` object."""


class PostAtsJobsJobIDApplicationsRequestBodyTalentsoft(BaseModel):
    r"""Fields specific to TalentSoft."""

    applicant: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to TalentSoft's `applicant` object."""

    application: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to TalentSoft's `application` object."""


class PostAtsJobsJobIDApplicationsRequestBodyTeamtailorApplicationTypedDict(TypedDict):
    attributes: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Teamtailor's attributes section `Job application` object."""


class PostAtsJobsJobIDApplicationsRequestBodyTeamtailorApplication(BaseModel):
    attributes: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Teamtailor's attributes section `Job application` object."""


class PostAtsJobsJobIDApplicationsRequestBodyTeamtailorTypedDict(TypedDict):
    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Teamtailor's `Candidate` object."""
    application: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyTeamtailorApplicationTypedDict
    ]


class PostAtsJobsJobIDApplicationsRequestBodyTeamtailor(BaseModel):
    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Teamtailor's `Candidate` object."""

    application: Optional[
        PostAtsJobsJobIDApplicationsRequestBodyTeamtailorApplication
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyPostHeadersTypedDict(TypedDict):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: NotRequired[Nullable[str]]
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""


class PostAtsJobsJobIDApplicationsRequestBodyPostHeaders(BaseModel):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: Annotated[
        OptionalNullable[str], pydantic.Field(alias="On-Behalf-Of")
    ] = UNSET
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["On-Behalf-Of"]
        nullable_fields = ["On-Behalf-Of"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsJobsJobIDApplicationsRequestBodyGreenhouseTypedDict(TypedDict):
    r"""Fields specific to Greenhouse."""

    post_headers: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyPostHeadersTypedDict
    ]
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsJobsJobIDApplicationsRequestBodyGreenhouse(BaseModel):
    r"""Fields specific to Greenhouse."""

    post_headers: Optional[PostAtsJobsJobIDApplicationsRequestBodyPostHeaders] = None
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsJobsJobIDApplicationsRequestBodyLeverTypedDict(TypedDict):
    r"""Fields specific to Lever."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Lever's `Candidate` object. Note: make sure to submit the keys and values in the correct form data format."""


class PostAtsJobsJobIDApplicationsRequestBodyLever(BaseModel):
    r"""Fields specific to Lever."""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Lever's `Candidate` object. Note: make sure to submit the keys and values in the correct form data format."""


class PostAtsJobsJobIDApplicationsRequestBodyWorkableTypedDict(TypedDict):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: NotRequired[str]
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsJobsJobIDApplicationsRequestBodyWorkable(BaseModel):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: Optional[str] = None
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsJobsJobIDApplicationsRequestBodySocialSuffixReferenceTypedDict(TypedDict):
    r"""The WID of the social suffix reference for the candidate"""

    predefined_name_component_id: str


class PostAtsJobsJobIDApplicationsRequestBodySocialSuffixReference(BaseModel):
    r"""The WID of the social suffix reference for the candidate"""

    predefined_name_component_id: Annotated[
        str, pydantic.Field(alias="Predefined_Name_Component_ID")
    ]


class PostAtsJobsJobIDApplicationsRequestBodyNameDetailDataTypedDict(TypedDict):
    middle_name: NotRequired[str]
    r"""The candidate's middle name"""
    social_suffix_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodySocialSuffixReferenceTypedDict
    ]
    r"""The WID of the social suffix reference for the candidate"""


class PostAtsJobsJobIDApplicationsRequestBodyNameDetailData(BaseModel):
    middle_name: Annotated[Optional[str], pydantic.Field(alias="Middle_Name")] = None
    r"""The candidate's middle name"""

    social_suffix_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodySocialSuffixReference],
        pydantic.Field(alias="Social_Suffix_Reference"),
    ] = None
    r"""The WID of the social suffix reference for the candidate"""


class PostAtsJobsJobIDApplicationsRequestBodyLanguageReferenceTypedDict(TypedDict):
    r"""Used to set the candidate's primary language"""

    wid: str


class PostAtsJobsJobIDApplicationsRequestBodyLanguageReference(BaseModel):
    r"""Used to set the candidate's primary language"""

    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsJobsJobIDApplicationsRequestBodyGlobalPersonalInformationDataTypedDict(
    TypedDict
):
    date_of_birth: NotRequired[str]


class PostAtsJobsJobIDApplicationsRequestBodyGlobalPersonalInformationData(BaseModel):
    date_of_birth: Annotated[Optional[str], pydantic.Field(alias="Date_of_Birth")] = (
        None
    )


class PostAtsJobsJobIDApplicationsRequestBodyJobAppliedToDataTypedDict(TypedDict):
    global_personal_information_data: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyGlobalPersonalInformationDataTypedDict
    ]


class PostAtsJobsJobIDApplicationsRequestBodyJobAppliedToData(BaseModel):
    global_personal_information_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyGlobalPersonalInformationData],
        pydantic.Field(alias="Global_Personal_Information_Data"),
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyFieldOfStudyReferenceTypedDict(TypedDict):
    wid: str


class PostAtsJobsJobIDApplicationsRequestBodyFieldOfStudyReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsJobsJobIDApplicationsRequestBodyDegreeReferenceTypedDict(TypedDict):
    wid: str


class PostAtsJobsJobIDApplicationsRequestBodyDegreeReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsJobsJobIDApplicationsRequestBodyEducationDatumTypedDict(TypedDict):
    school_name: NotRequired[str]
    first_year_attended: NotRequired[float]
    last_year_attended: NotRequired[float]
    field_of_study_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyFieldOfStudyReferenceTypedDict
    ]
    degree_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyDegreeReferenceTypedDict
    ]
    grade_average: NotRequired[str]


class PostAtsJobsJobIDApplicationsRequestBodyEducationDatum(BaseModel):
    school_name: Annotated[Optional[str], pydantic.Field(alias="School_Name")] = None

    first_year_attended: Annotated[
        Optional[float], pydantic.Field(alias="First_Year_Attended")
    ] = None

    last_year_attended: Annotated[
        Optional[float], pydantic.Field(alias="Last_Year_Attended")
    ] = None

    field_of_study_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyFieldOfStudyReference],
        pydantic.Field(alias="Field_of_Study_Reference"),
    ] = None

    degree_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyDegreeReference],
        pydantic.Field(alias="Degree_Reference"),
    ] = None

    grade_average: Annotated[Optional[str], pydantic.Field(alias="Grade_Average")] = (
        None
    )


class PostAtsJobsJobIDApplicationsRequestBodySkillDatumTypedDict(TypedDict):
    skill_name: NotRequired[str]


class PostAtsJobsJobIDApplicationsRequestBodySkillDatum(BaseModel):
    skill_name: Annotated[Optional[str], pydantic.Field(alias="Skill_Name")] = None


class PostAtsJobsJobIDApplicationsRequestBodyLanguageDatumLanguageReferenceTypedDict(
    TypedDict
):
    wid: NotRequired[str]


class PostAtsJobsJobIDApplicationsRequestBodyLanguageDatumLanguageReference(BaseModel):
    wid: Annotated[Optional[str], pydantic.Field(alias="WID")] = None


class PostAtsJobsJobIDApplicationsRequestBodyLanguageProficiencyReferenceTypedDict(
    TypedDict
):
    wid: str


class PostAtsJobsJobIDApplicationsRequestBodyLanguageProficiencyReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityTypeReferenceTypedDict(
    TypedDict
):
    wid: str


class PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityTypeReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityDataTypedDict(TypedDict):
    language_proficiency_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyLanguageProficiencyReferenceTypedDict
    ]
    language_ability_type_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityTypeReferenceTypedDict
    ]


class PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityData(BaseModel):
    language_proficiency_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyLanguageProficiencyReference],
        pydantic.Field(alias="Language_Proficiency_Reference"),
    ] = None

    language_ability_type_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityTypeReference],
        pydantic.Field(alias="Language_Ability_Type_Reference"),
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityTypedDict(TypedDict):
    language_ability_data: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityDataTypedDict
    ]


class PostAtsJobsJobIDApplicationsRequestBodyLanguageAbility(BaseModel):
    language_ability_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityData],
        pydantic.Field(alias="Language_Ability_Data"),
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyLanguageTypedDict(TypedDict):
    language_ability: List[
        PostAtsJobsJobIDApplicationsRequestBodyLanguageAbilityTypedDict
    ]
    native: NotRequired[bool]


class PostAtsJobsJobIDApplicationsRequestBodyLanguage(BaseModel):
    language_ability: Annotated[
        List[PostAtsJobsJobIDApplicationsRequestBodyLanguageAbility],
        pydantic.Field(alias="Language_Ability"),
    ]

    native: Annotated[Optional[bool], pydantic.Field(alias="Native")] = None


class PostAtsJobsJobIDApplicationsRequestBodyLanguageDatumTypedDict(TypedDict):
    language_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyLanguageDatumLanguageReferenceTypedDict
    ]
    language: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyLanguageTypedDict]


class PostAtsJobsJobIDApplicationsRequestBodyLanguageDatum(BaseModel):
    language_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyLanguageDatumLanguageReference],
        pydantic.Field(alias="Language_Reference"),
    ] = None

    language: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyLanguage],
        pydantic.Field(alias="Language"),
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyExperienceDatumTypedDict(TypedDict):
    company_name: str
    title: str
    start_date: datetime
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    location: NotRequired[str]
    end_date: NotRequired[datetime]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    currently_work_here: NotRequired[bool]
    description: NotRequired[str]


class PostAtsJobsJobIDApplicationsRequestBodyExperienceDatum(BaseModel):
    company_name: Annotated[str, pydantic.Field(alias="Company_Name")]

    title: Annotated[str, pydantic.Field(alias="Title")]

    start_date: Annotated[datetime, pydantic.Field(alias="Start_Date")]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    location: Annotated[Optional[str], pydantic.Field(alias="Location")] = None

    end_date: Annotated[Optional[datetime], pydantic.Field(alias="End_Date")] = None
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    currently_work_here: Annotated[
        Optional[bool], pydantic.Field(alias="Currently_Work_Here")
    ] = None

    description: Annotated[Optional[str], pydantic.Field(alias="Description")] = None


class PostAtsJobsJobIDApplicationsRequestBodyResumeDataTypedDict(TypedDict):
    education_data: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodyEducationDatumTypedDict]
    ]
    skill_data: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodySkillDatumTypedDict]
    ]
    language_data: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodyLanguageDatumTypedDict]
    ]
    experience_data: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodyExperienceDatumTypedDict]
    ]


class PostAtsJobsJobIDApplicationsRequestBodyResumeData(BaseModel):
    education_data: Annotated[
        Optional[List[PostAtsJobsJobIDApplicationsRequestBodyEducationDatum]],
        pydantic.Field(alias="Education_Data"),
    ] = None

    skill_data: Annotated[
        Optional[List[PostAtsJobsJobIDApplicationsRequestBodySkillDatum]],
        pydantic.Field(alias="Skill_Data"),
    ] = None

    language_data: Annotated[
        Optional[List[PostAtsJobsJobIDApplicationsRequestBodyLanguageDatum]],
        pydantic.Field(alias="Language_Data"),
    ] = None

    experience_data: Annotated[
        Optional[List[PostAtsJobsJobIDApplicationsRequestBodyExperienceDatum]],
        pydantic.Field(alias="Experience_Data"),
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyJobApplicationDataTypedDict(TypedDict):
    job_applied_to_data: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyJobAppliedToDataTypedDict
    ]
    resume_data: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyResumeDataTypedDict]


class PostAtsJobsJobIDApplicationsRequestBodyJobApplicationData(BaseModel):
    job_applied_to_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyJobAppliedToData],
        pydantic.Field(alias="Job_Applied_To_Data"),
    ] = None

    resume_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyResumeData],
        pydantic.Field(alias="Resume_Data"),
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyCountryRegionReferenceTypedDict(TypedDict):
    country_region_id: str


class PostAtsJobsJobIDApplicationsRequestBodyCountryRegionReference(BaseModel):
    country_region_id: Annotated[str, pydantic.Field(alias="Country_Region_ID")]


class PostAtsJobsJobIDApplicationsRequestBodyCountryCityReferenceTypedDict(TypedDict):
    wid: str


class PostAtsJobsJobIDApplicationsRequestBodyCountryCityReference(BaseModel):
    wid: Annotated[str, pydantic.Field(alias="WID")]


class PostAtsJobsJobIDApplicationsRequestBodyLocationDataTypedDict(TypedDict):
    address_line_1: NotRequired[str]
    address_line_2: NotRequired[str]
    region_subdivision_1: NotRequired[str]
    country_region_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyCountryRegionReferenceTypedDict
    ]
    country_city_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyCountryCityReferenceTypedDict
    ]


class PostAtsJobsJobIDApplicationsRequestBodyLocationData(BaseModel):
    address_line_1: Annotated[Optional[str], pydantic.Field(alias="Address_Line_1")] = (
        None
    )

    address_line_2: Annotated[Optional[str], pydantic.Field(alias="Address_Line_2")] = (
        None
    )

    region_subdivision_1: Annotated[
        Optional[str], pydantic.Field(alias="Region_Subdivision_1")
    ] = None

    country_region_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyCountryRegionReference],
        pydantic.Field(alias="Country_Region_Reference"),
    ] = None

    country_city_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyCountryCityReference],
        pydantic.Field(alias="Country_City_Reference"),
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyContactDataTypedDict(TypedDict):
    location_data: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyLocationDataTypedDict
    ]


class PostAtsJobsJobIDApplicationsRequestBodyContactData(BaseModel):
    location_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyLocationData],
        pydantic.Field(alias="Location_Data"),
    ] = None


class PostAtsJobsJobIDApplicationsRequestBodyWorkerReferenceTypedDict(TypedDict):
    r"""Reference to the Worker (employee) to link the candidate to. Provide either WID or Employee_ID."""

    wid: NotRequired[str]
    employee_id: NotRequired[str]


class PostAtsJobsJobIDApplicationsRequestBodyWorkerReference(BaseModel):
    r"""Reference to the Worker (employee) to link the candidate to. Provide either WID or Employee_ID."""

    wid: Annotated[Optional[str], pydantic.Field(alias="WID")] = None

    employee_id: Annotated[Optional[str], pydantic.Field(alias="Employee_ID")] = None


class PostAtsJobsJobIDApplicationsRequestBodyCandidateDataTypedDict(TypedDict):
    name_detail_data: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyNameDetailDataTypedDict
    ]
    language_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyLanguageReferenceTypedDict
    ]
    r"""Used to set the candidate's primary language"""
    job_application_data: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyJobApplicationDataTypedDict
    ]
    contact_data: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyContactDataTypedDict
    ]
    worker_reference: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyWorkerReferenceTypedDict
    ]
    r"""Reference to the Worker (employee) to link the candidate to. Provide either WID or Employee_ID."""


class PostAtsJobsJobIDApplicationsRequestBodyCandidateData(BaseModel):
    name_detail_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyNameDetailData],
        pydantic.Field(alias="Name_Detail_Data"),
    ] = None

    language_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyLanguageReference],
        pydantic.Field(alias="Language_Reference"),
    ] = None
    r"""Used to set the candidate's primary language"""

    job_application_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyJobApplicationData],
        pydantic.Field(alias="Job_Application_Data"),
    ] = None

    contact_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyContactData],
        pydantic.Field(alias="Contact_Data"),
    ] = None

    worker_reference: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyWorkerReference],
        pydantic.Field(alias="Worker_Reference"),
    ] = None
    r"""Reference to the Worker (employee) to link the candidate to. Provide either WID or Employee_ID."""


class PostAtsJobsJobIDApplicationsRequestBodyWorkdayTypedDict(TypedDict):
    r"""Fields specific to Workday. The remote fields schema follows the documentation at https://community.workday.com/sites/default/files/file-hosting/productionapi/Recruiting/v43.0/Put_Candidate.html. Only defined fields are supported, if you need additional field support please reach out to Kombo support."""

    candidate_data: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyCandidateDataTypedDict
    ]
    override_source_reference_wid: NotRequired[str]
    r"""Used to override the automatic source WID."""


class PostAtsJobsJobIDApplicationsRequestBodyWorkday(BaseModel):
    r"""Fields specific to Workday. The remote fields schema follows the documentation at https://community.workday.com/sites/default/files/file-hosting/productionapi/Recruiting/v43.0/Put_Candidate.html. Only defined fields are supported, if you need additional field support please reach out to Kombo support."""

    candidate_data: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodyCandidateData],
        pydantic.Field(alias="Candidate_Data"),
    ] = None

    override_source_reference_wid: Annotated[
        Optional[str], pydantic.Field(alias="Override_Source_Reference_WID")
    ] = None
    r"""Used to override the automatic source WID."""


class PostAtsJobsJobIDApplicationsRequestBodyZohorecruitTypedDict(TypedDict):
    r"""Fields specific to Zoho Recruit."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Zoho Recruit's `Candidate` object."""


class PostAtsJobsJobIDApplicationsRequestBodyZohorecruit(BaseModel):
    r"""Fields specific to Zoho Recruit."""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Zoho Recruit's `Candidate` object."""


class PostAtsJobsJobIDApplicationsRequestBodyBullhornTypedDict(TypedDict):
    r"""Fields specific to Bullhorn."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Bullhorn's `Candidate` object."""
    job_submission: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Bullhorn's `JobSubmission` object."""


class PostAtsJobsJobIDApplicationsRequestBodyBullhorn(BaseModel):
    r"""Fields specific to Bullhorn."""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Bullhorn's `Candidate` object."""

    job_submission: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Bullhorn's `JobSubmission` object."""


class PostAtsJobsJobIDApplicationsRequestBodySmartrecruitersTypedDict(TypedDict):
    r"""Fields specific to SmartRecruiters."""

    candidate_with_questions: NotRequired[Dict[str, Any]]
    r"""**(⚠️ Deprecated - Use the `candidate` field instead.)** Fields that we will pass through to the SmartRecruiters's `Candidate` object when created with screening question answers. This API is used: https://developers.smartrecruiters.com/reference/createcandidate-1"""
    candidate_without_questions: NotRequired[Dict[str, Any]]
    r"""**(⚠️ Deprecated - Use the `candidate` field instead.)** Fields that we will pass through to the SmartRecruiters's `Candidate` object when created with screening question answers. This API is used: https://developers.smartrecruiters.com/reference/candidatesaddtojob-1"""
    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to the SmartRecruiters's `Candidate` object. This API is used: https://developers.smartrecruiters.com/reference/createcandidate-1"""


class PostAtsJobsJobIDApplicationsRequestBodySmartrecruiters(BaseModel):
    r"""Fields specific to SmartRecruiters."""

    candidate_with_questions: Annotated[
        Optional[Dict[str, Any]],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""**(⚠️ Deprecated - Use the `candidate` field instead.)** Fields that we will pass through to the SmartRecruiters's `Candidate` object when created with screening question answers. This API is used: https://developers.smartrecruiters.com/reference/createcandidate-1"""

    candidate_without_questions: Annotated[
        Optional[Dict[str, Any]],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""**(⚠️ Deprecated - Use the `candidate` field instead.)** Fields that we will pass through to the SmartRecruiters's `Candidate` object when created with screening question answers. This API is used: https://developers.smartrecruiters.com/reference/candidatesaddtojob-1"""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to the SmartRecruiters's `Candidate` object. This API is used: https://developers.smartrecruiters.com/reference/createcandidate-1"""


class PostAtsJobsJobIDApplicationsRequestBodyTalentadoreTypedDict(TypedDict):
    r"""Fields specific to Talentadore."""

    applications: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to the Talentadore's when creating applications."""


class PostAtsJobsJobIDApplicationsRequestBodyTalentadore(BaseModel):
    r"""Fields specific to Talentadore."""

    applications: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to the Talentadore's when creating applications."""


class PostAtsJobsJobIDApplicationsRequestBodyGuidecomTypedDict(TypedDict):
    r"""Fields specific to GuideCom."""

    candidate: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to GuideCom's `Candidate` object."""


class PostAtsJobsJobIDApplicationsRequestBodyGuidecom(BaseModel):
    r"""Fields specific to GuideCom."""

    candidate: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to GuideCom's `Candidate` object."""


class PostAtsJobsJobIDApplicationsRequestBodyDvinciTypedDict(TypedDict):
    r"""Fields specific to d.vinci."""

    application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to d.vinci's application object. This API is used: https://static.dvinci-easy.com/files/d.vinci%20application-apply-api.html#jobs__id__applyApi_post"""


class PostAtsJobsJobIDApplicationsRequestBodyDvinci(BaseModel):
    r"""Fields specific to d.vinci."""

    application: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to d.vinci's application object. This API is used: https://static.dvinci-easy.com/files/d.vinci%20application-apply-api.html#jobs__id__applyApi_post"""


class PostAtsJobsJobIDApplicationsRequestBodyHrworksTypedDict(TypedDict):
    r"""Fields specific to GuideCom."""

    job_application: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to HRWorks's `Job Application` object. This API is used: https://developers.hrworks.de/docs/hrworks-api-v2/53021f035f62d-post-job-applications"""


class PostAtsJobsJobIDApplicationsRequestBodyHrworks(BaseModel):
    r"""Fields specific to GuideCom."""

    job_application: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="jobApplication")
    ] = None
    r"""Fields that we will pass through to HRWorks's `Job Application` object. This API is used: https://developers.hrworks.de/docs/hrworks-api-v2/53021f035f62d-post-job-applications"""


class PostAtsJobsJobIDApplicationsRequestBodyJobylonApplicationTypedDict(TypedDict):
    r"""Fields that we will pass through to Jobylon's create application [endpoint](https://developer.jobylon.com/push-api-and-webhooks#-xL0v)'s request body."""

    message: NotRequired[str]
    r"""The `message` field of Jobylon's create application endpoint's request body."""


class PostAtsJobsJobIDApplicationsRequestBodyJobylonApplication(BaseModel):
    r"""Fields that we will pass through to Jobylon's create application [endpoint](https://developer.jobylon.com/push-api-and-webhooks#-xL0v)'s request body."""

    message: Optional[str] = None
    r"""The `message` field of Jobylon's create application endpoint's request body."""


class PostAtsJobsJobIDApplicationsRequestBodyJobylonTypedDict(TypedDict):
    r"""Fields specific to Jobylon."""

    application: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyJobylonApplicationTypedDict
    ]
    r"""Fields that we will pass through to Jobylon's create application [endpoint](https://developer.jobylon.com/push-api-and-webhooks#-xL0v)'s request body."""


class PostAtsJobsJobIDApplicationsRequestBodyJobylon(BaseModel):
    r"""Fields specific to Jobylon."""

    application: Optional[PostAtsJobsJobIDApplicationsRequestBodyJobylonApplication] = (
        None
    )
    r"""Fields that we will pass through to Jobylon's create application [endpoint](https://developer.jobylon.com/push-api-and-webhooks#-xL0v)'s request body."""


class PostAtsJobsJobIDApplicationsRequestBodyStepTypedDict(TypedDict):
    id: int
    r"""The ID of the workflow step to assign to the candidate."""


class PostAtsJobsJobIDApplicationsRequestBodyStep(BaseModel):
    id: int
    r"""The ID of the workflow step to assign to the candidate."""


class PostAtsJobsJobIDApplicationsRequestBodyWorkflowTypedDict(TypedDict):
    step: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyStepTypedDict]


class PostAtsJobsJobIDApplicationsRequestBodyWorkflow(BaseModel):
    step: Optional[PostAtsJobsJobIDApplicationsRequestBodyStep] = None


class PostAtsJobsJobIDApplicationsRequestBodyAvatureTypedDict(TypedDict):
    r"""Fields specific to Avature."""

    workflow: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyWorkflowTypedDict]


class PostAtsJobsJobIDApplicationsRequestBodyAvature(BaseModel):
    r"""Fields specific to Avature."""

    workflow: Optional[PostAtsJobsJobIDApplicationsRequestBodyWorkflow] = None


class PostAtsJobsJobIDApplicationsRequestBodyRecruiteeCandidateTypedDict(TypedDict):
    cover_letter_text: NotRequired[str]
    r"""The cover letter text as a string. This will be visible on the main candidate page. Can be provided together with the `cover_letter` attachment, which will end up in a separate `file` section."""


class PostAtsJobsJobIDApplicationsRequestBodyRecruiteeCandidate(BaseModel):
    cover_letter_text: Optional[str] = None
    r"""The cover letter text as a string. This will be visible on the main candidate page. Can be provided together with the `cover_letter` attachment, which will end up in a separate `file` section."""


class PostAtsJobsJobIDApplicationsRequestBodyRecruiteeTypedDict(TypedDict):
    r"""Fields specific to Recruitee."""

    candidate: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyRecruiteeCandidateTypedDict
    ]


class PostAtsJobsJobIDApplicationsRequestBodyRecruitee(BaseModel):
    r"""Fields specific to Recruitee."""

    candidate: Optional[PostAtsJobsJobIDApplicationsRequestBodyRecruiteeCandidate] = (
        None
    )


class PostAtsJobsJobIDApplicationsRequestBodyUmantisTypedDict(TypedDict):
    r"""Fields specific to Abacus Umantis."""

    person: NotRequired[Dict[str, Any]]
    r"""Fields that we will pass through to Abacus Umantis's \"Create a person\" endpoint's `attributes` when creating a candidate."""


class PostAtsJobsJobIDApplicationsRequestBodyUmantis(BaseModel):
    r"""Fields specific to Abacus Umantis."""

    person: Optional[Dict[str, Any]] = None
    r"""Fields that we will pass through to Abacus Umantis's \"Create a person\" endpoint's `attributes` when creating a candidate."""


class PostAtsJobsJobIDApplicationsRequestBodyPilogaCandidateTypedDict(TypedDict):
    r"""Additional candidate fields for P&I Loga that will be mapped to the application form."""

    street: NotRequired[str]
    r"""The street address of the candidate."""


class PostAtsJobsJobIDApplicationsRequestBodyPilogaCandidate(BaseModel):
    r"""Additional candidate fields for P&I Loga that will be mapped to the application form."""

    street: Optional[str] = None
    r"""The street address of the candidate."""


class PostAtsJobsJobIDApplicationsRequestBodyPilogaTypedDict(TypedDict):
    r"""Fields specific to P&I Loga."""

    candidate: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyPilogaCandidateTypedDict
    ]
    r"""Additional candidate fields for P&I Loga that will be mapped to the application form."""


class PostAtsJobsJobIDApplicationsRequestBodyPiloga(BaseModel):
    r"""Fields specific to P&I Loga."""

    candidate: Optional[PostAtsJobsJobIDApplicationsRequestBodyPilogaCandidate] = None
    r"""Additional candidate fields for P&I Loga that will be mapped to the application form."""


class PostAtsJobsJobIDApplicationsRequestBodyRemoteFieldsTypedDict(TypedDict):
    r"""Additional fields that we will pass through to specific ATS systems."""

    successfactors: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodySuccessfactorsTypedDict
    ]
    r"""Fields specific to SAP SuccessFactors."""
    personio: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyPersonioTypedDict]
    r"""Fields specific to Personio."""
    talentsoft: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyTalentsoftTypedDict]
    r"""Fields specific to TalentSoft."""
    teamtailor: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyTeamtailorTypedDict]
    greenhouse: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyGreenhouseTypedDict]
    r"""Fields specific to Greenhouse."""
    lever: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyLeverTypedDict]
    r"""Fields specific to Lever."""
    workable: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyWorkableTypedDict]
    r"""Workable specific remote fields for ATS actions."""
    workday: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyWorkdayTypedDict]
    r"""Fields specific to Workday. The remote fields schema follows the documentation at https://community.workday.com/sites/default/files/file-hosting/productionapi/Recruiting/v43.0/Put_Candidate.html. Only defined fields are supported, if you need additional field support please reach out to Kombo support."""
    zohorecruit: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyZohorecruitTypedDict
    ]
    r"""Fields specific to Zoho Recruit."""
    bullhorn: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyBullhornTypedDict]
    r"""Fields specific to Bullhorn."""
    smartrecruiters: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodySmartrecruitersTypedDict
    ]
    r"""Fields specific to SmartRecruiters."""
    talentadore: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyTalentadoreTypedDict
    ]
    r"""Fields specific to Talentadore."""
    guidecom: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyGuidecomTypedDict]
    r"""Fields specific to GuideCom."""
    dvinci: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyDvinciTypedDict]
    r"""Fields specific to d.vinci."""
    hrworks: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyHrworksTypedDict]
    r"""Fields specific to GuideCom."""
    jobylon: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyJobylonTypedDict]
    r"""Fields specific to Jobylon."""
    avature: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyAvatureTypedDict]
    r"""Fields specific to Avature."""
    recruitee: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyRecruiteeTypedDict]
    r"""Fields specific to Recruitee."""
    umantis: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyUmantisTypedDict]
    r"""Fields specific to Abacus Umantis."""
    piloga: NotRequired[PostAtsJobsJobIDApplicationsRequestBodyPilogaTypedDict]
    r"""Fields specific to P&I Loga."""


class PostAtsJobsJobIDApplicationsRequestBodyRemoteFields(BaseModel):
    r"""Additional fields that we will pass through to specific ATS systems."""

    successfactors: Optional[PostAtsJobsJobIDApplicationsRequestBodySuccessfactors] = (
        None
    )
    r"""Fields specific to SAP SuccessFactors."""

    personio: Optional[PostAtsJobsJobIDApplicationsRequestBodyPersonio] = None
    r"""Fields specific to Personio."""

    talentsoft: Optional[PostAtsJobsJobIDApplicationsRequestBodyTalentsoft] = None
    r"""Fields specific to TalentSoft."""

    teamtailor: Optional[PostAtsJobsJobIDApplicationsRequestBodyTeamtailor] = None

    greenhouse: Optional[PostAtsJobsJobIDApplicationsRequestBodyGreenhouse] = None
    r"""Fields specific to Greenhouse."""

    lever: Optional[PostAtsJobsJobIDApplicationsRequestBodyLever] = None
    r"""Fields specific to Lever."""

    workable: Optional[PostAtsJobsJobIDApplicationsRequestBodyWorkable] = None
    r"""Workable specific remote fields for ATS actions."""

    workday: Optional[PostAtsJobsJobIDApplicationsRequestBodyWorkday] = None
    r"""Fields specific to Workday. The remote fields schema follows the documentation at https://community.workday.com/sites/default/files/file-hosting/productionapi/Recruiting/v43.0/Put_Candidate.html. Only defined fields are supported, if you need additional field support please reach out to Kombo support."""

    zohorecruit: Optional[PostAtsJobsJobIDApplicationsRequestBodyZohorecruit] = None
    r"""Fields specific to Zoho Recruit."""

    bullhorn: Optional[PostAtsJobsJobIDApplicationsRequestBodyBullhorn] = None
    r"""Fields specific to Bullhorn."""

    smartrecruiters: Optional[
        PostAtsJobsJobIDApplicationsRequestBodySmartrecruiters
    ] = None
    r"""Fields specific to SmartRecruiters."""

    talentadore: Optional[PostAtsJobsJobIDApplicationsRequestBodyTalentadore] = None
    r"""Fields specific to Talentadore."""

    guidecom: Optional[PostAtsJobsJobIDApplicationsRequestBodyGuidecom] = None
    r"""Fields specific to GuideCom."""

    dvinci: Optional[PostAtsJobsJobIDApplicationsRequestBodyDvinci] = None
    r"""Fields specific to d.vinci."""

    hrworks: Optional[PostAtsJobsJobIDApplicationsRequestBodyHrworks] = None
    r"""Fields specific to GuideCom."""

    jobylon: Optional[PostAtsJobsJobIDApplicationsRequestBodyJobylon] = None
    r"""Fields specific to Jobylon."""

    avature: Optional[PostAtsJobsJobIDApplicationsRequestBodyAvature] = None
    r"""Fields specific to Avature."""

    recruitee: Optional[PostAtsJobsJobIDApplicationsRequestBodyRecruitee] = None
    r"""Fields specific to Recruitee."""

    umantis: Optional[PostAtsJobsJobIDApplicationsRequestBodyUmantis] = None
    r"""Fields specific to Abacus Umantis."""

    piloga: Optional[PostAtsJobsJobIDApplicationsRequestBodyPiloga] = None
    r"""Fields specific to P&I Loga."""


class PostAtsJobsJobIDApplicationsRequestBodyAnswerTypedDict(TypedDict):
    r"""Answer to a `FILE` question."""

    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""
    content_type: NotRequired[str]
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """
    data_url: NotRequired[str]
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """
    data: NotRequired[str]
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PostAtsJobsJobIDApplicationsRequestBodyAnswer(BaseModel):
    r"""Answer to a `FILE` question."""

    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""

    content_type: Optional[str] = None
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """

    data_url: Optional[str] = None
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """

    data: Optional[str] = None
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


PostAtsJobsJobIDApplicationsRequestBodyAnswerUnionTypedDict = TypeAliasType(
    "PostAtsJobsJobIDApplicationsRequestBodyAnswerUnionTypedDict",
    Union[
        PostAtsJobsJobIDApplicationsRequestBodyAnswerTypedDict,
        str,
        bool,
        float,
        List[str],
        datetime,
    ],
)
r"""Answer to a question. This will be validated based on the question format and throw an error if the answer is invalid. Here is a description of each question type and the required answer format:

`TEXT` - Simply provide a \"string\" answer.

`SINGLE_SELECT` - Provide the ID of the answer as a string.

`MULTI_SELECT` - Provide a string array containing the question IDs of the selected options.

`BOOLEAN` - Either `true` or `false`.

`NUMBER` - A number.

`DATE` - Provide the answer as an ISO 8601 date string.

`FILE` - Please select Option 6 in the dropdown above to see the required format.
"""


PostAtsJobsJobIDApplicationsRequestBodyAnswerUnion = TypeAliasType(
    "PostAtsJobsJobIDApplicationsRequestBodyAnswerUnion",
    Union[
        PostAtsJobsJobIDApplicationsRequestBodyAnswer,
        str,
        bool,
        float,
        List[str],
        datetime,
    ],
)
r"""Answer to a question. This will be validated based on the question format and throw an error if the answer is invalid. Here is a description of each question type and the required answer format:

`TEXT` - Simply provide a \"string\" answer.

`SINGLE_SELECT` - Provide the ID of the answer as a string.

`MULTI_SELECT` - Provide a string array containing the question IDs of the selected options.

`BOOLEAN` - Either `true` or `false`.

`NUMBER` - A number.

`DATE` - Provide the answer as an ISO 8601 date string.

`FILE` - Please select Option 6 in the dropdown above to see the required format.
"""


class PostAtsJobsJobIDApplicationsRequestBodyScreeningQuestionAnswerTypedDict(
    TypedDict
):
    question_id: str
    r"""ID of the question returned by the Kombo API. We'll report a warning in the logs if the question can't be found on the job."""
    answer: PostAtsJobsJobIDApplicationsRequestBodyAnswerUnionTypedDict
    r"""Answer to a question. This will be validated based on the question format and throw an error if the answer is invalid. Here is a description of each question type and the required answer format:

    `TEXT` - Simply provide a \"string\" answer.

    `SINGLE_SELECT` - Provide the ID of the answer as a string.

    `MULTI_SELECT` - Provide a string array containing the question IDs of the selected options.

    `BOOLEAN` - Either `true` or `false`.

    `NUMBER` - A number.

    `DATE` - Provide the answer as an ISO 8601 date string.

    `FILE` - Please select Option 6 in the dropdown above to see the required format.
    """


class PostAtsJobsJobIDApplicationsRequestBodyScreeningQuestionAnswer(BaseModel):
    question_id: str
    r"""ID of the question returned by the Kombo API. We'll report a warning in the logs if the question can't be found on the job."""

    answer: PostAtsJobsJobIDApplicationsRequestBodyAnswerUnion
    r"""Answer to a question. This will be validated based on the question format and throw an error if the answer is invalid. Here is a description of each question type and the required answer format:

    `TEXT` - Simply provide a \"string\" answer.

    `SINGLE_SELECT` - Provide the ID of the answer as a string.

    `MULTI_SELECT` - Provide a string array containing the question IDs of the selected options.

    `BOOLEAN` - Either `true` or `false`.

    `NUMBER` - A number.

    `DATE` - Provide the answer as an ISO 8601 date string.

    `FILE` - Please select Option 6 in the dropdown above to see the required format.
    """


class PostAtsJobsJobIDApplicationsRequestBodyTypedDict(TypedDict):
    candidate: PostAtsJobsJobIDApplicationsRequestBodyCandidateTypedDict
    stage_id: NotRequired[str]
    r"""Stage this candidate should be in. If left out, the default stage for this job will be used. You can obtain the possible `stage_id`s from the `get-jobs` endpoint."""
    attachments: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodyAttachmentTypedDict]
    ]
    r"""Array of the attachments you would like to upload. The first CV in the attachments will be treated as the resume of the candidate when the tool allows previewing a resume."""
    source: NotRequired[PostAtsJobsJobIDApplicationsRequestBodySourceTypedDict]
    r"""**(⚠️ Deprecated - Use [automatic source writing](/ats/features/application-attribution#automatic-attribution) instead)** Optional source information that will be attached to the candidate. If
    you're a job board or recruiting service, you can use this to make sure your
    customers can see which candidates came from you.

    This is deprecated because writing sources requires users to do some setup in most ATSs.
    """
    sourced_by: NotRequired[PostAtsJobsJobIDApplicationsRequestBodySourcedByTypedDict]
    r"""Credit the recruiter or team member who sourced this candidate.

    While the `source` field tracks the channel/platform (e.g., \"Awesome Jobboard\"), the `sourced_by` field tracks the individual person responsible for finding the candidate.
    """
    gdpr_consent: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyGdprConsentTypedDict
    ]
    r"""Optional GDPR consent information required in some jurisdictions (like the Czech Republic or Slovakia)."""
    remote_fields: NotRequired[
        PostAtsJobsJobIDApplicationsRequestBodyRemoteFieldsTypedDict
    ]
    r"""Additional fields that we will pass through to specific ATS systems."""
    screening_question_answers: NotRequired[
        List[PostAtsJobsJobIDApplicationsRequestBodyScreeningQuestionAnswerTypedDict]
    ]
    r"""Array of answers to screening questions. Currently, not all question types are supported, and unsupported ones will not be submitted.

    The available questions for a job can be retrieved from the get jobs endpoint. The answers will be validated based on the format of the questions. Make sure to follow this schema to avoid errors.
    """


class PostAtsJobsJobIDApplicationsRequestBody(BaseModel):
    candidate: PostAtsJobsJobIDApplicationsRequestBodyCandidate

    stage_id: Optional[str] = None
    r"""Stage this candidate should be in. If left out, the default stage for this job will be used. You can obtain the possible `stage_id`s from the `get-jobs` endpoint."""

    attachments: Optional[List[PostAtsJobsJobIDApplicationsRequestBodyAttachment]] = (
        None
    )
    r"""Array of the attachments you would like to upload. The first CV in the attachments will be treated as the resume of the candidate when the tool allows previewing a resume."""

    source: Annotated[
        Optional[PostAtsJobsJobIDApplicationsRequestBodySource],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""**(⚠️ Deprecated - Use [automatic source writing](/ats/features/application-attribution#automatic-attribution) instead)** Optional source information that will be attached to the candidate. If
    you're a job board or recruiting service, you can use this to make sure your
    customers can see which candidates came from you.

    This is deprecated because writing sources requires users to do some setup in most ATSs.
    """

    sourced_by: Optional[PostAtsJobsJobIDApplicationsRequestBodySourcedBy] = None
    r"""Credit the recruiter or team member who sourced this candidate.

    While the `source` field tracks the channel/platform (e.g., \"Awesome Jobboard\"), the `sourced_by` field tracks the individual person responsible for finding the candidate.
    """

    gdpr_consent: Optional[PostAtsJobsJobIDApplicationsRequestBodyGdprConsent] = None
    r"""Optional GDPR consent information required in some jurisdictions (like the Czech Republic or Slovakia)."""

    remote_fields: Optional[PostAtsJobsJobIDApplicationsRequestBodyRemoteFields] = None
    r"""Additional fields that we will pass through to specific ATS systems."""

    screening_question_answers: Optional[
        List[PostAtsJobsJobIDApplicationsRequestBodyScreeningQuestionAnswer]
    ] = None
    r"""Array of answers to screening questions. Currently, not all question types are supported, and unsupported ones will not be submitted.

    The available questions for a job can be retrieved from the get jobs endpoint. The answers will be validated based on the format of the questions. Make sure to follow this schema to avoid errors.
    """
