"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict


PostConnectCreateLinkRequestBodyIntegrationCategory = Literal[
    "HRIS",
    "ATS",
    "ASSESSMENT",
]
r"""Category of the integration you want your customer to create."""


IntegrationTool = Literal[
    "personio",
    "workday",
    "workdaycustomreport",
    "workdaycustomreportsftp",
    "successfactors",
    "smartrecruiters",
    "factorial",
    "oraclerecruiting",
    "lever",
    "icims",
    "cornerstonetalentlink",
    "recruitee",
    "recruiterflow",
    "greenhouse",
    "greenhousejobboard",
    "teamtailor",
    "teamtailorjobboards",
    "ashby",
    "talentsoft",
    "talentsoftcustomer",
    "concludis",
    "talention",
    "piloga",
    "onlyfy",
    "ukgpro",
    "ukgready",
    "adpworkforcenow",
    "taleo",
    "rexx",
    "afas",
    "bamboohr",
    "bullhorn",
    "bullhornlogin",
    "workable",
    "payfitcustomer",
    "payfitpartner",
    "payfit",
    "jobvite",
    "employmenthero",
    "fountain",
    "fourth",
    "kenjo",
    "heavenhr",
    "hibob",
    "softgarden",
    "cezannehr",
    "entraid",
    "azuread",
    "googleworkspace",
    "nmbrs",
    "pinpoint",
    "welcometothejungle",
    "dvinci",
    "dvinciadmin",
    "join",
    "deel",
    "remotecom",
    "iriscascade",
    "okta",
    "sagehr",
    "sagepeople",
    "humaans",
    "traffit",
    "erecruiter",
    "eurecia",
    "abacusumantis",
    "umantis",
    "jobylon",
    "oraclehcm",
    "taleez",
    "officient",
    "sesamehr",
    "charliehr",
    "hrworks",
    "abacus",
    "otys",
    "zohopeople",
    "zohorecruit",
    "gusto",
    "breathehr",
    "catalystone",
    "mirus",
    "alexishr",
    "simployer",
    "eploy",
    "jobdiva",
    "peple",
    "youserve",
    "careerplug",
    "perview",
    "eightfold",
    "dayforce",
    "hansalog",
    "lattice",
    "trinet",
    "paylocity",
    "paycor",
    "namely",
    "paycom",
    "insperity",
    "paychex",
    "avature",
    "apploi",
    "phenom",
    "rippling",
    "sapling",
    "heyrecruit",
    "peoplehr",
    "recruhr",
    "jazzhr",
    "lucca",
    "bite",
    "zelt",
    "planday",
    "boondmanager",
    "homerun",
    "haileyhr",
    "silae",
    "mysolution",
    "carerix",
    "hroffice",
    "talentclue",
    "inrecruiting",
    "ubeeo",
    "oysterhr",
    "kiwihr",
    "connexys",
    "hr4you",
    "cornerstoneondemand",
    "zvooverecruit",
    "square",
    "perbilityhelix",
    "comeet",
    "leapsome",
    "compleet",
    "compleetpitcher",
    "gem",
    "loket",
    "workforcecom",
    "laura",
    "covetorest",
    "coveto",
    "peoplefirst",
    "sdworx",
    "crelate",
    "absenceio",
    "manatal",
    "avionte",
    "a3innuvanomina",
    "mhmhr",
    "scim",
    "softgardenpartner",
    "datevhr",
    "datev",
    "datevlug",
    "sympa",
    "breezyhr",
    "flatchr",
    "applicantstack",
    "reachmee",
    "talentadore",
    "youforce",
    "nibelis",
    "peoplexd",
    "sandbox",
    "guidecom",
    "sftp",
    "sftpfetch",
]
r"""Pre-define a tool this integration link can be used for."""


PostConnectCreateLinkRequestBodyLanguage = Literal[
    "en",
    "de",
    "fr",
    "it",
    "es",
]
r"""Language of the connection flow UI."""


PostConnectCreateLinkRequestBodyLinkType = Literal[
    "EMBEDDED",
    "MAGIC_LINK",
]
r"""The type of link you want to create. `EMBEDDED` is for the [embedded flow](../guides/connect/embedded-flow) using the Kombo Connect SDK (these links are valid for 1 hour) and `MAGIC_LINK` is for [magic links](../guides/connect/magic-links) which you send out manually to customers (there are valid for 1 year).

This defaults to `EMBEDDED`, which is our recommended method of implementing the connection flow for a seamless user experience.
"""


class PostConnectCreateLinkRequestBodyTypedDict(TypedDict):
    end_user_email: str
    r"""The email of the user this link is meant for."""
    end_user_organization_name: str
    r"""The name of the user's organization."""
    end_user_origin_id: NotRequired[Nullable[str]]
    r"""The id the user/organization has in your own database."""
    remote_environment: NotRequired[Nullable[str]]
    r"""If the tool you want to connect offers different environments, you can specify which one you want to connect to here. If you don't specify this, we'll assume you want to use the production environment. Note that this can only be used if you've also specified a tool through `integration_tool`."""
    integration_category: NotRequired[
        PostConnectCreateLinkRequestBodyIntegrationCategory
    ]
    r"""Category of the integration you want your customer to create."""
    integration_tool: NotRequired[Nullable[IntegrationTool]]
    r"""Pre-define a tool this integration link can be used for."""
    language: NotRequired[Nullable[PostConnectCreateLinkRequestBodyLanguage]]
    r"""Language of the connection flow UI."""
    scope_config_id: NotRequired[Nullable[str]]
    r"""Specify a scope config that should be used for this integration. This is an advanced feature, only use it if you know what you're doing!"""
    enable_filtering: NotRequired[bool]
    r"""Enable the [filtering feature](https://docs.kombo.dev/other/filtering) for the integration. HRIS only."""
    enable_field_mapping: NotRequired[bool]
    r"""Enable the [field mapping feature](https://docs.kombo.dev/hris/features/setup-flow/introduction#field-mapping) for this integration."""
    link_type: NotRequired[PostConnectCreateLinkRequestBodyLinkType]
    r"""The type of link you want to create. `EMBEDDED` is for the [embedded flow](../guides/connect/embedded-flow) using the Kombo Connect SDK (these links are valid for 1 hour) and `MAGIC_LINK` is for [magic links](../guides/connect/magic-links) which you send out manually to customers (there are valid for 1 year).

    This defaults to `EMBEDDED`, which is our recommended method of implementing the connection flow for a seamless user experience.
    """


class PostConnectCreateLinkRequestBody(BaseModel):
    end_user_email: str
    r"""The email of the user this link is meant for."""

    end_user_organization_name: str
    r"""The name of the user's organization."""

    end_user_origin_id: OptionalNullable[str] = UNSET
    r"""The id the user/organization has in your own database."""

    remote_environment: OptionalNullable[str] = UNSET
    r"""If the tool you want to connect offers different environments, you can specify which one you want to connect to here. If you don't specify this, we'll assume you want to use the production environment. Note that this can only be used if you've also specified a tool through `integration_tool`."""

    integration_category: Optional[
        PostConnectCreateLinkRequestBodyIntegrationCategory
    ] = "HRIS"
    r"""Category of the integration you want your customer to create."""

    integration_tool: OptionalNullable[IntegrationTool] = UNSET
    r"""Pre-define a tool this integration link can be used for."""

    language: OptionalNullable[PostConnectCreateLinkRequestBodyLanguage] = "en"
    r"""Language of the connection flow UI."""

    scope_config_id: OptionalNullable[str] = UNSET
    r"""Specify a scope config that should be used for this integration. This is an advanced feature, only use it if you know what you're doing!"""

    enable_filtering: Optional[bool] = False
    r"""Enable the [filtering feature](https://docs.kombo.dev/other/filtering) for the integration. HRIS only."""

    enable_field_mapping: Optional[bool] = False
    r"""Enable the [field mapping feature](https://docs.kombo.dev/hris/features/setup-flow/introduction#field-mapping) for this integration."""

    link_type: Optional[PostConnectCreateLinkRequestBodyLinkType] = "EMBEDDED"
    r"""The type of link you want to create. `EMBEDDED` is for the [embedded flow](../guides/connect/embedded-flow) using the Kombo Connect SDK (these links are valid for 1 hour) and `MAGIC_LINK` is for [magic links](../guides/connect/magic-links) which you send out manually to customers (there are valid for 1 year).

    This defaults to `EMBEDDED`, which is our recommended method of implementing the connection flow for a seamless user experience.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "end_user_origin_id",
            "remote_environment",
            "integration_category",
            "integration_tool",
            "language",
            "scope_config_id",
            "enable_filtering",
            "enable_field_mapping",
            "link_type",
        ]
        nullable_fields = [
            "end_user_origin_id",
            "remote_environment",
            "integration_tool",
            "language",
            "scope_config_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
