"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from kombo.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Any, List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


PostHrisAbsencesPositiveResponseUnit = Literal[
    "HOURS",
    "DAYS",
]
r"""The unit of time for this absence. Can be `HOURS` or `DAYS`."""


PostHrisAbsencesPositiveResponseStatus = Union[
    Literal[
        "REQUESTED",
        "APPROVED",
        "DECLINED",
        "CANCELLED",
        "DELETED",
    ],
    UnrecognizedStr,
]


class PostHrisAbsencesPositiveResponseDataTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    employee_id: str
    r"""The Kombo ID of the employee to which the absence belongs to. The ID can be used to retrieve the employee from the `get employees` endpoint."""
    start_date: Nullable[Any]
    r"""The date this absence starts in the `yyyy-MM-dd` format."""
    end_date: Nullable[Any]
    r"""The date this absence ends in the `yyyy-MM-dd` format."""
    start_half_day: Nullable[bool]
    r"""`true` if the absence starts in the middle of the day, `false` if not, and `null` if the absence type doesn't support half-day absences. For multi-day absences, this only applies to the first day of the absence."""
    end_half_day: Nullable[bool]
    r"""`true` if the absence ends in the middle of the day, `false` if not, and `null` if the absence type doesn't support half-day absences. For multi-day absences, this only applies to the last day of the absence."""
    start_time: Nullable[Any]
    r"""The time at which this absence starts. Follows the format `HH:mm:ss` (e.g., `14:45:15`)."""
    end_time: Nullable[Any]
    r"""The time at which this absence ends. Follows the format `HH:mm:ss` (e.g., `14:45:15`)."""
    amount: Nullable[float]
    r"""The amount of time this absence takes."""
    unit: Nullable[PostHrisAbsencesPositiveResponseUnit]
    r"""The unit of time for this absence. Can be `HOURS` or `DAYS`."""
    employee_note: Nullable[str]
    r"""A note the employee has added to this absence."""
    type_id: Nullable[str]
    r"""The Kombo absence type ID of this absence."""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    status: NotRequired[Nullable[PostHrisAbsencesPositiveResponseStatus]]
    r"""The absence’s current status. In rare cases where we can’t find a clear mapping, the original string is passed through."""


class PostHrisAbsencesPositiveResponseData(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    employee_id: str
    r"""The Kombo ID of the employee to which the absence belongs to. The ID can be used to retrieve the employee from the `get employees` endpoint."""

    start_date: Nullable[Any]
    r"""The date this absence starts in the `yyyy-MM-dd` format."""

    end_date: Nullable[Any]
    r"""The date this absence ends in the `yyyy-MM-dd` format."""

    start_half_day: Nullable[bool]
    r"""`true` if the absence starts in the middle of the day, `false` if not, and `null` if the absence type doesn't support half-day absences. For multi-day absences, this only applies to the first day of the absence."""

    end_half_day: Nullable[bool]
    r"""`true` if the absence ends in the middle of the day, `false` if not, and `null` if the absence type doesn't support half-day absences. For multi-day absences, this only applies to the last day of the absence."""

    start_time: Nullable[Any]
    r"""The time at which this absence starts. Follows the format `HH:mm:ss` (e.g., `14:45:15`)."""

    end_time: Nullable[Any]
    r"""The time at which this absence ends. Follows the format `HH:mm:ss` (e.g., `14:45:15`)."""

    amount: Nullable[float]
    r"""The amount of time this absence takes."""

    unit: Nullable[PostHrisAbsencesPositiveResponseUnit]
    r"""The unit of time for this absence. Can be `HOURS` or `DAYS`."""

    employee_note: Nullable[str]
    r"""A note the employee has added to this absence."""

    type_id: Nullable[str]
    r"""The Kombo absence type ID of this absence."""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    status: Annotated[
        OptionalNullable[PostHrisAbsencesPositiveResponseStatus],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The absence’s current status. In rare cases where we can’t find a clear mapping, the original string is passed through."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["status"]
        nullable_fields = [
            "remote_id",
            "start_date",
            "end_date",
            "start_half_day",
            "end_half_day",
            "start_time",
            "end_time",
            "amount",
            "unit",
            "status",
            "employee_note",
            "type_id",
            "remote_deleted_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostHrisAbsencesPositiveResponseWarningTypedDict(TypedDict):
    message: str


class PostHrisAbsencesPositiveResponseWarning(BaseModel):
    message: str


class PostHrisAbsencesPositiveResponseTypedDict(TypedDict):
    data: PostHrisAbsencesPositiveResponseDataTypedDict
    warnings: List[PostHrisAbsencesPositiveResponseWarningTypedDict]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""
    status: Literal["success"]


class PostHrisAbsencesPositiveResponse(BaseModel):
    data: PostHrisAbsencesPositiveResponseData

    warnings: List[PostHrisAbsencesPositiveResponseWarning]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
