"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict


PostHrisAbsencesRequestBodyStatus = Literal[
    "REQUESTED",
    "APPROVED",
]
r"""The state that the absence should be created in. Some tools may approve absences automatically if they were created for an absence type that does not require approval."""


PostHrisAbsencesRequestBodyUnit = Literal[
    "HOURS",
    "DAYS",
]
r"""The time unit of the `amount` value. Specifying this also requires specifying `amount`."""


class PostHrisAbsencesRequestBodyAdpworkforcenowTypedDict(TypedDict):
    r"""Fields specific to ADP Workforce Now."""

    employment_id: NotRequired[str]
    r"""[Required] The employment ID of the employee that the absence will be added to."""
    paid_leave: NotRequired[bool]
    r"""Whether the absence is paid or not."""


class PostHrisAbsencesRequestBodyAdpworkforcenow(BaseModel):
    r"""Fields specific to ADP Workforce Now."""

    employment_id: Optional[str] = None
    r"""[Required] The employment ID of the employee that the absence will be added to."""

    paid_leave: Optional[bool] = None
    r"""Whether the absence is paid or not."""


class PostHrisAbsencesRequestBodyRemoteFieldsTypedDict(TypedDict):
    r"""Additional fields that we will pass through to specific HRIS systems."""

    adpworkforcenow: NotRequired[PostHrisAbsencesRequestBodyAdpworkforcenowTypedDict]
    r"""Fields specific to ADP Workforce Now."""


class PostHrisAbsencesRequestBodyRemoteFields(BaseModel):
    r"""Additional fields that we will pass through to specific HRIS systems."""

    adpworkforcenow: Optional[PostHrisAbsencesRequestBodyAdpworkforcenow] = None
    r"""Fields specific to ADP Workforce Now."""


class PostHrisAbsencesRequestBodyTypedDict(TypedDict):
    employee_id: str
    r"""The ID of the employee in Kombo or their ID in the remote system by prefixing it with `remote:` (e.g., `remote:12312`)"""
    absence_type_id: str
    r"""The ID of the absence type in Kombo (not its `remote_id`)."""
    start_date: datetime
    r"""The date that the absence starts. This is a plain date (i.e., `yyyy-MM-dd`), with all time information discarded.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    end_date: datetime
    r"""When the absence ends.The date that the absence ends. This is a plain date (i.e., `yyyy-MM-dd`), with all time information discarded.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    employee_note: Nullable[str]
    r"""A note describing the reason for this absence."""
    status: NotRequired[PostHrisAbsencesRequestBodyStatus]
    r"""The state that the absence should be created in. Some tools may approve absences automatically if they were created for an absence type that does not require approval."""
    start_half_day: NotRequired[bool]
    r"""`true` if the absence should start in the middle of the day."""
    end_half_day: NotRequired[bool]
    r"""`true` if the absence should end in the middle of the day."""
    amount: NotRequired[float]
    r"""The amount of time of the absence. Specifying this also requires specifying `unit`. This is supported by very few tools."""
    unit: NotRequired[PostHrisAbsencesRequestBodyUnit]
    r"""The time unit of the `amount` value. Specifying this also requires specifying `amount`."""
    start_time: NotRequired[str]
    r"""The time of when the absence begins. Follows the format `HH:mm` or `HH:mm:ss` (e.g., `14:45:15`). If `start_time` is specified, `end_time` has to be specified as well."""
    end_time: NotRequired[str]
    r"""The time of when the absence ends. Follows the format `HH:mm` or `HH:mm:ss` (e.g., `14:45:15`). If `end_time` is specified, `start_time` has to be specified as well."""
    remote_fields: NotRequired[PostHrisAbsencesRequestBodyRemoteFieldsTypedDict]
    r"""Additional fields that we will pass through to specific HRIS systems."""


class PostHrisAbsencesRequestBody(BaseModel):
    employee_id: str
    r"""The ID of the employee in Kombo or their ID in the remote system by prefixing it with `remote:` (e.g., `remote:12312`)"""

    absence_type_id: str
    r"""The ID of the absence type in Kombo (not its `remote_id`)."""

    start_date: datetime
    r"""The date that the absence starts. This is a plain date (i.e., `yyyy-MM-dd`), with all time information discarded.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    end_date: datetime
    r"""When the absence ends.The date that the absence ends. This is a plain date (i.e., `yyyy-MM-dd`), with all time information discarded.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    employee_note: Nullable[str]
    r"""A note describing the reason for this absence."""

    status: Optional[PostHrisAbsencesRequestBodyStatus] = "REQUESTED"
    r"""The state that the absence should be created in. Some tools may approve absences automatically if they were created for an absence type that does not require approval."""

    start_half_day: Optional[bool] = False
    r"""`true` if the absence should start in the middle of the day."""

    end_half_day: Optional[bool] = False
    r"""`true` if the absence should end in the middle of the day."""

    amount: Optional[float] = None
    r"""The amount of time of the absence. Specifying this also requires specifying `unit`. This is supported by very few tools."""

    unit: Optional[PostHrisAbsencesRequestBodyUnit] = None
    r"""The time unit of the `amount` value. Specifying this also requires specifying `amount`."""

    start_time: Optional[str] = None
    r"""The time of when the absence begins. Follows the format `HH:mm` or `HH:mm:ss` (e.g., `14:45:15`). If `start_time` is specified, `end_time` has to be specified as well."""

    end_time: Optional[str] = None
    r"""The time of when the absence ends. Follows the format `HH:mm` or `HH:mm:ss` (e.g., `14:45:15`). If `end_time` is specified, `start_time` has to be specified as well."""

    remote_fields: Optional[PostHrisAbsencesRequestBodyRemoteFields] = None
    r"""Additional fields that we will pass through to specific HRIS systems."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "status",
            "start_half_day",
            "end_half_day",
            "amount",
            "unit",
            "start_time",
            "end_time",
            "remote_fields",
        ]
        nullable_fields = ["employee_note"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
