"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class DocumentTypedDict(TypedDict):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""
    content_type: NotRequired[str]
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """
    data_url: NotRequired[str]
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """
    data: NotRequired[str]
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class Document(BaseModel):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""

    content_type: Optional[str] = None
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """

    data_url: Optional[str] = None
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """

    data: Optional[str] = None
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PostHrisEmployeesEmployeeIDDocumentsRequestBodyTypedDict(TypedDict):
    category_id: str
    document: DocumentTypedDict


class PostHrisEmployeesEmployeeIDDocumentsRequestBody(BaseModel):
    category_id: str

    document: Document
