"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict


PostIntegrationsIntegrationIDRelinkRequestBodyLanguage = Literal[
    "en",
    "de",
    "fr",
    "it",
    "es",
]
r"""Language of the connection flow UI."""


PostIntegrationsIntegrationIDRelinkRequestBodyLinkType = Literal[
    "EMBEDDED",
    "MAGIC_LINK",
]
r"""The type of link you want to create. `EMBEDDED` is for the [embedded flow](../guides/connect/embedded-flow) using the Kombo Connect SDK (these links are valid for 1 hour) and `MAGIC_LINK` is for [magic links](../guides/connect/magic-links) which you send out manually to customers (there are valid for 1 year).

This defaults to `EMBEDDED`, which is our recommended method of implementing the connection flow for a seamless user experience.
"""


class PostIntegrationsIntegrationIDRelinkRequestBodyTypedDict(TypedDict):
    language: NotRequired[
        Nullable[PostIntegrationsIntegrationIDRelinkRequestBodyLanguage]
    ]
    r"""Language of the connection flow UI."""
    scope_config_id: NotRequired[Nullable[str]]
    r"""Specify a scope config which the integration will start using once the reconnection flow has been completed.

    This can be useful if you want to update the permissions of an integration, but only want the change to take effect once the user has updated their API credentials to prevent sync issues.
    """
    link_type: NotRequired[PostIntegrationsIntegrationIDRelinkRequestBodyLinkType]
    r"""The type of link you want to create. `EMBEDDED` is for the [embedded flow](../guides/connect/embedded-flow) using the Kombo Connect SDK (these links are valid for 1 hour) and `MAGIC_LINK` is for [magic links](../guides/connect/magic-links) which you send out manually to customers (there are valid for 1 year).

    This defaults to `EMBEDDED`, which is our recommended method of implementing the connection flow for a seamless user experience.
    """


class PostIntegrationsIntegrationIDRelinkRequestBody(BaseModel):
    language: OptionalNullable[
        PostIntegrationsIntegrationIDRelinkRequestBodyLanguage
    ] = "en"
    r"""Language of the connection flow UI."""

    scope_config_id: OptionalNullable[str] = UNSET
    r"""Specify a scope config which the integration will start using once the reconnection flow has been completed.

    This can be useful if you want to update the permissions of an integration, but only want the change to take effect once the user has updated their API credentials to prevent sync issues.
    """

    link_type: Optional[PostIntegrationsIntegrationIDRelinkRequestBodyLinkType] = (
        "EMBEDDED"
    )
    r"""The type of link you want to create. `EMBEDDED` is for the [embedded flow](../guides/connect/embedded-flow) using the Kombo Connect SDK (these links are valid for 1 hour) and `MAGIC_LINK` is for [magic links](../guides/connect/magic-links) which you send out manually to customers (there are valid for 1 year).

    This defaults to `EMBEDDED`, which is our recommended method of implementing the connection flow for a seamless user experience.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["language", "scope_config_id", "link_type"]
        nullable_fields = ["language", "scope_config_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
