"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel
from kombo.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


HeadersTypedDict = TypeAliasType("HeadersTypedDict", Union[str, List[str]])


Headers = TypeAliasType("Headers", Union[str, List[str]])


class PostPassthroughToolAPIPositiveResponseDataTypedDict(TypedDict):
    url: str
    r"""The full URL of the request that we automatically assemble for you based on the specified `api`, the specified `path`, and the integration's auth credentials. You can use this to debug path-related issues (e.g., the API returning 404 errors)."""
    status: int
    r"""The HTTP status code returned from the remote system."""
    headers: Dict[str, HeadersTypedDict]
    r"""The HTTP headers returned from the remote system."""
    data: NotRequired[Any]
    r"""The HTTP body returned from the remote system. This will either be an array or object (in the case that JSON was returned) or a string (in any other case)."""


class PostPassthroughToolAPIPositiveResponseData(BaseModel):
    url: str
    r"""The full URL of the request that we automatically assemble for you based on the specified `api`, the specified `path`, and the integration's auth credentials. You can use this to debug path-related issues (e.g., the API returning 404 errors)."""

    status: int
    r"""The HTTP status code returned from the remote system."""

    headers: Dict[str, Headers]
    r"""The HTTP headers returned from the remote system."""

    data: Optional[Any] = None
    r"""The HTTP body returned from the remote system. This will either be an array or object (in the case that JSON was returned) or a string (in any other case)."""


class PostPassthroughToolAPIPositiveResponseWarningTypedDict(TypedDict):
    message: str


class PostPassthroughToolAPIPositiveResponseWarning(BaseModel):
    message: str


class PostPassthroughToolAPIPositiveResponseTypedDict(TypedDict):
    data: PostPassthroughToolAPIPositiveResponseDataTypedDict
    warnings: List[PostPassthroughToolAPIPositiveResponseWarningTypedDict]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""
    status: Literal["success"]


class PostPassthroughToolAPIPositiveResponse(BaseModel):
    data: PostPassthroughToolAPIPositiveResponseData

    warnings: List[PostPassthroughToolAPIPositiveResponseWarning]
    r"""These are the interaction warnings that are shown in the dashboard. They are meant to provide debug information to you. We recommend logging them to the console."""

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
