"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


Method = Literal[
    "GET",
    "POST",
    "DELETE",
    "PUT",
    "PATCH",
]
r"""The HTTP method (e.g., `GET`) of the request."""


class ValueTypedDict(TypedDict):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""
    content_type: NotRequired[str]
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """
    data_url: NotRequired[str]
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """
    data: NotRequired[str]
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class Value(BaseModel):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""

    content_type: Optional[str] = None
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """

    data_url: Optional[str] = None
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """

    data: Optional[str] = None
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


ValueUnionTypedDict = TypeAliasType("ValueUnionTypedDict", Union[ValueTypedDict, str])


ValueUnion = TypeAliasType("ValueUnion", Union[Value, str])


class MultipartFormDatumTypedDict(TypedDict):
    r"""The data to submit as part of the request body if the request's `Content-Type` is `multipart/form-data`."""

    name: str
    r"""The key of the form data"""
    value: ValueUnionTypedDict


class MultipartFormDatum(BaseModel):
    r"""The data to submit as part of the request body if the request's `Content-Type` is `multipart/form-data`."""

    name: str
    r"""The key of the form data"""

    value: ValueUnion


class PostPassthroughToolAPIRequestBodyTypedDict(TypedDict):
    method: Method
    r"""The HTTP method (e.g., `GET`) of the request."""
    path: str
    r"""The path of the endpoint you want to call. We automatically prepend the base URL of the API (all base URLs are documented in the endpoint description)."""
    headers: NotRequired[Dict[str, str]]
    r"""The headers to send with the request. Note that we automatically supply any authentication-related headers."""
    params: NotRequired[Dict[str, str]]
    r"""The query parameters to send in addition to the ones in the `path`."""
    data: NotRequired[Any]
    r"""The data to submit as part of the request body. This can either be an array or object (in which case we will forward it as JSON) or a string (in which case we will forward it raw)."""
    response_as_base64: NotRequired[bool]
    r"""If set to `true`, the response will be returned as a base64-encoded string. This is useful for binary data (e.g., PDFs)."""
    multipart_form_data: NotRequired[List[MultipartFormDatumTypedDict]]
    api_options: NotRequired[Dict[str, str]]
    r"""Custom options interpreted by the passthrough API adapter you've selected. These options are not documented right now as they're only for very advanced use cases."""


class PostPassthroughToolAPIRequestBody(BaseModel):
    method: Method
    r"""The HTTP method (e.g., `GET`) of the request."""

    path: str
    r"""The path of the endpoint you want to call. We automatically prepend the base URL of the API (all base URLs are documented in the endpoint description)."""

    headers: Optional[Dict[str, str]] = None
    r"""The headers to send with the request. Note that we automatically supply any authentication-related headers."""

    params: Optional[Dict[str, str]] = None
    r"""The query parameters to send in addition to the ones in the `path`."""

    data: Optional[Any] = None
    r"""The data to submit as part of the request body. This can either be an array or object (in which case we will forward it as JSON) or a string (in which case we will forward it raw)."""

    response_as_base64: Optional[bool] = None
    r"""If set to `true`, the response will be returned as a base64-encoded string. This is useful for binary data (e.g., PDFs)."""

    multipart_form_data: Optional[List[MultipartFormDatum]] = None

    api_options: Optional[Dict[str, str]] = None
    r"""Custom options interpreted by the passthrough API adapter you've selected. These options are not documented right now as they're only for very advanced use cases."""
