"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel
from kombo.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PutAssessmentOrdersAssessmentOrderIDResultRequestBodyStatus = Literal[
    "COMPLETED",
    "CANCELLED",
    "OPEN",
]
r"""Status of the assessment.

**Please note the `status` can only be updated to a different value if its current value is `OPEN`.**
"""


class ScoreTypedDict(TypedDict):
    value: float
    max: float


class Score(BaseModel):
    value: float

    max: float


AttributeStatus = Literal[
    "COMPLETED",
    "CANCELLED",
]


class AttributeSubResultTypedDict(TypedDict):
    id: str
    label: str
    score: ScoreTypedDict
    status: AttributeStatus
    type: Literal["SUB_RESULT"]


class AttributeSubResult(BaseModel):
    id: str

    label: str

    score: Score

    status: AttributeStatus

    TYPE: Annotated[
        Annotated[Literal["SUB_RESULT"], AfterValidator(validate_const("SUB_RESULT"))],
        pydantic.Field(alias="type"),
    ] = "SUB_RESULT"


class AttributeTextTypedDict(TypedDict):
    label: str
    value: str
    type: Literal["TEXT"]


class AttributeText(BaseModel):
    label: str

    value: str

    TYPE: Annotated[
        Annotated[Literal["TEXT"], AfterValidator(validate_const("TEXT"))],
        pydantic.Field(alias="type"),
    ] = "TEXT"


AttributeTypedDict = TypeAliasType(
    "AttributeTypedDict", Union[AttributeTextTypedDict, AttributeSubResultTypedDict]
)


Attribute = TypeAliasType("Attribute", Union[AttributeText, AttributeSubResult])


class PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachmentTypedDict(
    TypedDict
):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""
    content_type: NotRequired[str]
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """
    data_url: NotRequired[str]
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """
    data: NotRequired[str]
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachment(BaseModel):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""

    content_type: Optional[str] = None
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """

    data_url: Optional[str] = None
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """

    data: Optional[str] = None
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PutAssessmentOrdersAssessmentOrderIDResultRequestBodySmartrecruitersTypedDict(
    TypedDict
):
    score_label: NotRequired[str]
    r"""Value that we will pass through to SmartRecruiters' `scoreLabel` field."""


class PutAssessmentOrdersAssessmentOrderIDResultRequestBodySmartrecruiters(BaseModel):
    score_label: Annotated[Optional[str], pydantic.Field(alias="scoreLabel")] = None
    r"""Value that we will pass through to SmartRecruiters' `scoreLabel` field."""


class PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFieldsTypedDict(
    TypedDict
):
    r"""Additional fields that we will pass through to specific ATS systems."""

    smartrecruiters: NotRequired[
        PutAssessmentOrdersAssessmentOrderIDResultRequestBodySmartrecruitersTypedDict
    ]


class PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFields(BaseModel):
    r"""Additional fields that we will pass through to specific ATS systems."""

    smartrecruiters: Optional[
        PutAssessmentOrdersAssessmentOrderIDResultRequestBodySmartrecruiters
    ] = None


class PutAssessmentOrdersAssessmentOrderIDResultRequestBodyTypedDict(TypedDict):
    status: PutAssessmentOrdersAssessmentOrderIDResultRequestBodyStatus
    r"""Status of the assessment.

    **Please note the `status` can only be updated to a different value if its current value is `OPEN`.**
    """
    result_url: str
    completed_at: NotRequired[datetime]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ

    **Please make sure this value is provided when the `status` is of the type `COMPLETED` or `CANCELLED`.**
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    score: NotRequired[float]
    max_score: NotRequired[float]
    attributes: NotRequired[List[AttributeTypedDict]]
    r"""An array of additional attributes that you would like to submit as a part of the assessment result.

    - If an ATS only supports writing text attributes, we will transform non `TEXT` attributes into formatted plain text values.
    """
    attachments: NotRequired[
        List[PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachmentTypedDict]
    ]
    r"""An array of attachments containing the assessment result."""
    remote_fields: NotRequired[
        PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFieldsTypedDict
    ]
    r"""Additional fields that we will pass through to specific ATS systems."""


class PutAssessmentOrdersAssessmentOrderIDResultRequestBody(BaseModel):
    status: PutAssessmentOrdersAssessmentOrderIDResultRequestBodyStatus
    r"""Status of the assessment.

    **Please note the `status` can only be updated to a different value if its current value is `OPEN`.**
    """

    result_url: str

    completed_at: Optional[datetime] = None
    r"""YYYY-MM-DDTHH:mm:ss.sssZ

    **Please make sure this value is provided when the `status` is of the type `COMPLETED` or `CANCELLED`.**
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    score: Optional[float] = None

    max_score: Optional[float] = None

    attributes: Optional[List[Attribute]] = None
    r"""An array of additional attributes that you would like to submit as a part of the assessment result.

    - If an ATS only supports writing text attributes, we will transform non `TEXT` attributes into formatted plain text values.
    """

    attachments: Optional[
        List[PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachment]
    ] = None
    r"""An array of attachments containing the assessment result."""

    remote_fields: Optional[
        PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFields
    ] = None
    r"""Additional fields that we will pass through to specific ATS systems."""
