"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseType = Literal[
    "DEFAULT",
    "CUSTOM",
]
r"""The type of the integration field. There is a type to avoid collisions between DEFAULT fields and CUSTOM fields with the same key."""


class PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseIntegrationFieldTypedDict(
    TypedDict
):
    r"""The integration field the custom field is mapped to. Null if not mapped."""

    id: str
    r"""The integration field's unique ID"""
    key: str
    r"""The key of the integration field in the remote system"""
    type: PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseType
    r"""The type of the integration field. There is a type to avoid collisions between DEFAULT fields and CUSTOM fields with the same key."""
    label: Nullable[str]
    r"""The label of the integration field in the remote system"""


class PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseIntegrationField(
    BaseModel
):
    r"""The integration field the custom field is mapped to. Null if not mapped."""

    id: str
    r"""The integration field's unique ID"""

    key: str
    r"""The key of the integration field in the remote system"""

    type: PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseType
    r"""The type of the integration field. There is a type to avoid collisions between DEFAULT fields and CUSTOM fields with the same key."""

    label: Nullable[str]
    r"""The label of the integration field in the remote system"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["label"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseDataTypedDict(
    TypedDict
):
    id: str
    r"""The unique ID of the field"""
    key: str
    r"""The key of the custom field as it will be used in the custom_field object of the corresponding model"""
    integration_field: Nullable[
        PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseIntegrationFieldTypedDict
    ]
    r"""The integration field the custom field is mapped to. Null if not mapped."""
    model: str
    r"""The model the field is associated with"""
    label: Nullable[str]
    r"""The label of the custom field"""
    description: Nullable[str]
    r"""The description of the custom field"""


class PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseData(
    BaseModel
):
    id: str
    r"""The unique ID of the field"""

    key: str
    r"""The key of the custom field as it will be used in the custom_field object of the corresponding model"""

    integration_field: Nullable[
        PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseIntegrationField
    ]
    r"""The integration field the custom field is mapped to. Null if not mapped."""

    model: str
    r"""The model the field is associated with"""

    label: Nullable[str]
    r"""The label of the custom field"""

    description: Nullable[str]
    r"""The description of the custom field"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["integration_field", "label", "description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseTypedDict(
    TypedDict
):
    data: PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseDataTypedDict
    status: Literal["success"]


class PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponse(BaseModel):
    data: PutIntegrationsIntegrationIDCustomFieldsCustomFieldIDPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
