"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schema1 import Schema1, Schema1TypedDict
from .schema2_union_1 import Schema2Union1, Schema2Union1TypedDict
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


Schema1UnifiedKey8 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema1FileRestrictionsTypedDict(TypedDict):
    accepted_mime_types: List[str]
    max_file_size: NotRequired[Nullable[float]]


class Schema1FileRestrictions(BaseModel):
    accepted_mime_types: List[str]

    max_file_size: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["max_file_size"]
        nullable_fields = ["max_file_size"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class Schema1FileTypedDict(TypedDict):
    label: str
    required: bool
    file_restrictions: Schema1FileRestrictionsTypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey8]]
    type: Literal["file"]


class Schema1File(BaseModel):
    label: str

    required: bool

    file_restrictions: Schema1FileRestrictions

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey8] = UNSET

    TYPE: Annotated[
        Annotated[Literal["file"], AfterValidator(validate_const("file"))],
        pydantic.Field(alias="type"),
    ] = "file"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema1UnifiedKey7 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema1Array1TypedDict(TypedDict):
    label: str
    required: bool
    item_type: Schema2Union1TypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey7]]
    type: Literal["array"]
    min_items: NotRequired[Nullable[float]]
    max_items: NotRequired[Nullable[float]]


class Schema1Array1(BaseModel):
    label: str

    required: bool

    item_type: Schema2Union1

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey7] = UNSET

    TYPE: Annotated[
        Annotated[Literal["array"], AfterValidator(validate_const("array"))],
        pydantic.Field(alias="type"),
    ] = "array"

    min_items: OptionalNullable[float] = UNSET

    max_items: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key", "min_items", "max_items"]
        nullable_fields = ["description", "unified_key", "min_items", "max_items"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema1UnifiedKey6 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema1ObjectTypedDict(TypedDict):
    label: str
    required: bool
    properties: Schema1TypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey6]]
    type: Literal["object"]


class Schema1Object(BaseModel):
    label: str

    required: bool

    properties: Schema1

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey6] = UNSET

    TYPE: Annotated[
        Annotated[Literal["object"], AfterValidator(validate_const("object"))],
        pydantic.Field(alias="type"),
    ] = "object"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema1UnifiedKey5 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema1CheckboxTypedDict(TypedDict):
    label: str
    required: bool
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey5]]
    type: Literal["checkbox"]


class Schema1Checkbox(BaseModel):
    label: str

    required: bool

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey5] = UNSET

    TYPE: Annotated[
        Annotated[Literal["checkbox"], AfterValidator(validate_const("checkbox"))],
        pydantic.Field(alias="type"),
    ] = "checkbox"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class Schema1OptionsReferenced2TypedDict(TypedDict):
    link: str
    type: Literal["referenced"]


class Schema1OptionsReferenced2(BaseModel):
    link: str

    TYPE: Annotated[
        Annotated[Literal["referenced"], AfterValidator(validate_const("referenced"))],
        pydantic.Field(alias="type"),
    ] = "referenced"


Schema1RemoteID2TypedDict = TypeAliasType(
    "Schema1RemoteID2TypedDict", Union[str, float]
)


Schema1RemoteID2 = TypeAliasType("Schema1RemoteID2", Union[str, float])


class Schema1Entry2TypedDict(TypedDict):
    id: str
    label: str
    remote_id: Schema1RemoteID2TypedDict
    unified_value: NotRequired[str]


class Schema1Entry2(BaseModel):
    id: str

    label: str

    remote_id: Schema1RemoteID2

    unified_value: Optional[str] = None


class Schema1OptionsInline2TypedDict(TypedDict):
    entries: List[Schema1Entry2TypedDict]
    type: Literal["inline"]


class Schema1OptionsInline2(BaseModel):
    entries: List[Schema1Entry2]

    TYPE: Annotated[
        Annotated[Literal["inline"], AfterValidator(validate_const("inline"))],
        pydantic.Field(alias="type"),
    ] = "inline"


Schema1OptionsUnion2TypedDict = TypeAliasType(
    "Schema1OptionsUnion2TypedDict",
    Union[Schema1OptionsInline2TypedDict, Schema1OptionsReferenced2TypedDict],
)


Schema1OptionsUnion2 = TypeAliasType(
    "Schema1OptionsUnion2", Union[Schema1OptionsInline2, Schema1OptionsReferenced2]
)


class Schema1MultiSelectTypedDict(TypedDict):
    label: str
    required: bool
    options: Schema1OptionsUnion2TypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[str]]
    type: Literal["multi_select"]
    min_items: NotRequired[Nullable[float]]
    max_items: NotRequired[Nullable[float]]


class Schema1MultiSelect(BaseModel):
    label: str

    required: bool

    options: Schema1OptionsUnion2

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[str] = UNSET

    TYPE: Annotated[
        Annotated[
            Literal["multi_select"], AfterValidator(validate_const("multi_select"))
        ],
        pydantic.Field(alias="type"),
    ] = "multi_select"

    min_items: OptionalNullable[float] = UNSET

    max_items: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key", "min_items", "max_items"]
        nullable_fields = ["description", "unified_key", "min_items", "max_items"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema1UnifiedKey4 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema1OptionsReferenced1TypedDict(TypedDict):
    link: str
    type: Literal["referenced"]


class Schema1OptionsReferenced1(BaseModel):
    link: str

    TYPE: Annotated[
        Annotated[Literal["referenced"], AfterValidator(validate_const("referenced"))],
        pydantic.Field(alias="type"),
    ] = "referenced"


Schema1RemoteID1TypedDict = TypeAliasType(
    "Schema1RemoteID1TypedDict", Union[str, float]
)


Schema1RemoteID1 = TypeAliasType("Schema1RemoteID1", Union[str, float])


class Schema1Entry1TypedDict(TypedDict):
    id: str
    label: str
    remote_id: Schema1RemoteID1TypedDict
    unified_value: NotRequired[str]


class Schema1Entry1(BaseModel):
    id: str

    label: str

    remote_id: Schema1RemoteID1

    unified_value: Optional[str] = None


class Schema1OptionsInline1TypedDict(TypedDict):
    entries: List[Schema1Entry1TypedDict]
    type: Literal["inline"]


class Schema1OptionsInline1(BaseModel):
    entries: List[Schema1Entry1]

    TYPE: Annotated[
        Annotated[Literal["inline"], AfterValidator(validate_const("inline"))],
        pydantic.Field(alias="type"),
    ] = "inline"


Schema1OptionsUnion1TypedDict = TypeAliasType(
    "Schema1OptionsUnion1TypedDict",
    Union[Schema1OptionsInline1TypedDict, Schema1OptionsReferenced1TypedDict],
)


Schema1OptionsUnion1 = TypeAliasType(
    "Schema1OptionsUnion1", Union[Schema1OptionsInline1, Schema1OptionsReferenced1]
)


class Schema1SingleSelectTypedDict(TypedDict):
    label: str
    required: bool
    options: Schema1OptionsUnion1TypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey4]]
    type: Literal["single_select"]


class Schema1SingleSelect(BaseModel):
    label: str

    required: bool

    options: Schema1OptionsUnion1

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey4] = UNSET

    TYPE: Annotated[
        Annotated[
            Literal["single_select"], AfterValidator(validate_const("single_select"))
        ],
        pydantic.Field(alias="type"),
    ] = "single_select"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema1UnifiedKey3 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema1DateTypedDict(TypedDict):
    label: str
    required: bool
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey3]]
    type: Literal["date"]


class Schema1Date(BaseModel):
    label: str

    required: bool

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey3] = UNSET

    TYPE: Annotated[
        Annotated[Literal["date"], AfterValidator(validate_const("date"))],
        pydantic.Field(alias="type"),
    ] = "date"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema1UnifiedKey2 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema1NumberTypedDict(TypedDict):
    label: str
    required: bool
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey2]]
    type: Literal["number"]
    min: NotRequired[Nullable[float]]
    max: NotRequired[Nullable[float]]


class Schema1Number(BaseModel):
    label: str

    required: bool

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey2] = UNSET

    TYPE: Annotated[
        Annotated[Literal["number"], AfterValidator(validate_const("number"))],
        pydantic.Field(alias="type"),
    ] = "number"

    min: OptionalNullable[float] = UNSET

    max: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key", "min", "max"]
        nullable_fields = ["description", "unified_key", "min", "max"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema1UnifiedKey1 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema1TextTypedDict(TypedDict):
    label: str
    required: bool
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey1]]
    type: Literal["text"]
    min_length: NotRequired[Nullable[float]]
    max_length: NotRequired[Nullable[float]]
    reg_exp: NotRequired[Nullable[str]]


class Schema1Text(BaseModel):
    label: str

    required: bool

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey1] = UNSET

    TYPE: Annotated[
        Annotated[Literal["text"], AfterValidator(validate_const("text"))],
        pydantic.Field(alias="type"),
    ] = "text"

    min_length: OptionalNullable[float] = UNSET

    max_length: OptionalNullable[float] = UNSET

    reg_exp: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "unified_key",
            "min_length",
            "max_length",
            "reg_exp",
        ]
        nullable_fields = [
            "description",
            "unified_key",
            "min_length",
            "max_length",
            "reg_exp",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema1Union1TypedDict = TypeAliasType(
    "Schema1Union1TypedDict",
    Union[
        Schema1DateTypedDict,
        Schema1CheckboxTypedDict,
        Schema1SingleSelectTypedDict,
        Schema1ObjectTypedDict,
        Schema1FileTypedDict,
        Schema1NumberTypedDict,
        Schema1TextTypedDict,
        Schema1MultiSelectTypedDict,
        Schema1Array1TypedDict,
    ],
)


Schema1Union1 = TypeAliasType(
    "Schema1Union1",
    Union[
        Schema1Date,
        Schema1Checkbox,
        Schema1SingleSelect,
        Schema1Object,
        Schema1File,
        Schema1Number,
        Schema1Text,
        Schema1MultiSelect,
        Schema1Array1,
    ],
)
