"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schema1_union_1 import (
    Schema1Checkbox,
    Schema1CheckboxTypedDict,
    Schema1Date,
    Schema1DateTypedDict,
    Schema1File,
    Schema1FileTypedDict,
    Schema1MultiSelect,
    Schema1MultiSelectTypedDict,
    Schema1Number,
    Schema1NumberTypedDict,
    Schema1Object,
    Schema1ObjectTypedDict,
    Schema1SingleSelect,
    Schema1SingleSelectTypedDict,
    Schema1Text,
    Schema1TextTypedDict,
    Schema1UnifiedKey7,
)
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, TYPE_CHECKING, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict

if TYPE_CHECKING:
    from .schema2_union_2 import Schema2Union2, Schema2Union2TypedDict


Schema1Union2TypedDict = TypeAliasType(
    "Schema1Union2TypedDict",
    Union[
        Schema1DateTypedDict,
        Schema1CheckboxTypedDict,
        Schema1SingleSelectTypedDict,
        Schema1ObjectTypedDict,
        Schema1FileTypedDict,
        Schema1NumberTypedDict,
        Schema1TextTypedDict,
        Schema1MultiSelectTypedDict,
        "Schema1Array2TypedDict",
    ],
)


Schema1Union2 = TypeAliasType(
    "Schema1Union2",
    Union[
        Schema1Date,
        Schema1Checkbox,
        Schema1SingleSelect,
        Schema1Object,
        Schema1File,
        Schema1Number,
        Schema1Text,
        Schema1MultiSelect,
        "Schema1Array2",
    ],
)


class Schema1Array2TypedDict(TypedDict):
    label: str
    required: bool
    item_type: "Schema2Union2TypedDict"
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema1UnifiedKey7]]
    type: Literal["array"]
    min_items: NotRequired[Nullable[float]]
    max_items: NotRequired[Nullable[float]]


class Schema1Array2(BaseModel):
    label: str

    required: bool

    item_type: "Schema2Union2"

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema1UnifiedKey7] = UNSET

    TYPE: Annotated[
        Annotated[Literal["array"], AfterValidator(validate_const("array"))],
        pydantic.Field(alias="type"),
    ] = "array"

    min_items: OptionalNullable[float] = UNSET

    max_items: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key", "min_items", "max_items"]
        nullable_fields = ["description", "unified_key", "min_items", "max_items"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
