"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schema1 import Schema1, Schema1TypedDict
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


Schema2UnifiedKey8 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema2FileRestrictionsTypedDict(TypedDict):
    accepted_mime_types: List[str]
    max_file_size: NotRequired[Nullable[float]]


class Schema2FileRestrictions(BaseModel):
    accepted_mime_types: List[str]

    max_file_size: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["max_file_size"]
        nullable_fields = ["max_file_size"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class Schema2FileTypedDict(TypedDict):
    label: str
    required: bool
    file_restrictions: Schema2FileRestrictionsTypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema2UnifiedKey8]]
    type: Literal["file"]


class Schema2File(BaseModel):
    label: str

    required: bool

    file_restrictions: Schema2FileRestrictions

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema2UnifiedKey8] = UNSET

    TYPE: Annotated[
        Annotated[Literal["file"], AfterValidator(validate_const("file"))],
        pydantic.Field(alias="type"),
    ] = "file"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema2UnifiedKey7 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


Schema2UnifiedKey1 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema2TextTypedDict(TypedDict):
    label: str
    required: bool
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema2UnifiedKey1]]
    type: Literal["text"]
    min_length: NotRequired[Nullable[float]]
    max_length: NotRequired[Nullable[float]]
    reg_exp: NotRequired[Nullable[str]]


class Schema2Text(BaseModel):
    label: str

    required: bool

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema2UnifiedKey1] = UNSET

    TYPE: Annotated[
        Annotated[Literal["text"], AfterValidator(validate_const("text"))],
        pydantic.Field(alias="type"),
    ] = "text"

    min_length: OptionalNullable[float] = UNSET

    max_length: OptionalNullable[float] = UNSET

    reg_exp: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "unified_key",
            "min_length",
            "max_length",
            "reg_exp",
        ]
        nullable_fields = [
            "description",
            "unified_key",
            "min_length",
            "max_length",
            "reg_exp",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema2UnifiedKey2 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema2NumberTypedDict(TypedDict):
    label: str
    required: bool
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema2UnifiedKey2]]
    type: Literal["number"]
    min: NotRequired[Nullable[float]]
    max: NotRequired[Nullable[float]]


class Schema2Number(BaseModel):
    label: str

    required: bool

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema2UnifiedKey2] = UNSET

    TYPE: Annotated[
        Annotated[Literal["number"], AfterValidator(validate_const("number"))],
        pydantic.Field(alias="type"),
    ] = "number"

    min: OptionalNullable[float] = UNSET

    max: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key", "min", "max"]
        nullable_fields = ["description", "unified_key", "min", "max"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema2UnifiedKey3 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema2DateTypedDict(TypedDict):
    label: str
    required: bool
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema2UnifiedKey3]]
    type: Literal["date"]


class Schema2Date(BaseModel):
    label: str

    required: bool

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema2UnifiedKey3] = UNSET

    TYPE: Annotated[
        Annotated[Literal["date"], AfterValidator(validate_const("date"))],
        pydantic.Field(alias="type"),
    ] = "date"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema2UnifiedKey4 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


Schema2RemoteID1TypedDict = TypeAliasType(
    "Schema2RemoteID1TypedDict", Union[str, float]
)


Schema2RemoteID1 = TypeAliasType("Schema2RemoteID1", Union[str, float])


class Schema2Entry1TypedDict(TypedDict):
    id: str
    label: str
    remote_id: Schema2RemoteID1TypedDict
    unified_value: NotRequired[str]


class Schema2Entry1(BaseModel):
    id: str

    label: str

    remote_id: Schema2RemoteID1

    unified_value: Optional[str] = None


class Schema2OptionsInline1TypedDict(TypedDict):
    entries: List[Schema2Entry1TypedDict]
    type: Literal["inline"]


class Schema2OptionsInline1(BaseModel):
    entries: List[Schema2Entry1]

    TYPE: Annotated[
        Annotated[Literal["inline"], AfterValidator(validate_const("inline"))],
        pydantic.Field(alias="type"),
    ] = "inline"


class Schema2OptionsReferenced1TypedDict(TypedDict):
    link: str
    type: Literal["referenced"]


class Schema2OptionsReferenced1(BaseModel):
    link: str

    TYPE: Annotated[
        Annotated[Literal["referenced"], AfterValidator(validate_const("referenced"))],
        pydantic.Field(alias="type"),
    ] = "referenced"


Schema2OptionsUnion1TypedDict = TypeAliasType(
    "Schema2OptionsUnion1TypedDict",
    Union[Schema2OptionsInline1TypedDict, Schema2OptionsReferenced1TypedDict],
)


Schema2OptionsUnion1 = TypeAliasType(
    "Schema2OptionsUnion1", Union[Schema2OptionsInline1, Schema2OptionsReferenced1]
)


class Schema2SingleSelectTypedDict(TypedDict):
    label: str
    required: bool
    options: Schema2OptionsUnion1TypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema2UnifiedKey4]]
    type: Literal["single_select"]


class Schema2SingleSelect(BaseModel):
    label: str

    required: bool

    options: Schema2OptionsUnion1

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema2UnifiedKey4] = UNSET

    TYPE: Annotated[
        Annotated[
            Literal["single_select"], AfterValidator(validate_const("single_select"))
        ],
        pydantic.Field(alias="type"),
    ] = "single_select"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema2RemoteID2TypedDict = TypeAliasType(
    "Schema2RemoteID2TypedDict", Union[str, float]
)


Schema2RemoteID2 = TypeAliasType("Schema2RemoteID2", Union[str, float])


class Schema2Entry2TypedDict(TypedDict):
    id: str
    label: str
    remote_id: Schema2RemoteID2TypedDict
    unified_value: NotRequired[str]


class Schema2Entry2(BaseModel):
    id: str

    label: str

    remote_id: Schema2RemoteID2

    unified_value: Optional[str] = None


class Schema2OptionsInline2TypedDict(TypedDict):
    entries: List[Schema2Entry2TypedDict]
    type: Literal["inline"]


class Schema2OptionsInline2(BaseModel):
    entries: List[Schema2Entry2]

    TYPE: Annotated[
        Annotated[Literal["inline"], AfterValidator(validate_const("inline"))],
        pydantic.Field(alias="type"),
    ] = "inline"


class Schema2OptionsReferenced2TypedDict(TypedDict):
    link: str
    type: Literal["referenced"]


class Schema2OptionsReferenced2(BaseModel):
    link: str

    TYPE: Annotated[
        Annotated[Literal["referenced"], AfterValidator(validate_const("referenced"))],
        pydantic.Field(alias="type"),
    ] = "referenced"


Schema2OptionsUnion2TypedDict = TypeAliasType(
    "Schema2OptionsUnion2TypedDict",
    Union[Schema2OptionsInline2TypedDict, Schema2OptionsReferenced2TypedDict],
)


Schema2OptionsUnion2 = TypeAliasType(
    "Schema2OptionsUnion2", Union[Schema2OptionsInline2, Schema2OptionsReferenced2]
)


class Schema2MultiSelectTypedDict(TypedDict):
    label: str
    required: bool
    options: Schema2OptionsUnion2TypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[str]]
    type: Literal["multi_select"]
    min_items: NotRequired[Nullable[float]]
    max_items: NotRequired[Nullable[float]]


class Schema2MultiSelect(BaseModel):
    label: str

    required: bool

    options: Schema2OptionsUnion2

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[str] = UNSET

    TYPE: Annotated[
        Annotated[
            Literal["multi_select"], AfterValidator(validate_const("multi_select"))
        ],
        pydantic.Field(alias="type"),
    ] = "multi_select"

    min_items: OptionalNullable[float] = UNSET

    max_items: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key", "min_items", "max_items"]
        nullable_fields = ["description", "unified_key", "min_items", "max_items"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema2UnifiedKey5 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema2CheckboxTypedDict(TypedDict):
    label: str
    required: bool
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema2UnifiedKey5]]
    type: Literal["checkbox"]


class Schema2Checkbox(BaseModel):
    label: str

    required: bool

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema2UnifiedKey5] = UNSET

    TYPE: Annotated[
        Annotated[Literal["checkbox"], AfterValidator(validate_const("checkbox"))],
        pydantic.Field(alias="type"),
    ] = "checkbox"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema2UnifiedKey6 = Literal[
    "first_name",
    "last_name",
    "date_of_birth",
    "gender",
    "home_address.city",
    "home_address.country",
    "home_address.state",
    "home_address.street_1",
    "home_address.street_2",
    "home_address.zip_code",
    "job_title",
    "legal_entity_id",
    "location_id",
    "mobile_phone_number",
    "home_phone_number",
    "nationality",
    "start_date",
    "work_email",
    "private_email",
    "yearly_salary",
]


class Schema2Object1TypedDict(TypedDict):
    label: str
    required: bool
    properties: Schema1TypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema2UnifiedKey6]]
    type: Literal["object"]


class Schema2Object1(BaseModel):
    label: str

    required: bool

    properties: Schema1

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema2UnifiedKey6] = UNSET

    TYPE: Annotated[
        Annotated[Literal["object"], AfterValidator(validate_const("object"))],
        pydantic.Field(alias="type"),
    ] = "object"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key"]
        nullable_fields = ["description", "unified_key"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class Schema2Array1TypedDict(TypedDict):
    label: str
    required: bool
    item_type: Schema2Union1TypedDict
    description: NotRequired[Nullable[str]]
    unified_key: NotRequired[Nullable[Schema2UnifiedKey7]]
    type: Literal["array"]
    min_items: NotRequired[Nullable[float]]
    max_items: NotRequired[Nullable[float]]


class Schema2Array1(BaseModel):
    label: str

    required: bool

    item_type: Schema2Union1

    description: OptionalNullable[str] = UNSET

    unified_key: OptionalNullable[Schema2UnifiedKey7] = UNSET

    TYPE: Annotated[
        Annotated[Literal["array"], AfterValidator(validate_const("array"))],
        pydantic.Field(alias="type"),
    ] = "array"

    min_items: OptionalNullable[float] = UNSET

    max_items: OptionalNullable[float] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "unified_key", "min_items", "max_items"]
        nullable_fields = ["description", "unified_key", "min_items", "max_items"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Schema2Union1TypedDict = TypeAliasType(
    "Schema2Union1TypedDict",
    Union[
        Schema2DateTypedDict,
        Schema2CheckboxTypedDict,
        Schema2SingleSelectTypedDict,
        Schema2Object1TypedDict,
        Schema2FileTypedDict,
        Schema2NumberTypedDict,
        Schema2TextTypedDict,
        Schema2MultiSelectTypedDict,
        "Schema2Array1TypedDict",
    ],
)


Schema2Union1 = TypeAliasType(
    "Schema2Union1",
    Union[
        Schema2Date,
        Schema2Checkbox,
        Schema2SingleSelect,
        Schema2Object1,
        Schema2File,
        Schema2Number,
        Schema2Text,
        Schema2MultiSelect,
        "Schema2Array1",
    ],
)
