"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal
from typing_extensions import TypedDict


SyncFinishedWebhookPayloadType = Literal["sync-finished",]
r"""Type of the webhook event"""


SyncFinishedWebhookPayloadIntegrationCategory = Literal[
    "HRIS",
    "ATS",
    "ASSESSMENT",
]
r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""


class SyncFinishedWebhookPayloadEndUserTypedDict(TypedDict):
    r"""Information about the end user who created the integration."""

    organization_name: str
    r"""The name of the organization that owns the integration."""
    creator_email: Nullable[str]
    r"""The email address of the user who created the integration."""
    origin_id: Nullable[str]
    r"""The unique identifier of the organization in the integrated system."""


class SyncFinishedWebhookPayloadEndUser(BaseModel):
    r"""Information about the end user who created the integration."""

    organization_name: str
    r"""The name of the organization that owns the integration."""

    creator_email: Nullable[str]
    r"""The email address of the user who created the integration."""

    origin_id: Nullable[str]
    r"""The unique identifier of the organization in the integrated system."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["creator_email", "origin_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SyncFinishedWebhookPayloadDataTypedDict(TypedDict):
    sync_id: str
    r"""The unique identifier of the sync operation."""
    sync_state: str
    r"""The final state of the sync operation (e.g., `SUCCEEDED`, `FAILED`)."""
    sync_started_at: datetime
    r"""ISO 8601 timestamp when the sync operation started."""
    sync_ended_at: datetime
    r"""ISO 8601 timestamp when the sync operation completed."""
    sync_duration_seconds: int
    r"""Duration of the sync operation in seconds."""
    integration_id: str
    r"""The unique identifier of the integration."""
    integration_tool: str
    r"""The name of the integrated tool (e.g., \"personio\", \"greenhouse\")."""
    integration_category: SyncFinishedWebhookPayloadIntegrationCategory
    r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""
    end_user: SyncFinishedWebhookPayloadEndUserTypedDict
    r"""Information about the end user who created the integration."""
    log_url: str
    r"""URL to view detailed logs for the operation."""


class SyncFinishedWebhookPayloadData(BaseModel):
    sync_id: str
    r"""The unique identifier of the sync operation."""

    sync_state: str
    r"""The final state of the sync operation (e.g., `SUCCEEDED`, `FAILED`)."""

    sync_started_at: datetime
    r"""ISO 8601 timestamp when the sync operation started."""

    sync_ended_at: datetime
    r"""ISO 8601 timestamp when the sync operation completed."""

    sync_duration_seconds: int
    r"""Duration of the sync operation in seconds."""

    integration_id: str
    r"""The unique identifier of the integration."""

    integration_tool: str
    r"""The name of the integrated tool (e.g., \"personio\", \"greenhouse\")."""

    integration_category: SyncFinishedWebhookPayloadIntegrationCategory
    r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""

    end_user: SyncFinishedWebhookPayloadEndUser
    r"""Information about the end user who created the integration."""

    log_url: str
    r"""URL to view detailed logs for the operation."""


class SyncFinishedWebhookPayloadTypedDict(TypedDict):
    id: str
    r"""Unique identifier for this webhook event"""
    type: SyncFinishedWebhookPayloadType
    r"""Type of the webhook event"""
    data: SyncFinishedWebhookPayloadDataTypedDict


class SyncFinishedWebhookPayload(BaseModel):
    id: str
    r"""Unique identifier for this webhook event"""

    type: SyncFinishedWebhookPayloadType
    r"""Type of the webhook event"""

    data: SyncFinishedWebhookPayloadData
