import ast
import json
import re

import pytest

from examples.agents.evaluate_and_evolve_demo import main


@pytest.mark.asyncio
async def test_sft_demo_integration(capfd):
    await main()
    captured = capfd.readouterr()
    output = captured.out.strip()
    assert output, "Output should not be empty"

    list_matches = re.findall(r"(\[.*\])", output, re.DOTALL)
    assert list_matches, "No list-like output found"

    data_list_str = list_matches[-1]
    data_list = ast.literal_eval(data_list_str)

    assert isinstance(data_list, list)
    assert len(data_list) > 0

    for block in data_list:
        inner_json_str = re.sub(r"```json|```", "", block).strip()

        data = json.loads(inner_json_str)

        assert "node_id" in data
        assert "keep" in data
        assert "reason" in data
        assert isinstance(data["node_id"], str)
        assert isinstance(data["keep"], bool)
        assert isinstance(data["reason"], str) and len(data["reason"]) <= 20
