# Generated by Django 5.2.8 on 2025-11-11 00:15

import secrets

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Node",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("environment", models.CharField(blank=True, max_length=200)),
                ("name", models.CharField(max_length=200)),
                ("platform", models.CharField(max_length=200)),
                ("python_version", models.CharField(max_length=100)),
                ("first_seen", models.DateTimeField(auto_now_add=True)),
                ("last_seen", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "node",
            },
        ),
        migrations.CreateModel(
            name="Request",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("environment", models.CharField(blank=True, max_length=200)),
                ("event_id", models.UUIDField(db_index=True)),
                ("timestamp", models.DateTimeField(default=django.utils.timezone.now)),
                ("tags", models.JSONField(blank=True, default=dict)),
                ("host", models.CharField(max_length=253)),
                ("path", models.TextField()),
                ("method", models.CharField(max_length=20)),
                ("status", models.IntegerField()),
                ("headers", models.JSONField(blank=True, default=dict)),
                ("size", models.IntegerField(blank=True, null=True)),
                ("ip", models.GenericIPAddressField(blank=True, null=True)),
                ("user", models.CharField(blank=True, max_length=200)),
            ],
            options={
                "db_table": "request",
                "ordering": ["-timestamp"],
            },
        ),
        migrations.CreateModel(
            name="Site",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=200)),
                ("slug", models.SlugField(max_length=200, unique=True)),
                (
                    "schema_name",
                    models.CharField(
                        max_length=63,
                        unique=True,
                        validators=[
                            django.core.validators.RegexValidator("[a-z][a-z0-9_]+")
                        ],
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "site",
            },
        ),
        migrations.CreateModel(
            name="Context",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("environment", models.CharField(blank=True, max_length=200)),
                ("event_id", models.UUIDField(db_index=True)),
                ("timestamp", models.DateTimeField(default=django.utils.timezone.now)),
                ("tags", models.JSONField(blank=True, default=dict)),
                ("name", models.CharField(max_length=200)),
                ("elapsed_ms", models.IntegerField()),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="subcontexts",
                        to="varanus.context",
                    ),
                ),
                (
                    "request",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="context",
                        to="varanus.request",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="%(class)ss",
                        to="varanus.site",
                    ),
                ),
            ],
            options={
                "db_table": "context",
                "ordering": ["-timestamp"],
            },
        ),
        migrations.CreateModel(
            name="Error",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("environment", models.CharField(blank=True, max_length=200)),
                ("event_id", models.UUIDField(db_index=True)),
                ("timestamp", models.DateTimeField(default=django.utils.timezone.now)),
                ("tags", models.JSONField(blank=True, default=dict)),
                ("fingerprint", models.CharField(db_index=True, max_length=64)),
                ("kind", models.CharField(max_length=200)),
                ("module", models.CharField(max_length=200)),
                ("message", models.TextField()),
                ("lines", models.JSONField(blank=True, default=list)),
                (
                    "context",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)ss",
                        to="varanus.context",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="%(class)ss",
                        to="varanus.site",
                    ),
                ),
            ],
            options={
                "db_table": "error",
                "ordering": ["-timestamp"],
            },
        ),
        migrations.CreateModel(
            name="NodeUpdate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("installed", models.JSONField(default=dict)),
                ("updated", models.JSONField(default=dict)),
                ("removed", models.JSONField(default=list)),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                (
                    "node",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="updates",
                        to="varanus.node",
                    ),
                ),
            ],
            options={
                "db_table": "node_update",
                "ordering": ["-timestamp"],
            },
        ),
        migrations.AddField(
            model_name="request",
            name="site",
            field=models.ForeignKey(
                db_constraint=False,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="%(class)ss",
                to="varanus.site",
            ),
        ),
        migrations.CreateModel(
            name="Query",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("environment", models.CharField(blank=True, max_length=200)),
                ("event_id", models.UUIDField(db_index=True)),
                ("timestamp", models.DateTimeField(default=django.utils.timezone.now)),
                ("tags", models.JSONField(blank=True, default=dict)),
                ("fingerprint", models.CharField(db_index=True, max_length=64)),
                ("sql", models.TextField()),
                ("params", models.JSONField(default=list)),
                ("db", models.CharField(default="default", max_length=200)),
                ("elapsed_ms", models.IntegerField()),
                ("success", models.BooleanField(default=True)),
                ("command", models.CharField(blank=True, max_length=20)),
                (
                    "context",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)ss",
                        to="varanus.context",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="%(class)ss",
                        to="varanus.site",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "queries",
                "db_table": "query",
                "ordering": ["-timestamp"],
            },
        ),
        migrations.AddField(
            model_name="node",
            name="site",
            field=models.ForeignKey(
                db_constraint=False,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="%(class)ss",
                to="varanus.site",
            ),
        ),
        migrations.CreateModel(
            name="Metric",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("environment", models.CharField(blank=True, max_length=200)),
                ("event_id", models.UUIDField(db_index=True)),
                ("timestamp", models.DateTimeField(default=django.utils.timezone.now)),
                ("tags", models.JSONField(blank=True, default=dict)),
                ("name", models.CharField(max_length=100)),
                ("agg_count", models.IntegerField(default=0)),
                ("agg_sum", models.FloatField(default=0.0)),
                ("agg_avg", models.FloatField(default=0.0)),
                ("agg_min", models.FloatField(default=0.0)),
                ("agg_max", models.FloatField(default=0.0)),
                (
                    "context",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)ss",
                        to="varanus.context",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="%(class)ss",
                        to="varanus.site",
                    ),
                ),
            ],
            options={
                "db_table": "metric",
                "ordering": ["-timestamp"],
            },
        ),
        migrations.CreateModel(
            name="Log",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("environment", models.CharField(blank=True, max_length=200)),
                ("event_id", models.UUIDField(db_index=True)),
                ("timestamp", models.DateTimeField(default=django.utils.timezone.now)),
                ("tags", models.JSONField(blank=True, default=dict)),
                ("fingerprint", models.CharField(db_index=True, max_length=64)),
                ("message", models.TextField()),
                ("name", models.CharField(blank=True, max_length=200)),
                ("level", models.IntegerField(blank=True, null=True)),
                ("file", models.TextField(blank=True)),
                ("lineno", models.IntegerField(blank=True, null=True)),
                (
                    "context",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)ss",
                        to="varanus.context",
                    ),
                ),
                (
                    "error",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="logs",
                        to="varanus.error",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="%(class)ss",
                        to="varanus.site",
                    ),
                ),
            ],
            options={
                "db_table": "log",
                "ordering": ["-timestamp"],
            },
        ),
        migrations.CreateModel(
            name="SiteKey",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "access_key",
                    models.CharField(
                        default=secrets.token_urlsafe, max_length=100, unique=True
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_expires", models.DateField()),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="keys",
                        to="varanus.site",
                    ),
                ),
            ],
            options={
                "db_table": "site_key",
            },
        ),
        migrations.CreateModel(
            name="SiteMember",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_admin", models.BooleanField(default=False)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="members",
                        to="varanus.site",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="memberships",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "site_member",
            },
        ),
        migrations.CreateModel(
            name="NodePackage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("package", models.CharField(max_length=200)),
                ("version", models.CharField(max_length=50)),
                (
                    "node",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="packages",
                        to="varanus.node",
                    ),
                ),
            ],
            options={
                "db_table": "node_package",
                "ordering": ["package"],
                "constraints": [
                    models.UniqueConstraint(
                        models.F("node"),
                        models.F("package"),
                        name="unique_node_package",
                    )
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="node",
            constraint=models.UniqueConstraint(
                models.F("site"),
                models.F("environment"),
                models.F("name"),
                name="unique_site_node",
            ),
        ),
        migrations.AddConstraint(
            model_name="sitemember",
            constraint=models.UniqueConstraint(
                models.F("site"), models.F("user"), name="unique_site_user"
            ),
        ),
    ]
