# yapf: disable
# isort: skip_file
# ruff: noqa



# To not generate code where imported names might get shadowed when a user
# specifies some name in their proto file to be the same as one of our imported
# names, (for example: a request field named `uuid`) we bind all imports to
# names that are forbidden in 'proto' and therefore can never collide.

# Standard imports.
from __future__ import annotations as IMPORT_future_annotations

# The following MUST appear before the rest of the imports, since those imports
# may be invalid (broken) if the generated code is mismatched with the installed
# libraries.
import rebootdev.versioning as IMPORT_reboot_versioning
IMPORT_reboot_versioning.check_generated_code_compatible("0.40.1")

# ATTENTION: no types in this file should be imported with their unqualified
#            name (e.g. `from typing import Any`). That would cause clashes
#            with user-defined methods that have the same name. Use
#            fully-qualified names (e.g. `IMPORT_typing.Any`) instead.
import asyncio as IMPORT_asyncio
import builtins as IMPORT_builtins
import contextvars as IMPORT_contextvars
import dataclasses as IMPORT_dataclasses
import google.protobuf.descriptor as IMPORT_google_protobuf_descriptor
import google.protobuf.json_format as IMPORT_google_protobuf_json_format
import google.protobuf.message as IMPORT_google_protobuf_message
import grpc as IMPORT_grpc
import grpc_status._async as IMPORT_rpc_status_async
from grpc_status import rpc_status as IMPORT_rpc_status_sync
import json as IMPORT_json
import os as IMPORT_os
import traceback as IMPORT_traceback
import uuid as IMPORT_uuid
import pickle as IMPORT_pickle
import rebootdev as IMPORT_rebootdev
import log.log as IMPORT_log_log   # type: ignore[import]
import typing as IMPORT_typing
import rebootdev.aio.backoff as IMPORT_reboot_aio_backoff
import functools as IMPORT_functools
from abc import abstractmethod as IMPORT_abc_abstractmethod
from datetime import datetime as IMPORT_datetime_datetime
from datetime import timedelta as IMPORT_datetime_timedelta
from datetime import timezone as IMPORT_datetime_timezone
from google.protobuf import timestamp_pb2 as IMPORT_google_protobuf_timestamp_pb2
from google.protobuf import wrappers_pb2 as IMPORT_google_protobuf_wrappers_pb2
from google.protobuf.empty_pb2 import Empty as IMPORT_google_protobuf_empty_pb2_Empty
import rebootdev.aio.tracing as IMPORT_reboot_aio_tracing
from google.rpc import status_pb2 as IMPORT_google_rpc_status_pb2
from tzlocal import get_localzone as IMPORT_tzlocal_get_localzone
import rebootdev.aio.call as IMPORT_reboot_aio_call
import rebootdev.aio.contexts as IMPORT_reboot_aio_contexts
import rebootdev.aio.headers as IMPORT_reboot_aio_headers
import rebootdev.aio.idempotency as IMPORT_reboot_aio_idempotency
import rebootdev.aio.internals.channel_manager as IMPORT_reboot_aio_internals_channel_manager
import rebootdev.aio.internals.middleware as IMPORT_reboot_aio_internals_middleware
import rebootdev.aio.internals.tasks_cache as IMPORT_reboot_aio_internals_tasks_cache
import rebootdev.aio.internals.tasks_dispatcher as IMPORT_reboot_aio_internals_tasks_dispatcher
import rebootdev.aio.placement as IMPORT_reboot_aio_placement
import rebootdev.aio.servicers as IMPORT_reboot_aio_servicers
import rebootdev.aio.state_managers as IMPORT_reboot_aio_state_managers
import rebootdev.aio.stubs as IMPORT_reboot_aio_stubs
import rebootdev.aio.tasks as IMPORT_reboot_aio_tasks
import rebootdev.aio.types as IMPORT_reboot_aio_types
import rebootdev.aio.external as IMPORT_reboot_aio_external
import rebootdev.aio.workflows as IMPORT_reboot_aio_workflows
import rebootdev.settings as IMPORT_reboot_settings
import rebootdev.nodejs.python as IMPORT_reboot_nodejs_python
from rebootdev.time import DateTimeWithTimeZone as IMPORT_reboot_time_DateTimeWithTimeZone
import rbt.v1alpha1 as IMPORT_rbt_v1alpha1
import rbt.v1alpha1.nodejs_pb2 as IMPORT_rbt_v1alpha1_nodejs_pb2
import google.protobuf.any_pb2 as IMPORT_google_protobuf_any_pb2
import sys as IMPORT_sys

# Additionally re-export all messages and enums from the pb2 module.
from google.protobuf.descriptor_pb2 import (
    DescriptorProto,
    Edition,
    EnumDescriptorProto,
    EnumOptions,
    EnumValueDescriptorProto,
    EnumValueOptions,
    ExtensionRangeOptions,
    FeatureSet,
    FeatureSetDefaults,
    FieldDescriptorProto,
    FieldOptions,
    FileDescriptorProto,
    FileDescriptorSet,
    FileOptions,
    GeneratedCodeInfo,
    MessageOptions,
    MethodDescriptorProto,
    MethodOptions,
    OneofDescriptorProto,
    OneofOptions,
    ServiceDescriptorProto,
    ServiceOptions,
    SourceCodeInfo,
    UninterpretedOption,
)

# User defined or referenced imports.
import google.protobuf.descriptor_pb2

logger = IMPORT_log_log.get_logger(__name__)

# We won't validate Pydantic state models while they are under construction.
states_being_constructed: set[str] = set()



############################ Legacy gRPC Servicers ############################
# This section is relevant (only) for servicers that implement a legacy gRPC
# service in a Reboot context. It is irrelevant to clients.

def MakeLegacyGrpcServiceable(
    # A legacy gRPC servicer type can't be more specific than `type`,
    # because legacy gRPC servicers (as generated by the gRPC `protoc`
    # plugin) do not share any common base class other than `object`.
    servicer_type: type
) -> IMPORT_reboot_aio_servicers.Serviceable:
    raise ValueError(f"Unknown legacy gRPC servicer type '{servicer_type}'")



############################ Reboot Servicer Middlewares ############################
# This section is relevant (only) for servicers implementing a Reboot servicer. It
# is irrelevant to clients, except for the fact that some clients are _also_ such
# servicers.

# For internal calls, we can use a magic token to bypass token verification and
# authorization checks. The token provides no auth information (e.g.,
# `context.auth is None`).
__internal_magic_token__: str = f'internal-{IMPORT_uuid.uuid4()}'


############################ Client Stubs ############################
# This section is relevant for clients accessing a Reboot service. Since
# servicers are themselves often clients also, this code is generated for
# them also.



############################ Authorizers ############################
# Relevant to servicers; irrelevant to clients.


############################ Reboot Servicers ############################
# Base classes for server-side implementations of Reboot servicers.
# Irrelevant to clients.


############################ Clients ############################
# The main developer-facing entrypoints for any Reboot type. Relevant to both
# clients and servicers (who use it to find the right servicer base types, as well
# as often being clients themselves).

# Attach an explicit time time zone to "naive" `datetime` objects. A "naive" `datetime` doesn't have a
# time zone. Such objects are typically interpreted as representing local time, but could be confused
# for objects representing UTC. This helper function disambiguates by explicitly attaching the local
# time zone to `datetime` objects that don't already have an explicit time zone. If the `datetime` object
# is already timezone-aware, we still convert it to our custom `DateTimeWithTimeZone` type.
def ensure_has_timezone(
    *,
    when: IMPORT_typing.Optional[IMPORT_datetime_datetime | IMPORT_datetime_timedelta] = None,
) -> IMPORT_typing.Optional[IMPORT_reboot_time_DateTimeWithTimeZone | IMPORT_datetime_timedelta]:
    if isinstance(when, IMPORT_datetime_datetime):
        return IMPORT_reboot_time_DateTimeWithTimeZone.from_datetime(when)
    return when


############################ Servicer Node adapters ############################
# Used by Node.js servicer implementations to access Python code and vice-versa.
# Relevant to servicers, irrelevant to clients.


############################ Reference Node adapters ############################
# Used by Node.js WeakReference implementations to access Python code and
# vice-versa. Relevant to clients.

# yapf: enable
