# This file was automatically generated by generate_cli.py
# type: ignore

from __future__ import annotations

import enum
import inspect
import traceback
from functools import reduce
from operator import add
from typing import Literal, Optional

from bec_lib.logger import bec_logger

from bec_widgets.cli.rpc.rpc_base import RPCBase, rpc_call, rpc_timeout
from bec_widgets.utils.bec_plugin_helper import get_all_plugin_widgets, get_plugin_client_module

logger = bec_logger.logger

# pylint: skip-file


class _WidgetsEnumType(str, enum.Enum):
    """Enum for the available widgets, to be generated programatically"""

    ...


_Widgets = {
    "AbortButton": "AbortButton",
    "BECDockArea": "BECDockArea",
    "BECMainWindow": "BECMainWindow",
    "BECProgressBar": "BECProgressBar",
    "BECQueue": "BECQueue",
    "BECStatusBox": "BECStatusBox",
    "DapComboBox": "DapComboBox",
    "DarkModeButton": "DarkModeButton",
    "DeviceBrowser": "DeviceBrowser",
    "DeviceComboBox": "DeviceComboBox",
    "DeviceLineEdit": "DeviceLineEdit",
    "Heatmap": "Heatmap",
    "Image": "Image",
    "LogPanel": "LogPanel",
    "Minesweeper": "Minesweeper",
    "MonacoWidget": "MonacoWidget",
    "MotorMap": "MotorMap",
    "MultiWaveform": "MultiWaveform",
    "PositionIndicator": "PositionIndicator",
    "PositionerBox": "PositionerBox",
    "PositionerBox2D": "PositionerBox2D",
    "PositionerControlLine": "PositionerControlLine",
    "PositionerGroup": "PositionerGroup",
    "ResetButton": "ResetButton",
    "ResumeButton": "ResumeButton",
    "RingProgressBar": "RingProgressBar",
    "SBBMonitor": "SBBMonitor",
    "ScanControl": "ScanControl",
    "ScanProgressBar": "ScanProgressBar",
    "ScatterWaveform": "ScatterWaveform",
    "SignalComboBox": "SignalComboBox",
    "SignalLabel": "SignalLabel",
    "SignalLineEdit": "SignalLineEdit",
    "StopButton": "StopButton",
    "TextBox": "TextBox",
    "VSCodeEditor": "VSCodeEditor",
    "Waveform": "Waveform",
    "WebConsole": "WebConsole",
    "WebsiteWidget": "WebsiteWidget",
}


try:
    _plugin_widgets = get_all_plugin_widgets().as_dict()
    plugin_client = get_plugin_client_module()
    Widgets = _WidgetsEnumType("Widgets", {name: name for name in _plugin_widgets} | _Widgets)

    if (_overlap := _Widgets.keys() & _plugin_widgets.keys()) != set():
        for _widget in _overlap:
            logger.warning(
                f"Detected duplicate widget {_widget} in plugin repo file: {inspect.getfile(_plugin_widgets[_widget])} !"
            )
    for plugin_name, plugin_class in inspect.getmembers(plugin_client, inspect.isclass):
        if issubclass(plugin_class, RPCBase) and plugin_class is not RPCBase:
            if plugin_name in globals():
                conflicting_file = (
                    inspect.getfile(_plugin_widgets[plugin_name])
                    if plugin_name in _plugin_widgets
                    else f"{plugin_client}"
                )
                logger.warning(
                    f"Plugin widget {plugin_name} from {conflicting_file} conflicts with a built-in class!"
                )
                continue
            if plugin_name not in _overlap:
                globals()[plugin_name] = plugin_class
except ImportError as e:
    logger.error(f"Failed loading plugins: \n{reduce(add, traceback.format_exception(e))}")


class AbortButton(RPCBase):
    """A button that abort the scan."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class AutoUpdates(RPCBase):
    @property
    @rpc_call
    def enabled(self) -> "bool":
        """
        Get the enabled status of the auto updates.
        """

    @enabled.setter
    @rpc_call
    def enabled(self) -> "bool":
        """
        Get the enabled status of the auto updates.
        """

    @property
    @rpc_call
    def selected_device(self) -> "str | None":
        """
        Get the selected device from the auto update config.

        Returns:
            str: The selected device. If no device is selected, None is returned.
        """

    @selected_device.setter
    @rpc_call
    def selected_device(self) -> "str | None":
        """
        Get the selected device from the auto update config.

        Returns:
            str: The selected device. If no device is selected, None is returned.
        """


class BECDock(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @property
    @rpc_call
    def element_list(self) -> "list[BECWidget]":
        """
        Get the widgets in the dock.

        Returns:
            widgets(list): The widgets in the dock.
        """

    @property
    @rpc_call
    def elements(self) -> "dict[str, BECWidget]":
        """
        Get the widgets in the dock.

        Returns:
            widgets(dict): The widgets in the dock.
        """

    @rpc_call
    def new(
        self,
        widget: "BECWidget | str",
        name: "str | None" = None,
        row: "int | None" = None,
        col: "int" = 0,
        rowspan: "int" = 1,
        colspan: "int" = 1,
        shift: "Literal['down', 'up', 'left', 'right']" = "down",
    ) -> "BECWidget":
        """
        Add a widget to the dock.

        Args:
            widget(QWidget): The widget to add. It can not be BECDock or BECDockArea.
            name(str): The name of the widget.
            row(int): The row to add the widget to. If None, the widget will be added to the next available row.
            col(int): The column to add the widget to.
            rowspan(int): The number of rows the widget should span.
            colspan(int): The number of columns the widget should span.
            shift(Literal["down", "up", "left", "right"]): The direction to shift the widgets if the position is occupied.
        """

    @rpc_call
    def show(self):
        """
        Show the dock.
        """

    @rpc_call
    def hide(self):
        """
        Hide the dock.
        """

    @rpc_call
    def show_title_bar(self):
        """
        Hide the title bar of the dock.
        """

    @rpc_call
    def set_title(self, title: "str"):
        """
        Set the title of the dock.

        Args:
            title(str): The title of the dock.
        """

    @rpc_call
    def hide_title_bar(self):
        """
        Hide the title bar of the dock.
        """

    @rpc_call
    def available_widgets(self) -> "list":
        """
        List all widgets that can be added to the dock.

        Returns:
            list: The list of eligible widgets.
        """

    @rpc_call
    def delete(self, widget_name: "str") -> "None":
        """
        Remove a widget from the dock.

        Args:
            widget_name(str): Delete the widget with the given name.
        """

    @rpc_call
    def delete_all(self):
        """
        Remove all widgets from the dock.
        """

    @rpc_call
    def remove(self):
        """
        Remove the dock from the parent dock area.
        """

    @rpc_call
    def attach(self):
        """
        Attach the dock to the parent dock area.
        """

    @rpc_call
    def detach(self):
        """
        Detach the dock from the parent dock area.
        """


class BECDockArea(RPCBase):
    """Container for other widgets. Widgets can be added to the dock area and arranged in a grid layout."""

    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """

    @rpc_call
    def new(
        self,
        name: "str | None" = None,
        widget: "str | QWidget | None" = None,
        widget_name: "str | None" = None,
        position: "Literal['bottom', 'top', 'left', 'right', 'above', 'below']" = "bottom",
        relative_to: "BECDock | None" = None,
        closable: "bool" = True,
        floating: "bool" = False,
        row: "int | None" = None,
        col: "int" = 0,
        rowspan: "int" = 1,
        colspan: "int" = 1,
    ) -> "BECDock":
        """
        Add a dock to the dock area. Dock has QGridLayout as layout manager by default.

        Args:
            name(str): The name of the dock to be displayed and for further references. Has to be unique.
            widget(str|QWidget|None): The widget to be added to the dock. While using RPC, only BEC RPC widgets from RPCWidgetHandler are allowed.
            position(Literal["bottom", "top", "left", "right", "above", "below"]): The position of the dock.
            relative_to(BECDock): The dock to which the new dock should be added relative to.
            closable(bool): Whether the dock is closable.
            floating(bool): Whether the dock is detached after creating.
            row(int): The row of the added widget.
            col(int): The column of the added widget.
            rowspan(int): The rowspan of the added widget.
            colspan(int): The colspan of the added widget.

        Returns:
            BECDock: The created dock.
        """

    @rpc_call
    def show(self):
        """
        Show all windows including floating docks.
        """

    @rpc_call
    def hide(self):
        """
        Hide all windows including floating docks.
        """

    @property
    @rpc_call
    def panels(self) -> "dict[str, BECDock]":
        """
        Get the docks in the dock area.
        Returns:
            dock_dict(dict): The docks in the dock area.
        """

    @property
    @rpc_call
    def panel_list(self) -> "list[BECDock]":
        """
        Get the docks in the dock area.

        Returns:
            list: The docks in the dock area.
        """

    @rpc_call
    def delete(self, dock_name: "str"):
        """
        Delete a dock by name.

        Args:
            dock_name(str): The name of the dock to delete.
        """

    @rpc_call
    def delete_all(self) -> "None":
        """
        Delete all docks.
        """

    @rpc_call
    def remove(self) -> "None":
        """
        Remove the dock area. If the dock area is embedded in a BECMainWindow and
        is set as the central widget, the main window will be closed.
        """

    @rpc_call
    def detach_dock(self, dock_name: "str") -> "BECDock":
        """
        Undock a dock from the dock area.

        Args:
            dock_name(str): The dock to undock.

        Returns:
            BECDock: The undocked dock.
        """

    @rpc_call
    def attach_all(self):
        """
        Return all floating docks to the dock area.
        """

    @rpc_call
    def save_state(self) -> "dict":
        """
        Save the state of the dock area.

        Returns:
            dict: The state of the dock area.
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """

    @rpc_call
    def restore_state(
        self, state: "dict" = None, missing: "Literal['ignore', 'error']" = "ignore", extra="bottom"
    ):
        """
        Restore the state of the dock area. If no state is provided, the last state is restored.

        Args:
            state(dict): The state to restore.
            missing(Literal['ignore','error']): What to do if a dock is missing.
            extra(str): Extra docks that are in the dockarea but that are not mentioned in state will be added to the bottom of the dockarea, unless otherwise specified by the extra argument.
        """


class BECMainWindow(RPCBase):
    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class BECProgressBar(RPCBase):
    """A custom progress bar with smooth transitions. The displayed text can be customized using a template."""

    @rpc_call
    def set_value(self, value):
        """
        Set the value of the progress bar.

        Args:
            value (float): The value to set.
        """

    @rpc_call
    def set_maximum(self, maximum: float):
        """
        Set the maximum value of the progress bar.

        Args:
            maximum (float): The maximum value.
        """

    @rpc_call
    def set_minimum(self, minimum: float):
        """
        Set the minimum value of the progress bar.

        Args:
            minimum (float): The minimum value.
        """

    @property
    @rpc_call
    def label_template(self):
        """
        The template for the center label. Use $value, $maximum, and $percentage to insert the values.

        Examples:
        >>> progressbar.label_template = "$value / $maximum - $percentage %"
        >>> progressbar.label_template = "$value / $percentage %"
        """

    @label_template.setter
    @rpc_call
    def label_template(self):
        """
        The template for the center label. Use $value, $maximum, and $percentage to insert the values.

        Examples:
        >>> progressbar.label_template = "$value / $maximum - $percentage %"
        >>> progressbar.label_template = "$value / $percentage %"
        """

    @property
    @rpc_call
    def state(self):
        """
        None
        """

    @state.setter
    @rpc_call
    def state(self):
        """
        None
        """

    @rpc_call
    def _get_label(self) -> str:
        """
        Return the label text. mostly used for testing rpc.
        """


class BECQueue(RPCBase):
    """Widget to display the BEC queue."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class BECStatusBox(RPCBase):
    """An autonomous widget to display the status of BEC services."""

    @rpc_call
    def get_server_state(self) -> "str":
        """
        Get the state ("RUNNING", "BUSY", "IDLE", "ERROR") of the BEC server
        """

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class BaseROI(RPCBase):
    """Base class for all Region of Interest (ROI) implementations."""

    @property
    @rpc_call
    def label(self) -> "str":
        """
        Gets the display name of this ROI.

        Returns:
            str: The current name of the ROI.
        """

    @label.setter
    @rpc_call
    def label(self) -> "str":
        """
        Gets the display name of this ROI.

        Returns:
            str: The current name of the ROI.
        """

    @property
    @rpc_call
    def movable(self) -> "bool":
        """
        Gets whether this ROI is movable.

        Returns:
            bool: True if the ROI can be moved, False otherwise.
        """

    @movable.setter
    @rpc_call
    def movable(self) -> "bool":
        """
        Gets whether this ROI is movable.

        Returns:
            bool: True if the ROI can be moved, False otherwise.
        """

    @property
    @rpc_call
    def line_color(self) -> "str":
        """
        Gets the current line color of the ROI.

        Returns:
            str: The current line color as a string (e.g., hex color code).
        """

    @line_color.setter
    @rpc_call
    def line_color(self) -> "str":
        """
        Gets the current line color of the ROI.

        Returns:
            str: The current line color as a string (e.g., hex color code).
        """

    @property
    @rpc_call
    def line_width(self) -> "int":
        """
        Gets the current line width of the ROI.

        Returns:
            int: The current line width in pixels.
        """

    @line_width.setter
    @rpc_call
    def line_width(self) -> "int":
        """
        Gets the current line width of the ROI.

        Returns:
            int: The current line width in pixels.
        """

    @rpc_call
    def get_coordinates(self):
        """
        Gets the coordinates that define this ROI's position and shape.

        This is an abstract method that must be implemented by subclasses.
        Implementations should return either a dictionary with descriptive keys
        or a tuple of coordinates, depending on the value of self.description.

        Returns:
            dict or tuple: The coordinates defining the ROI's position and shape.

        Raises:
            NotImplementedError: This method must be implemented by subclasses.
        """

    @rpc_call
    def get_data_from_image(
        self, image_item: "pg.ImageItem | None" = None, returnMappedCoords: "bool" = False, **kwargs
    ):
        """
        Wrapper around `pyqtgraph.ROI.getArrayRegion`.

        Args:
            image_item (pg.ImageItem or None): The ImageItem to sample. If None, auto-detects
                the first `ImageItem` in the same GraphicsScene as this ROI.
            returnMappedCoords (bool): If True, also returns the coordinate array generated by
                *getArrayRegion*.
            **kwargs: Additional keyword arguments passed to *getArrayRegion* or *affineSlice*,
                such as `axes`, `order`, `shape`, etc.

        Returns:
            ndarray: Pixel data inside the ROI, or (data, coords) if *returnMappedCoords* is True.
        """

    @rpc_call
    def set_position(self, x: "float", y: "float"):
        """
        Sets the position of the ROI.

        Args:
            x (float): The x-coordinate of the new position.
            y (float): The y-coordinate of the new position.
        """


class CircularROI(RPCBase):
    """Circular Region of Interest with center/diameter tracking and auto-labeling."""

    @property
    @rpc_call
    def label(self) -> "str":
        """
        Gets the display name of this ROI.

        Returns:
            str: The current name of the ROI.
        """

    @label.setter
    @rpc_call
    def label(self) -> "str":
        """
        Gets the display name of this ROI.

        Returns:
            str: The current name of the ROI.
        """

    @property
    @rpc_call
    def movable(self) -> "bool":
        """
        Gets whether this ROI is movable.

        Returns:
            bool: True if the ROI can be moved, False otherwise.
        """

    @movable.setter
    @rpc_call
    def movable(self) -> "bool":
        """
        Gets whether this ROI is movable.

        Returns:
            bool: True if the ROI can be moved, False otherwise.
        """

    @property
    @rpc_call
    def line_color(self) -> "str":
        """
        Gets the current line color of the ROI.

        Returns:
            str: The current line color as a string (e.g., hex color code).
        """

    @line_color.setter
    @rpc_call
    def line_color(self) -> "str":
        """
        Gets the current line color of the ROI.

        Returns:
            str: The current line color as a string (e.g., hex color code).
        """

    @property
    @rpc_call
    def line_width(self) -> "int":
        """
        Gets the current line width of the ROI.

        Returns:
            int: The current line width in pixels.
        """

    @line_width.setter
    @rpc_call
    def line_width(self) -> "int":
        """
        Gets the current line width of the ROI.

        Returns:
            int: The current line width in pixels.
        """

    @rpc_call
    def get_coordinates(self, typed: "bool | None" = None) -> "dict | tuple":
        """
        Calculates and returns the coordinates and size of an object, either as a
        typed dictionary or as a tuple.

        Args:
            typed (bool | None): If True, returns coordinates as a dictionary. Defaults
                to None, which utilizes the object's description value.

        Returns:
            dict: A dictionary with keys 'center_x', 'center_y', 'diameter', and 'radius'
                if `typed` is True.
            tuple: A tuple containing (center_x, center_y, diameter, radius) if `typed` is False.
        """

    @rpc_call
    def get_data_from_image(
        self, image_item: "pg.ImageItem | None" = None, returnMappedCoords: "bool" = False, **kwargs
    ):
        """
        Wrapper around `pyqtgraph.ROI.getArrayRegion`.

        Args:
            image_item (pg.ImageItem or None): The ImageItem to sample. If None, auto-detects
                the first `ImageItem` in the same GraphicsScene as this ROI.
            returnMappedCoords (bool): If True, also returns the coordinate array generated by
                *getArrayRegion*.
            **kwargs: Additional keyword arguments passed to *getArrayRegion* or *affineSlice*,
                such as `axes`, `order`, `shape`, etc.

        Returns:
            ndarray: Pixel data inside the ROI, or (data, coords) if *returnMappedCoords* is True.
        """

    @rpc_call
    def set_position(self, x: "float", y: "float"):
        """
        Sets the position of the ROI.

        Args:
            x (float): The x-coordinate of the new position.
            y (float): The y-coordinate of the new position.
        """


class Curve(RPCBase):
    @rpc_call
    def remove(self):
        """
        Remove the curve from the plot.
        """

    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_displayed_data(self) -> "tuple[np.ndarray, np.ndarray]":
        """
        Get the displayed data of the curve.

        Returns:
            tuple[np.ndarray, np.ndarray]: The x and y data of the curve.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the curve.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - color: str
            - symbol: str
            - symbol_color: str
            - symbol_size: int
            - pen_width: int
            - pen_style: Literal["solid", "dash", "dot", "dashdot"]
        """

    @rpc_call
    def set_data(self, x: "list | np.ndarray", y: "list | np.ndarray"):
        """
        Set the data of the curve.

        Args:
            x(list|np.ndarray): The x data.
            y(list|np.ndarray): The y data.

        Raises:
            ValueError: If the source is not custom.
        """

    @rpc_call
    def set_color(self, color: "str", symbol_color: "str | None" = None):
        """
        Change the color of the curve.

        Args:
            color(str): Color of the curve.
            symbol_color(str, optional): Color of the symbol. Defaults to None.
        """

    @rpc_call
    def set_color_map_z(self, colormap: "str"):
        """
        Set the colormap for the scatter plot z gradient.

        Args:
            colormap(str): Colormap for the scatter plot.
        """

    @rpc_call
    def set_symbol(self, symbol: "str"):
        """
        Change the symbol of the curve.

        Args:
            symbol(str): Symbol of the curve.
        """

    @rpc_call
    def set_symbol_color(self, symbol_color: "str"):
        """
        Change the symbol color of the curve.

        Args:
            symbol_color(str): Color of the symbol.
        """

    @rpc_call
    def set_symbol_size(self, symbol_size: "int"):
        """
        Change the symbol size of the curve.

        Args:
            symbol_size(int): Size of the symbol.
        """

    @rpc_call
    def set_pen_width(self, pen_width: "int"):
        """
        Change the pen width of the curve.

        Args:
            pen_width(int): Width of the pen.
        """

    @rpc_call
    def set_pen_style(self, pen_style: "Literal['solid', 'dash', 'dot', 'dashdot']"):
        """
        Change the pen style of the curve.

        Args:
            pen_style(Literal["solid", "dash", "dot", "dashdot"]): Style of the pen.
        """

    @rpc_call
    def get_data(self) -> "tuple[np.ndarray | None, np.ndarray | None]":
        """
        Get the data of the curve.
        Returns:
            tuple[np.ndarray,np.ndarray]: X and Y data of the curve.
        """

    @property
    @rpc_call
    def dap_params(self):
        """
        Get the dap parameters.
        """

    @property
    @rpc_call
    def dap_summary(self):
        """
        Get the dap summary.
        """

    @property
    @rpc_call
    def dap_oversample(self):
        """
        Get the dap oversample.
        """

    @dap_oversample.setter
    @rpc_call
    def dap_oversample(self):
        """
        Get the dap oversample.
        """


class DapComboBox(RPCBase):
    """The DAPComboBox widget is an extension to the QComboBox with all avaialble DAP model from BEC."""

    @rpc_call
    def select_y_axis(self, y_axis: str):
        """
        Slot to update the y axis.

        Args:
            y_axis(str): Y axis.
        """

    @rpc_call
    def select_x_axis(self, x_axis: str):
        """
        Slot to update the x axis.

        Args:
            x_axis(str): X axis.
        """

    @rpc_call
    def select_fit_model(self, fit_name: str | None):
        """
        Slot to update the fit model.

        Args:
            default_device(str): Default device name.
        """


class DarkModeButton(RPCBase):
    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class DeviceBrowser(RPCBase):
    """DeviceBrowser is a widget that displays all available devices in the current BEC session."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class DeviceComboBox(RPCBase):
    """Combobox widget for device input with autocomplete for device names."""

    @rpc_call
    def set_device(self, device: "str"):
        """
        Set the device.

        Args:
            device (str): Default name.
        """

    @property
    @rpc_call
    def devices(self) -> "list[str]":
        """
        Get the list of devices for the applied filters.

        Returns:
            list[str]: List of devices.
        """


class DeviceInputBase(RPCBase):
    """Mixin base class for device input widgets."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class DeviceLineEdit(RPCBase):
    """Line edit widget for device input with autocomplete for device names."""

    @rpc_call
    def set_device(self, device: "str"):
        """
        Set the device.

        Args:
            device (str): Default name.
        """

    @property
    @rpc_call
    def devices(self) -> "list[str]":
        """
        Get the list of devices for the applied filters.

        Returns:
            list[str]: List of devices.
        """

    @property
    @rpc_call
    def _is_valid_input(self) -> bool:
        """
        Check if the current value is a valid device name.

        Returns:
            bool: True if the current value is a valid device name, False otherwise.
        """


class EllipticalROI(RPCBase):
    """Elliptical Region of Interest with centre/width/height tracking and auto-labelling."""

    @property
    @rpc_call
    def label(self) -> "str":
        """
        Gets the display name of this ROI.

        Returns:
            str: The current name of the ROI.
        """

    @label.setter
    @rpc_call
    def label(self) -> "str":
        """
        Gets the display name of this ROI.

        Returns:
            str: The current name of the ROI.
        """

    @property
    @rpc_call
    def movable(self) -> "bool":
        """
        Gets whether this ROI is movable.

        Returns:
            bool: True if the ROI can be moved, False otherwise.
        """

    @movable.setter
    @rpc_call
    def movable(self) -> "bool":
        """
        Gets whether this ROI is movable.

        Returns:
            bool: True if the ROI can be moved, False otherwise.
        """

    @property
    @rpc_call
    def line_color(self) -> "str":
        """
        Gets the current line color of the ROI.

        Returns:
            str: The current line color as a string (e.g., hex color code).
        """

    @line_color.setter
    @rpc_call
    def line_color(self) -> "str":
        """
        Gets the current line color of the ROI.

        Returns:
            str: The current line color as a string (e.g., hex color code).
        """

    @property
    @rpc_call
    def line_width(self) -> "int":
        """
        Gets the current line width of the ROI.

        Returns:
            int: The current line width in pixels.
        """

    @line_width.setter
    @rpc_call
    def line_width(self) -> "int":
        """
        Gets the current line width of the ROI.

        Returns:
            int: The current line width in pixels.
        """

    @rpc_call
    def get_coordinates(self, typed: "bool | None" = None) -> "dict | tuple":
        """
        Return the ellipse's centre and size.

        Args:
            typed (bool | None): If True returns dict; otherwise tuple.
        """

    @rpc_call
    def get_data_from_image(
        self, image_item: "pg.ImageItem | None" = None, returnMappedCoords: "bool" = False, **kwargs
    ):
        """
        Wrapper around `pyqtgraph.ROI.getArrayRegion`.

        Args:
            image_item (pg.ImageItem or None): The ImageItem to sample. If None, auto-detects
                the first `ImageItem` in the same GraphicsScene as this ROI.
            returnMappedCoords (bool): If True, also returns the coordinate array generated by
                *getArrayRegion*.
            **kwargs: Additional keyword arguments passed to *getArrayRegion* or *affineSlice*,
                such as `axes`, `order`, `shape`, etc.

        Returns:
            ndarray: Pixel data inside the ROI, or (data, coords) if *returnMappedCoords* is True.
        """

    @rpc_call
    def set_position(self, x: "float", y: "float"):
        """
        Sets the position of the ROI.

        Args:
            x (float): The x-coordinate of the new position.
            y (float): The y-coordinate of the new position.
        """


class Heatmap(RPCBase):
    """Heatmap widget for visualizing 2d grid data with color mapping for the z-axis."""

    @property
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @enable_toolbar.setter
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @property
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @enable_side_panel.setter
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @property
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @enable_fps_monitor.setter
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @property
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @title.setter
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @property
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @x_label.setter
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @property
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @y_label.setter
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @property
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @x_limits.setter
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @property
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @y_limits.setter
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @property
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @x_grid.setter
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @property
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @y_grid.setter
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @property
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @inner_axes.setter
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @property
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @outer_axes.setter
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @property
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @auto_range_x.setter
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @property
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @auto_range_y.setter
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @property
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @minimal_crosshair_precision.setter
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """

    @property
    @rpc_call
    def color_map(self) -> "str":
        """
        Set the color map of the image.
        """

    @color_map.setter
    @rpc_call
    def color_map(self) -> "str":
        """
        Set the color map of the image.
        """

    @property
    @rpc_call
    def v_range(self) -> "QPointF":
        """
        Set the v_range of the main image.
        """

    @v_range.setter
    @rpc_call
    def v_range(self) -> "QPointF":
        """
        Set the v_range of the main image.
        """

    @property
    @rpc_call
    def v_min(self) -> "float":
        """
        Get the minimum value of the v_range.
        """

    @v_min.setter
    @rpc_call
    def v_min(self) -> "float":
        """
        Get the minimum value of the v_range.
        """

    @property
    @rpc_call
    def v_max(self) -> "float":
        """
        Get the maximum value of the v_range.
        """

    @v_max.setter
    @rpc_call
    def v_max(self) -> "float":
        """
        Get the maximum value of the v_range.
        """

    @property
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Whether the aspect ratio is locked.
        """

    @lock_aspect_ratio.setter
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Whether the aspect ratio is locked.
        """

    @property
    @rpc_call
    def autorange(self) -> "bool":
        """
        Whether autorange is enabled.
        """

    @autorange.setter
    @rpc_call
    def autorange(self) -> "bool":
        """
        Whether autorange is enabled.
        """

    @property
    @rpc_call
    def autorange_mode(self) -> "str":
        """
        Autorange mode.

        Options:
            - "max": Use the maximum value of the image for autoranging.
            - "mean": Use the mean value of the image for autoranging.
        """

    @autorange_mode.setter
    @rpc_call
    def autorange_mode(self) -> "str":
        """
        Autorange mode.

        Options:
            - "max": Use the maximum value of the image for autoranging.
            - "mean": Use the mean value of the image for autoranging.
        """

    @rpc_call
    def enable_colorbar(
        self,
        enabled: "bool",
        style: "Literal['full', 'simple']" = "full",
        vrange: "tuple[int, int] | None" = None,
    ):
        """
        Enable the colorbar and switch types of colorbars.

        Args:
            enabled(bool): Whether to enable the colorbar.
            style(Literal["full", "simple"]): The type of colorbar to enable.
            vrange(tuple): The range of values to use for the colorbar.
        """

    @property
    @rpc_call
    def enable_simple_colorbar(self) -> "bool":
        """
        Enable the simple colorbar.
        """

    @enable_simple_colorbar.setter
    @rpc_call
    def enable_simple_colorbar(self) -> "bool":
        """
        Enable the simple colorbar.
        """

    @property
    @rpc_call
    def enable_full_colorbar(self) -> "bool":
        """
        Enable the full colorbar.
        """

    @enable_full_colorbar.setter
    @rpc_call
    def enable_full_colorbar(self) -> "bool":
        """
        Enable the full colorbar.
        """

    @property
    @rpc_call
    def interpolation_method(self) -> "str":
        """
        The interpolation method used for the heatmap.
        """

    @interpolation_method.setter
    @rpc_call
    def interpolation_method(self) -> "str":
        """
        The interpolation method used for the heatmap.
        """

    @property
    @rpc_call
    def oversampling_factor(self) -> "float":
        """
        The oversampling factor for grid resolution.
        """

    @oversampling_factor.setter
    @rpc_call
    def oversampling_factor(self) -> "float":
        """
        The oversampling factor for grid resolution.
        """

    @property
    @rpc_call
    def enforce_interpolation(self) -> "bool":
        """
        Whether to enforce interpolation even for grid scans.
        """

    @enforce_interpolation.setter
    @rpc_call
    def enforce_interpolation(self) -> "bool":
        """
        Whether to enforce interpolation even for grid scans.
        """

    @property
    @rpc_call
    def fft(self) -> "bool":
        """
        Whether FFT postprocessing is enabled.
        """

    @fft.setter
    @rpc_call
    def fft(self) -> "bool":
        """
        Whether FFT postprocessing is enabled.
        """

    @property
    @rpc_call
    def log(self) -> "bool":
        """
        Whether logarithmic scaling is applied.
        """

    @log.setter
    @rpc_call
    def log(self) -> "bool":
        """
        Whether logarithmic scaling is applied.
        """

    @property
    @rpc_call
    def main_image(self) -> "ImageItem":
        """
        Access the main image item.
        """

    @rpc_call
    def add_roi(
        self,
        kind: "Literal['rect', 'circle', 'ellipse']" = "rect",
        name: "str | None" = None,
        line_width: "int | None" = 5,
        pos: "tuple[float, float] | None" = (10, 10),
        size: "tuple[float, float] | None" = (50, 50),
        movable: "bool" = True,
        **pg_kwargs,
    ) -> "RectangularROI | CircularROI":
        """
        Add a ROI to the image.

        Args:
            kind(str): The type of ROI to add. Options are "rect" or "circle".
            name(str): The name of the ROI.
            line_width(int): The line width of the ROI.
            pos(tuple): The position of the ROI.
            size(tuple): The size of the ROI.
            movable(bool): Whether the ROI is movable.
            **pg_kwargs: Additional arguments for the ROI.

        Returns:
            RectangularROI | CircularROI: The created ROI object.
        """

    @rpc_call
    def remove_roi(self, roi: "int | str"):
        """
        Remove an ROI by index or label via the ROIController.
        """

    @property
    @rpc_call
    def rois(self) -> "list[BaseROI]":
        """
        Get the list of ROIs.
        """

    @rpc_call
    def plot(
        self,
        x_name: "str",
        y_name: "str",
        z_name: "str",
        x_entry: "None | str" = None,
        y_entry: "None | str" = None,
        z_entry: "None | str" = None,
        color_map: "str | None" = "plasma",
        validate_bec: "bool" = True,
        interpolation: "Literal['linear', 'nearest'] | None" = None,
        enforce_interpolation: "bool | None" = None,
        oversampling_factor: "float | None" = None,
        lock_aspect_ratio: "bool | None" = None,
        show_config_label: "bool | None" = None,
        reload: "bool" = False,
    ):
        """
        Plot the heatmap with the given x, y, and z data.

        Args:
            x_name (str): The name of the x-axis signal.
            y_name (str): The name of the y-axis signal.
            z_name (str): The name of the z-axis signal.
            x_entry (str | None): The entry for the x-axis signal.
            y_entry (str | None): The entry for the y-axis signal.
            z_entry (str | None): The entry for the z-axis signal.
            color_map (str | None): The color map to use for the heatmap.
            validate_bec (bool): Whether to validate the entries against BEC signals.
            interpolation (Literal["linear", "nearest"] | None): The interpolation method to use.
            enforce_interpolation (bool | None): Whether to enforce interpolation even for grid scans.
            oversampling_factor (float | None): Factor to oversample the grid resolution.
            lock_aspect_ratio (bool | None): Whether to lock the aspect ratio of the image.
            show_config_label (bool | None): Whether to show the configuration label in the heatmap.
            reload (bool): Whether to reload the heatmap with new data.
        """


class Image(RPCBase):
    """Image widget for displaying 2D data."""

    @property
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @enable_toolbar.setter
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @property
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @enable_side_panel.setter
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @property
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @enable_fps_monitor.setter
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @property
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @title.setter
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @property
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @x_label.setter
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @property
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @y_label.setter
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @property
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @x_limits.setter
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @property
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @y_limits.setter
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @property
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @x_grid.setter
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @property
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @y_grid.setter
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @property
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @inner_axes.setter
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @property
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @outer_axes.setter
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @property
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @auto_range_x.setter
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @property
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @auto_range_y.setter
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @property
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @minimal_crosshair_precision.setter
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """

    @property
    @rpc_call
    def color_map(self) -> "str":
        """
        Set the color map of the image.
        """

    @color_map.setter
    @rpc_call
    def color_map(self) -> "str":
        """
        Set the color map of the image.
        """

    @property
    @rpc_call
    def v_range(self) -> "QPointF":
        """
        Set the v_range of the main image.
        """

    @v_range.setter
    @rpc_call
    def v_range(self) -> "QPointF":
        """
        Set the v_range of the main image.
        """

    @property
    @rpc_call
    def v_min(self) -> "float":
        """
        Get the minimum value of the v_range.
        """

    @v_min.setter
    @rpc_call
    def v_min(self) -> "float":
        """
        Get the minimum value of the v_range.
        """

    @property
    @rpc_call
    def v_max(self) -> "float":
        """
        Get the maximum value of the v_range.
        """

    @v_max.setter
    @rpc_call
    def v_max(self) -> "float":
        """
        Get the maximum value of the v_range.
        """

    @property
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Whether the aspect ratio is locked.
        """

    @lock_aspect_ratio.setter
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Whether the aspect ratio is locked.
        """

    @property
    @rpc_call
    def autorange(self) -> "bool":
        """
        Whether autorange is enabled.
        """

    @autorange.setter
    @rpc_call
    def autorange(self) -> "bool":
        """
        Whether autorange is enabled.
        """

    @property
    @rpc_call
    def autorange_mode(self) -> "str":
        """
        Autorange mode.

        Options:
            - "max": Use the maximum value of the image for autoranging.
            - "mean": Use the mean value of the image for autoranging.
        """

    @autorange_mode.setter
    @rpc_call
    def autorange_mode(self) -> "str":
        """
        Autorange mode.

        Options:
            - "max": Use the maximum value of the image for autoranging.
            - "mean": Use the mean value of the image for autoranging.
        """

    @property
    @rpc_call
    def monitor(self) -> "str":
        """
        The name of the monitor to use for the image.
        """

    @monitor.setter
    @rpc_call
    def monitor(self) -> "str":
        """
        The name of the monitor to use for the image.
        """

    @rpc_call
    def enable_colorbar(
        self,
        enabled: "bool",
        style: "Literal['full', 'simple']" = "full",
        vrange: "tuple[int, int] | None" = None,
    ):
        """
        Enable the colorbar and switch types of colorbars.

        Args:
            enabled(bool): Whether to enable the colorbar.
            style(Literal["full", "simple"]): The type of colorbar to enable.
            vrange(tuple): The range of values to use for the colorbar.
        """

    @property
    @rpc_call
    def enable_simple_colorbar(self) -> "bool":
        """
        Enable the simple colorbar.
        """

    @enable_simple_colorbar.setter
    @rpc_call
    def enable_simple_colorbar(self) -> "bool":
        """
        Enable the simple colorbar.
        """

    @property
    @rpc_call
    def enable_full_colorbar(self) -> "bool":
        """
        Enable the full colorbar.
        """

    @enable_full_colorbar.setter
    @rpc_call
    def enable_full_colorbar(self) -> "bool":
        """
        Enable the full colorbar.
        """

    @property
    @rpc_call
    def fft(self) -> "bool":
        """
        Whether FFT postprocessing is enabled.
        """

    @fft.setter
    @rpc_call
    def fft(self) -> "bool":
        """
        Whether FFT postprocessing is enabled.
        """

    @property
    @rpc_call
    def log(self) -> "bool":
        """
        Whether logarithmic scaling is applied.
        """

    @log.setter
    @rpc_call
    def log(self) -> "bool":
        """
        Whether logarithmic scaling is applied.
        """

    @property
    @rpc_call
    def num_rotation_90(self) -> "int":
        """
        The number of 90° rotations to apply counterclockwise.
        """

    @num_rotation_90.setter
    @rpc_call
    def num_rotation_90(self) -> "int":
        """
        The number of 90° rotations to apply counterclockwise.
        """

    @property
    @rpc_call
    def transpose(self) -> "bool":
        """
        Whether the image is transposed.
        """

    @transpose.setter
    @rpc_call
    def transpose(self) -> "bool":
        """
        Whether the image is transposed.
        """

    @rpc_call
    def image(
        self,
        monitor: "str | tuple | None" = None,
        monitor_type: "Literal['auto', '1d', '2d']" = "auto",
        color_map: "str | None" = None,
        color_bar: "Literal['simple', 'full'] | None" = None,
        vrange: "tuple[int, int] | None" = None,
    ) -> "ImageItem | None":
        """
        Set the image source and update the image.

        Args:
            monitor(str|tuple|None): The name of the monitor to use for the image, or a tuple of (device, signal) for preview signals. If None or empty string, the current monitor will be disconnected.
            monitor_type(str): The type of monitor to use. Options are "1d", "2d", or "auto".
            color_map(str): The color map to use for the image.
            color_bar(str): The type of color bar to use. Options are "simple" or "full".
            vrange(tuple): The range of values to use for the color map.

        Returns:
            ImageItem: The image object.
        """

    @property
    @rpc_call
    def main_image(self) -> "ImageItem":
        """
        Access the main image item.
        """

    @rpc_call
    def add_roi(
        self,
        kind: "Literal['rect', 'circle', 'ellipse']" = "rect",
        name: "str | None" = None,
        line_width: "int | None" = 5,
        pos: "tuple[float, float] | None" = (10, 10),
        size: "tuple[float, float] | None" = (50, 50),
        movable: "bool" = True,
        **pg_kwargs,
    ) -> "RectangularROI | CircularROI":
        """
        Add a ROI to the image.

        Args:
            kind(str): The type of ROI to add. Options are "rect" or "circle".
            name(str): The name of the ROI.
            line_width(int): The line width of the ROI.
            pos(tuple): The position of the ROI.
            size(tuple): The size of the ROI.
            movable(bool): Whether the ROI is movable.
            **pg_kwargs: Additional arguments for the ROI.

        Returns:
            RectangularROI | CircularROI: The created ROI object.
        """

    @rpc_call
    def remove_roi(self, roi: "int | str"):
        """
        Remove an ROI by index or label via the ROIController.
        """

    @property
    @rpc_call
    def rois(self) -> "list[BaseROI]":
        """
        Get the list of ROIs.
        """


class ImageItem(RPCBase):
    @property
    @rpc_call
    def color_map(self) -> "str":
        """
        Get the current color map.
        """

    @color_map.setter
    @rpc_call
    def color_map(self) -> "str":
        """
        Get the current color map.
        """

    @property
    @rpc_call
    def v_range(self) -> "tuple[float, float]":
        """
        Get the color intensity range of the image.
        """

    @v_range.setter
    @rpc_call
    def v_range(self) -> "tuple[float, float]":
        """
        Get the color intensity range of the image.
        """

    @property
    @rpc_call
    def v_min(self) -> "float":
        """
        None
        """

    @v_min.setter
    @rpc_call
    def v_min(self) -> "float":
        """
        None
        """

    @property
    @rpc_call
    def v_max(self) -> "float":
        """
        None
        """

    @v_max.setter
    @rpc_call
    def v_max(self) -> "float":
        """
        None
        """

    @property
    @rpc_call
    def autorange(self) -> "bool":
        """
        None
        """

    @autorange.setter
    @rpc_call
    def autorange(self) -> "bool":
        """
        None
        """

    @property
    @rpc_call
    def autorange_mode(self) -> "str":
        """
        None
        """

    @autorange_mode.setter
    @rpc_call
    def autorange_mode(self) -> "str":
        """
        None
        """

    @property
    @rpc_call
    def fft(self) -> "bool":
        """
        Get or set whether FFT postprocessing is enabled.
        """

    @fft.setter
    @rpc_call
    def fft(self) -> "bool":
        """
        Get or set whether FFT postprocessing is enabled.
        """

    @property
    @rpc_call
    def log(self) -> "bool":
        """
        Get or set whether logarithmic scaling is applied.
        """

    @log.setter
    @rpc_call
    def log(self) -> "bool":
        """
        Get or set whether logarithmic scaling is applied.
        """

    @property
    @rpc_call
    def num_rotation_90(self) -> "Optional[int]":
        """
        Get or set the number of 90° rotations to apply.
        """

    @num_rotation_90.setter
    @rpc_call
    def num_rotation_90(self) -> "Optional[int]":
        """
        Get or set the number of 90° rotations to apply.
        """

    @property
    @rpc_call
    def transpose(self) -> "bool":
        """
        Get or set whether the image is transposed.
        """

    @transpose.setter
    @rpc_call
    def transpose(self) -> "bool":
        """
        Get or set whether the image is transposed.
        """

    @rpc_call
    def get_data(self) -> "np.ndarray":
        """
        Get the data of the image.
        Returns:
            np.ndarray: The data of the image.
        """


class LogPanel(RPCBase):
    """Displays a log panel"""

    @rpc_call
    def set_plain_text(self, text: str) -> None:
        """
        Set the plain text of the widget.

        Args:
            text (str): The text to set.
        """

    @rpc_call
    def set_html_text(self, text: str) -> None:
        """
        Set the HTML text of the widget.

        Args:
            text (str): The text to set.
        """


class Minesweeper(RPCBase): ...


class MonacoWidget(RPCBase):
    """A simple Monaco editor widget"""

    @rpc_call
    def set_text(self, text: str) -> None:
        """
        Set the text in the Monaco editor.

        Args:
            text (str): The text to set in the editor.
        """

    @rpc_call
    def get_text(self) -> str:
        """
        Get the current text from the Monaco editor.
        """

    @rpc_call
    def insert_text(self, text: str, line: int | None = None, column: int | None = None) -> None:
        """
        Insert text at the current cursor position or at a specified line and column.

        Args:
            text (str): The text to insert.
            line (int, optional): The line number (1-based) to insert the text at. Defaults to None.
            column (int, optional): The column number (1-based) to insert the text at. Defaults to None.
        """

    @rpc_call
    def delete_line(self, line: int | None = None) -> None:
        """
        Delete a line in the Monaco editor.

        Args:
            line (int, optional): The line number (1-based) to delete. If None, the current line will be deleted.
        """

    @rpc_call
    def set_language(self, language: str) -> None:
        """
        Set the programming language for syntax highlighting in the Monaco editor.

        Args:
            language (str): The programming language to set (e.g., "python", "javascript").
        """

    @rpc_call
    def get_language(self) -> str:
        """
        Get the current programming language set in the Monaco editor.
        """

    @rpc_call
    def set_theme(self, theme: str) -> None:
        """
        Set the theme for the Monaco editor.

        Args:
            theme (str): The theme to set (e.g., "vs-dark", "light").
        """

    @rpc_call
    def get_theme(self) -> str:
        """
        Get the current theme of the Monaco editor.
        """

    @rpc_call
    def set_readonly(self, read_only: bool) -> None:
        """
        Set the Monaco editor to read-only mode.

        Args:
            read_only (bool): If True, the editor will be read-only.
        """

    @rpc_call
    def set_cursor(
        self,
        line: int,
        column: int = 1,
        move_to_position: Literal[None, "center", "top", "position"] = None,
    ) -> None:
        """
        Set the cursor position in the Monaco editor.

        Args:
            line (int): Line number (1-based).
            column (int): Column number (1-based), defaults to 1.
            move_to_position (Literal[None, "center", "top", "position"], optional): Position to move the cursor to.
        """

    @rpc_call
    def current_cursor(self) -> dict[str, int]:
        """
        Get the current cursor position in the Monaco editor.

        Returns:
            dict[str, int]: A dictionary with keys 'line' and 'column' representing the cursor position.
        """

    @rpc_call
    def set_minimap_enabled(self, enabled: bool) -> None:
        """
        Enable or disable the minimap in the Monaco editor.

        Args:
            enabled (bool): If True, the minimap will be enabled; otherwise, it will be disabled.
        """

    @rpc_call
    def set_vim_mode_enabled(self, enabled: bool) -> None:
        """
        Enable or disable Vim mode in the Monaco editor.

        Args:
            enabled (bool): If True, Vim mode will be enabled; otherwise, it will be disabled.
        """

    @rpc_call
    def set_lsp_header(self, header: str) -> None:
        """
        Set the LSP (Language Server Protocol) header for the Monaco editor.
        The header is used to provide context for language servers but is not displayed in the editor.

        Args:
            header (str): The LSP header to set.
        """

    @rpc_call
    def get_lsp_header(self) -> str:
        """
        Get the current LSP header set in the Monaco editor.

        Returns:
            str: The LSP header.
        """


class MotorMap(RPCBase):
    """Motor map widget for plotting motor positions in 2D including a trace of the last points."""

    @property
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @enable_toolbar.setter
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @property
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @enable_side_panel.setter
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @property
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @enable_fps_monitor.setter
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @property
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @title.setter
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @property
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @x_label.setter
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @property
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @y_label.setter
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @property
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @x_limits.setter
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @property
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @y_limits.setter
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @property
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @x_grid.setter
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @property
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @y_grid.setter
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @property
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @inner_axes.setter
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @property
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @outer_axes.setter
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @property
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Lock aspect ratio of the plot widget.
        """

    @lock_aspect_ratio.setter
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Lock aspect ratio of the plot widget.
        """

    @property
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @auto_range_x.setter
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @property
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @auto_range_y.setter
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @property
    @rpc_call
    def x_log(self) -> "bool":
        """
        Set X-axis to log scale if True, linear if False.
        """

    @x_log.setter
    @rpc_call
    def x_log(self) -> "bool":
        """
        Set X-axis to log scale if True, linear if False.
        """

    @property
    @rpc_call
    def y_log(self) -> "bool":
        """
        Set Y-axis to log scale if True, linear if False.
        """

    @y_log.setter
    @rpc_call
    def y_log(self) -> "bool":
        """
        Set Y-axis to log scale if True, linear if False.
        """

    @property
    @rpc_call
    def legend_label_size(self) -> "int":
        """
        The font size of the legend font.
        """

    @legend_label_size.setter
    @rpc_call
    def legend_label_size(self) -> "int":
        """
        The font size of the legend font.
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """

    @property
    @rpc_call
    def color(self) -> "tuple":
        """
        Get the color of the motor trace.

        Returns:
            tuple: Color of the motor trace.
        """

    @color.setter
    @rpc_call
    def color(self) -> "tuple":
        """
        Get the color of the motor trace.

        Returns:
            tuple: Color of the motor trace.
        """

    @property
    @rpc_call
    def max_points(self) -> "int":
        """
        Get the maximum number of points to display.
        """

    @max_points.setter
    @rpc_call
    def max_points(self) -> "int":
        """
        Get the maximum number of points to display.
        """

    @property
    @rpc_call
    def precision(self) -> "int":
        """
        Set the decimal precision of the motor position.
        """

    @precision.setter
    @rpc_call
    def precision(self) -> "int":
        """
        Set the decimal precision of the motor position.
        """

    @property
    @rpc_call
    def num_dim_points(self) -> "int":
        """
        Get the number of dim points for the motor map.
        """

    @num_dim_points.setter
    @rpc_call
    def num_dim_points(self) -> "int":
        """
        Get the number of dim points for the motor map.
        """

    @property
    @rpc_call
    def background_value(self) -> "int":
        """
        Get the background value of the motor map.
        """

    @background_value.setter
    @rpc_call
    def background_value(self) -> "int":
        """
        Get the background value of the motor map.
        """

    @property
    @rpc_call
    def scatter_size(self) -> "int":
        """
        Get the scatter size of the motor map plot.
        """

    @scatter_size.setter
    @rpc_call
    def scatter_size(self) -> "int":
        """
        Get the scatter size of the motor map plot.
        """

    @rpc_call
    def map(self, x_name: "str", y_name: "str", validate_bec: "bool" = True) -> "None":
        """
        Set the x and y motor names.

        Args:
            x_name(str): The name of the x motor.
            y_name(str): The name of the y motor.
            validate_bec(bool, optional): If True, validate the signal with BEC. Defaults to True.
        """

    @rpc_call
    def reset_history(self):
        """
        Reset the history of the motor map.
        """

    @rpc_call
    def get_data(self) -> "dict":
        """
        Get the data of the motor map.

        Returns:
            dict: Data of the motor map.
        """


class MultiWaveform(RPCBase):
    """MultiWaveform widget for displaying multiple waveforms emitted by a single signal."""

    @property
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @enable_toolbar.setter
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @property
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @enable_side_panel.setter
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @property
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @enable_fps_monitor.setter
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @property
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @title.setter
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @property
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @x_label.setter
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @property
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @y_label.setter
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @property
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @x_limits.setter
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @property
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @y_limits.setter
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @property
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @x_grid.setter
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @property
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @y_grid.setter
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @property
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @inner_axes.setter
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @property
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @outer_axes.setter
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @property
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Lock aspect ratio of the plot widget.
        """

    @lock_aspect_ratio.setter
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Lock aspect ratio of the plot widget.
        """

    @property
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @auto_range_x.setter
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @property
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @auto_range_y.setter
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @property
    @rpc_call
    def x_log(self) -> "bool":
        """
        Set X-axis to log scale if True, linear if False.
        """

    @x_log.setter
    @rpc_call
    def x_log(self) -> "bool":
        """
        Set X-axis to log scale if True, linear if False.
        """

    @property
    @rpc_call
    def y_log(self) -> "bool":
        """
        Set Y-axis to log scale if True, linear if False.
        """

    @y_log.setter
    @rpc_call
    def y_log(self) -> "bool":
        """
        Set Y-axis to log scale if True, linear if False.
        """

    @property
    @rpc_call
    def legend_label_size(self) -> "int":
        """
        The font size of the legend font.
        """

    @legend_label_size.setter
    @rpc_call
    def legend_label_size(self) -> "int":
        """
        The font size of the legend font.
        """

    @property
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @minimal_crosshair_precision.setter
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """

    @property
    @rpc_call
    def highlighted_index(self):
        """
        None
        """

    @highlighted_index.setter
    @rpc_call
    def highlighted_index(self):
        """
        None
        """

    @property
    @rpc_call
    def highlight_last_curve(self) -> "bool":
        """
        Get the highlight_last_curve property.
        Returns:
            bool: The highlight_last_curve property.
        """

    @highlight_last_curve.setter
    @rpc_call
    def highlight_last_curve(self) -> "bool":
        """
        Get the highlight_last_curve property.
        Returns:
            bool: The highlight_last_curve property.
        """

    @property
    @rpc_call
    def color_palette(self) -> "str":
        """
        The color palette of the figure widget.
        """

    @color_palette.setter
    @rpc_call
    def color_palette(self) -> "str":
        """
        The color palette of the figure widget.
        """

    @property
    @rpc_call
    def opacity(self) -> "int":
        """
        The opacity of the figure widget.
        """

    @opacity.setter
    @rpc_call
    def opacity(self) -> "int":
        """
        The opacity of the figure widget.
        """

    @property
    @rpc_call
    def flush_buffer(self) -> "bool":
        """
        The flush_buffer property.
        """

    @flush_buffer.setter
    @rpc_call
    def flush_buffer(self) -> "bool":
        """
        The flush_buffer property.
        """

    @property
    @rpc_call
    def max_trace(self) -> "int":
        """
        The maximum number of traces to display on the plot.
        """

    @max_trace.setter
    @rpc_call
    def max_trace(self) -> "int":
        """
        The maximum number of traces to display on the plot.
        """

    @property
    @rpc_call
    def monitor(self) -> "str":
        """
        The monitor of the figure widget.
        """

    @monitor.setter
    @rpc_call
    def monitor(self) -> "str":
        """
        The monitor of the figure widget.
        """

    @rpc_call
    def set_curve_limit(self, max_trace: "int", flush_buffer: "bool"):
        """
        Set the maximum number of traces to display on the plot.

        Args:
            max_trace (int): The maximum number of traces to display.
            flush_buffer (bool): Flush the buffer.
        """

    @rpc_call
    def plot(self, monitor: "str", color_palette: "str | None" = "plasma"):
        """
        Create a plot for the given monitor.
        Args:
            monitor (str): The monitor to set.
            color_palette (str|None): The color palette to use for the plot.
        """

    @rpc_call
    def set_curve_highlight(self, index: "int"):
        """
        Set the curve highlight based on visible curves.

        Args:
            index (int): The index of the curve to highlight among visible curves.
        """

    @rpc_call
    def clear_curves(self):
        """
        Remove all curves from the plot, excluding crosshair items.
        """


class PositionIndicator(RPCBase):
    """Display a position within a defined range, e.g. motor limits."""

    @rpc_call
    def set_value(self, position: float):
        """
        Set the position of the indicator

        Args:
            position: The new position of the indicator
        """

    @rpc_call
    def set_range(self, min_value: float, max_value: float):
        """
        Set the range of the position indicator

        Args:
            min_value(float): Minimum value of the range
            max_value(float): Maximum value of the range
        """

    @property
    @rpc_call
    def vertical(self):
        """
        Property to determine the orientation of the position indicator
        """

    @vertical.setter
    @rpc_call
    def vertical(self):
        """
        Property to determine the orientation of the position indicator
        """

    @property
    @rpc_call
    def indicator_width(self):
        """
        Property to get the width of the indicator
        """

    @indicator_width.setter
    @rpc_call
    def indicator_width(self):
        """
        Property to get the width of the indicator
        """

    @property
    @rpc_call
    def rounded_corners(self):
        """
        Property to get the rounded corners of the position indicator
        """

    @rounded_corners.setter
    @rpc_call
    def rounded_corners(self):
        """
        Property to get the rounded corners of the position indicator
        """


class PositionerBox(RPCBase):
    """Simple Widget to control a positioner in box form"""

    @rpc_call
    def set_positioner(self, positioner: "str | Positioner"):
        """
        Set the device

        Args:
            positioner (Positioner | str) : Positioner to set, accepts str or the device
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """


class PositionerBox2D(RPCBase):
    """Simple Widget to control two positioners in box form"""

    @rpc_call
    def set_positioner_hor(self, positioner: "str | Positioner"):
        """
        Set the device

        Args:
            positioner (Positioner | str) : Positioner to set, accepts str or the device
        """

    @rpc_call
    def set_positioner_ver(self, positioner: "str | Positioner"):
        """
        Set the device

        Args:
            positioner (Positioner | str) : Positioner to set, accepts str or the device
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """

    @property
    @rpc_call
    def enable_controls_hor(self) -> "bool":
        """
        Persisted switch for horizontal control buttons (tweak/step).
        """

    @enable_controls_hor.setter
    @rpc_call
    def enable_controls_hor(self) -> "bool":
        """
        Persisted switch for horizontal control buttons (tweak/step).
        """

    @property
    @rpc_call
    def enable_controls_ver(self) -> "bool":
        """
        Persisted switch for vertical control buttons (tweak/step).
        """

    @enable_controls_ver.setter
    @rpc_call
    def enable_controls_ver(self) -> "bool":
        """
        Persisted switch for vertical control buttons (tweak/step).
        """


class PositionerControlLine(RPCBase):
    """A widget that controls a single device."""

    @rpc_call
    def set_positioner(self, positioner: "str | Positioner"):
        """
        Set the device

        Args:
            positioner (Positioner | str) : Positioner to set, accepts str or the device
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """


class PositionerGroup(RPCBase):
    """Simple Widget to control a positioner in box form"""

    @rpc_call
    def set_positioners(self, device_names: "str"):
        """
        Redraw grid with positioners from device_names string

        Device names must be separated by space
        """


class RectangularROI(RPCBase):
    """Defines a rectangular Region of Interest (ROI) with additional functionality."""

    @property
    @rpc_call
    def label(self) -> "str":
        """
        Gets the display name of this ROI.

        Returns:
            str: The current name of the ROI.
        """

    @label.setter
    @rpc_call
    def label(self) -> "str":
        """
        Gets the display name of this ROI.

        Returns:
            str: The current name of the ROI.
        """

    @property
    @rpc_call
    def movable(self) -> "bool":
        """
        Gets whether this ROI is movable.

        Returns:
            bool: True if the ROI can be moved, False otherwise.
        """

    @movable.setter
    @rpc_call
    def movable(self) -> "bool":
        """
        Gets whether this ROI is movable.

        Returns:
            bool: True if the ROI can be moved, False otherwise.
        """

    @property
    @rpc_call
    def line_color(self) -> "str":
        """
        Gets the current line color of the ROI.

        Returns:
            str: The current line color as a string (e.g., hex color code).
        """

    @line_color.setter
    @rpc_call
    def line_color(self) -> "str":
        """
        Gets the current line color of the ROI.

        Returns:
            str: The current line color as a string (e.g., hex color code).
        """

    @property
    @rpc_call
    def line_width(self) -> "int":
        """
        Gets the current line width of the ROI.

        Returns:
            int: The current line width in pixels.
        """

    @line_width.setter
    @rpc_call
    def line_width(self) -> "int":
        """
        Gets the current line width of the ROI.

        Returns:
            int: The current line width in pixels.
        """

    @rpc_call
    def get_coordinates(self, typed: "bool | None" = None) -> "dict | tuple":
        """
        Returns the coordinates of a rectangle's corners, rectangle center and dimensions.
        Supports returning them as either a dictionary with descriptive keys or a tuple of coordinates.

        Args:
            typed (bool | None): If True, returns coordinates as a dictionary with
                descriptive keys. If False, returns them as a tuple. Defaults to
                the value of `self.description`.

        Returns:
            dict | tuple: The rectangle's corner coordinates, rectangle center and dimensions, where the format
                depends on the `typed` parameter.
        """

    @rpc_call
    def get_data_from_image(
        self, image_item: "pg.ImageItem | None" = None, returnMappedCoords: "bool" = False, **kwargs
    ):
        """
        Wrapper around `pyqtgraph.ROI.getArrayRegion`.

        Args:
            image_item (pg.ImageItem or None): The ImageItem to sample. If None, auto-detects
                the first `ImageItem` in the same GraphicsScene as this ROI.
            returnMappedCoords (bool): If True, also returns the coordinate array generated by
                *getArrayRegion*.
            **kwargs: Additional keyword arguments passed to *getArrayRegion* or *affineSlice*,
                such as `axes`, `order`, `shape`, etc.

        Returns:
            ndarray: Pixel data inside the ROI, or (data, coords) if *returnMappedCoords* is True.
        """

    @rpc_call
    def set_position(self, x: "float", y: "float"):
        """
        Sets the position of the ROI.

        Args:
            x (float): The x-coordinate of the new position.
            y (float): The y-coordinate of the new position.
        """


class ResetButton(RPCBase):
    """A button that resets the scan queue."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class ResumeButton(RPCBase):
    """A button that continue scan queue."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class Ring(RPCBase):
    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """

    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def set_value(self, value: "int | float"):
        """
        Set the value for the ring widget

        Args:
            value(int | float): Value for the ring widget
        """

    @rpc_call
    def set_color(self, color: "str | tuple"):
        """
        Set the color for the ring widget

        Args:
            color(str | tuple): Color for the ring widget. Can be HEX code or tuple (R, G, B, A).
        """

    @rpc_call
    def set_background(self, color: "str | tuple"):
        """
        Set the background color for the ring widget

        Args:
            color(str | tuple): Background color for the ring widget. Can be HEX code or tuple (R, G, B, A).
        """

    @rpc_call
    def set_line_width(self, width: "int"):
        """
        Set the line width for the ring widget

        Args:
            width(int): Line width for the ring widget
        """

    @rpc_call
    def set_min_max_values(self, min_value: "int | float", max_value: "int | float"):
        """
        Set the min and max values for the ring widget.

        Args:
            min_value(int | float): Minimum value for the ring widget
            max_value(int | float): Maximum value for the ring widget
        """

    @rpc_call
    def set_start_angle(self, start_angle: "int"):
        """
        Set the start angle for the ring widget

        Args:
            start_angle(int): Start angle for the ring widget in degrees
        """

    @rpc_call
    def set_update(self, mode: "Literal['manual', 'scan', 'device']", device: "str" = None):
        """
        Set the update mode for the ring widget.
        Modes:
        - "manual": Manual update mode, the value is set by the user.
        - "scan": Update mode for the scan progress. The value is updated by the current scan progress.
        - "device": Update mode for the device readback. The value is updated by the device readback. Take into account that user has to set the device name and limits.

        Args:
            mode(str): Update mode for the ring widget. Can be "manual", "scan" or "device"
            device(str): Device name for the device readback mode, only used when mode is "device"
        """

    @rpc_call
    def reset_connection(self):
        """
        Reset the connections for the ring widget. Disconnect the current slot and endpoint.
        """


class RingProgressBar(RPCBase):
    """Show the progress of devices, scans or custom values in the form of ring progress bars."""

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """

    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @property
    @rpc_call
    def rings(self) -> "list[Ring]":
        """
        Returns a list of all rings in the progress bar.
        """

    @rpc_call
    def update_config(self, config: "RingProgressBarConfig | dict"):
        """
        Update the configuration of the widget.

        Args:
            config(SpiralProgressBarConfig|dict): Configuration to update.
        """

    @rpc_call
    def add_ring(self, **kwargs) -> "Ring":
        """
        Add a new progress bar.

        Args:
            **kwargs: Keyword arguments for the new progress bar.

        Returns:
            Ring: Ring object.
        """

    @rpc_call
    def remove_ring(self, index: "int"):
        """
        Remove a progress bar by index.

        Args:
            index(int): Index of the progress bar to remove.
        """

    @rpc_call
    def set_precision(self, precision: "int", bar_index: "int | None" = None):
        """
        Set the precision for the progress bars. If bar_index is not provide, the precision will be set for all progress bars.

        Args:
            precision(int): Precision for the progress bars.
            bar_index(int): Index of the progress bar to set the precision for. If provided, only a single precision can be set.
        """

    @rpc_call
    def set_min_max_values(
        self,
        min_values: "int | float | list[int | float]",
        max_values: "int | float | list[int | float]",
    ):
        """
        Set the minimum and maximum values for the progress bars.

        Args:
            min_values(int|float | list[float]): Minimum value(s) for the progress bars. If multiple progress bars are displayed, provide a list of minimum values for each progress bar.
            max_values(int|float | list[float]): Maximum value(s) for the progress bars. If multiple progress bars are displayed, provide a list of maximum values for each progress bar.
        """

    @rpc_call
    def set_number_of_bars(self, num_bars: "int"):
        """
        Set the number of progress bars to display.

        Args:
            num_bars(int): Number of progress bars to display.
        """

    @rpc_call
    def set_value(self, values: "int | list", ring_index: "int" = None):
        """
        Set the values for the progress bars.

        Args:
            values(int | tuple): Value(s) for the progress bars. If multiple progress bars are displayed, provide a tuple of values for each progress bar.
            ring_index(int): Index of the progress bar to set the value for. If provided, only a single value can be set.

        Examples:
            >>> SpiralProgressBar.set_value(50)
            >>> SpiralProgressBar.set_value([30, 40, 50]) # (outer, middle, inner)
            >>> SpiralProgressBar.set_value(60, bar_index=1) # Set the value for the middle progress bar.
        """

    @rpc_call
    def set_colors_from_map(self, colormap, color_format: "Literal['RGB', 'HEX']" = "RGB"):
        """
        Set the colors for the progress bars from a colormap.

        Args:
            colormap(str): Name of the colormap.
            color_format(Literal["RGB","HEX"]): Format of the returned colors ('RGB', 'HEX').
        """

    @rpc_call
    def set_colors_directly(
        self, colors: "list[str | tuple] | str | tuple", bar_index: "int" = None
    ):
        """
        Set the colors for the progress bars directly.

        Args:
            colors(list[str | tuple] | str | tuple): Color(s) for the progress bars. If multiple progress bars are displayed, provide a list of colors for each progress bar.
            bar_index(int): Index of the progress bar to set the color for. If provided, only a single color can be set.
        """

    @rpc_call
    def set_line_widths(self, widths: "int | list[int]", bar_index: "int" = None):
        """
        Set the line widths for the progress bars.

        Args:
            widths(int | list[int]): Line width(s) for the progress bars. If multiple progress bars are displayed, provide a list of line widths for each progress bar.
            bar_index(int): Index of the progress bar to set the line width for. If provided, only a single line width can be set.
        """

    @rpc_call
    def set_gap(self, gap: "int"):
        """
        Set the gap between the progress bars.

        Args:
            gap(int): Gap between the progress bars.
        """

    @rpc_call
    def set_diameter(self, diameter: "int"):
        """
        Set the diameter of the widget.

        Args:
            diameter(int): Diameter of the widget.
        """

    @rpc_call
    def reset_diameter(self):
        """
        Reset the fixed size of the widget.
        """

    @rpc_call
    def enable_auto_updates(self, enable: "bool" = True):
        """
        Enable or disable updates based on scan status. Overrides manual updates.
        The behaviour of the whole progress bar widget will be driven by the scan queue status.

        Args:
            enable(bool): True or False.

        Returns:
            bool: True if scan segment updates are enabled.
        """


class SBBMonitor(RPCBase):
    """A widget to display the SBB monitor website."""

    ...


class ScanControl(RPCBase):
    """Widget to submit new scans to the queue."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """


class ScanProgressBar(RPCBase):
    """Widget to display a progress bar that is hooked up to the scan progress of a scan."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class ScatterCurve(RPCBase):
    """Scatter curve item for the scatter waveform widget."""

    @property
    @rpc_call
    def color_map(self) -> "str":
        """
        The color map of the scatter curve.
        """


class ScatterWaveform(RPCBase):
    @property
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @enable_toolbar.setter
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @property
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @enable_side_panel.setter
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @property
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @enable_fps_monitor.setter
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @property
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @title.setter
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @property
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @x_label.setter
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @property
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @y_label.setter
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @property
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @x_limits.setter
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @property
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @y_limits.setter
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @property
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @x_grid.setter
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @property
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @y_grid.setter
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @property
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @inner_axes.setter
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @property
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @outer_axes.setter
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @property
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Lock aspect ratio of the plot widget.
        """

    @lock_aspect_ratio.setter
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Lock aspect ratio of the plot widget.
        """

    @property
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @auto_range_x.setter
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @property
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @auto_range_y.setter
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @property
    @rpc_call
    def x_log(self) -> "bool":
        """
        Set X-axis to log scale if True, linear if False.
        """

    @x_log.setter
    @rpc_call
    def x_log(self) -> "bool":
        """
        Set X-axis to log scale if True, linear if False.
        """

    @property
    @rpc_call
    def y_log(self) -> "bool":
        """
        Set Y-axis to log scale if True, linear if False.
        """

    @y_log.setter
    @rpc_call
    def y_log(self) -> "bool":
        """
        Set Y-axis to log scale if True, linear if False.
        """

    @property
    @rpc_call
    def legend_label_size(self) -> "int":
        """
        The font size of the legend font.
        """

    @legend_label_size.setter
    @rpc_call
    def legend_label_size(self) -> "int":
        """
        The font size of the legend font.
        """

    @property
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @minimal_crosshair_precision.setter
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """

    @property
    @rpc_call
    def main_curve(self) -> "ScatterCurve":
        """
        The main scatter curve item.
        """

    @property
    @rpc_call
    def color_map(self) -> "str":
        """
        The color map of the scatter waveform.
        """

    @color_map.setter
    @rpc_call
    def color_map(self) -> "str":
        """
        The color map of the scatter waveform.
        """

    @rpc_call
    def plot(
        self,
        x_name: "str",
        y_name: "str",
        z_name: "str",
        x_entry: "None | str" = None,
        y_entry: "None | str" = None,
        z_entry: "None | str" = None,
        color_map: "str | None" = "plasma",
        label: "str | None" = None,
        validate_bec: "bool" = True,
    ) -> "ScatterCurve":
        """
        Plot the data from the device signals.

        Args:
            x_name (str): The name of the x device signal.
            y_name (str): The name of the y device signal.
            z_name (str): The name of the z device signal.
            x_entry (None | str): The x entry of the device signal.
            y_entry (None | str): The y entry of the device signal.
            z_entry (None | str): The z entry of the device signal.
            color_map (str | None): The color map of the scatter waveform.
            label (str | None): The label of the curve.
            validate_bec (bool): Whether to validate the device signals with current BEC instance.

        Returns:
            ScatterCurve: The scatter curve object.
        """

    @rpc_call
    def update_with_scan_history(self, scan_index: "int" = None, scan_id: "str" = None):
        """
        Update the scan curves with the data from the scan storage.
        Provide only one of scan_id or scan_index.

        Args:
            scan_id(str, optional): ScanID of the scan to be updated. Defaults to None.
            scan_index(int, optional): Index of the scan to be updated. Defaults to None.
        """

    @rpc_call
    def clear_all(self):
        """
        Clear all the curves from the plot.
        """


class SignalComboBox(RPCBase):
    """Line edit widget for device input with autocomplete for device names."""

    @rpc_call
    def set_signal(self, signal: str):
        """
        Set the signal.

        Args:
            signal (str): signal name.
        """

    @rpc_call
    def set_device(self, device: str | None):
        """
        Set the device. If device is not valid, device will be set to None which happens

        Args:
            device(str): device name.
        """

    @property
    @rpc_call
    def signals(self) -> list[str]:
        """
        Get the list of device signals for the applied filters.

        Returns:
            list[str]: List of device signals.
        """


class SignalLabel(RPCBase):
    @property
    @rpc_call
    def custom_label(self) -> "str":
        """
        Use a cusom label rather than the signal name
        """

    @property
    @rpc_call
    def custom_units(self) -> "str":
        """
        Use a custom unit string
        """

    @custom_label.setter
    @rpc_call
    def custom_label(self) -> "str":
        """
        Use a cusom label rather than the signal name
        """

    @custom_units.setter
    @rpc_call
    def custom_units(self) -> "str":
        """
        Use a custom unit string
        """

    @property
    @rpc_call
    def decimal_places(self) -> "int":
        """
        Format to a given number of decimal_places. Set to 0 to disable.
        """

    @decimal_places.setter
    @rpc_call
    def decimal_places(self) -> "int":
        """
        Format to a given number of decimal_places. Set to 0 to disable.
        """

    @property
    @rpc_call
    def show_default_units(self) -> "bool":
        """
        Show default units obtained from the signal alongside it
        """

    @show_default_units.setter
    @rpc_call
    def show_default_units(self) -> "bool":
        """
        Show default units obtained from the signal alongside it
        """

    @property
    @rpc_call
    def show_select_button(self) -> "bool":
        """
        Show the button to select the signal to display
        """

    @show_select_button.setter
    @rpc_call
    def show_select_button(self) -> "bool":
        """
        Show the button to select the signal to display
        """

    @property
    @rpc_call
    def show_hinted_signals(self) -> "bool":
        """
        In the signal selection menu, show hinted signals
        """

    @show_hinted_signals.setter
    @rpc_call
    def show_hinted_signals(self) -> "bool":
        """
        In the signal selection menu, show hinted signals
        """

    @property
    @rpc_call
    def show_normal_signals(self) -> "bool":
        """
        In the signal selection menu, show normal signals
        """

    @show_normal_signals.setter
    @rpc_call
    def show_normal_signals(self) -> "bool":
        """
        In the signal selection menu, show normal signals
        """

    @property
    @rpc_call
    def show_config_signals(self) -> "bool":
        """
        In the signal selection menu, show config signals
        """

    @show_config_signals.setter
    @rpc_call
    def show_config_signals(self) -> "bool":
        """
        In the signal selection menu, show config signals
        """

    @property
    @rpc_call
    def display_array_data(self) -> "bool":
        """
        Displays the full data from array signals if set to True.
        """

    @display_array_data.setter
    @rpc_call
    def display_array_data(self) -> "bool":
        """
        Displays the full data from array signals if set to True.
        """

    @property
    @rpc_call
    def max_list_display_len(self) -> "int":
        """
        For small lists, the max length to display
        """

    @max_list_display_len.setter
    @rpc_call
    def max_list_display_len(self) -> "int":
        """
        For small lists, the max length to display
        """


class SignalLineEdit(RPCBase):
    """Line edit widget for device input with autocomplete for device names."""

    @property
    @rpc_call
    def _is_valid_input(self) -> bool:
        """
        Check if the current value is a valid device name.

        Returns:
            bool: True if the current value is a valid device name, False otherwise.
        """

    @rpc_call
    def set_signal(self, signal: str):
        """
        Set the signal.

        Args:
            signal (str): signal name.
        """

    @rpc_call
    def set_device(self, device: str | None):
        """
        Set the device. If device is not valid, device will be set to None which happens

        Args:
            device(str): device name.
        """

    @property
    @rpc_call
    def signals(self) -> list[str]:
        """
        Get the list of device signals for the applied filters.

        Returns:
            list[str]: List of device signals.
        """


class StopButton(RPCBase):
    """A button that stops the current scan."""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class TextBox(RPCBase):
    """A widget that displays text in plain and HTML format"""

    @rpc_call
    def set_plain_text(self, text: str) -> None:
        """
        Set the plain text of the widget.

        Args:
            text (str): The text to set.
        """

    @rpc_call
    def set_html_text(self, text: str) -> None:
        """
        Set the HTML text of the widget.

        Args:
            text (str): The text to set.
        """


class VSCodeEditor(RPCBase):
    """A widget to display the VSCode editor."""

    ...


class Waveform(RPCBase):
    """Widget for plotting waveforms."""

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @property
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @enable_toolbar.setter
    @rpc_call
    def enable_toolbar(self) -> "bool":
        """
        Show Toolbar.
        """

    @property
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @enable_side_panel.setter
    @rpc_call
    def enable_side_panel(self) -> "bool":
        """
        Show Side Panel
        """

    @property
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @enable_fps_monitor.setter
    @rpc_call
    def enable_fps_monitor(self) -> "bool":
        """
        Enable the FPS monitor.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @property
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @title.setter
    @rpc_call
    def title(self) -> "str":
        """
        Set title of the plot.
        """

    @property
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @x_label.setter
    @rpc_call
    def x_label(self) -> "str":
        """
        The set label for the x-axis.
        """

    @property
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @y_label.setter
    @rpc_call
    def y_label(self) -> "str":
        """
        The set label for the y-axis.
        """

    @property
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @x_limits.setter
    @rpc_call
    def x_limits(self) -> "QPointF":
        """
        Get the x limits of the plot.
        """

    @property
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @y_limits.setter
    @rpc_call
    def y_limits(self) -> "QPointF":
        """
        Get the y limits of the plot.
        """

    @property
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @x_grid.setter
    @rpc_call
    def x_grid(self) -> "bool":
        """
        Show grid on the x-axis.
        """

    @property
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @y_grid.setter
    @rpc_call
    def y_grid(self) -> "bool":
        """
        Show grid on the y-axis.
        """

    @property
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @inner_axes.setter
    @rpc_call
    def inner_axes(self) -> "bool":
        """
        Show inner axes of the plot widget.
        """

    @property
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @outer_axes.setter
    @rpc_call
    def outer_axes(self) -> "bool":
        """
        Show the outer axes of the plot widget.
        """

    @property
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Lock aspect ratio of the plot widget.
        """

    @lock_aspect_ratio.setter
    @rpc_call
    def lock_aspect_ratio(self) -> "bool":
        """
        Lock aspect ratio of the plot widget.
        """

    @property
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @auto_range_x.setter
    @rpc_call
    def auto_range_x(self) -> "bool":
        """
        Set auto range for the x-axis.
        """

    @property
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @auto_range_y.setter
    @rpc_call
    def auto_range_y(self) -> "bool":
        """
        Set auto range for the y-axis.
        """

    @rpc_call
    def auto_range(self, value: "bool" = True):
        """
        On demand apply autorange to the plot item based on the visible curves.

        Args:
            value(bool): If True, apply autorange to the visible curves.
        """

    @property
    @rpc_call
    def x_log(self) -> "bool":
        """
        Set X-axis to log scale if True, linear if False.
        """

    @x_log.setter
    @rpc_call
    def x_log(self) -> "bool":
        """
        Set X-axis to log scale if True, linear if False.
        """

    @property
    @rpc_call
    def y_log(self) -> "bool":
        """
        Set Y-axis to log scale if True, linear if False.
        """

    @y_log.setter
    @rpc_call
    def y_log(self) -> "bool":
        """
        Set Y-axis to log scale if True, linear if False.
        """

    @property
    @rpc_call
    def legend_label_size(self) -> "int":
        """
        The font size of the legend font.
        """

    @legend_label_size.setter
    @rpc_call
    def legend_label_size(self) -> "int":
        """
        The font size of the legend font.
        """

    @property
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @minimal_crosshair_precision.setter
    @rpc_call
    def minimal_crosshair_precision(self) -> "int":
        """
        Minimum decimal places for crosshair when dynamic precision is enabled.
        """

    @rpc_timeout(None)
    @rpc_call
    def screenshot(self, file_name: "str | None" = None):
        """
        Take a screenshot of the dock area and save it to a file.
        """

    @property
    @rpc_call
    def curves(self) -> "list[Curve]":
        """
        Get the curves of the plot widget as a list.

        Returns:
            list: List of curves.
        """

    @property
    @rpc_call
    def x_mode(self) -> "str":
        """
        None
        """

    @x_mode.setter
    @rpc_call
    def x_mode(self) -> "str":
        """
        None
        """

    @property
    @rpc_call
    def x_entry(self) -> "str | None":
        """
        The x signal name.
        """

    @x_entry.setter
    @rpc_call
    def x_entry(self) -> "str | None":
        """
        The x signal name.
        """

    @property
    @rpc_call
    def color_palette(self) -> "str":
        """
        The color palette of the figure widget.
        """

    @color_palette.setter
    @rpc_call
    def color_palette(self) -> "str":
        """
        The color palette of the figure widget.
        """

    @property
    @rpc_call
    def skip_large_dataset_warning(self) -> "bool":
        """
        Whether to skip the large dataset warning when fetching async data.
        """

    @skip_large_dataset_warning.setter
    @rpc_call
    def skip_large_dataset_warning(self) -> "bool":
        """
        Whether to skip the large dataset warning when fetching async data.
        """

    @property
    @rpc_call
    def skip_large_dataset_check(self) -> "bool":
        """
        Whether to skip the large dataset warning when fetching async data.
        """

    @skip_large_dataset_check.setter
    @rpc_call
    def skip_large_dataset_check(self) -> "bool":
        """
        Whether to skip the large dataset warning when fetching async data.
        """

    @property
    @rpc_call
    def max_dataset_size_mb(self) -> "float":
        """
        The maximum dataset size (in MB) permitted when fetching async data from history before prompting the user.
        """

    @max_dataset_size_mb.setter
    @rpc_call
    def max_dataset_size_mb(self) -> "float":
        """
        The maximum dataset size (in MB) permitted when fetching async data from history before prompting the user.
        """

    @rpc_call
    def plot(
        self,
        arg1: "list | np.ndarray | str | None" = None,
        y: "list | np.ndarray | None" = None,
        x: "list | np.ndarray | None" = None,
        x_name: "str | None" = None,
        y_name: "str | None" = None,
        x_entry: "str | None" = None,
        y_entry: "str | None" = None,
        color: "str | None" = None,
        label: "str | None" = None,
        dap: "str | None" = None,
        scan_id: "str | None" = None,
        scan_number: "int | None" = None,
        **kwargs,
    ) -> "Curve":
        """
        Plot a curve to the plot widget.

        Args:
            arg1(list | np.ndarray | str | None): First argument, which can be x data, y data, or y_name.
            y(list | np.ndarray): Custom y data to plot.
            x(list | np.ndarray): Custom y data to plot.
            x_name(str): Name of the x signal.
                - "auto": Use the best effort signal.
                - "timestamp": Use the timestamp signal.
                - "index": Use the index signal.
                - Custom signal name of a device from BEC.
            y_name(str): The name of the device for the y-axis.
            x_entry(str): The name of the entry for the x-axis.
            y_entry(str): The name of the entry for the y-axis.
            color(str): The color of the curve.
            label(str): The label of the curve.
            dap(str): The dap model to use for the curve, only available for sync devices.
            If not specified, none will be added.
            Use the same string as is the name of the LMFit model.
            scan_id(str):  Optional scan ID. When provided, the curve is treated as a **history** curve and
                the y‑data (and optional x‑data) are fetched from that historical scan. Such curves are
                never cleared by live‑scan resets.
            scan_number(int): Optional scan index. When provided, the curve is treated as a **history** curve and

        Returns:
            Curve: The curve object.
        """

    @rpc_call
    def add_dap_curve(
        self,
        device_label: "str",
        dap_name: "str",
        color: "str | None" = None,
        dap_oversample: "int" = 1,
        **kwargs,
    ) -> "Curve":
        """
        Create a new DAP curve referencing the existing device curve `device_label`,
        with the data processing model `dap_name`.

        Args:
            device_label(str): The label of the device curve to add DAP to.
            dap_name(str): The name of the DAP model to use.
            color(str): The color of the curve.
            dap_oversample(int): The oversampling factor for the DAP curve.
            **kwargs

        Returns:
            Curve: The new DAP curve.
        """

    @rpc_call
    def remove_curve(self, curve: "int | str"):
        """
        Remove a curve from the plot widget.

        Args:
            curve(int|str): The curve to remove. It Can be the order of the curve or the name of the curve.
        """

    @rpc_call
    def update_with_scan_history(self, scan_index: "int" = None, scan_id: "str" = None):
        """
        Update the scan curves with the data from the scan storage.
        If both arguments are provided, scan_id takes precedence and scan_index is ignored.

        Args:
            scan_id(str, optional): ScanID of the scan to be updated. Defaults to None.
            scan_index(int, optional): Index (scan number) of the scan to be updated. Defaults to None.
        """

    @rpc_call
    def get_dap_params(self) -> "dict[str, dict]":
        """
        Get the DAP parameters of all DAP curves.

        Returns:
            dict[str, dict]: DAP parameters of all DAP curves.
        """

    @rpc_call
    def get_dap_summary(self) -> "dict[str, dict]":
        """
        Get the DAP summary of all DAP curves.

        Returns:
            dict[str, dict]: DAP summary of all DAP curves.
        """

    @rpc_call
    def get_all_data(self, output: "Literal['dict', 'pandas']" = "dict") -> "dict":
        """
        Extract all curve data into a dictionary or a pandas DataFrame.

        Args:
            output (Literal["dict", "pandas"]): Format of the output data.

        Returns:
            dict | pd.DataFrame: Data of all curves in the specified format.
        """

    @rpc_call
    def get_curve(self, curve: "int | str") -> "Curve | None":
        """
        Get a curve from the plot widget.

        Args:
            curve(int|str): The curve to get. It Can be the order of the curve or the name of the curve.

        Return(Curve|None): The curve object if found, None otherwise.
        """

    @rpc_call
    def select_roi(self, region: "tuple[float, float]"):
        """
        Public method if you want the old `select_roi` style.
        """

    @rpc_call
    def clear_all(self):
        """
        Clear all curves from the plot widget.
        """


class WebConsole(RPCBase):
    """A simple widget to display a website"""

    @rpc_call
    def remove(self):
        """
        Cleanup the BECConnector
        """


class WebsiteWidget(RPCBase):
    """A simple widget to display a website"""

    @rpc_call
    def set_url(self, url: str) -> None:
        """
        Set the url of the website widget

        Args:
            url (str): The url to set
        """

    @rpc_call
    def get_url(self) -> str:
        """
        Get the current url of the website widget

        Returns:
            str: The current url
        """

    @rpc_call
    def reload(self):
        """
        Reload the website
        """

    @rpc_call
    def back(self):
        """
        Go back in the history
        """

    @rpc_call
    def forward(self):
        """
        Go forward in the history
        """
