"""Added branch fields to DispBase

Peek Plugin Database Migration Script

Revision ID: 4f6ed1047562
Revises: 361988cd327d
Create Date: 2019-05-11 15:05:14.096453

"""

# revision identifiers, used by Alembic.
revision = '4f6ed1047562'
down_revision = '361988cd327d'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('DispBase', sa.Column('branchId', sa.Integer(), nullable=True), schema='pl_diagram')
    op.add_column('DispBase', sa.Column('branchStage', sa.Integer(), nullable=True), schema='pl_diagram')
    op.add_column('DispBase', sa.Column('hashId', sa.String(), nullable=True), schema='pl_diagram')
    op.add_column('DispBase', sa.Column('replacesHashId', sa.String(), nullable=True), schema='pl_diagram')
    op.create_index('idx_Disp_branchId', 'DispBase', ['branchId'], unique=False, schema='pl_diagram')
    op.create_foreign_key('DispBase_branchId_fkey', 'DispBase', 'BranchIndex', ['branchId'], ['id'], source_schema='pl_diagram', referent_schema='pl_diagram', ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('DispBase_branchId_fkey', 'DispBase', schema='pl_diagram', type_='foreignkey')
    op.drop_index('idx_Disp_branchId', table_name='DispBase', schema='pl_diagram')
    op.drop_column('DispBase', 'replacesHashId', schema='pl_diagram')
    op.drop_column('DispBase', 'hashId', schema='pl_diagram')
    op.drop_column('DispBase', 'branchStage', schema='pl_diagram')
    op.drop_column('DispBase', 'branchId', schema='pl_diagram')
    # ### end Alembic commands ###