import {CommonModule} from "@angular/common";
import {NgModule} from "@angular/core";
// Import a small abstraction library to switch between nativescript and web
import {PeekModuleFactory} from "@synerty/peek-util-ns";
// Import the default route component
import {DiagramComponent} from "./diagram.component.ns";


// Define the root module for this plugin.
// This module is loaded by the lazy loader, what ever this defines is what is started.
// When it first loads, it will look up the routs and then select the component to load.
@NgModule({
    imports: [
        CommonModule,
        ...PeekModuleFactory.FormsModules,
    ],
    exports: [DiagramComponent],
    providers: [],
    declarations: [DiagramComponent]
})
export class PeekPluginDiagramModule {
}
