"""Radomes, Antennas and Receiver names tables and translation dicts for typos"""

translation_country = {
    "NA": "N/A",
    "": "N/A",
    "US": "USA",
    "UNITED STATES": "USA",
    "UNITED STATES OF AMERICA": "USA",
    "U.S.": "USA",
    "U.S.A": "USA",
    "U.S.A.": "USA",
    "UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN": "UK",
    "UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN IRELAND": "UK",
    "ENGLAND": "UK",
    "ANTIGUA & BARBUDA": "ANTIGUA",
    "ANTIGUA AND BARBUDA": "ANTIGUA",
    "I.R.IRAN": "IRAN",
    "DANMARK": "DENMARK",
    "MÉXICO": "MEXICO",
    "CZECH REPUBLIC": "CZECHIA",
    "REPUBLIC OF INDONESIA": "INDONESIA",
    "REPUBLIC OF MALDIVES": "MALDIVES",
    "REPUBLIC OF MOLDOVA": "MOLDOVA",
    "REPUBLIC OF NAURU": "NAURU",
    "REPUBLIC OF SINGAPORE": "SINGAPORE",
    "REPUBLIC OF SOUTH AFRICA": "SOUTH AFRICA",
    "REPUBLICA DOMINICANA": "DOMINICANA",
    "RUSSIAN FEDERATION": "RUSSIA",
    "UNITED ARAB EMIRATES": "UAE",
    "CA": "CANADA",
    "ANTARCTIC PENINSULA": "ANTARCTICA",
    "ANTARTIDA": "ANTARCTICA",
    "BRASIL": "BRAZIL",
    "CAPE VERDE": "CABO VERDE",
    "DOMINICAN REPUBLIC": "DOMINICANA",
    "BOSNIA AND HERZEGOVINA": "BOSNIA",
    "BRITISH VIRGIN ISLANDS": "VIRGIN ISL",
    "BRUNEI DARUSSALAM": "BRUNEI",
    "CAYMAN ISLANDS": "CAYMAN ISL",
    "COOK ISLANDS": "COOK ISL",
    "FALKLAND ISLANDS": "FALKLAND ISL",
    "FAROE ISLANDS": "FAROE ISL",
    "FRENCH GUIANA": "FR GUIANA",
    "FRENCH GUYANA": "FR GUYANA",
    "FRENCH POLYNESIA": "FR POLYNESIA",
    "FRENCH SOUTHERN TERRITORIES": "FR SOUTHERN",
    "NETHERLANDS ANTILLES": "ANTILLES",
    "MARSHALL ISLANDS": "MARSHALL ISL",
    "SAINT HELENA": "ST HELENA",
    "SAINT VINCENT AND THE GRENADINES": "ST VINCENT",
    "ST. LUCIA": "ST LUCIA",
    "THE BAHAMAS": "BAHAMAS",
    "TRINIDAD AND TOBAGO": "TRINIDAD",
    "TURKS AND CAICOS ISLANDS": "TURKS ISL",
    "VIET NAM": "VIETNAM",
    "VIRGIN ISLANDS": "VIRGIN ISL",
    "US VIRGIN ISLANDS": "VIRGIN ISL",
    "WALLIS AND FUTUNA": "WALLIS",
    "WEST ANTARCTICA": "ANTARCTICA",
    "W ANTARCTICA": "ANTARCTICA",
}

translation_rec = {
    "3S NAVIGATION R100-40T": "3SNAV R100-40T 4",
    "LEICA GRX1200 PRO": "LEICA GRX1200PRO",
    "LEICA GRX1200 +GNSS": "LEICA GRX1200+GNSS",
    "LEICA GRX1200 GNSS": "LEICA GRX1200+GNSS",
    "LEICA GRX1200+ GNSS": "LEICA GRX1200+GNSS",
    "LEICA GRX1200GG PRO": "LEICA GRX1200GGPRO",
    "GRX1200 GG PRO": "LEICA GRX1200GGPRO",
    "ASHTECH UZ_12": "ASHTECH UZ-12",
    "ASHTECH Z-12": "ASHTECH Z-XII3",
    "ASHTECH MICROZ": "ASHTECH UZ-12",
    "SEPTENTRIO POLARX5": "SEPT POLARX5",
    "TOPCON NET-G3A": "TPS NET-G3A",
    "TOPCON NET-G5": "TPS NET-G5",
    "TOPCON NET-G3": "TPS NETG3",
    "TOPCON NETG3": "TPS NETG3",
    "TRIMBLE 4000 SSE": "TRIMBLE 4000SSE",
    "TRIMBLE 4000 SSI": "TRIMBLE 4000SSI",
    "E_GGD": "JPS E_GGD",
    "NOVATEL EURO4": "NOV EURO4-1.00-222",
}

translation_ant = {
    "AERAT1675-120": "AERAT1675_120",
    "AERAT2775-42": "AERAT2775_42",
    "LEIAR25.3": "LEIAR25.R3",
    "JAV_GRANT-G3T+G": "JAV_GRANT-G3T",
    "TPSPG_F1+GP": "TPSPG_A1+GP",
}

translation_rad = {
    "": "NONE",  # this is done after radome2 field check
    "N/A": "NONE",
    " NONE": "NONE",
    " NON": "NONE",
}

atx_rad_tbl = [
    "ARFC",
    "ARFS",
    "CHCD",
    "CONE",
    "DUTD",
    "HITS",
    "HITZ",
    "HXCG",
    "HXCS",
    "JAVC",
    "JAVD",
    "JVDM",
    "JVGR",
    "JVSD",
    "LEIC",
    "LEIM",
    "LEIS",
    "LEIT",
    "MMAC",
    "NONE",
    "NOVC",
    "NOVS",
    "OLGA",
    "PFAN",
    "RADM",
    "SCIS",
    "SCIT",
    "SNOW",
    "SPKE",
    "STHC",
    "TCWD",
    "TPSD",
    "TPSH",
    "TZGD",
    "UNAV",
    "GSI4",
    "UNKN",
    "DOME",
    "EMRA",
    "AUST",
    "JPLA",
    "ENCL",
    "CAFG",  # non-atx
    "SCPL",
    "CNTS",
    "STXG",
    "OSOD",
    "BEVA",
]  # non-atx


atx_ant_tbl = (
    [
        "3S-02-TSADM",
        "3S-02-TSATE",
        "ACC123CGNSSA_XN",
        "ACCG8ANT_52A4TC",
        "ACC_G5ANT_52AT1",
        "AERAT1675_120",
        "AERAT2775_42",
        "AERAT2775_43",
        "AOAD/M_B",
        "AOAD/M_T",
        "AOAD/M_TA_NGS",
        "APSAPS-3",
        "ARFAS13DFS",
        "ARFAS1FS",
        "ASH110454",
        "ASH111661",
        "ASH700228A",
        "ASH700228A+EX",
        "ASH700228B",
        "ASH700228C",
        "ASH700228D",
        "ASH700228E",
        "ASH700699.L1",
        "ASH700700.A",
        "ASH700700.B",
        "ASH700700.C",
        "ASH700718A",
        "ASH700718B",
        "ASH700829.2",
        "ASH700829.3",
        "ASH700829.A",
        "ASH700829.A1",
        "ASH700936A_M",
        "ASH700936B_M",
        "ASH700936C_M",
        "ASH700936D_M",
        "ASH700936E",
        "ASH700936E_C",
        "ASH700936F_C",
        "ASH701008.01B",
        "ASH701023.A",
        "ASH701073.1",
        "ASH701073.3",
        "ASH701933A_M",
        "ASH701933B_M",
        "ASH701933C_M",
        "ASH701941.1",
        "ASH701941.2",
        "ASH701941.A",
        "ASH701941.B",
        "ASH701945B_M",
        "ASH701945C_M",
        "ASH701945D_M",
        "ASH701945E_M",
        "ASH701945G_M",
        "ASH701946.2",
        "ASH701946.3",
        "ASH701975.01A",
        "ASH701975.01AGP",
        "CHAPS9017",
        "CHCA220GR",
        "CHCC220GR",
        "CHCC220GR2",
        "CHCI80",
        "CHCX90D-OPUS",
        "CHCX91+S",
        "CHCX91B",
        "GMXZENITH10",
        "GMXZENITH15",
        "GMXZENITH20",
        "GMXZENITH25",
        "GMXZENITH25PRO",
        "GMXZENITH35",
        "GMXZENITH40",
        "HEMA42",
        "HEMA52_WB",
        "HITAT35101CP",
        "HITAT35101CR",
        "HITAT35101H",
        "HITAT45101CP",
        "HITAT45101CR",
        "HXCCG7601A",
        "HXCCG7602A",
        "HXCCGX601A",
        "HXCCSX601A",
        "HXCGG486A",
        "HXCGS488A",
        "IGAIG8",
        "ITT3750323",
        "JAVGRANT_G5T",
        "JAVGRANT_G5T+GP",
        "JAVRINGANT_DM",
        "JAVRINGANT_G5T",
        "JAVTRIUMPH_1M",
        "JAVTRIUMPH_1MR",
        "JAVTRIUMPH_2A",
        "JAVTRIUMPH_2A+G",
        "JAVTRIUMPH_2A+P",
        "JAVTRIUMPH_LSA",
        "JAV_GRANT-G3T",
        "JAV_RINGANT_G3T",
        "JAV_TRIUMPH-1",
        "JAV_TRIUMPH-1R",
        "JNSCHOKERING_DM",
        "JNSCR_C146-22-1",
        "JNSMARANT_GGD",
        "JPLD/M_R",
        "JPLD/M_RA_SOP",
        "JPSLEGANT_E",
        "JPSODYSSEY_I",
        "JPSREGANT_DD_E",
        "JPSREGANT_DD_E1",
        "JPSREGANT_DD_E2",
        "JPSREGANT_SD_E",
        "JPSREGANT_SD_E1",
        "JPSREGANT_SD_E2",
        "LEIAR10",
        "LEIAR20",
        "LEIAR25",
        "LEIAR25.R3",
        "LEIAR25.R4",
        "LEIAS05",
        "LEIAS10",
        "LEIAT202+GP",
        "LEIAT202-GP",
        "LEIAT302+GP",
        "LEIAT302-GP",
        "LEIAT303",
        "LEIAT502",
        "LEIAT503",
        "LEIAT504",
        "LEIAT504GG",
        "LEIATX1230",
        "LEIATX1230+GNSS",
        "LEIATX1230GG",
        "LEIAX1202",
        "LEIAX1202A",
        "LEIAX1202GG",
        "LEIAX1203+GNSS",
        "LEICGA60",
        "LEIGG02PLUS",
        "LEIGG03",
        "LEIGG04",
        "LEIGG04PLUS",
        "LEIGS08",
        "LEIGS08PLUS",
        "LEIGS09",
        "LEIGS12",
        "LEIGS14",
        "LEIGS15",
        "LEIGS15.R2",
        "LEIGS16",
        "LEIGS18",
        "LEIICG60",
        "LEIICG70",
        "LEIMNA950GG",
        "LEISR299_INT",
        "LEISR399_INT",
        "LEISR399_INTA",
        "MAC4647942",
        "MAG111406",
        "MPLL1/L2_SURV",
        "MPL_WAAS_2224NW",
        "MPL_WAAS_2225NW",
        "MVECR152GNSSA",
        "MVEGA152GNSSA",
        "NAVAN2004T",
        "NAVAN2008T",
        "NAV_ANT3001BR",
        "NAX3G+C",
        "NOV501",
        "NOV501+CR",
        "NOV502",
        "NOV502+CR",
        "NOV503+CR",
        "NOV531",
        "NOV531+CR",
        "NOV533",
        "NOV533+CR",
        "NOV600",
        "NOV702",
        "NOV702GG",
        "NOV702_2.02",
        "NOV702_3.00",
        "NOV703GGG.R2",
        "NOV750.R4",
        "NOV750.R5",
        "NOV850",
        "NOV_WAAS_600",
        "RNG80971.00",
        "SEN67157596+CR",
        "SEPALTUS_NR3",
        "SEPCHOKE_B3E6",
        "SEPCHOKE_MC",
        "SEPPOLANT_X_MF",
        "SJTTL111",
        "SOK502",
        "SOK600",
        "SOK702",
        "SOKGCX2",
        "SOKGCX3",
        "SOKGRX2",
        "SOKGSX2",
        "SOKSA500",
        "SOK_GSR2700ISX",
        "SOK_RADIAN_IS",
        "SPP571212238+GP",
        "SPP571908273+CR",
        "SPP68410_10",
        "SPP91564_1",
        "SPP91564_2",
        "STHCR3-G3",
        "STHS82_7224V3.0",
        "STHS86_7224V3.1",
        "STXS10SX017A",
        "STXS800",
        "STXS800A",
        "STXS8PX003A",
        "STXS900",
        "STXS9I",
        "STXS9PX001A",
        "STXS9SA7224V3.0",
        "THA800961+REC",
        "THA800961+RTK",
        "THA800961RECUHF",
        "THA800961RTKUHF",
        "TIAPENG2100B",
        "TIAPENG2100R",
        "TIAPENG3100R1",
        "TIAPENG3100R2",
        "TOP700779A",
        "TOP72110",
        "TPSCR.G3",
        "TPSCR.G5",
        "TPSCR.G5C",
        "TPSCR3_GGD",
        "TPSCR4",
        "TPSG3_A1",
        "TPSG5_A1",
        "TPSGR3",
        "TPSGR5",
        "TPSHIPER_GD",
        "TPSHIPER_GGD",
        "TPSHIPER_HR",
        "TPSHIPER_HR+PS",
        "TPSHIPER_II",
        "TPSHIPER_II+10",
        "TPSHIPER_LITE",
        "TPSHIPER_PLUS",
        "TPSHIPER_SR",
        "TPSHIPER_VR",
        "TPSLEGANT2",
        "TPSLEGANT3_UHF",
        "TPSLEGANT_G",
        "TPSODYSSEY_I",
        "TPSPG_A1",
        "TPSPG_A1+GP",
        "TPSPG_A1_6+GP",
        "TPSPG_S1",
        "TPSPN.A5",
        "TRM105000.10",
        "TRM115000.00",
        "TRM115000.10",
        "TRM14177.00",
        "TRM14532.00",
        "TRM14532.10",
        "TRM159800.00",
        "TRM159900.00",
        "TRM22020.00+GP",
        "TRM22020.00-GP",
        "TRM23903.00",
        "TRM27947.00+GP",
        "TRM27947.00-GP",
        "TRM29659.00",
        "TRM33429.00+GP",
        "TRM33429.00-GP",
        "TRM33429.20+GP",
        "TRM36569.00+GP",
        "TRM39105.00",
        "TRM41249.00",
        "TRM41249USCG",
        "TRM4800",
        "TRM55970.00",
        "TRM55971.00",
        "TRM57970.00",
        "TRM57971.00",
        "TRM5800",
        "TRM59800.00",
        "TRM59800.00C",
        "TRM59800.80",
        "TRM59900.00",
        "TRMR10",
        "TRMR10-2",
        "TRMR2",
        "TRMR4-2",
        "TRMR4-3",
        "TRMR6",
        "TRMR6-2",
        "TRMR6-3",
        "TRMR6-4",
        "TRMR8-4",
        "TRMR8S",
        "TRMR8_GNSS",
        "TRMR8_GNSS3",
        "TRMSPS985",
        "TRMSPS986",
        "TRM_R6",
        "TRM_R8",
        "TWIVP6000",
        "TWIVP6050_CONE",
    ]
    + [
        "TSA-100",
        "MP-1372FW+REGP",
        "TRM59800.99",
        "TRM5797100.00",
        "TWIVC6150",
        "TRM115000.00+S",
        "TRM26738.00",
        "TPSCR.3G",
        "CNTAT350",
        "AOAD/M_T_RFI_T",
        "TPSPG_A1+M",
        "ASH701975.02A",
        "STXSA1500",
        "SPP135000.00",
        "LEAT504",
        "ACC72CGNSSA",
        "AERAT1675-7M",
        "ASH700936E_M",
        "TRM27256.00",
        "TRM29659",
        "LEIAR24.R4",
        "TRM77971.00",
        "TRM57971",
        "3S-02-1AERO+CR",
        "ASH701945H_M",
    ]
    + ["ADVNULLANTENNA", "NULLANTENNA", "GPPNULLANTENNA"]
)


igs_rec_tbl = [
    "3SNAV GNSS-300",
    "3SNAV GNSS-300T",
    "3SNAV R100 OLD",
    "3SNAV R101 OLD",
    "3SNAV R100-30",
    "3SNAV R100-30T 2",
    "3SNAV R100-30T 12",
    "3SNAV R100-40",
    "3SNAV R100-40T 4",
    "3SNAV R100-40T 12",
    "ALERTGEO RESOLUTE",
    "ALTUS APS-3",
    "ALTUS APS-3L",
    "ALTUS APS-GEOPOD",
    "ALTUS APS-NR2",
    "ASHTECH 3DF-XXIV",
    "ASHTECH 802147_A",
    "ASHTECH D-XII",
    "ASHTECH G-XII",
    "ASHTECH GG24C",
    "ASHTECH L-XII",
    "ASHTECH LCS-XII",
    "ASHTECH LM-XII3",
    "ASHTECH M-XII",
    "ASHTECH MS-XII",
    "ASHTECH P-XII3",
    "ASHTECH PF500",
    "ASHTECH PF800",
    "ASHTECH RANGER",
    "ASHTECH S-XII",
    "ASHTECH SUPER-CA",
    "ASHTECH UZ-12",
    "ASHTECH Z-X",
    "ASHTECH Z-XII3",
    "ASHTECH Z-XII3GETT",
    "ASHTECH Z-XII3T",
    "ASHTECH Z18",
    "CHAMPION PRO",
    "CHAMPION QB1",
    "CHAMPION WR1",
    "CHC B20",
    "CHC I80",
    "CHC LT500H",
    "CHC LT500N",
    "CHC LT500T",
    "CHC LT500U",
    "CHC N71",
    "CHC N72",
    "CHC P5E",
    "CHC X20+",
    "CHC X20I+DGNSS",
    "CHC X20I+RTK",
    "CHC X360",
    "CHC X90+",
    "CHC X900+",
    "CHC X900+S",
    "CHC X900B",
    "CHC X900R",
    "CHC X90D-OPUS",
    "CHC X91+",
    "CHC X91+S",
    "CHC X91B",
    "CHC X91R",
    "COMNAV M300 PRO",
    "COMNAV M300 MINI",
    "COMNAV T30",
    "COMNAV T300",
    "COMNAV T300+",
    "EMLID REACH RS2",
    "FOIF A30",
    "FOIF A90 GNSS",
    "GEOMAX ZENITH10",
    "GEOMAX ZENITH15",
    "GEOMAX ZENITH16",
    "GEOMAX ZENITH20",
    "GEOMAX ZENITH25",
    "GEOMAX ZENITH25PRO",
    "GEOMAX ZENITH35",
    "GEOMAX ZENITH40",
    "GINTEC CYF90",
    "HEMISPHERE S631",
    "IFEN NX_NTR_303_D",
    "IFEN NX_NTR_500_D",
    "IFEN NX_NTR_600_D",
    "IFEN SX_NSR_RT_200",
    "IFEN SX_NSR_RT_300",
    "IFEN SX_NSR_RT_400",
    "IFEN SX_NSR_RT_401",
    "IFEN SX_NSR_RT_402",
    "IFEN SX_NSR_RT_700",
    "IFEN SX_NSR_RT_800",
    "IGAGE IG8",
    "ITT 3750300",
    "JAVAD DUO_G2",
    "JAVAD DUO_G2 DELTA",
    "JAVAD DUO_G2 SIGMA",
    "JAVAD DUO_G2D",
    "JAVAD DUO_G2D DELTA",
    "JAVAD DUO_G2D SIGMA",
    "JAVAD DUO_G3D",
    "JAVAD DUO_G3D DELTA",
    "JAVAD DUO_G3D SIGMA",
    "JAVAD GISMORE",
    "JAVAD OMEGA",
    "JAVAD QUA_G3D",
    "JAVAD QUA_G3D DELTA",
    "JAVAD QUA_G3D SIGMA",
    "JAVAD TR_3N",
    "JAVAD TR_3N ALPHA",
    "JAVAD TR_3N ALPHA2",
    "JAVAD TR_G2",
    "JAVAD TR_G2 ALPHA2",
    "JAVAD TR_G2T",
    "JAVAD TR_G2T ALPHA",
    "JAVAD TR_G2TH",
    "JAVAD TR_G2TH ALPHA",
    "JAVAD TR_G2TH ALPHA2",
    "JAVAD TR_G3",
    "JAVAD TR_G3 ALPHA",
    "JAVAD TR_G3H",
    "JAVAD TR_G3H ALPHA",
    "JAVAD TR_G3H ALPHA2",
    "JAVAD TR_G3T",
    "JAVAD TR_G3T ALPHA",
    "JAVAD TR_G3TH",
    "JAVAD TR_G3TH ALPHA",
    "JAVAD TR_G3TH ALPHA2",
    "JAVAD TR_LS",
    "JAVAD TR_VS",
    "JAVAD TRE_3",
    "JAVAD TRE_3 DELTA",
    "JAVAD TRE_3 SIGMA",
    "JAVAD TRE_3L SIGMA",
    "JAVAD TRE_3L",
    "JAVAD TRE_3L DELTA",
    "JAVAD TRE_3N",
    "JAVAD TRE_3N DELTA",
    "JAVAD TRE_3N SIGMA",
    "JAVAD TRE_DUO",
    "JAVAD TRE_DUO DELTA",
    "JAVAD TRE_DUO SIGMA",
    "JAVAD TRE_G2T",
    "JAVAD TRE_G2T DELTA",
    "JAVAD TRE_G2T SIGMA",
    "JAVAD TRE_G2TH",
    "JAVAD TRE_G2TH DELTA",
    "JAVAD TRE_G2TH SIGMA",
    "JAVAD TRE_G3T",
    "JAVAD TRE_G3T DELTA",
    "JAVAD TRE_G3T SIGMA",
    "JAVAD TRE_G3TAJ",
    "JAVAD TRE_G3TAJ DELT",
    "JAVAD TRE_G3TAJ SIGM",
    "JAVAD TRE_G3TH",
    "JAVAD TRE_G3TH DELTA",
    "JAVAD TRE_G3TH SIGMA",
    "JAVAD TRE_QUA",
    "JAVAD TRE_QUA DELTA",
    "JAVAD TRE_QUA SIGMA",
    "JAVAD TRIUMPH_1M",
    "JAVAD TRIUMPH1",
    "JAVAD TRIUMPH2",
    "JAVAD TRIUMPH3",
    "JAVAD TRIUMPH4",
    "JPS E_GGD",
    "JPS EGGDT",
    "JPS EUROCARD",
    "JPS LEGACY",
    "JPS ODYSSEY",
    "JPS REGENCY",
    "LEICA ATX1230",
    "LEICA ATX1230+GNSS",
    "LEICA CRS1000",
    "LEICA FLX100",
    "LEICA GG02PLUS",
    "LEICA GG03",
    "LEICA GG04",
    "LEICA GG04PLUS",
    "LEICA GM30",
    "LEICA GMX901",
    "LEICA GMX902",
    "LEICA GMX910",
    "LEICA GMX902GG",
    "LEICA GR10",
    "LEICA GR25",
    "LEICA GR30",
    "LEICA GR50",
    "LEICA GRX1200",
    "LEICA GRX1200+",
    "LEICA GRX1200+GNSS",
    "LEICA GRX1200GGPRO",
    "LEICA GRX1200LITE",
    "LEICA GRX1200PRO",
    "LEICA GS07",
    "LEICA GS08",
    "LEICA GS08PLUS",
    "LEICA GS09",
    "LEICA GS10",
    "LEICA GS12",
    "LEICA GS14",
    "LEICA GS15",
    "LEICA GS16",
    "LEICA GS18",
    "LEICA GS25",
    "LEICA GX1210",
    "LEICA GX1210+",
    "LEICA GX1220",
    "LEICA GX1220+",
    "LEICA GX1220+GNSS",
    "LEICA GX1230",
    "LEICA GX1230+",
    "LEICA GX1230+GNSS",
    "LEICA GX1230GG",
    "LEICA ICG30",
    "LEICA ICG60",
    "LEICA ICG70",
    "LEICA ICG81",
    "LEICA ICG82",
    "LEICA MC1000",
    "LEICA MC500",
    "LEICA MNA950GG",
    "LEICA MNS1250GG",
    "LEICA RS500",
    "LEICA SR260",
    "LEICA SR261",
    "LEICA SR299",
    "LEICA SR299E",
    "LEICA SR399",
    "LEICA SR399E",
    "LEICA SR510",
    "LEICA SR520",
    "LEICA SR530",
    "LEICA SR9400",
    "LEICA SR9500",
    "LEICA SR9600",
    "MAGELLAN PM-500",
    "MINIMAC 2816",
    "MINIMAC 2816AT",
    "NAVCOM NCT-2000D",
    "NAVCOM NCT-2030M",
    "NAVCOM RT-3010S",
    "NAVCOM RT-3020M",
    "NAVCOM RT-3020S",
    "NAVCOM SF-2000",
    "NAVCOM SF-2040G",
    "NAVCOM SF-2050G",
    "NAVCOM SF-2050M",
    "NAVCOM SF-2050R",
    "NOV 15A",
    "NOV EURO4-1.00-222",
    "NOV MILLEN-RT2",
    "NOV MILLEN-RT2OS",
    "NOV MILLEN-STD",
    "NOV MILLEN-STDW",
    "NOV OEM4-G2",
    "NOV OEM6",
    "NOV OEM7",
    "NOV OEMV1",
    "NOV OEMV1G",
    "NOV OEMV2",
    "NOV OEMV3",
    "NOV OEMV3-RT2",
    "NOV WAASGII",
    "PANDA PD318",
    "PANDA PD51A",
    "PANDA PD9",
    "PREXISO G4",
    "PREXISO G5",
    "QIANXUN ISTATION18",
    "RAYMAND IRNET-G3B",
    "RAYMAND IRO-G3B",
    "AOA BENCHMARK ACT",
    "AOA ICS-4000Z",
    "AOA ICS-4000Z ACT",
    "AOA RASCAL-12",
    "AOA RASCAL-8",
    "AOA SNR-12 ACT",
    "AOA SNR-8000 ACT",
    "AOA SNR-8100 ACT",
    "AOA TTR-12",
    "AOA TTR-4P",
    "ROGUE SNR-12",
    "ROGUE SNR-12 RM",
    "ROGUE SNR-8",
    "ROGUE SNR-800",
    "ROGUE SNR-8000",
    "ROGUE SNR-8100",
    "ROGUE SNR-8A",
    "ROGUE SNR-8C",
    "RNG FASA+",
    "RNG FAZA2",
    "RNG SMAXGEO",
    "SANDING T3 GNSS",
    "SANDING T66PRO GNSS",
    "SEPT ALTUS NR3",
    "SEPT ASTERX SB",
    "SEPT ASTERX-M",
    "SEPT ASTERX-U",
    "SEPT ASTERX1",
    "SEPT ASTERX2",
    "SEPT ASTERX2E",
    "SEPT ASTERX2EH",
    "SEPT ASTERX2EL",
    "SEPT ASTERX3",
    "SEPT ASTERX4",
    "SEPT POLARX2",
    "SEPT POLARX2C",
    "SEPT POLARX2E",
    "SEPT POLARX3",
    "SEPT POLARX3E",
    "SEPT POLARX3EG",
    "SEPT POLARX3ETR",
    "SEPT POLARX3G",
    "SEPT POLARX3TR",
    "SEPT POLARX4",
    "SEPT POLARX4TR",
    "SEPT POLARX5",
    "SEPT POLARX5E",
    "SEPT POLARX5S",
    "SEPT POLARX5TR",
    "SEPT POLARXS",
    "SETTOP M1-V1",
    "SOK GCX3",
    "SOK GSR2600",
    "SOK GSR2700 RS",
    "SOK GSR2700 RSX",
    "SOK RADIAN",
    "SOK RADIAN_IS",
    "SOUTH 660N GNSS",
    "SOUTH G1 GNSS",
    "SOUTH G1PLUS GNSS",
    "SOUTH G6 GNSS",
    "SOUTH NET-S8",
    "SOUTH NET-S8+",
    "SOUTH NET-S9",
    "SOUTH S82-2013 GNSS",
    "SOUTH S82T GNSS",
    "SOUTH S82V GNSS",
    "SOUTH S82V2 GNSS",
    "SOUTH S86 GNSS",
    "SOUTH S86-2013 GNSS",
    "SOUTH S86T GNSS",
    "SPECTRA SP60",
    "SPECTRA SP80",
    "SPECTRA SP85",
    "SPECTRA SP90M",
    "SPP 68410_10",
    "SPP GEODIMETER-L1",
    "SPP GEOTRACER100",
    "SPP GEOTRACER3220",
    "SPP GEOTRACER3320",
    "SPP PROMARK700",
    "STONEX S10",
    "STONEX S700A",
    "STONEX S8+ GNSS",
    "STONEX S800",
    "STONEX S800A",
    "STONEX S850A",
    "STONEX S900",
    "STONEX S900A",
    "STONEX S900A NEW",
    "STONEX S900T",
    "STONEX S980",
    "STONEX S980A",
    "STONEX S990A",
    "STONEX S9I",
    "STONEX S9II GNSS",
    "STONEX S9III+ GNSS",
    "STONEX SC200",
    "STONEX SC2000",
    "STONEX SC2200",
    "STONEX SC600",
    "STONEX SC600A",
    "TI4100",
    "TIASAHI PENG2100B",
    "TIASAHI PENG2100R",
    "TIASAHI PENG3100-R1",
    "TIASAHI PENG3100-R2",
    "TIASAHI PENG6J2",
    "TIASAHI PENSMT888-3G",
    "TOPCON GP-DX1",
    "TOPCON GP-R1",
    "TOPCON GP-R1D",
    "TOPCON GP-R1DP",
    "TOPCON GP-R1DY",
    "TOPCON GP-S1",
    "TOPCON GP-SX1",
    "TOPCON TT4000SSI",
    "TOPCON TURBO-SII",
    "TPS E_GGD",
    "TPS EUROCARD",
    "TPS GB-1000",
    "TPS GB-500",
    "TPS GR3",
    "TPS GR5",
    "TPS HIPER_GD",
    "TPS HIPER_GGD",
    "TPS HIPER_HR",
    "TPS HIPER_VR",
    "TPS HIPER_LITE",
    "TPS HIPER_PLUS",
    "TPS LEGACY",
    "TPS NET-G3A",
    "TPS NET-G5",
    "TPS NETG3",
    "TPS ODYSSEY_E",
    "TPS ODYSSEY_I",
    "TRIMBLE 4000S",
    "TRIMBLE 4000SE",
    "TRIMBLE 4000SL",
    "TRIMBLE 4000SLD",
    "TRIMBLE 4000SSE",
    "TRIMBLE 4000SSI",
    "TRIMBLE 4000SSI-SS",
    "TRIMBLE 4000SST",
    "TRIMBLE 4000ST",
    "TRIMBLE 4000ST S",
    "TRIMBLE 4000SX",
    "TRIMBLE 4400",
    "TRIMBLE 4600",
    "TRIMBLE 4700",
    "TRIMBLE 4800",
    "TRIMBLE 5700",
    "TRIMBLE 5800",
    "TRIMBLE 7400MSI",
    "TRIMBLE ALLOY",
    "TRIMBLE GEODESIST P",
    "TRIMBLE MS750",
    "TRIMBLE NETR3",
    "TRIMBLE NETR5",
    "TRIMBLE NETR8",
    "TRIMBLE NETR9",
    "TRIMBLE NETRS",
    "TRIMBLE R10",
    "TRIMBLE R10-2",
    "TRIMBLE R12",
    "TRIMBLE R12I",
    "TRIMBLE R2",
    "TRIMBLE R4",
    "TRIMBLE R4-2",
    "TRIMBLE R4-3",
    "TRIMBLE R5",
    "TRIMBLE R6",
    "TRIMBLE R6-2",
    "TRIMBLE R6-3",
    "TRIMBLE R6-4",
    "TRIMBLE R7",
    "TRIMBLE R7 GNSS",
    "TRIMBLE R8",
    "TRIMBLE R8 GNSS",
    "TRIMBLE R8 GNSS3",
    "TRIMBLE R8-4",
    "TRIMBLE R8S",
    "TRIMBLE R9S",
    "TRIMBLE SPS852",
    "TRIMBLE SPS855",
    "TRIMBLE SPS985",
    "TRIMBLE SPS986",
    "JPL BLACKJACK",
    "ASHTECH Z-MAX",
    "TRIMBLE SPS851",
]  # extra non-igs
