import unittest
from gnssanalysis.gn_io.trop import read_tro_solution_bytes

GINAN_TROP_FILE = """
%=TRO 2.00 GAA 2024:185:11916.2 IGN 2024:185:11902 2024:185:11902 P  MIX

+FILE/REFERENCE
 DESCRIPTION        Geoscience Australia
 OUTPUT             Solution parameters
 SOFTWARE           Ginan PEA Version 3.0
 INPUT              RINEX
-FILE/REFERENCE

+TROP/SOLUTION
*STATION__ ____EPOCH_____   TGEWET   STDDEV   TGNWET   STDDEV   TROTOT   STDDEV   TROWET   STDDEV
 DARW      2024:185:11922     0.15    29.99     0.02    30.00  2443.98   299.88   165.57   299.88
 MAW1      2024:185:11922     0.05    30.00    -0.09    30.00  2252.43   299.96    10.66   299.96
 STR2      2024:185:11922    -0.05    30.00     0.02    29.99  2206.14   299.81   100.30   299.81
 DARW      2024:185:11942     1.13    29.96    -0.06    30.00  2456.94   299.56   176.28   299.56
 MAW1      2024:185:11942    -0.17    29.96    -1.31    29.86  2239.85   297.80    -2.77   297.80
 STR2      2024:185:11942    -0.35    30.00     0.02    29.93  2207.80   298.43    95.24   298.43
 DARW      2024:185:11962     0.57    29.90     0.12    29.99  2448.28   299.05   168.88   299.05
 MAW1      2024:185:11962    -0.15    29.90    -2.08    29.60  2235.75   293.17    -4.30   293.17
 STR2      2024:185:11962    -0.09    29.99    -1.11    29.79  2195.63   295.48    85.57   295.48
 DARW      2024:185:11982     1.10    29.88     0.14    29.99  2451.87   298.94   173.60   298.94
-TROP/SOLUTION

%=ENDTRO
"""

BERNESE_TROP_FILE = """
%=TRO 0.01 XYZ 24:197:01258 IGS 24:196:00000 24:197:00000 P  MIX
*-------------------------------------------------------------------------------
+FILE/REFERENCE
*INFO_TYPE_________ INFO________________________________________________________
 DESCRIPTION        My agency/institute
 OUTPUT             Precise-Point-Positioning solution generated by PPP BPE
 CONTACT            My e-mail address
 SOFTWARE           Bernese GNSS Software Version 5.2
-FILE/REFERENCE
+TROP/SOLUTION
*SITE ____EPOCH___ TROTOT STDDEV  TGNTOT STDDEV  TGETOT STDDEV
 ALIC 24:196:00000 2268.3    2.4   0.296  0.134  -1.446  0.184
 ALIC 24:196:03600 2260.9    1.4   0.355  0.127  -1.399  0.172
 ALIC 24:196:07200 2243.5    1.6   0.414  0.121  -1.353  0.161
 ALIC 24:196:10800 2247.9    1.4   0.473  0.114  -1.306  0.150
 ALIC 24:196:14400 2255.8    1.7   0.532  0.108  -1.259  0.140
 ALIC 24:196:18000 2247.6    1.4   0.591  0.103  -1.213  0.130
 ALIC 24:196:21600 2254.1    1.7   0.650  0.097  -1.166  0.120
 ALIC 24:196:25200 2255.3    1.3   0.709  0.093  -1.120  0.112
 ALIC 24:196:28800 2256.9    1.7   0.768  0.089  -1.073  0.105
 ALIC 24:196:32400 2268.1    1.9   0.827  0.085  -1.027  0.099
-TROP/SOLUTION
%=ENDTRO
"""


class TestTroposphere(unittest.TestCase):
    def test_ginan_trop(self):
        result = read_tro_solution_bytes(GINAN_TROP_FILE.encode("utf-8"), trop_mode="Ginan")
        self.assertEqual(result.shape, (10, 8))

    def test_bernese_trop(self):
        # 10 records, 6 fields
        result = read_tro_solution_bytes(BERNESE_TROP_FILE.encode("utf-8"), trop_mode="Bernese")
        self.assertEqual(result.shape, (10, 6))
