# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import AirweaveSDKEnvironment

if typing.TYPE_CHECKING:
    from .collections.client import AsyncCollectionsClient, CollectionsClient
    from .source_connections.client import AsyncSourceConnectionsClient, SourceConnectionsClient
    from .sources.client import AsyncSourcesClient, SourcesClient


class AirweaveSDK:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : AirweaveSDKEnvironment
        The environment to use for requests from the client. from .environment import AirweaveSDKEnvironment



        Defaults to AirweaveSDKEnvironment.PRODUCTION



    framework_name : typing.Optional[str]
    framework_version : typing.Optional[str]
    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from airweave import AirweaveSDK

    client = AirweaveSDK(
        framework_name="YOUR_FRAMEWORK_NAME",
        framework_version="YOUR_FRAMEWORK_VERSION",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: AirweaveSDKEnvironment = AirweaveSDKEnvironment.PRODUCTION,
        framework_name: typing.Optional[str] = None,
        framework_version: typing.Optional[str] = None,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            framework_name=framework_name,
            framework_version=framework_version,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._sources: typing.Optional[SourcesClient] = None
        self._collections: typing.Optional[CollectionsClient] = None
        self._source_connections: typing.Optional[SourceConnectionsClient] = None

    @property
    def sources(self):
        if self._sources is None:
            from .sources.client import SourcesClient  # noqa: E402

            self._sources = SourcesClient(client_wrapper=self._client_wrapper)
        return self._sources

    @property
    def collections(self):
        if self._collections is None:
            from .collections.client import CollectionsClient  # noqa: E402

            self._collections = CollectionsClient(client_wrapper=self._client_wrapper)
        return self._collections

    @property
    def source_connections(self):
        if self._source_connections is None:
            from .source_connections.client import SourceConnectionsClient  # noqa: E402

            self._source_connections = SourceConnectionsClient(client_wrapper=self._client_wrapper)
        return self._source_connections


class AsyncAirweaveSDK:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : AirweaveSDKEnvironment
        The environment to use for requests from the client. from .environment import AirweaveSDKEnvironment



        Defaults to AirweaveSDKEnvironment.PRODUCTION



    framework_name : typing.Optional[str]
    framework_version : typing.Optional[str]
    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from airweave import AsyncAirweaveSDK

    client = AsyncAirweaveSDK(
        framework_name="YOUR_FRAMEWORK_NAME",
        framework_version="YOUR_FRAMEWORK_VERSION",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: AirweaveSDKEnvironment = AirweaveSDKEnvironment.PRODUCTION,
        framework_name: typing.Optional[str] = None,
        framework_version: typing.Optional[str] = None,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            framework_name=framework_name,
            framework_version=framework_version,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._sources: typing.Optional[AsyncSourcesClient] = None
        self._collections: typing.Optional[AsyncCollectionsClient] = None
        self._source_connections: typing.Optional[AsyncSourceConnectionsClient] = None

    @property
    def sources(self):
        if self._sources is None:
            from .sources.client import AsyncSourcesClient  # noqa: E402

            self._sources = AsyncSourcesClient(client_wrapper=self._client_wrapper)
        return self._sources

    @property
    def collections(self):
        if self._collections is None:
            from .collections.client import AsyncCollectionsClient  # noqa: E402

            self._collections = AsyncCollectionsClient(client_wrapper=self._client_wrapper)
        return self._collections

    @property
    def source_connections(self):
        if self._source_connections is None:
            from .source_connections.client import AsyncSourceConnectionsClient  # noqa: E402

            self._source_connections = AsyncSourceConnectionsClient(client_wrapper=self._client_wrapper)
        return self._source_connections


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: AirweaveSDKEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
