# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CollectionUpdate(UniversalBaseModel):
    """
    Schema for updating an existing collection.

    Only the collection's display name can be updated. The readable_id is immutable
    to maintain stable API endpoints and references.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Updated display name for the collection. Must be between 4 and 64 characters.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
