/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 81:
/***/ (() => {

(function ($) {
if (CKEDITOR && CKEDITOR.plugins && CKEDITOR.plugins.registered && CKEDITOR.plugins.registered.cmsresize) {
	return;
}
/**
+ * Modified version of the resize plugin to support touch events.
+ *
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

CKEDITOR.plugins.add( 'cmsresize', {
	init: function( editor ) {
		function dragHandler( evt ) {
			var dx = evt.originalEvent.screenX - origin.x,
			dy = evt.originalEvent.screenY - origin.y,
			width = startSize.width,
			height = startSize.height,
			internalWidth = width + dx * ( resizeDir == 'rtl' ? -1 : 1 ),
			internalHeight = height + dy;

			if ( resizeHorizontal )
				width = Math.max( config.resize_minWidth, Math.min( internalWidth, config.resize_maxWidth ) );

			if ( resizeVertical )
				height = Math.max( config.resize_minHeight, Math.min( internalHeight, config.resize_maxHeight ) );

			// DO NOT impose fixed size with single direction resize. (https://dev.ckeditor.com/ticket/6308)
			editor.resize( resizeHorizontal ? width : null, height );
		}

		function dragEndHandler() {
			CMS.$(CKEDITOR.document.$).off( 'pointermove', dragHandler );
			CMS.$(CKEDITOR.document.$).off( 'pointerup', dragEndHandler );

			if ( editor.document ) {
				CMS.$(editor.document.$).off( 'pointermove', dragHandler );
				CMS.$(editor.document.$).off( 'pointerup', dragEndHandler );
			}
		}

		var config = editor.config;
		var spaceId = editor.ui.spaceId( 'resizer' );

		// Resize in the same direction of chrome,
		// which is identical to dir of editor element. (https://dev.ckeditor.com/ticket/6614)
		var resizeDir = editor.element ? editor.element.getDirection( 1 ) : 'ltr';

		!config.resize_dir && ( config.resize_dir = 'vertical' );
		( config.resize_maxWidth === undefined ) && ( config.resize_maxWidth = 3000 );
		( config.resize_maxHeight === undefined ) && ( config.resize_maxHeight = 3000 );
		( config.resize_minWidth === undefined ) && ( config.resize_minWidth = 750 );
		( config.resize_minHeight === undefined ) && ( config.resize_minHeight = 250 );

		if ( config.resize_enabled !== false ) {
			var container = null,
				origin, startSize,
				resizeHorizontal = ( config.resize_dir == 'both' || config.resize_dir == 'horizontal' ) && ( config.resize_minWidth != config.resize_maxWidth ),
				resizeVertical = ( config.resize_dir == 'both' || config.resize_dir == 'vertical' ) && ( config.resize_minHeight != config.resize_maxHeight );

			var mouseDownFn = CKEDITOR.tools.addFunction( function( $event ) {
				if ( !container )
					container = editor.getResizable();

				startSize = { width: container.$.offsetWidth || 0, height: container.$.offsetHeight || 0 };
				origin = { x: $event.screenX, y: $event.screenY };

				config.resize_minWidth > startSize.width && ( config.resize_minWidth = startSize.width );
				config.resize_minHeight > startSize.height && ( config.resize_minHeight = startSize.height );

				CMS.$(CKEDITOR.document.$).on( 'pointermove', dragHandler );
				CMS.$(CKEDITOR.document.$).on( 'pointerup', dragEndHandler );

				if ( editor.document ) {
					CMS.$(editor.document.$).on( 'pointermove', dragHandler );
					CMS.$(editor.document.$).on( 'pointerup', dragEndHandler );
				}

				$event.preventDefault && $event.preventDefault();
			} );

			CMS.$(CKEDITOR.document.$).find('html').attr('data-touch-action', 'none');

			editor.on( 'destroy', function() {
				CKEDITOR.tools.removeFunction( mouseDownFn );
			} );

			editor.on( 'uiSpace', function( event ) {
				if ( event.data.space == 'bottom' ) {
					var direction = '';
					if ( resizeHorizontal && !resizeVertical )
						direction = ' cke_resizer_horizontal';
					if ( !resizeHorizontal && resizeVertical )
						direction = ' cke_resizer_vertical';

					var resizerHtml =
						'<span' +
						' id="' + spaceId + '"' +
						' class="cms-ckeditor-resizer cke_resizer' + direction + ' cke_resizer_' + resizeDir + '"' +
						' title="' + CKEDITOR.tools.htmlEncode( editor.lang.common.resize ) + '"' +
						' onmousedown="CKEDITOR.tools.callFunction(' + mouseDownFn + ', event)"' +
						'>' +
						// BLACK LOWER RIGHT TRIANGLE (ltr)
						// BLACK LOWER LEFT TRIANGLE (rtl)
						( resizeDir == 'ltr' ? '\u25E2' : '\u25E3' ) +
						'</span>';

					// Always sticks the corner of botttom space.
					resizeDir == 'ltr' && direction == 'ltr' ? event.data.html += resizerHtml : event.data.html = resizerHtml + event.data.html;
				}
			}, editor, null, 100 );

			// Toggle the visibility of the resizer when an editor is being maximized or minimized.
			editor.on( 'maximize', function( event ) {
				editor.ui.space( 'resizer' )[ event.data == CKEDITOR.TRISTATE_ON ? 'hide' : 'show' ]();
			} );
		}
	}
} );

/**
 * The minimum editor width, in pixels, when resizing the editor interface by using the resize handle.
 * Note: It falls back to editor's actual width if it is smaller than the default value.
 *
 * Read more in the {@glink features/resize documentation}
 * and see the {@glink examples/resize example}.
 *
 *		config.resize_minWidth = 500;
 *
 * @cfg {Number} [resize_minWidth=750]
 * @member CKEDITOR.config
 */

/**
 * The minimum editor height, in pixels, when resizing the editor interface by using the resize handle.
 * Note: It falls back to editor's actual height if it is smaller than the default value.
 *
 * Read more in the {@glink features/resize documentation}
 * and see the {@glink examples/resize example}.
 *
 *		config.resize_minHeight = 600;
 *
 * @cfg {Number} [resize_minHeight=250]
 * @member CKEDITOR.config
 */

/**
 * The maximum editor width, in pixels, when resizing the editor interface by using the resize handle.
 *
 * Read more in the {@glink features/resize documentation}
 * and see the {@glink examples/resize example}.
 *
 *		config.resize_maxWidth = 750;
 *
 * @cfg {Number} [resize_maxWidth=3000]
 * @member CKEDITOR.config
 */

/**
 * The maximum editor height, in pixels, when resizing the editor interface by using the resize handle.
 *
 * Read more in the {@glink features/resize documentation}
 * and see the {@glink examples/resize example}.
 *
 *		config.resize_maxHeight = 600;
 *
 * @cfg {Number} [resize_maxHeight=3000]
 * @member CKEDITOR.config
 */

/**
 * Whether to enable the resizing feature. If this feature is disabled, the resize handle will not be visible.
 *
 * Read more in the {@glink features/resize documentation}
 * and see the {@glink examples/resize example}.
 *
 *		config.resize_enabled = false;
 *
 * @cfg {Boolean} [resize_enabled=true]
 * @member CKEDITOR.config
 */

/**
 * The dimensions for which the editor resizing is enabled. Possible values
 * are `both`, `vertical`, and `horizontal`.
 *
 * Read more in the {@glink features/resize documentation}
 * and see the {@glink examples/resize example}.
 *
 *		config.resize_dir = 'both';
 *
 * @since 3.3.0
 * @cfg {String} [resize_dir='vertical']
 * @member CKEDITOR.config
 */
})(CMS.$);


/***/ }),

/***/ 437:
/***/ (() => {

(function ($) {
    if (CKEDITOR && CKEDITOR.plugins && CKEDITOR.plugins.registered && CKEDITOR.plugins.registered.cmswidget) {
        return;
    }

    /**
     * Returns the focused widget, if of the type specific for this plugin.
     * If no widget is focused, `null` is returned.
     *
     * @param {CKEDITOR.editor} editor
     * @returns {CKEDITOR.plugins.widget|null} widget
     */
    function getSelectedWidget(editor) {
        var widget = editor.widgets.focused;

        if (widget && widget.name === 'cmswidget') {
            return widget;
        }

        widget = editor.widgets.selected;

        if (widget && widget.length) {
            var index = widget.findIndex(function (w) {
                return w.name === 'cmswidget';
            });

            if (index !== -1) {
                return widget[index];
            }
        }

        return null;
    }

    /**
     * Block / inline-but-block widgets can't be aligned properly
     * because CKEDITOR unwraps them and widget markup is then injected incorrectly
     * into resulting markup. This is not the complete solution, but this is what we have.
     *
     * @param {CKEDITOR.plugins.widget} widget widget
     * @returns {Boolean}
     */
    function canWidgetBeAligned(widget) {
        if (widget.inline) {
            if (CMS.$(widget.wrapper.$).hasClass('cke_widget_wrapper_force_block')) {
                return false;
            }

            return true;
        }

        return false;
    }

    var alignCommandIntegrator = function (editor) {
        var execCallbacks = [];

        return function (value) {
            var command = editor.getCommand('justify' + value);

            if (!command) {
                return;
            }

            execCallbacks.push(function () {
                command.refresh(editor, editor.elementPath());
            });

            command.on('exec', function (e) {
                var widget = getSelectedWidget(editor);

                if (widget) {
                    var enabled = canWidgetBeAligned(widget);

                    if (!enabled) {
                        // Once the widget changed its align, all the align commands
                        // must be refreshed: the event is to be cancelled.
                        for (var i = execCallbacks.length; i--;) {
                            execCallbacks[i]();
                        }

                        e.cancel();
                    }
                }
            });

            command.on('refresh', function (e) {
                var widget = getSelectedWidget(editor);

                if (!widget) {
                    return;
                }

                var enabled = canWidgetBeAligned(widget);

                // Don't allow justify commands when widget alignment is disabled
                if (!enabled) {
                    this.setState(CKEDITOR.TRISTATE_DISABLED);
                    e.cancel();
                }
            });
        };
    };

    CKEDITOR.plugins.add('cmswidget', {
        requires: 'widget',
        onLoad: function () {
            CKEDITOR.addCss(
                // when widget contents are inline,
                // but have block-level css
                '.cke_widget_wrapper_force_block{' +
                    'display:block!important;' +
                '}' +
                // empty elements focus outline
                '.cke_widget_block>.cke_widget_element{' +
                    'display:block!important;' +
                '}' +
                'span.cms-ckeditor-plugin-label{' +
                    'display: inline-block !important;' +
                    'padding-left: 8px;' +
                    'padding-right: 8px;' +
                '}' +
                '.cms-ckeditor-plugin-label{' +
                    'background: black;' +
                    'color: white;' +
                    'text-align: center;' +
                    'border-radius: 3px;' +
                    'height: 24px;' +
                    'line-height: 24px;' +
                    'font-size: 14px !important;' +
                '}'
            );
        },

        init: function (editor) {
            this.addWidgetDefinition(editor);
        },

        afterInit: function (editor) {
            // Integrate with align commands (justify plugin).
            var integrate = alignCommandIntegrator(editor);

            ['left', 'right', 'center', 'block'].forEach(integrate);
        },

        addWidgetDefinition: function (editor) {
            editor.widgets.add('cmswidget', {
                button: 'CMS Plugin',

                template:
                    '<cms-plugin style="unset: all">' +
                    '</cms-plugin>',

                allowedContent: 'cms-plugin',
                disallowedContent: 'cms-plugin{float}',

                requiredContent: 'cms-plugin',

                upcast: function (element) {
                    return element.name === 'cms-plugin';
                },

                init: function () {
                    var contents = $(this.element.$).children();
                    var displayProp = contents.css('display') || '';

                    if (!displayProp.includes('inline')) {
                        this.wrapper.addClass('cke_widget_wrapper_force_block');
                    }
                }
            });
        }
    });
})(CMS.$);


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";

;// ./private/js/cms.dialog.js
/* eslint-env es6 */
/* jshint esversion: 6 */
/* global document, window, console */


class CmsDialog {
    /**
     * Constructor for creating an instance of the class showing a django CMS modal in a
     * modal HTML dialog element to show a plugin admin form in an iframe.
     *
     * The django CMS modal is resizable (thanks to CSS) and movable. It cannot be
     * minimized or maximized. It blocks all other input on the page until it is closed.
     *
     * The dialog element is attached to the <div id="cms-top"> at the beginning of a page
     * with a toolbar. The dialog is removed when it is closed.
     *
     * @param {Element} el - The editor element to be associated with the instance.
     * @param {Function} saveSuccess - The success callback function to be invoked upon save.
     * @param {Function} cancel - The callback function to be invoked upon cancellation.
     */
    constructor(el, saveSuccess, cancel) {
        this.el = el;
        this.saveSuccess = saveSuccess;
        this.cancel = cancel;
        this.close = this._close.bind(this);
    }

    /**
     * Create a plugin modal dialog.
     * @return {HTMLIFrameElement} - The newly created iframe element.
     */
    pluginDialog() {
        this.dialog = document.createElement("dialog");
        this.dialog.classList.add("cms-dialog");
        this.dialog.dataset.editor = this.el.id;
        this.dialog.innerHTML = `
            <div class="cms-modal-head">
                <span class="cms-modal-title">
                    <span class="cms-modal-title-prefix"></span>
                    <span class="cms-modal-title-suffix"></span>
                    <span class="cms-modal-close cms-icon cms-icon-close"></span>
                </span>
            </div>
            <div class="cms-modal-body">
            </div>
            <div class="cms-modal-foot">
                <div class="cms-modal-buttons">
                <div class="cms-modal-buttons-inner">
                    <div class="cms-modal-item-buttons"><a href="#" class="cms-btn cms-btn-action default">Save</a></div>
                    <div class="cms-modal-item-buttons"><a href="#" class="cms-btn cms-btn-close-action">Cancel</a></div>
                </div>
            </div>
        `;

        (window.parent || window).document.querySelector('div.cms').prepend(this.dialog);
        const settings = window.CMS_Editor.getSettings(this.el);
        this.dialog.querySelector(".cms-modal-title-suffix").textContent = settings.lang.edit;
        this.dialog.querySelector(".cms-modal-title-prefix").textContent = settings.lang.toolbar;
        this.dialog.querySelector('.cms-modal-title').addEventListener('mousedown', (event) => {
            this.dragDialog(event);
        });
        this.dialog.querySelector('.cms-modal-title').addEventListener('touchstart', (event) => {
            this.swipeDialog(event);
        });
        const closeEvent = (event) => {
            event.stopPropagation();
            event.preventDefault();
            this.close();
            if (this.cancel) {
                this.cancel(event);
            }
        };
        this.dialog.addEventListener("close", (event) => closeEvent(event));
        this.dialog
            .querySelector(".cms-btn-close-action")
            .addEventListener('click', (event) => closeEvent(event));
        this.dialog
            .querySelector(".cms-modal-close")
            .addEventListener('click', (event) => closeEvent(event));
        this.dialog.addEventListener('keydown', (event) => {
            if (event.key === 'Escape') {
                // Don't propagate the event to the CMS modal, or it will close, too
                event.stopPropagation();
            }
        });
        const iframe = document.createElement('iframe');
        this.dialog.querySelector(".cms-modal-body").append(iframe);
        return iframe;
    }

    /**
     * Opens the edit dialog for a specific plugin.
     *
     * @param {string} pluginId - The ID of the plugin to be edited.
     *
     * @return {void}
     */
    editDialog(pluginId) {
        const iframe = this.pluginDialog();

        window.CMS_Editor.editPluginForm(pluginId, iframe, this.el,
            (el, content, heading, submitrow) => this._dialogLoaded(el, content, heading, submitrow),
            (el, content, data) => this._dialogSaved(el, content, data));
    }

    /**
     * Dialog to add a plugin.
     *
     * @param {string} pluginType - The type of the plugin.
     * @param {string} selectionText - The selected text (will be copied into the input field with
     *                                 the class "js-prepopulate-selected-text").
     *
     * @return {void}
     */
    addDialog(pluginType, selectionText) {
        const iframe = this.pluginDialog();

        window.CMS_Editor.addPluginForm(pluginType, iframe, this.el,
            (el, content, heading, submitrow) =>
                this._dialogLoaded(el, content, heading, submitrow, selectionText),
            (el, content, data) => this._dialogSaved(el, content, data));
    }

    _dialogLoaded(el, content, heading, submitrow, selectionText) {
        if (submitrow) {
            this.dialog.querySelector('.cms-btn-action.default')
                .addEventListener('click', (event) => {
                    event.stopPropagation();
                    event.preventDefault();
                    submitrow.closest('form').submit();
                });
        } else {
            this.dialog.querySelector('.cms-btn-action.default').style.display = 'none';
        }
        if (heading) {
            this.dialog.querySelector(".cms-modal-title-suffix").textContent = heading.textContent;
        }
        this.open();
        // If form is big (i.e., scrollbars appear), make the dialog bigger
        if (content.documentElement.scrollHeight > content.documentElement.clientHeight) {
            this.dialog.style.height = "60%";
            this.dialog.style.width = "80%";
            content.documentElement.scrollTop = 0;
        }

        // Prefill marked input fields with selected text
        selectionText = selectionText || '';
        if (selectionText.length > 0) {
            let fillInput = content.querySelector('.js-ckeditor-use-selected-text,.js-prepopulate-selected-text') ||
                content.querySelector('#id_name');
            if (fillInput) {  // Does such a field exist?
                if (!(fillInput.value.trim())) {
                    fillInput.value = selectionText;  // Prefill the field only if it is empty
                    fillInput.focus();
                }
            }
        }
    }

    _dialogSaved(el, content, data) {
        this.saveSuccess(data);
        this.close();
    }

    /**
     * Opens the dialog by showing it in a modal state.
     *
     * @return {void}
     */
    open() {
        this.dialog.showModal();
    }

    /**
     * Removes the dialog
     *
     * @method close
     * @memberof ClassName
     * @returns {void}
     */
    _close() {
        this.dialog.removeEventListener("close", this.close);
        this.dialog.remove();
    }

    /**
     * Allows dragging the dialog based on the user's mouse movements.
     *
     * @param {Event} event - The mouse event that triggers the drag.
     */
    dragDialog(event) {
        if (event.which !== 1) {
            return;
        }
        event.preventDefault();
        const firstX = event.pageX;
        const firstY = event.pageY;
        const initialX = parseInt(getComputedStyle(this.dialog).left);
        const initialY = parseInt(getComputedStyle(this.dialog).top);

        const dragIt = (e) => {
            this.dialog.style.left = initialX + e.pageX - firstX + 'px';
            this.dialog.style.top = initialY + e.pageY - firstY + 'px';
        };
        const Window = window.parent || window;
        Window.addEventListener('mousemove', dragIt, false);
        Window.addEventListener('mouseup', (e) => {
            Window.removeEventListener('mousemove', dragIt, false);
        }, false);
    }

    /**
     * Allows dragging the dialog based on the user's touch movements.
     *
     * @param {Event} event - The touch event that triggers the drag.
     */
    swipeDialog(event) {
        event.preventDefault();

        const firstX = event.pageX;
        const firstY = event.pageY;
        const initialX = parseInt(getComputedStyle(this.dialog).left);
        const initialY = parseInt(getComputedStyle(this.dialog).top);

        const swipeIt = (e) => {
            const contact = e.touches;
            this.dialog.style.left = initialX + contact[0].pageX - firstX + 'px';
            this.dialog.style.top = initialY + contact[0].pageY - firstY + 'px';
        };

        const Window = window.parent || window;
        Window.addEventListener('touchmove', swipeIt, false);
        Window.addEventListener('touchend', (e) => {
            Window.removeEventListener('touchmove', swipeIt, false);
        }, false);
    }
}


/**
 * Represents an editor form, e.g. to enter a link address, or a pop-up toolbar.
 *
 * The form is contained in a (non-modal) dialog element which is attached to the editor's div wrapper.
 *
 *
 * @constructor
 * @param {*} el - The element to attach the form to.
 * @param {function} saveSuccess - The callback function to be called when form is successfully submitted.
 * @param {function} cancel - The callback function to be called when form is cancelled.
 */
class CmsForm {
     constructor(el, saveSuccess, cancel) {
        this.el = el;
        this.saveSuccess = saveSuccess;
        this.cancel = cancel;
        this.close = this._close.bind(this);
    }

    formDialog(form, options) {
        this.dialog = document.createElement("dialog");
        this.dialog.classList.add("cms-form-dialog");
        if (options.toolbar) {
            this.dialog.innerHTML = form;
        } else {
            this.dialog.innerHTML = `
                <form class="cms-form">
                    <div class="cms-form-inputs">${form}</div>
                    <div class="cms-form-buttons">
                        <span class="submit"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-lg" viewBox="0 0 16 16">
                            <path d="M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425z"/>
                            </svg></span>
                        <span class="cancel"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                            <path d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8z"/>
                            </svg></span>
                    </div>
                </form>`;
        }

        if (options && options.x && options.y) {
            const el_pos = this.el.getBoundingClientRect();
            if (options.x > window.innerWidth / 2) {
                this.dialog.classList.add("right");
                this.dialog.style.right = (el_pos.x + el_pos.width - options.x - 24 - 10) + 'px';
            } else {
                this.dialog.style.left = (options.x - el_pos.x - 24) + 'px';
            }
            this.dialog.style.top = (options.y - el_pos.y + 5) + 'px';
            this.dialog.style.transform = 'none';
        }

        // Add the dialog to the inline editor
        this.el.prepend(this.dialog);
        this.dialog.addEventListener("close", (event) => {
            event.stopPropagation();
            this.close();
        });
        document.addEventListener("click", this.close);
        if (this.dialog.querySelector('.cancel')) {
            this.dialog.querySelector(".cancel")
                .addEventListener('click',  () => this.close() );
        }
        this.dialog.addEventListener('keydown', (event) => {
            if (event.key === 'Escape') {
                // Don't propagate the event to the CMS modal, or it will close, too
                event.stopPropagation();
                event.preventDefault();
                this.close();
            }
        });
        const formElement = this.dialog.querySelector('form');
        if (formElement) {
            formElement.addEventListener('submit', (event) => {
                event.preventDefault();
                this.submit();
            });
            this.dialog.querySelector(".submit").addEventListener('click', (event) => {
                event.preventDefault();
                if (this.dialog.querySelector('form').reportValidity()) {
                    this.submit();
                }
            });
        }
        return formElement || this.dialog;
    }

    open() {
        this.dialog.show();
        const firstInput = this.dialog.querySelector('input');
        if (firstInput) {
            firstInput.focus();
        }
    }

    _close(event) {
        if (!event || !this.dialog.contains(event.target)) {
            // Do only close if the click is outside the dialog
            document.removeEventListener("click", this.close);
            this.dialog.removeEventListener("close", this.close);
            if (this.cancel) {
                this.cancel(event);
            }
            this.dialog.remove();
        }
    }

    submit() {
        const data = new FormData(this.dialog.querySelector('form'));
        this.dialog.remove();
        this.saveSuccess(data);
    }
}


/**
 * Converts a given form array to HTML representation.
 *
 * @param {Array} formArray - The array containing form elements.
 * @returns {string} - The HTML form representation.
 */
function formToHtml(formArray) {
    'use strict';
    let form = '';

    formArray.forEach((element) => {
        const id = Math.random().toString(36).slice(2, 9);
        switch(element.type) {
            case 'text':
            case 'url':
                if (element.label) {
                    form += `<label for="id${id}">${element.label}</label>`;
                }
                form += `<input type="${element.type}" id="id${id}"
                    placeholder="${element.placeholder || ''}" name="${element.name}"
                    class="${element.class || ''}"
                    value="${element.value || ''}"${element.required ? ' required' : ''}>`;
                break;
            case 'select':
                if (element.label) {
                    form += `<label for="id${id}">${element.label}</label>`;
                }
                form += `<select id="id${id}" name="${element.name}"${element.required ? ' required' : ''} class="${element.class || ''}">`;
                element.options.forEach((option) => {
                    form += `<option value="${option.value}"${option.value === element.value ? ' selected' : ''}>${option.label}</option>`;
                });
                form += '</select>';
                break;
            case 'hidden':
                form += `<input type="hidden" id="id${id}" name="${element.name}" value="${element.value || ''}">`;
                break;
            case 'hr':
                form += '<hr>';
                break;
            case 'link':
                form += `<a href="${element.url}" target="_blank">${element.label}</a>`;
                break;
            case 'section':
                const content = formToHtml(element.content);
                form += `<details><summary>${element.label}</summary>${content}</details>`;
                break;
        }
    });
    return form + '<input type="submit" hidden />';
}


/**
 * Populates a given HTML form with values from a form object.
 *
 * @param {HTMLFormElement} htmlForm - The HTML form element to populate.
 * @param {object} attributes - The attributes to populate the form with.
 * @param {Array} formObject - The form object containing input values.
 */
function populateForm(htmlForm,  attributes, formObject) {
    'use strict';
    if (attributes && formObject) {
        for (const input of formObject) {
            let value;
            if (input.name in attributes) {
                value = attributes[input.name] || '';
            } else {
                value = input.value || '';
            }
            const field = htmlForm.querySelector(`[name="${input.name}"]`);
            if (field && field.value !== value) {
                field.value = value;
                if (field.getAttribute('type') === 'hidden') {
                    // Trigger change event for hidden fields
                    field.dispatchEvent(new Event('input', {bubbles: true, cancelable: true}));
                }
            }
        }
    }
}






;// ./private/js/ckeditor4_plugins/cmsplugins/plugin.js


(function ($) {
    if (CKEDITOR && CKEDITOR.plugins && CKEDITOR.plugins.registered && CKEDITOR.plugins.registered.CMSPlugins) {
        return;
    }

    /**
     * Determine if we should return `div` or `span` based on the
     * plugin markup.
     *
     * @function getFakePluginElement
     * @private
     * @param {String} pluginMarkup valid html hopefully
     * @returns {String} div|span
     */
    function getFakePluginElement(pluginMarkup) {
        var innerTags = (pluginMarkup.match(/<\s*([^>\s]+)[\s\S]*?>/) || [0, false]).splice(1);

        var containsAnyBlockLikeElements = innerTags.some(function (tag) {
            return tag && CKEDITOR.dtd.$block[tag];
        });

        var fakeRealType = 'span';

        if (containsAnyBlockLikeElements) {
            fakeRealType = 'div';
        }

        return fakeRealType;
    }

    /**
     * @function replaceTagName
     * @private
     * @param {jQuery} elements
     * @param {String} tagName
     */
    function replaceTagName(elements, tagName) {
        elements.each(function (i, el) {
            var newElement;

            var element = $(el);

            newElement = $('<' + tagName + '>');

            // attributes
            $.each(el.attributes, function (index, attribute) {
                newElement.attr(attribute.nodeName, attribute.nodeValue);
            });

            // content
            newElement.html(element.html());

            element.replaceWith(newElement);
        });
    }

    CKEDITOR.plugins.add('CMSPlugins', {

        // Register the icons. They must match command names.
        icons: 'CMSPlugins',

        // The plugin initialization logic goes inside this method.
        init: function (editor) {
            var that = this;

			CKEDITOR.on('instanceReady', function () {
                var widgetInstances = [];

                for (var key in editor.widgets.instances) {
                    if (editor.widgets.instances.hasOwnProperty(key)) {
                        widgetInstances.push(editor.widgets.instances[key]);
                    }
                }

                that.numberOfChildren = CKEDITOR.tools.array.filter(widgetInstances, function (i) {
                    return i.name === 'cms-widget';
                }).length;
            });
            /**
             * populated with _fresh_ child plugins
             */
            this.unsaved_child_plugins = [];

			var settings  = CMS_Editor.getSettings(editor.name);
			this.setupCancelCleanupCallback(settings);

            // don't do anything if there are no plugins defined
            if (settings === undefined || settings.plugins === undefined) {
                return false;
            }

            this.setupDialog(editor);

            // add the button
            editor.ui.add('CMSPlugins', CKEDITOR.UI_PANELBUTTON, {
                toolbar: 'cms,0',
                label: settings.lang.CMSPlugins.title,
                title: settings.lang.CMSPlugins.title,
                className: 'cke_panelbutton__cmsplugins',
                modes: { wysiwyg: 1 },
                editorFocus: 0,

                panel: {
                    css: [CKEDITOR.skin.getPath('editor')].concat(editor.config.contentsCss),
                    attributes: { 'role': 'cmsplugins', 'aria-label': settings.lang.CMSPlugins.aria }
                },

                // this is called when creating the dropdown list
                onBlock: function (panel, block) {
                    block.element.setHtml(that.setupDropdown(editor));

                    var anchors = $(block.element.$).find('.cke_panel_listItem a');

                    anchors.bind('click', function (e) {
                        e.preventDefault();

                        that.addPlugin($(this), panel, editor);
                    });
                }
            });

            // handle edit event via context menu
            if (editor.contextMenu) {
                this.setupContextMenu(editor);
            }

            editor.addCommand('cmspluginsEdit', {
                exec: function () {
                    var element = that.getElementFromSelection(editor);
                    var plugin = that.getPluginWidget(element);
                    if (plugin) {
                        that.editPlugin(plugin, editor);
                    }
                }
            });

            // handle edit event on double click
            // if event is a jQuery event (touchend), then we mutate
            // event a bit so we make the payload similar to what ckeditor.event produces
            var handleEdit = function (event) {
                event.stop();

                if (event.type === 'touchend' || event.type === 'click') {
                    var cmsPluginNode = $(event.currentTarget).closest('cms-plugin')[0];
					var element;

                    // pick cke_widget span
                    // eslint-disable-next-line new-cap
                    element = new CKEDITOR.dom.element(cmsPluginNode).getParent();

                    event.data = event.data || {};
                    // have to fake selection to be able to replace markup after editing
                    editor.getSelection().fake(element);
                }

                editor.execCommand('cmspluginsEdit');
            };

            editor.on('doubleclick', handleEdit);

            editor.on('instanceReady', function () {
/*
				var context = CMS.$('iframe.cke_wysiwyg_frame');
				if (context.length > 0) {
					context = context.contentWindow.document.documentElement;
				} else {
					context = null;
				}
                CMS.$('cms-plugin', CMS.$('iframe.cke_wysiwyg_frame')[0]
                    .contentWindow.document.documentElement).on('click touchend', handleEdit);
*/
            });

            this.setupDataProcessor(editor);
        },

        getElementFromSelection: function (editor) {
            var selection = editor.getSelection();
            var element = selection.getSelectedElement() ||
                selection.getCommonAncestor().getAscendant('cms-plugin', true);

            return element;
        },

        getPluginWidget: function (element) {
            if (!element) {
                return null;
            }
            return element.getAscendant('cms-plugin', true) || element.findOne('cms-plugin');
        },

        setupDialog: function (editor) {
            var that = this;
            var definition = function () {
                return {
                    title: '',
                    minWidth: 200,
                    minHeight: 200,
                    contents: [{
                        elements: [
                            {
                                type: 'html',
                                html: '<iframe style="position:static; width:100%; height:100%; border:none;" />'
                            }
                        ]
                    }],
                    onOk: function (dialog) {
                        var iframe = $(CKEDITOR.dialog.getCurrent().parts.contents.$).find('iframe').contents();
                        var iframeUrl = iframe[0].URL;

                        iframe.find('form').submit();

                        // catch the reload event and reattach
                        var onSave = CMS.API.Helpers.onPluginSave;

                        CMS.API.Helpers.onPluginSave = function () {
                            CKEDITOR.dialog.getCurrent().hide();
                            var data = CMS.API.Helpers.dataBridge;
                            var addedChildPlugin = false;
							var settings = CMS_Editor.getSettings(editor.name);

                            if (iframeUrl.match(/add-plugin/)) {
                                addedChildPlugin = true;
                            }
                            // in case it's a fresh text plugin children don't have to be
                            // deleted separately
                            if (!settings.delete_on_cancel && addedChildPlugin) {
                                that.unsaved_child_plugins.push(data.plugin_id);
                            }
                            that.insertPlugin(data, dialog.sender._.editor);
							that.numberOfChildren += 1

                            CMS.API.Helpers.onPluginSave = onSave;
                            return false;
                        };
                        return false;
                    }
                };
            };

            // set default definition and open dialog
            CKEDITOR.dialog.add('cmspluginsDialog', definition);
        },

        setupDropdown: function (editor) {
            var tpl = '<div class="cke_panel_block">';
			var settings = CMS_Editor.getSettings(editor.name);

            // loop through the groups
            $.each(settings.plugins, function (i, group) {
                // add template
                tpl += '<h1 class="cke_panel_grouptitle">' + group.group + '</h1>';
                tpl += '<ul role="presentation" class="cke_panel_list">';
                // loop through the plugins
                $.each(group.items, function (ii, item) {
                    tpl += '<li class="cke_panel_listItem"><a href="#" rel="' + item.type + '">' +
                        item.title + '</a></li>';
                });
                tpl += '</ul>';
            });

            tpl += '</div>';

            return tpl;
        },

        setupContextMenu: function (editor) {
            var that = this;
			var settings = CMS_Editor.getSettings(editor.name);

            editor.addMenuGroup('cmspluginsGroup');
            editor.addMenuItem('cmspluginsItem', {
                label: settings.lang.CMSPlugins.editLabel,
                icon: settings.static_url + '/icons/cmsplugins.svg',
                command: 'cmspluginsEdit',
                group: 'cmspluginsGroup'
            });

            editor.removeMenuItem('image');

            editor.contextMenu.addListener(function (element) {
                var plugin = that.getPluginWidget(element);

                if (plugin) {
                    return { cmspluginsItem: CKEDITOR.TRISTATE_OFF };
                }
            });
        },

        editPlugin: function (element, editor) {
            var id = element.getAttribute('id');
            editor.fire('saveSnapshot');

			new CmsDialog(editor.element.$, saveSuccess => {
				if (saveSuccess) {
					window.CMS_Editor.requestPluginMarkup(id, editor.element.$)
						.then(markup => {
							editor.insertHtml(markup, 'unfiltered_html');
							editor.fire('updateSnapshot');
						})
						.catch(error => {
							console.error(error);
						});
				}
				editor.focus();
			}, () => editor.focus()).editDialog(id);
        },

        addPlugin: function (item, panel, editor) {

            // hide the panel
            panel.hide();

            editor.focus();
            editor.fire('saveSnapshot');

			new CmsDialog(editor.element.$, data => {
				if (data.plugin_id) {
					window.CMS_Editor.requestPluginMarkup(data.plugin_id, editor.element.$)
						.then(markup => {
							editor.insertHtml(markup, 'unfiltered_html');
							editor.fire('updateSnapshot');
						})
						.catch(error => {
							console.error(error);
						});
				}
			}, () => editor.focus()).addDialog(item.attr('rel'), editor.getSelection().getSelectedText());
        },

        /**
         * Sets up cleanup requests. If the plugin itself or child plugin was created and then
         * creation was cancelled - we need to clean up created plugins.
         *
         * @method setupCancelCleanupCallback
         * @public
         * @param {Object} settings editor settings
         */
        setupCancelCleanupCallback: function setupCancelCleanupCallback(settings) {
            if (!window.parent || !window.parent.CMS || !window.parent.CMS.API || !window.parent.CMS.API.Helpers) {
                return;
            }

            var that = this;
            var CMS = window.parent.CMS;
            var cancelModalCallback = function cancelModalCallback(e, opts) {
                if (!settings.delete_on_cancel && !that.unsaved_child_plugins.length) {
                    return;
                }
                if (that.unsaved_child_plugins.length) {
                    e.preventDefault();
                    CMS.API.Toolbar.showLoader();
                    var data = {
                        token: settings.action_token
                    };

                    if (!settings.delete_on_cancel) {
                        data.child_plugins = that.unsaved_child_plugins;
                    }

                    $.ajax({
                        method: 'POST',
                        url: settings.cancel_plugin_url,
                        data: data,
                        // use 'child_plugins' instead of default 'child_plugins[]'
                        traditional: true
                    }).done(function () {
                        CMS.API.Helpers.removeEventListener(
                            'modal-close.text-plugin.text-plugin-' + settings.plugin_id
                        );
                        opts.instance.close();
                    }).fail(function (res) {
                        CMS.API.Messages.open({
                            message: res.responseText + ' | ' + res.status + ' ' + res.statusText,
                            delay: 0,
                            error: true
                        });
                    });
                }
            };

            CMS.API.Helpers.addEventListener(
                'modal-close.text-plugin.text-plugin-' + settings.plugin_id,
                cancelModalCallback
            );
        },

        setupDataProcessor: function (editor) {
            // priorities of callback execution, see http://docs.ckeditor.com/#!/api/CKEDITOR.editor-event-toHtml
            var BEFORE_PROCESSING_STARTED = 1;
            var BEFORE_MARKUP_IS_PARSED = 4;

            /**
             * This override is required for the inline plugins that have preceding space, because otherwise CKEditor
             * would remove that space while parsing
             * html.
             *
             * Ref: https://github.com/ckeditor/ckeditor-dev/blob/master/core/htmlparser/fragment.js#L484
             */
            CKEDITOR.htmlParser.element = CKEDITOR.tools.override(CKEDITOR.htmlParser.element, function (original) {
                return function (name, attributes) {
                    original.call(this, name, attributes);

                    if (name === 'cms-plugin' && attributes['data-cke-real-element-type'] === 'span') {
                        this._.isBlockLike = false;
                    }
                };
            });

            /**
             * @function isBlockLikeChildren
             * @public
             * @param {CKEDITOR.htmlParser.element} element
             * @returns {Boolean}
             */
            function isBlockLikeChildren(element) {
                return element.attributes && element.attributes['data-cke-real-element-type'] === 'div';
            }

            editor.dataProcessor.dataFilter.addRules(
                {
                    elements: {
                        span: function (element) {
                            if (CKEDITOR.plugins.widget.isParserWidgetWrapper(element)) {
                                var cmsPluginNode = element.getFirst();

                                if (isBlockLikeChildren(cmsPluginNode)) {
                                    // eslint-disable-next-line new-cap
                                    var newWrapper = new CKEDITOR.htmlParser.element(
                                        'div',
                                        $.extend({}, element.attributes)
                                    );

                                    editor.widgets.registered.cmswidget.inline = false;
                                    newWrapper.children = element.children;
                                    newWrapper.removeClass('cke_widget_inline');
                                    newWrapper.removeClass('cke_widget_force_block');
                                    newWrapper.addClass('cke_widget_block');
                                    cmsPluginNode.attributes['data-cke-real-element-type'] = 'div';

                                    return newWrapper;
                                }

                                editor.widgets.registered.cmswidget.inline = true;
                                cmsPluginNode.attributes['data-cke-real-element-type'] = 'span';
                            }
                            return element;
                        }
                    }
                },
                {
                    priority: 1,
                    applyToAll: true
                }
            );

            // need to update cms-plugin-nodes with fake "real type" so
            // ckeditor treats them as flow / phrasing elements correctly
            // + we check if plugin markup should be rendered or not
            editor.on('toHtml', function (e) {
                // now i have two problems
                var newMarkup = e.data.dataValue.replace(
                    /<cms-plugin(.*?)>([\s\S]*?)<\/cms-plugin>/gi,
                    function (all, attributes, pluginMarkup) {
                        var fakeRealType = getFakePluginElement(pluginMarkup);

                        if (attributes.match(/render-plugin=["']?false/gi)) {
                            return '<cms-plugin data-cke-real-element-type="' + fakeRealType + '" ' + attributes + '>' +
                                    '<' + fakeRealType + ' class="cms-ckeditor-plugin-label">' +
                                        attributes.replace(/[\s\S]*alt=["']([\s\S]*?)['"][\s\S]*/, '$1') +
                                    '</' + fakeRealType + '>' +
                                '</cms-plugin>';
                        }

                        return '<cms-plugin data-cke-real-element-type="' + fakeRealType + '" ' + attributes + '>' +
                            pluginMarkup +
                            '</cms-plugin>';
                    }
                );

                // in case we have a stale markup with <p> tag wrapped around
                // we want to avoid a situation where browser would try to unwrap the tags in a way that would
                // break the markup. what we do is we replace <cms-plugin> tags with divs if that is necessary,
                // unwrap them with jQuery (which uses browser mechanism) and then replace the divs back
                if (newMarkup.match(/<cms-plugin[^>]*(?=data-cke-real-element-type=\"div)/)) {
                    // eslint-disable-next-line max-len
                    var blockLevelPluginRegex = /<cms-plugin([^>]*(?=data-cke-real-element-type=\"div)[\s\S]*?>[\s\S]*?<\/)cms-plugin>/g;

                    var unwrappedMarkup = newMarkup.replace(blockLevelPluginRegex, '<div$1div>');
                    // have to create a wrapper, otherwise we won't be able to return markup back
                    var unwrappedElementsWrapper = $(unwrappedMarkup).wrapAll('<div>').parent();
                    var wrappers = unwrappedElementsWrapper.find('div[data-cke-real-element-type="div"]');

                    replaceTagName(wrappers, 'cms-plugin');

                    newMarkup = unwrappedElementsWrapper.html();
                }

                e.data.dataValue = newMarkup;
            }, null, null, BEFORE_MARKUP_IS_PARSED);

            editor.on('toHtml', function () {
                // reset widgets to inline again to avoid creating block-level inline widget
                if (editor.widgets && editor.widgets.registered && editor.widgets.registered.cmswidget) {
                    editor.widgets.registered.cmswidget.inline = true;
                }
            }, null, null, BEFORE_PROCESSING_STARTED);
        }
    });
})(CMS.$);

// EXTERNAL MODULE: ./private/js/ckeditor4_plugins/cmsresize/plugin.js
var cmsresize_plugin = __webpack_require__(81);
// EXTERNAL MODULE: ./private/js/ckeditor4_plugins/cmswidget/plugin.js
var cmswidget_plugin = __webpack_require__(437);
;// ./private/js/cms.ckeditor4.js
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/* eslint-env es6 */
/* jshint esversion: 6 */
/* global document, window, console */






// Configure cmsplugin


window.cms_editor_plugin = {

    _editors: {},
    _CSS: [],

    options: {
        // ckeditor default settings, will be overwritten by CKEDITOR_SETTINGS
        language: 'en',
        readOnly: false,
        skin: 'moono-lisa',
        toolbar_CMS: [
            ['Undo', 'Redo'],
            ['CMSPlugins', 'cmswidget', '-', 'ShowBlocks'],
            ['Format', 'Styles'],
            ['TextColor', 'BGColor', '-', 'PasteText', 'PasteFromWord'],
            ['Scayt'],
            ['Maximize', ''],
            '/',
            ['Bold', 'Italic', 'Underline', 'Strike', '-', 'Subscript', 'Superscript', '-', 'RemoveFormat'],
            ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
            ['HorizontalRule'],
            ['NumberedList', 'BulletedList'],
            ['Outdent', 'Indent', '-', 'Blockquote', '-', 'Link', 'Unlink', '-', 'Table'],
            ['Source']
        ],
        toolbar_HTMLField: [
            ['Undo', 'Redo'],
            ['ShowBlocks'],
            ['Format', 'Styles'],
            ['TextColor', 'BGColor', '-', 'PasteText', 'PasteFromWord'],
            ['Scayt'],
            ['Maximize', ''],
            '/',
            ['Bold', 'Italic', 'Underline', 'Strike', '-', 'Subscript', 'Superscript', '-', 'RemoveFormat'],
            ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock'],
            ['HorizontalRule'],
            ['NumberedList', 'BulletedList'],
            ['Outdent', 'Indent', '-', 'Blockquote', '-', 'Link', 'Unlink', '-', 'Table'],
            ['Source']
        ],
        allowedContent: true,
        toolbarCanCollapse: false,
        removePlugins: 'resize,flash',
        extraPlugins: ''
    },

    // initializes the editor on the target element, with the given html code
    create: function(el, inModal, content, settings, save_callback) {
        const all_options = Object.assign({}, this.options, settings.options);

        // add extra plugins that we absolutely must have
        all_options.extraPlugins = all_options.extraPlugins +=
            ',CMSPlugins,cmswidget,cmsresize,widget';

        if (typeof all_options.toolbar === 'string' && ('toolbar_' + all_options.toolbar) in all_options) {
            all_options.toolbar = all_options['toolbar_' + all_options.toolbar];
        }

        if (CKEDITOR.dtd['cms-plugin'] === undefined) {
            document.createElement('cms-plugin');
            CKEDITOR.dtd['cms-plugin'] = CKEDITOR.dtd.div;
            CKEDITOR.dtd.$inline['cms-plugin'] = 1;
            // has to be here, otherwise extra <p> tags appear
            CKEDITOR.dtd.$nonEditable['cms-plugin'] = 1;
            CKEDITOR.dtd.$transparent['cms-plugin'] = 1;
            CKEDITOR.dtd.body['cms-plugin'] = 1;

            // add additional plugins (autoloads plugins.js)
            CKEDITOR.skin.addIcon('CMSPlugins', settings.static_url +
                '/icons/cmsplugins.svg');
            CKEDITOR.disableAutoInline = true
        };
        if (!(el.id in this._editors)) {
            if (el.tagName === 'TEXTAREA') {
                const editor = CKEDITOR.replace(el, all_options);
                this._editors[el.id] = editor;

                // Maximize editor if alone in modal
                if (inModal) {

                    setTimeout(() => editor.execCommand('maximize'), 300);
                }
            } else {
                const editor = CKEDITOR.inline(el, all_options);
                this._editors[el.id] = editor;
                el.addEventListener('blur', save_callback);
                editor.on('change', () => el.dataset.changed='true');
                // Let ckeditor first add its styles
                setTimeout(this._manageStyles, 200);
            }
        }
    },

    _manageStyles: function () {
        const styles = document.querySelectorAll('link[rel="stylesheet"][type="text/css"][href*="ckeditor4"]');
        if (styles.length > 0) {
            // Styles are installed in the document head, but we need to clone them
            // for later recovery
            styles.forEach((style) => {
                    if (cms_editor_plugin._CSS.indexOf(style) === -1) {
                        cms_editor_plugin._CSS.push(style.cloneNode(true));
                    }
                }
            );
        } else {
            cms_editor_plugin._CSS.forEach((style) => document.head.appendChild(style));
        }
    },

    // returns the edited html code
    getHTML: function(el) {
        return this._editors[el.id].getData();
    },

    // returns the edited content as json
    getJSON: function(el) {
        return undefined;
    },

    // destroy the editor
    destroyEditor: function(el) {
        this._editors[el.id].destroy();
        delete this._editors[el.id];
    }
};

})();

/******/ })()
;
//# sourceMappingURL=bundle.ckeditor4.min.js.map