"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyxetabase.rest_clients._parent_rest_clients import _ParentRestClient


class Admin(_ParentRestClient):
    """
    This class contains methods for the 'Admin' webservices
    PATH: /{apiVersion}/admin
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(Admin, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def group_by_audit(self, fields, entity, **options):
        """
        Group by operation.
        PATH: /{apiVersion}/admin/audit/groupBy

        :param str entity: Entity to be grouped by. Allowed values: ['AUDIT
            NOTE ORGANIZATION USER PROJECT STUDY FILE SAMPLE JOB INDIVIDUAL
            COHORT DISEASE_PANEL FAMILY CLINICAL_ANALYSIS INTERPRETATION
            VARIANT ALIGNMENT CLINICAL EXPRESSION RGA FUNCTIONAL WORKFLOW
            RESOURCE'] (REQUIRED)
        :param str fields: Comma separated list of fields by which to group
            by. (REQUIRED)
        :param bool count: Count the number of elements matching the group.
        :param int limit: Maximum number of documents (groups) to be returned.
        :param str action: Action performed.
        :param str before: Object before update.
        :param str after: Object after update.
        :param str date: Date <,<=,>,>=(Format: yyyyMMddHHmmss) and
            yyyyMMddHHmmss-yyyyMMddHHmmss.
        """

        options['fields'] = fields
        options['entity'] = entity
        return self._get(category='admin', resource='groupBy', subcategory='audit', **options)

    def install_catalog(self, data=None, **options):
        """
        Install OpenCGA database.
        PATH: /{apiVersion}/admin/catalog/install

        :param dict data: JSON containing the mandatory parameters. (REQUIRED)
        """

        return self._post(category='admin', resource='install', subcategory='catalog', data=data, **options)

    def jwt_catalog(self, data=None, **options):
        """
        Change JWT secret key.
        PATH: /{apiVersion}/admin/catalog/jwt

        :param dict data: JSON containing the parameters. (REQUIRED)
        :param str organization: Organization id.
        """

        return self._post(category='admin', resource='jwt', subcategory='catalog', data=data, **options)

    def fetch_resource(self, data=None, **options):
        """
        Fetch resources from the public server and save them into the OpenCGA
            local installation.
        PATH: /{apiVersion}/admin/resource/fetch

        :param dict data: Download-resources tool parameters. (REQUIRED)
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='admin', resource='fetch', subcategory='resource', data=data, **options)

    def create_users(self, data=None, **options):
        """
        Create a new user.
        PATH: /{apiVersion}/admin/users/create

        :param dict data: JSON containing the parameters. (REQUIRED)
        """

        return self._post(category='admin', resource='create', subcategory='users', data=data, **options)

    def import_users(self, data=None, **options):
        """
        Import users or a group of users from LDAP or AAD.
        PATH: /{apiVersion}/admin/users/import

        :param dict data: JSON containing the parameters. (REQUIRED)
        :param str organization: Organization id.
        """

        return self._post(category='admin', resource='import', subcategory='users', data=data, **options)

    def permissions_users(self, **options):
        """
        User permissions.
        PATH: /{apiVersion}/admin/users/permissions

        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str entry_ids: Comma separated list of entry ids.
        :param str permissions: Comma separated list of permissions to be
            retrieved.
        :param str category: Category corresponding to the id's provided.
        """

        return self._get(category='admin', resource='permissions', subcategory='users', **options)

    def search_users(self, **options):
        """
        User search method.
        PATH: /{apiVersion}/admin/users/search

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool count: Get the total number of results matching the query.
            Deactivated by default.
        :param str organization: Organization id.
        :param str user: User ID.
        :param str authentication_id: Authentication origin ID.
        """

        return self._get(category='admin', resource='search', subcategory='users', **options)

    def sync_users(self, data=None, **options):
        """
        Synchronise a group of users from an authentication origin with a
            group in a study from catalog.
        PATH: /{apiVersion}/admin/users/sync

        :param dict data: JSON containing the parameters. (REQUIRED)
        :param str organization: Organization id.
        """

        return self._post(category='admin', resource='sync', subcategory='users', data=data, **options)

    def users_update_groups(self, user, data=None, **options):
        """
        Add or remove users from existing groups.
        PATH: /{apiVersion}/admin/users/{user}/groups/update

        :param dict data: JSON containing the parameters. (REQUIRED)
        :param str user: User ID. (REQUIRED)
        :param str organization: Organization id.
        :param str action: Action to be performed: ADD or REMOVE user to/from
            groups. Allowed values: ['ADD REMOVE']
        """

        return self._post(category='admin/users', resource='update', query_id=user, subcategory='groups', data=data, **options)

