from dataclasses import dataclass


@dataclass
class FilterDefinition:
    name: str
    trusted: bool
    source: str


BUILTIN_FILTERS = [
    FilterDefinition(name="abs", trusted=True, source="jinja2"),
    FilterDefinition(name="attr", trusted=False, source="jinja2"),
    FilterDefinition(name="batch", trusted=False, source="jinja2"),
    FilterDefinition(name="capitalize", trusted=True, source="jinja2"),
    FilterDefinition(name="center", trusted=True, source="jinja2"),
    FilterDefinition(name="count", trusted=True, source="jinja2"),
    FilterDefinition(name="d", trusted=True, source="jinja2"),
    FilterDefinition(name="default", trusted=True, source="jinja2"),
    FilterDefinition(name="dictsort", trusted=False, source="jinja2"),
    FilterDefinition(name="e", trusted=True, source="jinja2"),
    FilterDefinition(name="escape", trusted=True, source="jinja2"),
    FilterDefinition(name="filesizeformat", trusted=True, source="jinja2"),
    FilterDefinition(name="first", trusted=True, source="jinja2"),
    FilterDefinition(name="float", trusted=True, source="jinja2"),
    FilterDefinition(name="forceescape", trusted=True, source="jinja2"),
    FilterDefinition(name="format", trusted=True, source="jinja2"),
    FilterDefinition(name="groupby", trusted=False, source="jinja2"),
    FilterDefinition(name="indent", trusted=True, source="jinja2"),
    FilterDefinition(name="int", trusted=True, source="jinja2"),
    FilterDefinition(name="items", trusted=False, source="jinja2"),
    FilterDefinition(name="join", trusted=True, source="jinja2"),
    FilterDefinition(name="last", trusted=True, source="jinja2"),
    FilterDefinition(name="length", trusted=True, source="jinja2"),
    FilterDefinition(name="list", trusted=True, source="jinja2"),
    FilterDefinition(name="lower", trusted=True, source="jinja2"),
    FilterDefinition(name="map", trusted=False, source="jinja2"),
    FilterDefinition(name="max", trusted=True, source="jinja2"),
    FilterDefinition(name="min", trusted=True, source="jinja2"),
    FilterDefinition(name="pprint", trusted=False, source="jinja2"),
    FilterDefinition(name="random", trusted=False, source="jinja2"),
    FilterDefinition(name="reject", trusted=False, source="jinja2"),
    FilterDefinition(name="rejectattr", trusted=False, source="jinja2"),
    FilterDefinition(name="replace", trusted=True, source="jinja2"),
    FilterDefinition(name="reverse", trusted=True, source="jinja2"),
    FilterDefinition(name="round", trusted=True, source="jinja2"),
    FilterDefinition(name="safe", trusted=False, source="jinja2"),
    FilterDefinition(name="select", trusted=False, source="jinja2"),
    FilterDefinition(name="selectattr", trusted=False, source="jinja2"),
    FilterDefinition(name="slice", trusted=True, source="jinja2"),
    FilterDefinition(name="sort", trusted=False, source="jinja2"),
    FilterDefinition(name="string", trusted=True, source="jinja2"),
    FilterDefinition(name="striptags", trusted=True, source="jinja2"),
    FilterDefinition(name="sum", trusted=True, source="jinja2"),
    FilterDefinition(name="title", trusted=True, source="jinja2"),
    FilterDefinition(name="tojson", trusted=False, source="jinja2"),
    FilterDefinition(name="trim", trusted=True, source="jinja2"),
    FilterDefinition(name="truncate", trusted=True, source="jinja2"),
    FilterDefinition(name="unique", trusted=False, source="jinja2"),
    FilterDefinition(name="upper", trusted=True, source="jinja2"),
    FilterDefinition(name="urlencode", trusted=True, source="jinja2"),
    FilterDefinition(name="urlize", trusted=False, source="jinja2"),
    FilterDefinition(name="wordcount", trusted=True, source="jinja2"),
    FilterDefinition(name="wordwrap", trusted=True, source="jinja2"),
    FilterDefinition(name="xmlattr", trusted=False, source="jinja2"),
]


NETUTILS_FILTERS = [
    FilterDefinition(name="abbreviated_interface_name", trusted=True, source="netutils"),
    FilterDefinition(name="abbreviated_interface_name_list", trusted=True, source="netutils"),
    FilterDefinition(name="asn_to_int", trusted=True, source="netutils"),
    FilterDefinition(name="bits_to_name", trusted=True, source="netutils"),
    FilterDefinition(name="bytes_to_name", trusted=True, source="netutils"),
    FilterDefinition(name="canonical_interface_name", trusted=True, source="netutils"),
    FilterDefinition(name="canonical_interface_name_list", trusted=True, source="netutils"),
    FilterDefinition(name="cidr_to_netmask", trusted=True, source="netutils"),
    FilterDefinition(name="cidr_to_netmaskv6", trusted=True, source="netutils"),
    FilterDefinition(name="clean_config", trusted=True, source="netutils"),
    FilterDefinition(name="compare_version_loose", trusted=True, source="netutils"),
    FilterDefinition(name="compare_version_strict", trusted=True, source="netutils"),
    FilterDefinition(name="config_compliance", trusted=True, source="netutils"),
    FilterDefinition(name="config_section_not_parsed", trusted=True, source="netutils"),
    FilterDefinition(name="delimiter_change", trusted=True, source="netutils"),
    FilterDefinition(name="diff_network_config", trusted=True, source="netutils"),
    FilterDefinition(name="feature_compliance", trusted=True, source="netutils"),
    FilterDefinition(name="find_unordered_cfg_lines", trusted=True, source="netutils"),
    FilterDefinition(name="fqdn_to_ip", trusted=False, source="netutils"),
    FilterDefinition(name="get_all_host", trusted=False, source="netutils"),
    FilterDefinition(name="get_broadcast_address", trusted=True, source="netutils"),
    FilterDefinition(name="get_first_usable", trusted=True, source="netutils"),
    FilterDefinition(name="get_ips_sorted", trusted=True, source="netutils"),
    FilterDefinition(name="get_nist_urls", trusted=True, source="netutils"),
    FilterDefinition(name="get_nist_vendor_platform_urls", trusted=True, source="netutils"),
    FilterDefinition(name="get_oui", trusted=True, source="netutils"),
    FilterDefinition(name="get_peer_ip", trusted=True, source="netutils"),
    FilterDefinition(name="get_range_ips", trusted=True, source="netutils"),
    FilterDefinition(name="get_upgrade_path", trusted=True, source="netutils"),
    FilterDefinition(name="get_usable_range", trusted=True, source="netutils"),
    FilterDefinition(name="hash_data", trusted=True, source="netutils"),
    FilterDefinition(name="int_to_asdot", trusted=True, source="netutils"),
    FilterDefinition(name="interface_range_compress", trusted=True, source="netutils"),
    FilterDefinition(name="interface_range_expansion", trusted=True, source="netutils"),
    FilterDefinition(name="ip_addition", trusted=True, source="netutils"),
    FilterDefinition(name="ip_subtract", trusted=True, source="netutils"),
    FilterDefinition(name="ip_to_bin", trusted=True, source="netutils"),
    FilterDefinition(name="ip_to_hex", trusted=True, source="netutils"),
    FilterDefinition(name="ipaddress_address", trusted=True, source="netutils"),
    FilterDefinition(name="ipaddress_interface", trusted=True, source="netutils"),
    FilterDefinition(name="ipaddress_network", trusted=True, source="netutils"),
    FilterDefinition(name="is_classful", trusted=True, source="netutils"),
    FilterDefinition(name="is_fqdn_resolvable", trusted=False, source="netutils"),
    FilterDefinition(name="is_ip", trusted=True, source="netutils"),
    FilterDefinition(name="is_ip_range", trusted=True, source="netutils"),
    FilterDefinition(name="is_ip_within", trusted=True, source="netutils"),
    FilterDefinition(name="is_netmask", trusted=True, source="netutils"),
    FilterDefinition(name="is_network", trusted=True, source="netutils"),
    FilterDefinition(name="is_reversible_wildcardmask", trusted=True, source="netutils"),
    FilterDefinition(name="is_valid_mac", trusted=True, source="netutils"),
    FilterDefinition(name="longest_prefix_match", trusted=True, source="netutils"),
    FilterDefinition(name="mac_normalize", trusted=True, source="netutils"),
    FilterDefinition(name="mac_to_format", trusted=True, source="netutils"),
    FilterDefinition(name="mac_to_int", trusted=True, source="netutils"),
    FilterDefinition(name="mac_type", trusted=True, source="netutils"),
    FilterDefinition(name="name_to_bits", trusted=True, source="netutils"),
    FilterDefinition(name="name_to_bytes", trusted=True, source="netutils"),
    FilterDefinition(name="name_to_name", trusted=True, source="netutils"),
    FilterDefinition(name="netmask_to_cidr", trusted=True, source="netutils"),
    FilterDefinition(name="netmask_to_wildcardmask", trusted=True, source="netutils"),
    FilterDefinition(name="normalise_delimiter_caret_c", trusted=True, source="netutils"),
    FilterDefinition(name="paloalto_panos_brace_to_set", trusted=True, source="netutils"),
    FilterDefinition(name="paloalto_panos_clean_newlines", trusted=True, source="netutils"),
    FilterDefinition(name="regex_findall", trusted=False, source="netutils"),
    FilterDefinition(name="regex_match", trusted=False, source="netutils"),
    FilterDefinition(name="regex_search", trusted=False, source="netutils"),
    FilterDefinition(name="regex_split", trusted=False, source="netutils"),
    FilterDefinition(name="regex_sub", trusted=False, source="netutils"),
    FilterDefinition(name="sanitize_config", trusted=True, source="netutils"),
    FilterDefinition(name="section_config", trusted=True, source="netutils"),
    FilterDefinition(name="sort_interface_list", trusted=True, source="netutils"),
    FilterDefinition(name="split_interface", trusted=True, source="netutils"),
    FilterDefinition(name="uptime_seconds_to_string", trusted=True, source="netutils"),
    FilterDefinition(name="uptime_string_to_seconds", trusted=True, source="netutils"),
    FilterDefinition(name="version_metadata", trusted=True, source="netutils"),
    FilterDefinition(name="vlanconfig_to_list", trusted=True, source="netutils"),
    FilterDefinition(name="vlanlist_to_config", trusted=True, source="netutils"),
    FilterDefinition(name="wildcardmask_to_netmask", trusted=True, source="netutils"),
]


AVAILABLE_FILTERS = BUILTIN_FILTERS + NETUTILS_FILTERS
