# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/HumanBrainProject/openMINDS/3fa86f956b407b2debf47c2e1b6314e37579c707/v3/SANDS/v3/atlas/commonCoordinateSpace.schema.json

from datetime import date
from typing import Any, Dict, List, Optional

from pydantic import Field
from siibra.openminds.base import SiibraBaseModel


class AxesOrigin(SiibraBaseModel):
    type_of_uncertainty: Optional[Any] = Field(
        None,
        alias='typeOfUncertainty',
        description='Distinct technique used to quantify the uncertainty of a measurement.',
        title='typeOfUncertainty',
    )
    uncertainty: Optional[List[float]] = Field(
        None,
        description='Quantitative value range defining the uncertainty of a measurement.',
        max_items=2,
        min_items=2,
        title='uncertainty',
    )
    unit: Optional[Any] = Field(
        None,
        description='Determinate quantity adopted as a standard of measurement.',
        title='unit',
    )
    value: float = Field(..., description='Entry for a property.', title='value')


class Model(SiibraBaseModel):
    id: str = Field(..., alias='@id', description='Metadata node identifier.')
    type: str = Field(..., alias='@type')
    anatomical_axes_orientation: Dict[str, Any] = Field(
        ...,
        alias='anatomicalAxesOrientation',
        description='Relation between reference planes used in anatomy and mathematics.',
        title='anatomicalAxesOrientation',
    )
    axes_origin: List['AxesOrigin'] = Field(
        ...,
        alias='axesOrigin',
        description='Structured information on a quantitative value.',
    )
    default_image: Optional[List[Any]] = Field(
        None,
        alias='defaultImage',
        description='Two or three dimensional image that particluarly represents a specific coordinate space.',
        min_items=1,
        title='defaultImage',
    )
    digital_identifier: Optional[Dict[str, Any]] = Field(
        None,
        alias='digitalIdentifier',
        description='Digital handle to identify objects or legal persons.',
        title='digitalIdentifier',
    )
    full_name: str = Field(
        ...,
        alias='fullName',
        description='Whole, non-abbreviated name of something or somebody.',
        title='fullName',
    )
    homepage: Optional[Dict[str, Any]] = Field(
        None,
        alias='homepage',
        description='Main website of something or someone.',
        title='homepage',
    )
    how_to_cite: Optional[str] = Field(
        None,
        alias='howToCite',
        description='Preferred format for citing a particular object or legal person.',
        title='howToCite',
    )
    native_unit: Dict[str, Any] = Field(
        ...,
        alias='nativeUnit',
        description='Determinate quantity used in the original measurement.',
        title='nativeUnit',
    )
    ontology_identifier: Optional[List[str]] = Field(
        None,
        alias='ontologyIdentifier',
        description='Term or code used to identify something or someone registered within a particular ontology.',
        min_items=1,
        title='ontologyIdentifier',
    )
    release_date: date = Field(
        ...,
        alias='releaseDate',
        description='Fixed date on which a product is due to become or was made available for the general public to see or buy',
        title='releaseDate',
    )
    short_name: str = Field(
        ...,
        alias='shortName',
        description='Shortened or fully abbreviated name of something or somebody.',
        title='shortName',
    )
    version_identifier: str = Field(
        ...,
        alias='versionIdentifier',
        description='Term or code used to identify the version of something.',
        title='versionIdentifier',
    )
