# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/HumanBrainProject/openMINDS/3fa86f956b407b2debf47c2e1b6314e37579c707/v3/core/v4/research/protocolExecution.schema.json

from typing import Any, Dict, List, Optional, Union

from pydantic import Field
from siibra.openminds.base import SiibraBaseModel


class ValueItem(SiibraBaseModel):
    type_of_uncertainty: Optional[Any] = Field(
        None,
        alias='typeOfUncertainty',
        description='Distinct technique used to quantify the uncertainty of a measurement.',
        title='typeOfUncertainty',
    )
    uncertainty: Optional[List[float]] = Field(
        None,
        description='Quantitative value range defining the uncertainty of a measurement.',
        max_items=2,
        min_items=2,
        title='uncertainty',
    )
    unit: Optional[Any] = Field(
        None,
        description='Determinate quantity adopted as a standard of measurement.',
        title='unit',
    )
    value: float = Field(..., description='Entry for a property.', title='value')


class ValueItem1(SiibraBaseModel):
    max_value: float = Field(
        ...,
        alias='maxValue',
        description='Greatest quantity attained or allowed.',
        title='maxValue',
    )
    max_value_unit: Optional[Any] = Field(
        None, alias='maxValueUnit', title='maxValueUnit'
    )
    min_value: float = Field(
        ...,
        alias='minValue',
        description='Smallest quantity attained or allowed.',
        title='minValue',
    )
    min_value_unit: Optional[Any] = Field(
        None, alias='minValueUnit', title='minValueUnit'
    )


class ParameterItem(SiibraBaseModel):
    name: str = Field(
        ...,
        description='Word or phrase that constitutes the distinctive designation of a being or thing.',
        title='name',
    )
    value: Union['ValueItem', 'ValueItem1']


class ParameterItem1(SiibraBaseModel):
    name: str = Field(
        ...,
        description='Word or phrase that constitutes the distinctive designation of a being or thing.',
        title='name',
    )
    value: str = Field(..., description='Entry for a property.', title='value')


class ParameterSet(SiibraBaseModel):
    context: str = Field(..., title='context')
    parameter: Union['ParameterItem', 'ParameterItem1']
    relevant_for: Any = Field(
        ...,
        alias='relevantFor',
        description='Reference to what or whom something or someone bears siginificance.',
        title='relevantFor',
    )


class Model(SiibraBaseModel):
    id: str = Field(..., alias='@id', description='Metadata node identifier.')
    type: str = Field(..., alias='@type')
    behavioral_protocol: Optional[List[Any]] = Field(
        None,
        alias='behavioralProtocol',
        min_items=1,
        title='behavioralProtocol',
    )
    description: Optional[str] = Field(
        None,
        alias='description',
        description='Longer statement or account giving the characteristics of someone or something.',
        title='description',
    )
    ended_at_time: Optional[Union[Any, Any]] = Field(
        None,
        alias='endedAtTime',
        title='endedAtTime',
    )
    input: List[Any] = Field(
        ...,
        alias='input',
        description='Something or someone that is put into or participates in a process or machine.',
        min_items=1,
        title='input',
    )
    is_part_of: Dict[str, Any] = Field(
        ...,
        alias='isPartOf',
        description='Reference to the ensemble of multiple things or beings.',
        title='isPartOf',
    )
    lookup_label: Optional[str] = Field(
        None,
        alias='lookupLabel',
        title='lookupLabel',
    )
    output: List[Any] = Field(
        ...,
        alias='output',
        description='Something or someone that comes out of, is delivered or produced by a process or machine.',
        min_items=1,
        title='output',
    )
    parameter_set: Optional['ParameterSet'] = Field(
        None,
        alias='parameterSet',
        description='Structured information on a used parameter set.',
    )
    preparation_design: Optional[Dict[str, Any]] = Field(
        None,
        alias='preparationDesign',
        title='preparationDesign',
    )
    protocol: List[Any] = Field(
        ...,
        alias='protocol',
        description='Plan that describes the process of a scientific or medical experiment, treatment, or procedure.',
        min_items=1,
        title='protocol',
    )
    started_at_time: Optional[Union[Any, Any]] = Field(
        None,
        alias='startedAtTime',
        title='startedAtTime',
    )
    study_target: Optional[List[Any]] = Field(
        None,
        alias='studyTarget',
        description='Structure or function that was targeted within a study.',
        min_items=1,
        title='studyTarget',
    )
