# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/HumanBrainProject/openMINDS/3fa86f956b407b2debf47c2e1b6314e37579c707/v3/core/v4/research/strain.schema.json

from typing import Any, Dict, List, Optional

from pydantic import Field, constr
from siibra.openminds.base import SiibraBaseModel


class StockNumber(SiibraBaseModel):
    identifier: str = Field(
        ...,
        description='Term or code used to identify something or someone.',
        title='identifier',
    )
    vendor: Any = Field(..., title='vendor')


class Model(SiibraBaseModel):
    id: str = Field(..., alias='@id', description='Metadata node identifier.')
    type: str = Field(..., alias='@type')
    rrid: Optional[Dict[str, Any]] = Field(
        None, alias='RRID', title='RRID'
    )
    background_strain: Optional[List[Any]] = Field(
        None,
        alias='backgroundStrain',
        max_items=2,
        min_items=1,
        title='backgroundStrain',
    )
    breeding_type: Optional[Dict[str, Any]] = Field(
        None,
        alias='breedingType',
        title='breedingType',
    )
    description: Optional[str] = Field(
        None,
        alias='description',
        description='Longer statement or account giving the characteristics of someone or something.',
        title='description',
    )
    disease_model: Optional[List[Any]] = Field(
        None,
        alias='diseaseModel',
        min_items=1,
        title='diseaseModel',
    )
    genetic_strain_type: Dict[str, Any] = Field(
        ...,
        alias='geneticStrainType',
        title='geneticStrainType',
    )
    identifier: Optional[List[str]] = Field(
        None,
        alias='identifier',
        description='Term or code used to identify something or someone.',
        min_items=1,
        title='identifier',
    )
    laboratory_code: Optional[constr(regex=r'^[A-Z]([a-z]?)+$')] = Field(
        None,
        alias='laboratoryCode',
        title='laboratoryCode',
    )
    name: str = Field(
        ...,
        alias='name',
        description='Word or phrase that constitutes the distinctive designation of a being or thing.',
        title='name',
    )
    ontology_identifier: Optional[List[str]] = Field(
        None,
        alias='ontologyIdentifier',
        description='Term or code used to identify something or someone registered within a particular ontology.',
        min_items=1,
        title='ontologyIdentifier',
    )
    phenotype: Optional[str] = Field(
        None,
        alias='phenotype',
        description='Physical expression of one or more genes of an organism.',
        title='phenotype',
    )
    species: Optional[Dict[str, Any]] = Field(
        None,
        alias='species',
        description='Category of biological classification comprising related organisms or populations potentially capable of interbreeding, and being designated by a binomial that consists of the name of a genus followed by a Latin or latinized uncapitalized noun or adjective.',
        title='species',
    )
    stock_number: Optional['StockNumber'] = Field(
        None, alias='stockNumber'
    )
    synonym: Optional[List[str]] = Field(
        None,
        alias='synonym',
        description='Words or expressions used in the same language that have the same or nearly the same meaning in some or all senses.',
        min_items=1,
        title='synonym',
    )
