__version__ = "1.0.0"

from .datasets import generate_fc_matrices

from .eeg_utils import (
    read_from_eeg_dataframe,
    reshape_eeg_data,
    inverse_reshape_eeg_data,
    EEGData,
    Electrodes,
    Bands,
    PairsElectrodes1020
)
from .nbs_utils import nbs_bct
from .pairwise_tfns import (
    compute_p_val, 
    compute_null_dist, 
    compute_permute_t_stat_ind,
    compute_permute_t_stat_diff, 
    compute_t_stat_tfnos, 
    compute_t_stat_tfnos_diffs, 
    compute_t_stat, 
    compute_diffs, 
    compute_t_stat_diff, 
    compute_t_stat_ind)

from .tfnos import get_tfce_score, get_tfce_score_scipy
from .utils import fisher_r_to_z, fisher_z_to_r, get_components, binarize

#__all__ = ['nbs_bct', 'compute_p_val', 'compute_t_stat_diff']