#
# MUSIC𝄞NTWRK
#
# A python library for pitch class set and rhythmic sequences classification and manipulation,
# the generation of networks in generalized music and sound spaces, and the sonification of arbitrary data
#
# Copyright (C) 2018 Marco Buongiorno Nardelli
# http://www.materialssoundmusic.com, mbn@unt.edu
#
# This file is distributed under the terms of the
# GNU General Public License. See the file `License'
# in the root directory of the present distribution,
# or http://www.gnu.org/copyleft/gpl.txt .
#

import time,re
import numpy as np
import itertools as iter
import pandas as pd
import music21 as m21

from ..musicntwrk import PCSet
from ..utils.minimalDistance import minimalDistance

def vLeadNetwork(dictionary,thup,thdw,distance,prob,write,pcslabel,TET):
    
    '''
    •	generation of the network of all minimal voice leadings in a generalized musical space of TET pitches – based on the minimal distance operators
    •	input_csv (str)– file containing the dictionary generated by pcsNetwork
    •	thup, thdw (float)– upper and lower thresholds for edge creation
    •	write (logical) – if True it writes the nodes.csv and edges.csv files in csv format
    •	returns nodes and edges tables as pandas DataFrames
    '''

    # Create network of minimal voice leadings from the pcsDictionary
    
    df = np.asarray(dictionary)

    # write csv for nodes
    if pcslabel:
        dnodes = pd.DataFrame(None,columns=['Label'])
        for n in range(len(df)):
            p = PCSet(np.asarray(list(map(int,re.findall('\d+',df[n,1])))))
            if p.pcs.shape[0] == 1:
                nn = ''.join(m21.chord.Chord(p.pcs.tolist()).pitchNames)
            else:
                nn = ''.join(m21.chord.Chord(p.normalOrder().tolist()).pitchNames)
            nameseq = pd.DataFrame([[str(nn)]],columns=['Label'])
            dnodes = pd.concat([dnodes,nameseq],ignore_index=True)
    else:
        dnodes = pd.DataFrame(df[:,0],columns=['Label'])
    if write: dnodes.to_csv('nodes.csv',index=False)
    
    # find edges according to a metric - allows for non-bijective voice leading
    N = df[:,1].shape[0]
    dedges = pd.DataFrame(None,columns=['Source','Target','Weight'])
    np.random.seed(int(time.process_time()*10000))
    for i in range(N):
        vector_i  = np.asarray(list(map(int,re.findall('\d+',df[i,1]))))
        for j in range(i,N):
            vector_j  = np.asarray(list(map(int,re.findall('\d+',df[j,1]))))
            if vector_i.shape[0] == vector_j.shape[0]:
                pair,_ = minimalDistance(vector_i,vector_j,TET,distance)
            else:
                if vector_i.shape[0] > vector_j.shape[0]:
                    a = vector_i 
                    b = vector_j
                else:
                    b = vector_i 
                    a = vector_j
                ndif = np.sort(np.array([a.shape[0],b.shape[0]]))[1] - np.sort(np.array([a.shape[0],b.shape[0]]))[0]
                c = np.asarray(list(iter.combinations_with_replacement(b,ndif)))
                r = np.zeros((c.shape[0],a.shape[0]))
                for l in range(c.shape[0]):
                    r[l,:b.shape[0]] = b
                    r[l,b.shape[0]:] = c[l]
                dist = np.zeros(r.shape[0])
                for l in range(r.shape[0]):
                    dist[l],_ = minimalDistance(a,r[l])
                pair = min(dist)
            if pair <= thup and pair >= thdw:
                if prob == 1:
                    tmp = pd.DataFrame([[str(i),str(j),str(1/pair)]],columns=['Source','Target','Weight'])
                    dedges = pd.concat([dedges,tmp],ignore_index=True)
                else:
                    r = np.random.rand()
                    if r <= prob:
                        tmp = pd.DataFrame([[str(i),str(j),str(1/pair)]],columns=['Source','Target','Weight'])
                        dedges = pd.concat([dedges,tmp],ignore_index=True)
                    else:
                        pass

    # write csv for edges
    if write: dedges.to_csv('edges.csv',index=False)
    
    return(dnodes,dedges)
