import pybirdsreynolds.const as const

ARROWS_ACTIVATED = 1

SELECTED_INDEX = 0
PARAM_ORDER_IHM = None

# PARAMS


NUM_BIRDS_ACTIVATED = 2
NUM_BIRDS_DOC = "Number of birds"
NUM_BIRDS_DEFAULT = 500
NUM_BIRDS = 500
NUM_BIRDS_MIN = 1
NUM_BIRDS_MAX = 2000
NUM_BIRDS_FREE_MIN = 1
NUM_BIRDS_FREE_MAX = None

COH_WEIGHT_ACTIVATED = 2
COH_WEIGHT_DOC = "Cohesion weight"
COH_WEIGHT_DEFAULT = 1
COH_WEIGHT = 1
COH_WEIGHT_MIN = 0
COH_WEIGHT_MAX = 10
COH_WEIGHT_FREE_MIN = None
COH_WEIGHT_FREE_MAX = None

ALIGN_WEIGHT_ACTIVATED = 2
ALIGN_WEIGHT_DOC = "Alignment weight"
ALIGN_WEIGHT_DEFAULT = 2
ALIGN_WEIGHT = 2
ALIGN_WEIGHT_MIN = 0
ALIGN_WEIGHT_MAX = 10
ALIGN_WEIGHT_FREE_MIN = None
ALIGN_WEIGHT_FREE_MAX = None

SEP_WEIGHT_ACTIVATED = 2
SEP_WEIGHT_DOC = "Separation weight"
SEP_WEIGHT_DEFAULT = 3
SEP_WEIGHT = 3
SEP_WEIGHT_MIN = 0
SEP_WEIGHT_MAX = 10
SEP_WEIGHT_FREE_MIN = None
SEP_WEIGHT_FREE_MAX = None

NEIGHBOR_RADIUS_ACTIVATED = 2
NEIGHBOR_RADIUS_DOC = "Distance to detect neighbors"
NEIGHBOR_RADIUS_DEFAULT = 50
NEIGHBOR_RADIUS = 50
NEIGHBOR_RADIUS_MIN = 0
NEIGHBOR_RADIUS_MAX = None
NEIGHBOR_RADIUS_FREE_MIN = 0
NEIGHBOR_RADIUS_FREE_MAX = None

WIDTH_ACTIVATED = 2
WIDTH_DOC = "Box width"
WIDTH_DEFAULT = 1000
WIDTH = 1000
WIDTH_MIN = 200
WIDTH_MAX = None
WIDTH_FREE_MIN = 200
WIDTH_FREE_MAX = None

HEIGHT_ACTIVATED = 2
HEIGHT_DOC = "Box height"
HEIGHT_DEFAULT = 600
HEIGHT = 600
HEIGHT_MIN = 600
HEIGHT_MAX = None
HEIGHT_FREE_MIN = 600
HEIGHT_FREE_MAX = None

MAX_SPEED_ACTIVATED = 2
MAX_SPEED_DOC = "Maximum speed of birds"
MAX_SPEED_DEFAULT = 5
MAX_SPEED = 5
MAX_SPEED_MIN = 0
MAX_SPEED_MAX = 100
MAX_SPEED_FREE_MIN = 0
MAX_SPEED_FREE_MAX = 100

RANDOM_SPEED_ACTIVATED = 2
RANDOM_SPEED_DOC = "Random speed variation ratio in percentage"
RANDOM_SPEED_DEFAULT = 3
RANDOM_SPEED = 3
RANDOM_SPEED_MIN = 0
RANDOM_SPEED_MAX = 10
RANDOM_SPEED_FREE_MIN = 0
RANDOM_SPEED_FREE_MAX = None

RANDOM_ANGLE_ACTIVATED = 2
RANDOM_ANGLE_DOC = "Random angle variation in degrees"
RANDOM_ANGLE_DEFAULT = 3
RANDOM_ANGLE = 3
RANDOM_ANGLE_MIN = 0
RANDOM_ANGLE_MAX = 10
RANDOM_ANGLE_FREE_MIN = None
RANDOM_ANGLE_FREE_MAX = None

REFRESH_MS_ACTIVATED = 2
REFRESH_MS_DOC = "Refresh interval in milliseconds"
REFRESH_MS_DEFAULT = 1
REFRESH_MS = 1
REFRESH_MS_MIN = 1
REFRESH_MS_MAX = 100
REFRESH_MS_FREE_MIN = 1
REFRESH_MS_FREE_MAX = None

SIZE_ACTIVATED = 2
SIZE_DOC = "Visual size of birds"
SIZE_DEFAULT = 2
SIZE = 2
SIZE_MIN = 1
SIZE_MAX = 3
SIZE_FREE_MIN = 1
SIZE_FREE_MAX = None

TRIANGLES_ACTIVATED = 2
TRIANGLES_DOC = "Render birds as triangles instead of points"
TRIANGLES_DEFAULT = False
TRIANGLES = False

COLOR_ACTIVATED = 2
COLOR_DOC = "Enable colors"
COLOR_DEFAULT = False
COLOR = False

FONT_TYPE_ACTIVATED = 2
FONT_TYPE_DEFAULT = "Nota Sans Mono"
FONT_TYPE = "Nota Sans Mono"
FONT_TYPE_DOC = "Font"

FONT_SIZE_ACTIVATED = 2
FONT_SIZE_DOC = "Font Size"
FONT_SIZE_DEFAULT = 12
FONT_SIZE = 12
FONT_SIZE_MIN = 11
FONT_SIZE_MAX = 13
FONT_SIZE_FREE_MIN = 11
FONT_SIZE_FREE_MAX = 13

FREE_ACTIVATED = 2
FREE_DOC = "Remove parameter limits"
FREE_DEFAULT = False
FREE = False

# CONTROLS
TOGGLE_START_PAUSE_ACTIVATED = 2
TOGGLE_START_PAUSE_ICON = "⏯"
TOGGLE_START_PAUSE_TEXT = "Toggle start / stop"
TOGGLE_START_PAUSE_COMMAND = "p"

NEXT_FRAME_ACTIVATED = 2
NEXT_FRAME_ICON = "⏭"
NEXT_FRAME_TEXT = "Next frame"
NEXT_FRAME_COMMAND = "n"

REGENERATION_ACTIVATED = 2
REGENERATION_ICON = "🐦"
REGENERATION_COMMAND = "b"
REGENERATION_TEXT = "New generation of birds"

RESET_ACTIVATED = 2
RESET_ICON = "⟳"
RESET_TEXT = "Reset all params"
RESET_COMMAND = "r"

TOGGLE_FPS_ACTIVATED = 2
TOGGLE_FPS_ICON = "⏱"
TOGGLE_FPS_TEXT = "Toggle FPS display"
TOGGLE_FPS_COMMAND = "f"

AVERAGE_ACTIVATED = 2
AVERAGE_ICON = "μ"
AVERAGE_TEXT = "Display average position of birds"
AVERAGE_COMMAND = "a"

TOGGLE_MAXIMIZE_ACTIVATED = 2
TOGGLE_MAXIMIZE_ICON = "🗖"
TOGGLE_MAXIMIZE_TEXT = "Maximize/Minimize"
TOGGLE_MAXIMIZE_COMMAND = "m"

HIDE_ACTIVATED = 2
HIDE_ICON = "👁"
HIDE_TEXT = "Hide Params and Controls"
HIDE_COMMAND = "h"

DOC_ACTIVATED = 2
DOC_ICON = "?"
DOC_TEXT = "Open/Close the documentation"
DOC_COMMAND = "d"

SHIFT_ACTIVATED = 1
SHIFT_ICON = "⇧"
SHIFT_TEXT = "With <LEFT>/<RIGHT> Adjust param by ±10 instead of ±1"
SHIFT_COMMAND = "<SHIFT>"

UP_ACTIVATED = ARROWS_ACTIVATED
UP_ICON = "⬆️"
UP_TEXT = "Navigate params"
UP_COMMAND = "<UP>"

DOWN_ACTIVATED = ARROWS_ACTIVATED
DOWN_ICON = "⬇️"
DOWN_TEXT = "Navigate params"
DOWN_COMMAND = "<DOWN>"

LEFT_ACTIVATED = ARROWS_ACTIVATED
LEFT_ICON = "⬅️"
LEFT_TEXT = "Adjust param (-1)"
LEFT_COMMAND = "<LEFT>"

RIGHT_ACTIVATED = ARROWS_ACTIVATED
RIGHT_ICON = "➡️"
RIGHT_TEXT = "Adjust param (+1)"
RIGHT_COMMAND = "<RIGHT>"
