# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AccessCustomPageArgs', 'AccessCustomPage']

@pulumi.input_type
class AccessCustomPageArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 app_count: Optional[pulumi.Input[int]] = None,
                 custom_html: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AccessCustomPage resource.
        :param pulumi.Input[str] name: Friendly name of the Access Custom Page configuration.
        :param pulumi.Input[str] type: Type of Access custom page to create. Available values: `identity_denied`, `forbidden`.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] app_count: Number of apps to display on the custom page.
        :param pulumi.Input[str] custom_html: Custom HTML to display on the custom page.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`. **Modifying this attribute will force creation of a new resource.**
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if app_count is not None:
            pulumi.set(__self__, "app_count", app_count)
        if custom_html is not None:
            pulumi.set(__self__, "custom_html", custom_html)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Friendly name of the Access Custom Page configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of Access custom page to create. Available values: `identity_denied`, `forbidden`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="appCount")
    def app_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of apps to display on the custom page.
        """
        return pulumi.get(self, "app_count")

    @app_count.setter
    def app_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_count", value)

    @property
    @pulumi.getter(name="customHtml")
    def custom_html(self) -> Optional[pulumi.Input[str]]:
        """
        Custom HTML to display on the custom page.
        """
        return pulumi.get(self, "custom_html")

    @custom_html.setter
    def custom_html(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_html", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _AccessCustomPageState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 app_count: Optional[pulumi.Input[int]] = None,
                 custom_html: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccessCustomPage resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] app_count: Number of apps to display on the custom page.
        :param pulumi.Input[str] custom_html: Custom HTML to display on the custom page.
        :param pulumi.Input[str] name: Friendly name of the Access Custom Page configuration.
        :param pulumi.Input[str] type: Type of Access custom page to create. Available values: `identity_denied`, `forbidden`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`. **Modifying this attribute will force creation of a new resource.**
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if app_count is not None:
            pulumi.set(__self__, "app_count", app_count)
        if custom_html is not None:
            pulumi.set(__self__, "custom_html", custom_html)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="appCount")
    def app_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of apps to display on the custom page.
        """
        return pulumi.get(self, "app_count")

    @app_count.setter
    def app_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_count", value)

    @property
    @pulumi.getter(name="customHtml")
    def custom_html(self) -> Optional[pulumi.Input[str]]:
        """
        Custom HTML to display on the custom page.
        """
        return pulumi.get(self, "custom_html")

    @custom_html.setter
    def custom_html(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_html", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the Access Custom Page configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of Access custom page to create. Available values: `identity_denied`, `forbidden`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class AccessCustomPage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 app_count: Optional[pulumi.Input[int]] = None,
                 custom_html: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to customize the pages your end users will see
        when trying to reach applications behind Cloudflare Access.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.AccessCustomPage("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            name="example",
            type="forbidden",
            custom_html="<html><body><h1>Forbidden</h1></body></html>")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] app_count: Number of apps to display on the custom page.
        :param pulumi.Input[str] custom_html: Custom HTML to display on the custom page.
        :param pulumi.Input[str] name: Friendly name of the Access Custom Page configuration.
        :param pulumi.Input[str] type: Type of Access custom page to create. Available values: `identity_denied`, `forbidden`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessCustomPageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to customize the pages your end users will see
        when trying to reach applications behind Cloudflare Access.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.AccessCustomPage("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            name="example",
            type="forbidden",
            custom_html="<html><body><h1>Forbidden</h1></body></html>")
        ```

        :param str resource_name: The name of the resource.
        :param AccessCustomPageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessCustomPageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 app_count: Optional[pulumi.Input[int]] = None,
                 custom_html: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessCustomPageArgs.__new__(AccessCustomPageArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["app_count"] = app_count
            __props__.__dict__["custom_html"] = custom_html
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["zone_id"] = zone_id
        super(AccessCustomPage, __self__).__init__(
            'cloudflare:index/accessCustomPage:AccessCustomPage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            app_count: Optional[pulumi.Input[int]] = None,
            custom_html: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'AccessCustomPage':
        """
        Get an existing AccessCustomPage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] app_count: Number of apps to display on the custom page.
        :param pulumi.Input[str] custom_html: Custom HTML to display on the custom page.
        :param pulumi.Input[str] name: Friendly name of the Access Custom Page configuration.
        :param pulumi.Input[str] type: Type of Access custom page to create. Available values: `identity_denied`, `forbidden`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessCustomPageState.__new__(_AccessCustomPageState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["app_count"] = app_count
        __props__.__dict__["custom_html"] = custom_html
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        __props__.__dict__["zone_id"] = zone_id
        return AccessCustomPage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="appCount")
    def app_count(self) -> pulumi.Output[Optional[int]]:
        """
        Number of apps to display on the custom page.
        """
        return pulumi.get(self, "app_count")

    @property
    @pulumi.getter(name="customHtml")
    def custom_html(self) -> pulumi.Output[Optional[str]]:
        """
        Custom HTML to display on the custom page.
        """
        return pulumi.get(self, "custom_html")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Friendly name of the Access Custom Page configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of Access custom page to create. Available values: `identity_denied`, `forbidden`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

