# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ContentScanningExpressionArgs', 'ContentScanningExpression']

@pulumi.input_type
class ContentScanningExpressionArgs:
    def __init__(__self__, *,
                 payload: pulumi.Input[str],
                 zone_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ContentScanningExpression resource.
        :param pulumi.Input[str] payload: Custom scan expression to tell the content scanner where to find the content objects.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        pulumi.set(__self__, "payload", payload)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def payload(self) -> pulumi.Input[str]:
        """
        Custom scan expression to tell the content scanner where to find the content objects.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: pulumi.Input[str]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ContentScanningExpressionState:
    def __init__(__self__, *,
                 payload: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ContentScanningExpression resources.
        :param pulumi.Input[str] payload: Custom scan expression to tell the content scanner where to find the content objects.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[str]]:
        """
        Custom scan expression to tell the content scanner where to find the content objects.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class ContentScanningExpression(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 payload: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Content Scanning Expression resource for managing custom scan expression within a specific zone.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # Enable Content Scanning before trying to add custom scan expressions
        example = cloudflare.ContentScanning("example",
            zone_id="399c6f4950c01a5a141b99ff7fbcbd8b",
            enabled=True)
        first_example = cloudflare.ContentScanningExpression("first_example",
            zone_id=example.zone_id,
            payload="lookup_json_string(http.request.body.raw, \\"file\\")")
        second_example = cloudflare.ContentScanningExpression("second_example",
            zone_id=example.zone_id,
            payload="lookup_json_string(http.request.body.raw, \\"document\\")")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/contentScanningExpression:ContentScanningExpression example <zone_id>/<resource_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] payload: Custom scan expression to tell the content scanner where to find the content objects.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContentScanningExpressionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Content Scanning Expression resource for managing custom scan expression within a specific zone.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # Enable Content Scanning before trying to add custom scan expressions
        example = cloudflare.ContentScanning("example",
            zone_id="399c6f4950c01a5a141b99ff7fbcbd8b",
            enabled=True)
        first_example = cloudflare.ContentScanningExpression("first_example",
            zone_id=example.zone_id,
            payload="lookup_json_string(http.request.body.raw, \\"file\\")")
        second_example = cloudflare.ContentScanningExpression("second_example",
            zone_id=example.zone_id,
            payload="lookup_json_string(http.request.body.raw, \\"document\\")")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/contentScanningExpression:ContentScanningExpression example <zone_id>/<resource_id>
        ```

        :param str resource_name: The name of the resource.
        :param ContentScanningExpressionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContentScanningExpressionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 payload: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContentScanningExpressionArgs.__new__(ContentScanningExpressionArgs)

            if payload is None and not opts.urn:
                raise TypeError("Missing required property 'payload'")
            __props__.__dict__["payload"] = payload
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(ContentScanningExpression, __self__).__init__(
            'cloudflare:index/contentScanningExpression:ContentScanningExpression',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            payload: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'ContentScanningExpression':
        """
        Get an existing ContentScanningExpression resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] payload: Custom scan expression to tell the content scanner where to find the content objects.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContentScanningExpressionState.__new__(_ContentScanningExpressionState)

        __props__.__dict__["payload"] = payload
        __props__.__dict__["zone_id"] = zone_id
        return ContentScanningExpression(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def payload(self) -> pulumi.Output[str]:
        """
        Custom scan expression to tell the content scanner where to find the content objects.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

