# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDcvDelegationResult',
    'AwaitableGetDcvDelegationResult',
    'get_dcv_delegation',
    'get_dcv_delegation_output',
]

@pulumi.output_type
class GetDcvDelegationResult:
    """
    A collection of values returned by getDcvDelegation.
    """
    def __init__(__self__, hostname=None, id=None, zone_id=None):
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The DCV Delegation hostname
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The DCV Delegation unique identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetDcvDelegationResult(GetDcvDelegationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDcvDelegationResult(
            hostname=self.hostname,
            id=self.id,
            zone_id=self.zone_id)


def get_dcv_delegation(zone_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDcvDelegationResult:
    """
    Use this data source to retrieve the DCV Delegation unique identifier for a zone.


    :param str zone_id: The zone identifier to target for the resource.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getDcvDelegation:getDcvDelegation', __args__, opts=opts, typ=GetDcvDelegationResult).value

    return AwaitableGetDcvDelegationResult(
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_dcv_delegation_output(zone_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDcvDelegationResult]:
    """
    Use this data source to retrieve the DCV Delegation unique identifier for a zone.


    :param str zone_id: The zone identifier to target for the resource.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getDcvDelegation:getDcvDelegation', __args__, opts=opts, typ=GetDcvDelegationResult)
    return __ret__.apply(lambda __response__: GetDcvDelegationResult(
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
