# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZoneCacheReserveResult',
    'AwaitableGetZoneCacheReserveResult',
    'get_zone_cache_reserve',
    'get_zone_cache_reserve_output',
]

@pulumi.output_type
class GetZoneCacheReserveResult:
    """
    A collection of values returned by getZoneCacheReserve.
    """
    def __init__(__self__, enabled=None, id=None, zone_id=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        The status of Cache Reserve support.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneCacheReserveResult(GetZoneCacheReserveResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneCacheReserveResult(
            enabled=self.enabled,
            id=self.id,
            zone_id=self.zone_id)


def get_zone_cache_reserve(zone_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneCacheReserveResult:
    """
    Provides a Cloudflare data source to look up Cache Reserve
    status for a given zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example = cloudflare.get_zone_cache_reserve(zone_id="0da42c8d2132a9ddaf714f9e7c920711")
    ```


    :param str zone_id: The zone identifier to target for the resource.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZoneCacheReserve:getZoneCacheReserve', __args__, opts=opts, typ=GetZoneCacheReserveResult).value

    return AwaitableGetZoneCacheReserveResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_cache_reserve_output(zone_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneCacheReserveResult]:
    """
    Provides a Cloudflare data source to look up Cache Reserve
    status for a given zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example = cloudflare.get_zone_cache_reserve(zone_id="0da42c8d2132a9ddaf714f9e7c920711")
    ```


    :param str zone_id: The zone identifier to target for the resource.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZoneCacheReserve:getZoneCacheReserve', __args__, opts=opts, typ=GetZoneCacheReserveResult)
    return __ret__.apply(lambda __response__: GetZoneCacheReserveResult(
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
