# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HyperdriveConfigArgs', 'HyperdriveConfig']

@pulumi.input_type
class HyperdriveConfigArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 origin: pulumi.Input['HyperdriveConfigOriginArgs'],
                 caching: Optional[pulumi.Input['HyperdriveConfigCachingArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HyperdriveConfig resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] name: The name of the Hyperdrive configuration.
        :param pulumi.Input['HyperdriveConfigOriginArgs'] origin: The origin details for the Hyperdrive configuration.
        :param pulumi.Input['HyperdriveConfigCachingArgs'] caching: The caching details for the Hyperdrive configuration.
        :param pulumi.Input[str] resource_id: The identifier of this resource. This is the hyperdrive config value.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origin", origin)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Hyperdrive configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Input['HyperdriveConfigOriginArgs']:
        """
        The origin details for the Hyperdrive configuration.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: pulumi.Input['HyperdriveConfigOriginArgs']):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['HyperdriveConfigCachingArgs']]:
        """
        The caching details for the Hyperdrive configuration.
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['HyperdriveConfigCachingArgs']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of this resource. This is the hyperdrive config value.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class _HyperdriveConfigState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 caching: Optional[pulumi.Input['HyperdriveConfigCachingArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin: Optional[pulumi.Input['HyperdriveConfigOriginArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HyperdriveConfig resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input['HyperdriveConfigCachingArgs'] caching: The caching details for the Hyperdrive configuration.
        :param pulumi.Input[str] name: The name of the Hyperdrive configuration.
        :param pulumi.Input['HyperdriveConfigOriginArgs'] origin: The origin details for the Hyperdrive configuration.
        :param pulumi.Input[str] resource_id: The identifier of this resource. This is the hyperdrive config value.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['HyperdriveConfigCachingArgs']]:
        """
        The caching details for the Hyperdrive configuration.
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['HyperdriveConfigCachingArgs']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Hyperdrive configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input['HyperdriveConfigOriginArgs']]:
        """
        The origin details for the Hyperdrive configuration.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input['HyperdriveConfigOriginArgs']]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of this resource. This is the hyperdrive config value.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


class HyperdriveConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 caching: Optional[pulumi.Input[Union['HyperdriveConfigCachingArgs', 'HyperdriveConfigCachingArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin: Optional[pulumi.Input[Union['HyperdriveConfigOriginArgs', 'HyperdriveConfigOriginArgsDict']]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The [Hyperdrive Config](https://developers.cloudflare.com/hyperdrive/) resource allows you to manage Cloudflare Hyperdrive Configs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        no_defaults = cloudflare.HyperdriveConfig("no_defaults",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="my-hyperdrive-config",
            origin={
                "database": "postgres",
                "password": "my-password",
                "host": "my-database.example.com",
                "port": 5432,
                "scheme": "postgres",
                "user": "my-user",
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/hyperdriveConfig:HyperdriveConfig example <account_id>/<hyperdrive_config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[Union['HyperdriveConfigCachingArgs', 'HyperdriveConfigCachingArgsDict']] caching: The caching details for the Hyperdrive configuration.
        :param pulumi.Input[str] name: The name of the Hyperdrive configuration.
        :param pulumi.Input[Union['HyperdriveConfigOriginArgs', 'HyperdriveConfigOriginArgsDict']] origin: The origin details for the Hyperdrive configuration.
        :param pulumi.Input[str] resource_id: The identifier of this resource. This is the hyperdrive config value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HyperdriveConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The [Hyperdrive Config](https://developers.cloudflare.com/hyperdrive/) resource allows you to manage Cloudflare Hyperdrive Configs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        no_defaults = cloudflare.HyperdriveConfig("no_defaults",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="my-hyperdrive-config",
            origin={
                "database": "postgres",
                "password": "my-password",
                "host": "my-database.example.com",
                "port": 5432,
                "scheme": "postgres",
                "user": "my-user",
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/hyperdriveConfig:HyperdriveConfig example <account_id>/<hyperdrive_config_id>
        ```

        :param str resource_name: The name of the resource.
        :param HyperdriveConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HyperdriveConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 caching: Optional[pulumi.Input[Union['HyperdriveConfigCachingArgs', 'HyperdriveConfigCachingArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin: Optional[pulumi.Input[Union['HyperdriveConfigOriginArgs', 'HyperdriveConfigOriginArgsDict']]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HyperdriveConfigArgs.__new__(HyperdriveConfigArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["caching"] = caching
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if origin is None and not opts.urn:
                raise TypeError("Missing required property 'origin'")
            __props__.__dict__["origin"] = origin
            __props__.__dict__["resource_id"] = resource_id
        super(HyperdriveConfig, __self__).__init__(
            'cloudflare:index/hyperdriveConfig:HyperdriveConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            caching: Optional[pulumi.Input[Union['HyperdriveConfigCachingArgs', 'HyperdriveConfigCachingArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            origin: Optional[pulumi.Input[Union['HyperdriveConfigOriginArgs', 'HyperdriveConfigOriginArgsDict']]] = None,
            resource_id: Optional[pulumi.Input[str]] = None) -> 'HyperdriveConfig':
        """
        Get an existing HyperdriveConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[Union['HyperdriveConfigCachingArgs', 'HyperdriveConfigCachingArgsDict']] caching: The caching details for the Hyperdrive configuration.
        :param pulumi.Input[str] name: The name of the Hyperdrive configuration.
        :param pulumi.Input[Union['HyperdriveConfigOriginArgs', 'HyperdriveConfigOriginArgsDict']] origin: The origin details for the Hyperdrive configuration.
        :param pulumi.Input[str] resource_id: The identifier of this resource. This is the hyperdrive config value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HyperdriveConfigState.__new__(_HyperdriveConfigState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["caching"] = caching
        __props__.__dict__["name"] = name
        __props__.__dict__["origin"] = origin
        __props__.__dict__["resource_id"] = resource_id
        return HyperdriveConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def caching(self) -> pulumi.Output['outputs.HyperdriveConfigCaching']:
        """
        The caching details for the Hyperdrive configuration.
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Hyperdrive configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output['outputs.HyperdriveConfigOrigin']:
        """
        The origin details for the Hyperdrive configuration.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The identifier of this resource. This is the hyperdrive config value.
        """
        return pulumi.get(self, "resource_id")

