# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LeakedCredentialCheckRuleArgs', 'LeakedCredentialCheckRule']

@pulumi.input_type
class LeakedCredentialCheckRuleArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 zone_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a LeakedCredentialCheckRule resource.
        :param pulumi.Input[str] password: The ruleset expression to use in matching the password in a request
        :param pulumi.Input[str] username: The ruleset expression to use in matching the username in a request.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The ruleset expression to use in matching the password in a request
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The ruleset expression to use in matching the username in a request.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _LeakedCredentialCheckRuleState:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LeakedCredentialCheckRule resources.
        :param pulumi.Input[str] password: The ruleset expression to use in matching the password in a request
        :param pulumi.Input[str] username: The ruleset expression to use in matching the username in a request.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The ruleset expression to use in matching the password in a request
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The ruleset expression to use in matching the username in a request.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class LeakedCredentialCheckRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Leaked Credential Check Rule resource for managing user-defined Leaked Credential detection patterns within a specific zone.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # Enable the Leaked Credentials Check detection before trying
        # to add detections.
        example = cloudflare.LeakedCredentialCheck("example",
            zone_id="399c6f4950c01a5a141b99ff7fbcbd8b",
            enabled=True)
        example_leaked_credential_check_rule = cloudflare.LeakedCredentialCheckRule("example",
            zone_id=example.zone_id,
            username="lookup_json_string(http.request.body.raw, \\"user\\")",
            password="lookup_json_string(http.request.body.raw, \\"pass\\")")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/leakedCredentialCheckRule:LeakedCredentialCheckRule example <zone_id>/<resource_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] password: The ruleset expression to use in matching the password in a request
        :param pulumi.Input[str] username: The ruleset expression to use in matching the username in a request.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LeakedCredentialCheckRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Leaked Credential Check Rule resource for managing user-defined Leaked Credential detection patterns within a specific zone.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # Enable the Leaked Credentials Check detection before trying
        # to add detections.
        example = cloudflare.LeakedCredentialCheck("example",
            zone_id="399c6f4950c01a5a141b99ff7fbcbd8b",
            enabled=True)
        example_leaked_credential_check_rule = cloudflare.LeakedCredentialCheckRule("example",
            zone_id=example.zone_id,
            username="lookup_json_string(http.request.body.raw, \\"user\\")",
            password="lookup_json_string(http.request.body.raw, \\"pass\\")")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/leakedCredentialCheckRule:LeakedCredentialCheckRule example <zone_id>/<resource_id>
        ```

        :param str resource_name: The name of the resource.
        :param LeakedCredentialCheckRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LeakedCredentialCheckRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LeakedCredentialCheckRuleArgs.__new__(LeakedCredentialCheckRuleArgs)

            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(LeakedCredentialCheckRule, __self__).__init__(
            'cloudflare:index/leakedCredentialCheckRule:LeakedCredentialCheckRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            password: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'LeakedCredentialCheckRule':
        """
        Get an existing LeakedCredentialCheckRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] password: The ruleset expression to use in matching the password in a request
        :param pulumi.Input[str] username: The ruleset expression to use in matching the username in a request.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LeakedCredentialCheckRuleState.__new__(_LeakedCredentialCheckRuleState)

        __props__.__dict__["password"] = password
        __props__.__dict__["username"] = username
        __props__.__dict__["zone_id"] = zone_id
        return LeakedCredentialCheckRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The ruleset expression to use in matching the password in a request
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The ruleset expression to use in matching the username in a request.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

