# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 default_pool_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 fallback_pool_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 adaptive_routings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]]] = None,
                 country_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerCountryPoolArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 location_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerLocationStrategyArgs']]]] = None,
                 pop_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPopPoolArgs']]]] = None,
                 proxied: Optional[pulumi.Input[bool]] = None,
                 random_steerings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRandomSteeringArgs']]]] = None,
                 region_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRegionPoolArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 session_affinity_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSessionAffinityAttributeArgs']]]] = None,
                 session_affinity_ttl: Optional[pulumi.Input[int]] = None,
                 steering_policy: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_pool_ids: A list of pool IDs ordered by their failover priority. Used whenever `pop_pools`/`country_pools`/`region_pools` are not defined.
        :param pulumi.Input[str] fallback_pool_id: The pool ID to use when all other pools are detected as unhealthy.
        :param pulumi.Input[str] name: The DNS hostname to associate with your load balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the load balancer will take precedence and the DNS record will not be used.
        :param pulumi.Input[str] zone_id: The zone ID to add the load balancer to. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]] adaptive_routings: Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerCountryPoolArgs']]] country_pools: A set containing mappings of country codes to a list of pool IDs (ordered by their failover priority) for the given country.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[bool] enabled: Enable or disable the load balancer. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerLocationStrategyArgs']]] location_strategies: Controls location-based steering for non-proxied requests.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPopPoolArgs']]] pop_pools: A set containing mappings of Cloudflare Point-of-Presence (PoP) identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). This feature is only available to enterprise customers.
        :param pulumi.Input[bool] proxied: Whether the hostname gets Cloudflare's origin protection. Defaults to `false`. Conflicts with `ttl`.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRandomSteeringArgs']]] random_steerings: Configures pool weights. When `steering_policy="random"`, a random pool is selected with probability proportional to pool weights. When `steering_policy="least_outstanding_requests"`, pool weights are used to scale each pool's outstanding requests. When `steering_policy="least_connections"`, pool weights are used to scale each pool's open connections.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRegionPoolArgs']]] region_pools: A set containing mappings of region codes to a list of pool IDs (ordered by their failover priority) for the given region.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]] rules: A list of rules for this load balancer to execute.
        :param pulumi.Input[str] session_affinity: Specifies the type of session affinity the load balancer should use unless specified as `none` or `""` (default). With value `cookie`, on the first request to a proxied load balancer, a cookie is generated, encoding information of which origin the request will be forwarded to. Subsequent requests, by the same client to the same load balancer, will be sent to the origin server the cookie encodes, for the duration of the cookie and as long as the origin server remains healthy. If the cookie has expired or the origin server is unhealthy then a new origin server is calculated and used. Value `ip_cookie` behaves the same as `cookie` except the initial origin selection is stable and based on the client's IP address. Available values: `""`, `none`, `cookie`, `ip_cookie`, `header`. Defaults to `none`.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerSessionAffinityAttributeArgs']]] session_affinity_attributes: Configure attributes for session affinity.
        :param pulumi.Input[int] session_affinity_ttl: Time, in seconds, until this load balancer's session affinity cookie expires after being created. This parameter is ignored unless a supported session affinity policy is set. The current default of `82800` (23 hours) will be used unless `session_affinity_ttl` is explicitly set. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. Valid values are between `1800` and `604800`.
        :param pulumi.Input[str] steering_policy: The method the load balancer uses to determine the route to your origin. Value `off` uses `default_pool_ids`. Value `geo` uses `pop_pools`/`country_pools`/`region_pools`. For non-proxied requests, the `country` for `country_pools` is determined by `location_strategy`. Value `random` selects a pool randomly. Value `dynamic_latency` uses round trip time to select the closest pool in `default_pool_ids` (requires pool health checks). Value `proximity` uses the pools' latitude and longitude to select the closest pool using the Cloudflare PoP location for proxied requests or the location determined by `location_strategy` for non-proxied requests. Value `least_outstanding_requests` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of outstanding requests. Pools with more pending requests are weighted proportionately less relative to others. Value `least_connections` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of open connections. Pools with more open connections are weighted proportionately less relative to others. Supported for HTTP/1 and HTTP/2 connections. Value `""` maps to `geo` if you use `pop_pools`/`country_pools`/`region_pools` otherwise `off`. Available values: `off`, `geo`, `dynamic_latency`, `random`, `proximity`, `least_outstanding_requests`, `least_connections`, `""` Defaults to `""`.
        :param pulumi.Input[int] ttl: Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This cannot be set for proxied load balancers. Defaults to `30`. Conflicts with `proxied`.
        """
        pulumi.set(__self__, "default_pool_ids", default_pool_ids)
        pulumi.set(__self__, "fallback_pool_id", fallback_pool_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "zone_id", zone_id)
        if adaptive_routings is not None:
            pulumi.set(__self__, "adaptive_routings", adaptive_routings)
        if country_pools is not None:
            pulumi.set(__self__, "country_pools", country_pools)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location_strategies is not None:
            pulumi.set(__self__, "location_strategies", location_strategies)
        if pop_pools is not None:
            pulumi.set(__self__, "pop_pools", pop_pools)
        if proxied is not None:
            pulumi.set(__self__, "proxied", proxied)
        if random_steerings is not None:
            pulumi.set(__self__, "random_steerings", random_steerings)
        if region_pools is not None:
            pulumi.set(__self__, "region_pools", region_pools)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if session_affinity_attributes is not None:
            pulumi.set(__self__, "session_affinity_attributes", session_affinity_attributes)
        if session_affinity_ttl is not None:
            pulumi.set(__self__, "session_affinity_ttl", session_affinity_ttl)
        if steering_policy is not None:
            pulumi.set(__self__, "steering_policy", steering_policy)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="defaultPoolIds")
    def default_pool_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of pool IDs ordered by their failover priority. Used whenever `pop_pools`/`country_pools`/`region_pools` are not defined.
        """
        return pulumi.get(self, "default_pool_ids")

    @default_pool_ids.setter
    def default_pool_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "default_pool_ids", value)

    @property
    @pulumi.getter(name="fallbackPoolId")
    def fallback_pool_id(self) -> pulumi.Input[str]:
        """
        The pool ID to use when all other pools are detected as unhealthy.
        """
        return pulumi.get(self, "fallback_pool_id")

    @fallback_pool_id.setter
    def fallback_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "fallback_pool_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The DNS hostname to associate with your load balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the load balancer will take precedence and the DNS record will not be used.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone ID to add the load balancer to. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="adaptiveRoutings")
    def adaptive_routings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]]]:
        """
        Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests.
        """
        return pulumi.get(self, "adaptive_routings")

    @adaptive_routings.setter
    def adaptive_routings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]]]):
        pulumi.set(self, "adaptive_routings", value)

    @property
    @pulumi.getter(name="countryPools")
    def country_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerCountryPoolArgs']]]]:
        """
        A set containing mappings of country codes to a list of pool IDs (ordered by their failover priority) for the given country.
        """
        return pulumi.get(self, "country_pools")

    @country_pools.setter
    def country_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerCountryPoolArgs']]]]):
        pulumi.set(self, "country_pools", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable the load balancer. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="locationStrategies")
    def location_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerLocationStrategyArgs']]]]:
        """
        Controls location-based steering for non-proxied requests.
        """
        return pulumi.get(self, "location_strategies")

    @location_strategies.setter
    def location_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerLocationStrategyArgs']]]]):
        pulumi.set(self, "location_strategies", value)

    @property
    @pulumi.getter(name="popPools")
    def pop_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPopPoolArgs']]]]:
        """
        A set containing mappings of Cloudflare Point-of-Presence (PoP) identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). This feature is only available to enterprise customers.
        """
        return pulumi.get(self, "pop_pools")

    @pop_pools.setter
    def pop_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPopPoolArgs']]]]):
        pulumi.set(self, "pop_pools", value)

    @property
    @pulumi.getter
    def proxied(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the hostname gets Cloudflare's origin protection. Defaults to `false`. Conflicts with `ttl`.
        """
        return pulumi.get(self, "proxied")

    @proxied.setter
    def proxied(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxied", value)

    @property
    @pulumi.getter(name="randomSteerings")
    def random_steerings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRandomSteeringArgs']]]]:
        """
        Configures pool weights. When `steering_policy="random"`, a random pool is selected with probability proportional to pool weights. When `steering_policy="least_outstanding_requests"`, pool weights are used to scale each pool's outstanding requests. When `steering_policy="least_connections"`, pool weights are used to scale each pool's open connections.
        """
        return pulumi.get(self, "random_steerings")

    @random_steerings.setter
    def random_steerings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRandomSteeringArgs']]]]):
        pulumi.set(self, "random_steerings", value)

    @property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRegionPoolArgs']]]]:
        """
        A set containing mappings of region codes to a list of pool IDs (ordered by their failover priority) for the given region.
        """
        return pulumi.get(self, "region_pools")

    @region_pools.setter
    def region_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRegionPoolArgs']]]]):
        pulumi.set(self, "region_pools", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]:
        """
        A list of rules for this load balancer to execute.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of session affinity the load balancer should use unless specified as `none` or `""` (default). With value `cookie`, on the first request to a proxied load balancer, a cookie is generated, encoding information of which origin the request will be forwarded to. Subsequent requests, by the same client to the same load balancer, will be sent to the origin server the cookie encodes, for the duration of the cookie and as long as the origin server remains healthy. If the cookie has expired or the origin server is unhealthy then a new origin server is calculated and used. Value `ip_cookie` behaves the same as `cookie` except the initial origin selection is stable and based on the client's IP address. Available values: `""`, `none`, `cookie`, `ip_cookie`, `header`. Defaults to `none`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="sessionAffinityAttributes")
    def session_affinity_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSessionAffinityAttributeArgs']]]]:
        """
        Configure attributes for session affinity.
        """
        return pulumi.get(self, "session_affinity_attributes")

    @session_affinity_attributes.setter
    def session_affinity_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSessionAffinityAttributeArgs']]]]):
        pulumi.set(self, "session_affinity_attributes", value)

    @property
    @pulumi.getter(name="sessionAffinityTtl")
    def session_affinity_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Time, in seconds, until this load balancer's session affinity cookie expires after being created. This parameter is ignored unless a supported session affinity policy is set. The current default of `82800` (23 hours) will be used unless `session_affinity_ttl` is explicitly set. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. Valid values are between `1800` and `604800`.
        """
        return pulumi.get(self, "session_affinity_ttl")

    @session_affinity_ttl.setter
    def session_affinity_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_affinity_ttl", value)

    @property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The method the load balancer uses to determine the route to your origin. Value `off` uses `default_pool_ids`. Value `geo` uses `pop_pools`/`country_pools`/`region_pools`. For non-proxied requests, the `country` for `country_pools` is determined by `location_strategy`. Value `random` selects a pool randomly. Value `dynamic_latency` uses round trip time to select the closest pool in `default_pool_ids` (requires pool health checks). Value `proximity` uses the pools' latitude and longitude to select the closest pool using the Cloudflare PoP location for proxied requests or the location determined by `location_strategy` for non-proxied requests. Value `least_outstanding_requests` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of outstanding requests. Pools with more pending requests are weighted proportionately less relative to others. Value `least_connections` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of open connections. Pools with more open connections are weighted proportionately less relative to others. Supported for HTTP/1 and HTTP/2 connections. Value `""` maps to `geo` if you use `pop_pools`/`country_pools`/`region_pools` otherwise `off`. Available values: `off`, `geo`, `dynamic_latency`, `random`, `proximity`, `least_outstanding_requests`, `least_connections`, `""` Defaults to `""`.
        """
        return pulumi.get(self, "steering_policy")

    @steering_policy.setter
    def steering_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "steering_policy", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This cannot be set for proxied load balancers. Defaults to `30`. Conflicts with `proxied`.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 adaptive_routings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]]] = None,
                 country_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerCountryPoolArgs']]]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 default_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fallback_pool_id: Optional[pulumi.Input[str]] = None,
                 location_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerLocationStrategyArgs']]]] = None,
                 modified_on: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pop_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPopPoolArgs']]]] = None,
                 proxied: Optional[pulumi.Input[bool]] = None,
                 random_steerings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRandomSteeringArgs']]]] = None,
                 region_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRegionPoolArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 session_affinity_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSessionAffinityAttributeArgs']]]] = None,
                 session_affinity_ttl: Optional[pulumi.Input[int]] = None,
                 steering_policy: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]] adaptive_routings: Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerCountryPoolArgs']]] country_pools: A set containing mappings of country codes to a list of pool IDs (ordered by their failover priority) for the given country.
        :param pulumi.Input[str] created_on: The RFC3339 timestamp of when the load balancer was created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_pool_ids: A list of pool IDs ordered by their failover priority. Used whenever `pop_pools`/`country_pools`/`region_pools` are not defined.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[bool] enabled: Enable or disable the load balancer. Defaults to `true`.
        :param pulumi.Input[str] fallback_pool_id: The pool ID to use when all other pools are detected as unhealthy.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerLocationStrategyArgs']]] location_strategies: Controls location-based steering for non-proxied requests.
        :param pulumi.Input[str] modified_on: The RFC3339 timestamp of when the load balancer was last modified.
        :param pulumi.Input[str] name: The DNS hostname to associate with your load balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the load balancer will take precedence and the DNS record will not be used.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPopPoolArgs']]] pop_pools: A set containing mappings of Cloudflare Point-of-Presence (PoP) identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). This feature is only available to enterprise customers.
        :param pulumi.Input[bool] proxied: Whether the hostname gets Cloudflare's origin protection. Defaults to `false`. Conflicts with `ttl`.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRandomSteeringArgs']]] random_steerings: Configures pool weights. When `steering_policy="random"`, a random pool is selected with probability proportional to pool weights. When `steering_policy="least_outstanding_requests"`, pool weights are used to scale each pool's outstanding requests. When `steering_policy="least_connections"`, pool weights are used to scale each pool's open connections.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRegionPoolArgs']]] region_pools: A set containing mappings of region codes to a list of pool IDs (ordered by their failover priority) for the given region.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]] rules: A list of rules for this load balancer to execute.
        :param pulumi.Input[str] session_affinity: Specifies the type of session affinity the load balancer should use unless specified as `none` or `""` (default). With value `cookie`, on the first request to a proxied load balancer, a cookie is generated, encoding information of which origin the request will be forwarded to. Subsequent requests, by the same client to the same load balancer, will be sent to the origin server the cookie encodes, for the duration of the cookie and as long as the origin server remains healthy. If the cookie has expired or the origin server is unhealthy then a new origin server is calculated and used. Value `ip_cookie` behaves the same as `cookie` except the initial origin selection is stable and based on the client's IP address. Available values: `""`, `none`, `cookie`, `ip_cookie`, `header`. Defaults to `none`.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerSessionAffinityAttributeArgs']]] session_affinity_attributes: Configure attributes for session affinity.
        :param pulumi.Input[int] session_affinity_ttl: Time, in seconds, until this load balancer's session affinity cookie expires after being created. This parameter is ignored unless a supported session affinity policy is set. The current default of `82800` (23 hours) will be used unless `session_affinity_ttl` is explicitly set. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. Valid values are between `1800` and `604800`.
        :param pulumi.Input[str] steering_policy: The method the load balancer uses to determine the route to your origin. Value `off` uses `default_pool_ids`. Value `geo` uses `pop_pools`/`country_pools`/`region_pools`. For non-proxied requests, the `country` for `country_pools` is determined by `location_strategy`. Value `random` selects a pool randomly. Value `dynamic_latency` uses round trip time to select the closest pool in `default_pool_ids` (requires pool health checks). Value `proximity` uses the pools' latitude and longitude to select the closest pool using the Cloudflare PoP location for proxied requests or the location determined by `location_strategy` for non-proxied requests. Value `least_outstanding_requests` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of outstanding requests. Pools with more pending requests are weighted proportionately less relative to others. Value `least_connections` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of open connections. Pools with more open connections are weighted proportionately less relative to others. Supported for HTTP/1 and HTTP/2 connections. Value `""` maps to `geo` if you use `pop_pools`/`country_pools`/`region_pools` otherwise `off`. Available values: `off`, `geo`, `dynamic_latency`, `random`, `proximity`, `least_outstanding_requests`, `least_connections`, `""` Defaults to `""`.
        :param pulumi.Input[int] ttl: Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This cannot be set for proxied load balancers. Defaults to `30`. Conflicts with `proxied`.
        :param pulumi.Input[str] zone_id: The zone ID to add the load balancer to. **Modifying this attribute will force creation of a new resource.**
        """
        if adaptive_routings is not None:
            pulumi.set(__self__, "adaptive_routings", adaptive_routings)
        if country_pools is not None:
            pulumi.set(__self__, "country_pools", country_pools)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if default_pool_ids is not None:
            pulumi.set(__self__, "default_pool_ids", default_pool_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fallback_pool_id is not None:
            pulumi.set(__self__, "fallback_pool_id", fallback_pool_id)
        if location_strategies is not None:
            pulumi.set(__self__, "location_strategies", location_strategies)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pop_pools is not None:
            pulumi.set(__self__, "pop_pools", pop_pools)
        if proxied is not None:
            pulumi.set(__self__, "proxied", proxied)
        if random_steerings is not None:
            pulumi.set(__self__, "random_steerings", random_steerings)
        if region_pools is not None:
            pulumi.set(__self__, "region_pools", region_pools)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if session_affinity_attributes is not None:
            pulumi.set(__self__, "session_affinity_attributes", session_affinity_attributes)
        if session_affinity_ttl is not None:
            pulumi.set(__self__, "session_affinity_ttl", session_affinity_ttl)
        if steering_policy is not None:
            pulumi.set(__self__, "steering_policy", steering_policy)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="adaptiveRoutings")
    def adaptive_routings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]]]:
        """
        Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests.
        """
        return pulumi.get(self, "adaptive_routings")

    @adaptive_routings.setter
    def adaptive_routings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]]]):
        pulumi.set(self, "adaptive_routings", value)

    @property
    @pulumi.getter(name="countryPools")
    def country_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerCountryPoolArgs']]]]:
        """
        A set containing mappings of country codes to a list of pool IDs (ordered by their failover priority) for the given country.
        """
        return pulumi.get(self, "country_pools")

    @country_pools.setter
    def country_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerCountryPoolArgs']]]]):
        pulumi.set(self, "country_pools", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC3339 timestamp of when the load balancer was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter(name="defaultPoolIds")
    def default_pool_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of pool IDs ordered by their failover priority. Used whenever `pop_pools`/`country_pools`/`region_pools` are not defined.
        """
        return pulumi.get(self, "default_pool_ids")

    @default_pool_ids.setter
    def default_pool_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "default_pool_ids", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable the load balancer. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="fallbackPoolId")
    def fallback_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The pool ID to use when all other pools are detected as unhealthy.
        """
        return pulumi.get(self, "fallback_pool_id")

    @fallback_pool_id.setter
    def fallback_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fallback_pool_id", value)

    @property
    @pulumi.getter(name="locationStrategies")
    def location_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerLocationStrategyArgs']]]]:
        """
        Controls location-based steering for non-proxied requests.
        """
        return pulumi.get(self, "location_strategies")

    @location_strategies.setter
    def location_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerLocationStrategyArgs']]]]):
        pulumi.set(self, "location_strategies", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC3339 timestamp of when the load balancer was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS hostname to associate with your load balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the load balancer will take precedence and the DNS record will not be used.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="popPools")
    def pop_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPopPoolArgs']]]]:
        """
        A set containing mappings of Cloudflare Point-of-Presence (PoP) identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). This feature is only available to enterprise customers.
        """
        return pulumi.get(self, "pop_pools")

    @pop_pools.setter
    def pop_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPopPoolArgs']]]]):
        pulumi.set(self, "pop_pools", value)

    @property
    @pulumi.getter
    def proxied(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the hostname gets Cloudflare's origin protection. Defaults to `false`. Conflicts with `ttl`.
        """
        return pulumi.get(self, "proxied")

    @proxied.setter
    def proxied(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxied", value)

    @property
    @pulumi.getter(name="randomSteerings")
    def random_steerings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRandomSteeringArgs']]]]:
        """
        Configures pool weights. When `steering_policy="random"`, a random pool is selected with probability proportional to pool weights. When `steering_policy="least_outstanding_requests"`, pool weights are used to scale each pool's outstanding requests. When `steering_policy="least_connections"`, pool weights are used to scale each pool's open connections.
        """
        return pulumi.get(self, "random_steerings")

    @random_steerings.setter
    def random_steerings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRandomSteeringArgs']]]]):
        pulumi.set(self, "random_steerings", value)

    @property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRegionPoolArgs']]]]:
        """
        A set containing mappings of region codes to a list of pool IDs (ordered by their failover priority) for the given region.
        """
        return pulumi.get(self, "region_pools")

    @region_pools.setter
    def region_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRegionPoolArgs']]]]):
        pulumi.set(self, "region_pools", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]:
        """
        A list of rules for this load balancer to execute.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of session affinity the load balancer should use unless specified as `none` or `""` (default). With value `cookie`, on the first request to a proxied load balancer, a cookie is generated, encoding information of which origin the request will be forwarded to. Subsequent requests, by the same client to the same load balancer, will be sent to the origin server the cookie encodes, for the duration of the cookie and as long as the origin server remains healthy. If the cookie has expired or the origin server is unhealthy then a new origin server is calculated and used. Value `ip_cookie` behaves the same as `cookie` except the initial origin selection is stable and based on the client's IP address. Available values: `""`, `none`, `cookie`, `ip_cookie`, `header`. Defaults to `none`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="sessionAffinityAttributes")
    def session_affinity_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSessionAffinityAttributeArgs']]]]:
        """
        Configure attributes for session affinity.
        """
        return pulumi.get(self, "session_affinity_attributes")

    @session_affinity_attributes.setter
    def session_affinity_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSessionAffinityAttributeArgs']]]]):
        pulumi.set(self, "session_affinity_attributes", value)

    @property
    @pulumi.getter(name="sessionAffinityTtl")
    def session_affinity_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Time, in seconds, until this load balancer's session affinity cookie expires after being created. This parameter is ignored unless a supported session affinity policy is set. The current default of `82800` (23 hours) will be used unless `session_affinity_ttl` is explicitly set. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. Valid values are between `1800` and `604800`.
        """
        return pulumi.get(self, "session_affinity_ttl")

    @session_affinity_ttl.setter
    def session_affinity_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_affinity_ttl", value)

    @property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The method the load balancer uses to determine the route to your origin. Value `off` uses `default_pool_ids`. Value `geo` uses `pop_pools`/`country_pools`/`region_pools`. For non-proxied requests, the `country` for `country_pools` is determined by `location_strategy`. Value `random` selects a pool randomly. Value `dynamic_latency` uses round trip time to select the closest pool in `default_pool_ids` (requires pool health checks). Value `proximity` uses the pools' latitude and longitude to select the closest pool using the Cloudflare PoP location for proxied requests or the location determined by `location_strategy` for non-proxied requests. Value `least_outstanding_requests` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of outstanding requests. Pools with more pending requests are weighted proportionately less relative to others. Value `least_connections` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of open connections. Pools with more open connections are weighted proportionately less relative to others. Supported for HTTP/1 and HTTP/2 connections. Value `""` maps to `geo` if you use `pop_pools`/`country_pools`/`region_pools` otherwise `off`. Available values: `off`, `geo`, `dynamic_latency`, `random`, `proximity`, `least_outstanding_requests`, `least_connections`, `""` Defaults to `""`.
        """
        return pulumi.get(self, "steering_policy")

    @steering_policy.setter
    def steering_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "steering_policy", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This cannot be set for proxied load balancers. Defaults to `30`. Conflicts with `proxied`.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID to add the load balancer to. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_routings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]]]] = None,
                 country_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerCountryPoolArgs', 'LoadBalancerCountryPoolArgsDict']]]]] = None,
                 default_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fallback_pool_id: Optional[pulumi.Input[str]] = None,
                 location_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pop_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPopPoolArgs', 'LoadBalancerPopPoolArgsDict']]]]] = None,
                 proxied: Optional[pulumi.Input[bool]] = None,
                 random_steerings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]]]] = None,
                 region_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRegionPoolArgs', 'LoadBalancerRegionPoolArgsDict']]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 session_affinity_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSessionAffinityAttributeArgs', 'LoadBalancerSessionAffinityAttributeArgsDict']]]]] = None,
                 session_affinity_ttl: Optional[pulumi.Input[int]] = None,
                 steering_policy: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Load Balancer resource. This sits in front of
        a number of defined pools of origins and provides various options
        for geographically-aware load balancing. Note that the load balancing
        feature must be enabled in your Cloudflare account before you can use
        this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_load_balancer_pool = cloudflare.LoadBalancerPool("example",
            name="example-lb-pool",
            origins=[{
                "name": "example-1",
                "address": "192.0.2.1",
                "enabled": False,
            }])
        # Define a load balancer which always points to a pool we define below.
        # In normal usage, would have different pools set for different pops
        # (cloudflare points-of-presence) and/or for different regions.
        # Within each pop or region we can define multiple pools in failover order.
        example = cloudflare.LoadBalancer("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            name="example-load-balancer.example.com",
            fallback_pool_id=example_load_balancer_pool.id,
            default_pool_ids=[example_load_balancer_pool.id],
            description="example load balancer using geo-balancing",
            proxied=True,
            steering_policy="geo",
            pop_pools=[{
                "pop": "LAX",
                "pool_ids": [example_load_balancer_pool.id],
            }],
            country_pools=[{
                "country": "US",
                "pool_ids": [example_load_balancer_pool.id],
            }],
            region_pools=[{
                "region": "WNAM",
                "pool_ids": [example_load_balancer_pool.id],
            }],
            rules=[{
                "name": "example rule",
                "condition": "http.request.uri.path contains \\"testing\\"",
                "fixed_response": {
                    "message_body": "hello",
                    "status_code": 200,
                    "content_type": "html",
                    "location": "www.example.com",
                },
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancer:LoadBalancer example <zone_id>/<load_balancer_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]]] adaptive_routings: Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerCountryPoolArgs', 'LoadBalancerCountryPoolArgsDict']]]] country_pools: A set containing mappings of country codes to a list of pool IDs (ordered by their failover priority) for the given country.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_pool_ids: A list of pool IDs ordered by their failover priority. Used whenever `pop_pools`/`country_pools`/`region_pools` are not defined.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[bool] enabled: Enable or disable the load balancer. Defaults to `true`.
        :param pulumi.Input[str] fallback_pool_id: The pool ID to use when all other pools are detected as unhealthy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']]]] location_strategies: Controls location-based steering for non-proxied requests.
        :param pulumi.Input[str] name: The DNS hostname to associate with your load balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the load balancer will take precedence and the DNS record will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPopPoolArgs', 'LoadBalancerPopPoolArgsDict']]]] pop_pools: A set containing mappings of Cloudflare Point-of-Presence (PoP) identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). This feature is only available to enterprise customers.
        :param pulumi.Input[bool] proxied: Whether the hostname gets Cloudflare's origin protection. Defaults to `false`. Conflicts with `ttl`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]]] random_steerings: Configures pool weights. When `steering_policy="random"`, a random pool is selected with probability proportional to pool weights. When `steering_policy="least_outstanding_requests"`, pool weights are used to scale each pool's outstanding requests. When `steering_policy="least_connections"`, pool weights are used to scale each pool's open connections.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRegionPoolArgs', 'LoadBalancerRegionPoolArgsDict']]]] region_pools: A set containing mappings of region codes to a list of pool IDs (ordered by their failover priority) for the given region.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]] rules: A list of rules for this load balancer to execute.
        :param pulumi.Input[str] session_affinity: Specifies the type of session affinity the load balancer should use unless specified as `none` or `""` (default). With value `cookie`, on the first request to a proxied load balancer, a cookie is generated, encoding information of which origin the request will be forwarded to. Subsequent requests, by the same client to the same load balancer, will be sent to the origin server the cookie encodes, for the duration of the cookie and as long as the origin server remains healthy. If the cookie has expired or the origin server is unhealthy then a new origin server is calculated and used. Value `ip_cookie` behaves the same as `cookie` except the initial origin selection is stable and based on the client's IP address. Available values: `""`, `none`, `cookie`, `ip_cookie`, `header`. Defaults to `none`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSessionAffinityAttributeArgs', 'LoadBalancerSessionAffinityAttributeArgsDict']]]] session_affinity_attributes: Configure attributes for session affinity.
        :param pulumi.Input[int] session_affinity_ttl: Time, in seconds, until this load balancer's session affinity cookie expires after being created. This parameter is ignored unless a supported session affinity policy is set. The current default of `82800` (23 hours) will be used unless `session_affinity_ttl` is explicitly set. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. Valid values are between `1800` and `604800`.
        :param pulumi.Input[str] steering_policy: The method the load balancer uses to determine the route to your origin. Value `off` uses `default_pool_ids`. Value `geo` uses `pop_pools`/`country_pools`/`region_pools`. For non-proxied requests, the `country` for `country_pools` is determined by `location_strategy`. Value `random` selects a pool randomly. Value `dynamic_latency` uses round trip time to select the closest pool in `default_pool_ids` (requires pool health checks). Value `proximity` uses the pools' latitude and longitude to select the closest pool using the Cloudflare PoP location for proxied requests or the location determined by `location_strategy` for non-proxied requests. Value `least_outstanding_requests` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of outstanding requests. Pools with more pending requests are weighted proportionately less relative to others. Value `least_connections` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of open connections. Pools with more open connections are weighted proportionately less relative to others. Supported for HTTP/1 and HTTP/2 connections. Value `""` maps to `geo` if you use `pop_pools`/`country_pools`/`region_pools` otherwise `off`. Available values: `off`, `geo`, `dynamic_latency`, `random`, `proximity`, `least_outstanding_requests`, `least_connections`, `""` Defaults to `""`.
        :param pulumi.Input[int] ttl: Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This cannot be set for proxied load balancers. Defaults to `30`. Conflicts with `proxied`.
        :param pulumi.Input[str] zone_id: The zone ID to add the load balancer to. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Load Balancer resource. This sits in front of
        a number of defined pools of origins and provides various options
        for geographically-aware load balancing. Note that the load balancing
        feature must be enabled in your Cloudflare account before you can use
        this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_load_balancer_pool = cloudflare.LoadBalancerPool("example",
            name="example-lb-pool",
            origins=[{
                "name": "example-1",
                "address": "192.0.2.1",
                "enabled": False,
            }])
        # Define a load balancer which always points to a pool we define below.
        # In normal usage, would have different pools set for different pops
        # (cloudflare points-of-presence) and/or for different regions.
        # Within each pop or region we can define multiple pools in failover order.
        example = cloudflare.LoadBalancer("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            name="example-load-balancer.example.com",
            fallback_pool_id=example_load_balancer_pool.id,
            default_pool_ids=[example_load_balancer_pool.id],
            description="example load balancer using geo-balancing",
            proxied=True,
            steering_policy="geo",
            pop_pools=[{
                "pop": "LAX",
                "pool_ids": [example_load_balancer_pool.id],
            }],
            country_pools=[{
                "country": "US",
                "pool_ids": [example_load_balancer_pool.id],
            }],
            region_pools=[{
                "region": "WNAM",
                "pool_ids": [example_load_balancer_pool.id],
            }],
            rules=[{
                "name": "example rule",
                "condition": "http.request.uri.path contains \\"testing\\"",
                "fixed_response": {
                    "message_body": "hello",
                    "status_code": 200,
                    "content_type": "html",
                    "location": "www.example.com",
                },
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancer:LoadBalancer example <zone_id>/<load_balancer_id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_routings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]]]] = None,
                 country_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerCountryPoolArgs', 'LoadBalancerCountryPoolArgsDict']]]]] = None,
                 default_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fallback_pool_id: Optional[pulumi.Input[str]] = None,
                 location_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pop_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPopPoolArgs', 'LoadBalancerPopPoolArgsDict']]]]] = None,
                 proxied: Optional[pulumi.Input[bool]] = None,
                 random_steerings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]]]] = None,
                 region_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRegionPoolArgs', 'LoadBalancerRegionPoolArgsDict']]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 session_affinity_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSessionAffinityAttributeArgs', 'LoadBalancerSessionAffinityAttributeArgsDict']]]]] = None,
                 session_affinity_ttl: Optional[pulumi.Input[int]] = None,
                 steering_policy: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["adaptive_routings"] = adaptive_routings
            __props__.__dict__["country_pools"] = country_pools
            if default_pool_ids is None and not opts.urn:
                raise TypeError("Missing required property 'default_pool_ids'")
            __props__.__dict__["default_pool_ids"] = default_pool_ids
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if fallback_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'fallback_pool_id'")
            __props__.__dict__["fallback_pool_id"] = fallback_pool_id
            __props__.__dict__["location_strategies"] = location_strategies
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["pop_pools"] = pop_pools
            __props__.__dict__["proxied"] = proxied
            __props__.__dict__["random_steerings"] = random_steerings
            __props__.__dict__["region_pools"] = region_pools
            __props__.__dict__["rules"] = rules
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["session_affinity_attributes"] = session_affinity_attributes
            __props__.__dict__["session_affinity_ttl"] = session_affinity_ttl
            __props__.__dict__["steering_policy"] = steering_policy
            __props__.__dict__["ttl"] = ttl
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(LoadBalancer, __self__).__init__(
            'cloudflare:index/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adaptive_routings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]]]] = None,
            country_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerCountryPoolArgs', 'LoadBalancerCountryPoolArgsDict']]]]] = None,
            created_on: Optional[pulumi.Input[str]] = None,
            default_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            fallback_pool_id: Optional[pulumi.Input[str]] = None,
            location_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']]]]] = None,
            modified_on: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pop_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPopPoolArgs', 'LoadBalancerPopPoolArgsDict']]]]] = None,
            proxied: Optional[pulumi.Input[bool]] = None,
            random_steerings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]]]] = None,
            region_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRegionPoolArgs', 'LoadBalancerRegionPoolArgsDict']]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
            session_affinity: Optional[pulumi.Input[str]] = None,
            session_affinity_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSessionAffinityAttributeArgs', 'LoadBalancerSessionAffinityAttributeArgsDict']]]]] = None,
            session_affinity_ttl: Optional[pulumi.Input[int]] = None,
            steering_policy: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]]] adaptive_routings: Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerCountryPoolArgs', 'LoadBalancerCountryPoolArgsDict']]]] country_pools: A set containing mappings of country codes to a list of pool IDs (ordered by their failover priority) for the given country.
        :param pulumi.Input[str] created_on: The RFC3339 timestamp of when the load balancer was created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] default_pool_ids: A list of pool IDs ordered by their failover priority. Used whenever `pop_pools`/`country_pools`/`region_pools` are not defined.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[bool] enabled: Enable or disable the load balancer. Defaults to `true`.
        :param pulumi.Input[str] fallback_pool_id: The pool ID to use when all other pools are detected as unhealthy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']]]] location_strategies: Controls location-based steering for non-proxied requests.
        :param pulumi.Input[str] modified_on: The RFC3339 timestamp of when the load balancer was last modified.
        :param pulumi.Input[str] name: The DNS hostname to associate with your load balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the load balancer will take precedence and the DNS record will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPopPoolArgs', 'LoadBalancerPopPoolArgsDict']]]] pop_pools: A set containing mappings of Cloudflare Point-of-Presence (PoP) identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). This feature is only available to enterprise customers.
        :param pulumi.Input[bool] proxied: Whether the hostname gets Cloudflare's origin protection. Defaults to `false`. Conflicts with `ttl`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]]] random_steerings: Configures pool weights. When `steering_policy="random"`, a random pool is selected with probability proportional to pool weights. When `steering_policy="least_outstanding_requests"`, pool weights are used to scale each pool's outstanding requests. When `steering_policy="least_connections"`, pool weights are used to scale each pool's open connections.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRegionPoolArgs', 'LoadBalancerRegionPoolArgsDict']]]] region_pools: A set containing mappings of region codes to a list of pool IDs (ordered by their failover priority) for the given region.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]] rules: A list of rules for this load balancer to execute.
        :param pulumi.Input[str] session_affinity: Specifies the type of session affinity the load balancer should use unless specified as `none` or `""` (default). With value `cookie`, on the first request to a proxied load balancer, a cookie is generated, encoding information of which origin the request will be forwarded to. Subsequent requests, by the same client to the same load balancer, will be sent to the origin server the cookie encodes, for the duration of the cookie and as long as the origin server remains healthy. If the cookie has expired or the origin server is unhealthy then a new origin server is calculated and used. Value `ip_cookie` behaves the same as `cookie` except the initial origin selection is stable and based on the client's IP address. Available values: `""`, `none`, `cookie`, `ip_cookie`, `header`. Defaults to `none`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSessionAffinityAttributeArgs', 'LoadBalancerSessionAffinityAttributeArgsDict']]]] session_affinity_attributes: Configure attributes for session affinity.
        :param pulumi.Input[int] session_affinity_ttl: Time, in seconds, until this load balancer's session affinity cookie expires after being created. This parameter is ignored unless a supported session affinity policy is set. The current default of `82800` (23 hours) will be used unless `session_affinity_ttl` is explicitly set. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. Valid values are between `1800` and `604800`.
        :param pulumi.Input[str] steering_policy: The method the load balancer uses to determine the route to your origin. Value `off` uses `default_pool_ids`. Value `geo` uses `pop_pools`/`country_pools`/`region_pools`. For non-proxied requests, the `country` for `country_pools` is determined by `location_strategy`. Value `random` selects a pool randomly. Value `dynamic_latency` uses round trip time to select the closest pool in `default_pool_ids` (requires pool health checks). Value `proximity` uses the pools' latitude and longitude to select the closest pool using the Cloudflare PoP location for proxied requests or the location determined by `location_strategy` for non-proxied requests. Value `least_outstanding_requests` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of outstanding requests. Pools with more pending requests are weighted proportionately less relative to others. Value `least_connections` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of open connections. Pools with more open connections are weighted proportionately less relative to others. Supported for HTTP/1 and HTTP/2 connections. Value `""` maps to `geo` if you use `pop_pools`/`country_pools`/`region_pools` otherwise `off`. Available values: `off`, `geo`, `dynamic_latency`, `random`, `proximity`, `least_outstanding_requests`, `least_connections`, `""` Defaults to `""`.
        :param pulumi.Input[int] ttl: Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This cannot be set for proxied load balancers. Defaults to `30`. Conflicts with `proxied`.
        :param pulumi.Input[str] zone_id: The zone ID to add the load balancer to. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["adaptive_routings"] = adaptive_routings
        __props__.__dict__["country_pools"] = country_pools
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["default_pool_ids"] = default_pool_ids
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fallback_pool_id"] = fallback_pool_id
        __props__.__dict__["location_strategies"] = location_strategies
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["pop_pools"] = pop_pools
        __props__.__dict__["proxied"] = proxied
        __props__.__dict__["random_steerings"] = random_steerings
        __props__.__dict__["region_pools"] = region_pools
        __props__.__dict__["rules"] = rules
        __props__.__dict__["session_affinity"] = session_affinity
        __props__.__dict__["session_affinity_attributes"] = session_affinity_attributes
        __props__.__dict__["session_affinity_ttl"] = session_affinity_ttl
        __props__.__dict__["steering_policy"] = steering_policy
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["zone_id"] = zone_id
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adaptiveRoutings")
    def adaptive_routings(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerAdaptiveRouting']]]:
        """
        Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests.
        """
        return pulumi.get(self, "adaptive_routings")

    @property
    @pulumi.getter(name="countryPools")
    def country_pools(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerCountryPool']]]:
        """
        A set containing mappings of country codes to a list of pool IDs (ordered by their failover priority) for the given country.
        """
        return pulumi.get(self, "country_pools")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[str]:
        """
        The RFC3339 timestamp of when the load balancer was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="defaultPoolIds")
    def default_pool_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of pool IDs ordered by their failover priority. Used whenever `pop_pools`/`country_pools`/`region_pools` are not defined.
        """
        return pulumi.get(self, "default_pool_ids")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable the load balancer. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fallbackPoolId")
    def fallback_pool_id(self) -> pulumi.Output[str]:
        """
        The pool ID to use when all other pools are detected as unhealthy.
        """
        return pulumi.get(self, "fallback_pool_id")

    @property
    @pulumi.getter(name="locationStrategies")
    def location_strategies(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerLocationStrategy']]]:
        """
        Controls location-based steering for non-proxied requests.
        """
        return pulumi.get(self, "location_strategies")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[str]:
        """
        The RFC3339 timestamp of when the load balancer was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The DNS hostname to associate with your load balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the load balancer will take precedence and the DNS record will not be used.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="popPools")
    def pop_pools(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerPopPool']]]:
        """
        A set containing mappings of Cloudflare Point-of-Presence (PoP) identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). This feature is only available to enterprise customers.
        """
        return pulumi.get(self, "pop_pools")

    @property
    @pulumi.getter
    def proxied(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the hostname gets Cloudflare's origin protection. Defaults to `false`. Conflicts with `ttl`.
        """
        return pulumi.get(self, "proxied")

    @property
    @pulumi.getter(name="randomSteerings")
    def random_steerings(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerRandomSteering']]]:
        """
        Configures pool weights. When `steering_policy="random"`, a random pool is selected with probability proportional to pool weights. When `steering_policy="least_outstanding_requests"`, pool weights are used to scale each pool's outstanding requests. When `steering_policy="least_connections"`, pool weights are used to scale each pool's open connections.
        """
        return pulumi.get(self, "random_steerings")

    @property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerRegionPool']]]:
        """
        A set containing mappings of region codes to a list of pool IDs (ordered by their failover priority) for the given region.
        """
        return pulumi.get(self, "region_pools")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerRule']]]:
        """
        A list of rules for this load balancer to execute.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of session affinity the load balancer should use unless specified as `none` or `""` (default). With value `cookie`, on the first request to a proxied load balancer, a cookie is generated, encoding information of which origin the request will be forwarded to. Subsequent requests, by the same client to the same load balancer, will be sent to the origin server the cookie encodes, for the duration of the cookie and as long as the origin server remains healthy. If the cookie has expired or the origin server is unhealthy then a new origin server is calculated and used. Value `ip_cookie` behaves the same as `cookie` except the initial origin selection is stable and based on the client's IP address. Available values: `""`, `none`, `cookie`, `ip_cookie`, `header`. Defaults to `none`.
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter(name="sessionAffinityAttributes")
    def session_affinity_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerSessionAffinityAttribute']]]:
        """
        Configure attributes for session affinity.
        """
        return pulumi.get(self, "session_affinity_attributes")

    @property
    @pulumi.getter(name="sessionAffinityTtl")
    def session_affinity_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        Time, in seconds, until this load balancer's session affinity cookie expires after being created. This parameter is ignored unless a supported session affinity policy is set. The current default of `82800` (23 hours) will be used unless `session_affinity_ttl` is explicitly set. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. Valid values are between `1800` and `604800`.
        """
        return pulumi.get(self, "session_affinity_ttl")

    @property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> pulumi.Output[str]:
        """
        The method the load balancer uses to determine the route to your origin. Value `off` uses `default_pool_ids`. Value `geo` uses `pop_pools`/`country_pools`/`region_pools`. For non-proxied requests, the `country` for `country_pools` is determined by `location_strategy`. Value `random` selects a pool randomly. Value `dynamic_latency` uses round trip time to select the closest pool in `default_pool_ids` (requires pool health checks). Value `proximity` uses the pools' latitude and longitude to select the closest pool using the Cloudflare PoP location for proxied requests or the location determined by `location_strategy` for non-proxied requests. Value `least_outstanding_requests` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of outstanding requests. Pools with more pending requests are weighted proportionately less relative to others. Value `least_connections` selects a pool by taking into consideration `random_steering` weights, as well as each pool's number of open connections. Pools with more open connections are weighted proportionately less relative to others. Supported for HTTP/1 and HTTP/2 connections. Value `""` maps to `geo` if you use `pop_pools`/`country_pools`/`region_pools` otherwise `off`. Available values: `off`, `geo`, `dynamic_latency`, `random`, `proximity`, `least_outstanding_requests`, `least_connections`, `""` Defaults to `""`.
        """
        return pulumi.get(self, "steering_policy")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[int]:
        """
        Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This cannot be set for proxied load balancers. Defaults to `30`. Conflicts with `proxied`.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID to add the load balancer to. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

