# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerMonitorArgs', 'LoadBalancerMonitor']

@pulumi.input_type
class LoadBalancerMonitorArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 consecutive_down: Optional[pulumi.Input[int]] = None,
                 consecutive_up: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_body: Optional[pulumi.Input[str]] = None,
                 expected_codes: Optional[pulumi.Input[str]] = None,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerMonitorHeaderArgs']]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 probe_zone: Optional[pulumi.Input[str]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LoadBalancerMonitor resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] allow_insecure: Do not validate the certificate when monitor use HTTPS.  Only valid if `type` is "http" or "https".
        :param pulumi.Input[int] consecutive_down: To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times. Defaults to `0`.
        :param pulumi.Input[int] consecutive_up: To be marked healthy the monitored origin must pass this healthcheck N consecutive times. Defaults to `0`.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. Only valid if `type` is "http" or "https".
        :param pulumi.Input[str] expected_codes: The expected HTTP response code or code range of the health check. Eg `2xx`. Only valid and required if `type` is "http" or "https".
        :param pulumi.Input[bool] follow_redirects: Follow redirects if returned by the origin. Only valid if `type` is "http" or "https".
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerMonitorHeaderArgs']]] headers: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        :param pulumi.Input[int] interval: The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations. Defaults to `60`.
        :param pulumi.Input[str] method: The method to use for the health check.
        :param pulumi.Input[str] path: The endpoint path to health check against.
        :param pulumi.Input[int] port: The port number to use for the healthcheck, required when creating a TCP monitor.
        :param pulumi.Input[str] probe_zone: Assign this monitor to emulate the specified zone while probing. Only valid if `type` is "http" or "https".
        :param pulumi.Input[int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        :param pulumi.Input[int] timeout: The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        :param pulumi.Input[str] type: The protocol to use for the healthcheck. Available values: `http`, `https`, `tcp`, `udp_icmp`, `icmp_ping`, `smtp`. Defaults to `http`.
        """
        pulumi.set(__self__, "account_id", account_id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if consecutive_down is not None:
            pulumi.set(__self__, "consecutive_down", consecutive_down)
        if consecutive_up is not None:
            pulumi.set(__self__, "consecutive_up", consecutive_up)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expected_body is not None:
            pulumi.set(__self__, "expected_body", expected_body)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe_zone is not None:
            pulumi.set(__self__, "probe_zone", probe_zone)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not validate the certificate when monitor use HTTPS.  Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter(name="consecutiveDown")
    def consecutive_down(self) -> Optional[pulumi.Input[int]]:
        """
        To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times. Defaults to `0`.
        """
        return pulumi.get(self, "consecutive_down")

    @consecutive_down.setter
    def consecutive_down(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_down", value)

    @property
    @pulumi.getter(name="consecutiveUp")
    def consecutive_up(self) -> Optional[pulumi.Input[int]]:
        """
        To be marked healthy the monitored origin must pass this healthcheck N consecutive times. Defaults to `0`.
        """
        return pulumi.get(self, "consecutive_up")

    @consecutive_up.setter
    def consecutive_up(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_up", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> Optional[pulumi.Input[str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "expected_body")

    @expected_body.setter
    def expected_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_body", value)

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[pulumi.Input[str]]:
        """
        The expected HTTP response code or code range of the health check. Eg `2xx`. Only valid and required if `type` is "http" or "https".
        """
        return pulumi.get(self, "expected_codes")

    @expected_codes.setter
    def expected_codes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_codes", value)

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[pulumi.Input[bool]]:
        """
        Follow redirects if returned by the origin. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "follow_redirects")

    @follow_redirects.setter
    def follow_redirects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "follow_redirects", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerMonitorHeaderArgs']]]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerMonitorHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations. Defaults to `60`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The method to use for the health check.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint path to health check against.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number to use for the healthcheck, required when creating a TCP monitor.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="probeZone")
    def probe_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Assign this monitor to emulate the specified zone while probing. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "probe_zone")

    @probe_zone.setter
    def probe_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "probe_zone", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol to use for the healthcheck. Available values: `http`, `https`, `tcp`, `udp_icmp`, `icmp_ping`, `smtp`. Defaults to `http`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _LoadBalancerMonitorState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 consecutive_down: Optional[pulumi.Input[int]] = None,
                 consecutive_up: Optional[pulumi.Input[int]] = None,
                 created_on: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_body: Optional[pulumi.Input[str]] = None,
                 expected_codes: Optional[pulumi.Input[str]] = None,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerMonitorHeaderArgs']]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 modified_on: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 probe_zone: Optional[pulumi.Input[str]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerMonitor resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] allow_insecure: Do not validate the certificate when monitor use HTTPS.  Only valid if `type` is "http" or "https".
        :param pulumi.Input[int] consecutive_down: To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times. Defaults to `0`.
        :param pulumi.Input[int] consecutive_up: To be marked healthy the monitored origin must pass this healthcheck N consecutive times. Defaults to `0`.
        :param pulumi.Input[str] created_on: The RFC3339 timestamp of when the load balancer monitor was created.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. Only valid if `type` is "http" or "https".
        :param pulumi.Input[str] expected_codes: The expected HTTP response code or code range of the health check. Eg `2xx`. Only valid and required if `type` is "http" or "https".
        :param pulumi.Input[bool] follow_redirects: Follow redirects if returned by the origin. Only valid if `type` is "http" or "https".
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerMonitorHeaderArgs']]] headers: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        :param pulumi.Input[int] interval: The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations. Defaults to `60`.
        :param pulumi.Input[str] method: The method to use for the health check.
        :param pulumi.Input[str] modified_on: The RFC3339 timestamp of when the load balancer monitor was last modified.
        :param pulumi.Input[str] path: The endpoint path to health check against.
        :param pulumi.Input[int] port: The port number to use for the healthcheck, required when creating a TCP monitor.
        :param pulumi.Input[str] probe_zone: Assign this monitor to emulate the specified zone while probing. Only valid if `type` is "http" or "https".
        :param pulumi.Input[int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        :param pulumi.Input[int] timeout: The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        :param pulumi.Input[str] type: The protocol to use for the healthcheck. Available values: `http`, `https`, `tcp`, `udp_icmp`, `icmp_ping`, `smtp`. Defaults to `http`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if consecutive_down is not None:
            pulumi.set(__self__, "consecutive_down", consecutive_down)
        if consecutive_up is not None:
            pulumi.set(__self__, "consecutive_up", consecutive_up)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expected_body is not None:
            pulumi.set(__self__, "expected_body", expected_body)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe_zone is not None:
            pulumi.set(__self__, "probe_zone", probe_zone)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not validate the certificate when monitor use HTTPS.  Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter(name="consecutiveDown")
    def consecutive_down(self) -> Optional[pulumi.Input[int]]:
        """
        To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times. Defaults to `0`.
        """
        return pulumi.get(self, "consecutive_down")

    @consecutive_down.setter
    def consecutive_down(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_down", value)

    @property
    @pulumi.getter(name="consecutiveUp")
    def consecutive_up(self) -> Optional[pulumi.Input[int]]:
        """
        To be marked healthy the monitored origin must pass this healthcheck N consecutive times. Defaults to `0`.
        """
        return pulumi.get(self, "consecutive_up")

    @consecutive_up.setter
    def consecutive_up(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "consecutive_up", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC3339 timestamp of when the load balancer monitor was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> Optional[pulumi.Input[str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "expected_body")

    @expected_body.setter
    def expected_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_body", value)

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[pulumi.Input[str]]:
        """
        The expected HTTP response code or code range of the health check. Eg `2xx`. Only valid and required if `type` is "http" or "https".
        """
        return pulumi.get(self, "expected_codes")

    @expected_codes.setter
    def expected_codes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_codes", value)

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[pulumi.Input[bool]]:
        """
        Follow redirects if returned by the origin. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "follow_redirects")

    @follow_redirects.setter
    def follow_redirects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "follow_redirects", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerMonitorHeaderArgs']]]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerMonitorHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations. Defaults to `60`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The method to use for the health check.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC3339 timestamp of when the load balancer monitor was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint path to health check against.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number to use for the healthcheck, required when creating a TCP monitor.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="probeZone")
    def probe_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Assign this monitor to emulate the specified zone while probing. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "probe_zone")

    @probe_zone.setter
    def probe_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "probe_zone", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol to use for the healthcheck. Available values: `http`, `https`, `tcp`, `udp_icmp`, `icmp_ping`, `smtp`. Defaults to `http`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class LoadBalancerMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 consecutive_down: Optional[pulumi.Input[int]] = None,
                 consecutive_up: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_body: Optional[pulumi.Input[str]] = None,
                 expected_codes: Optional[pulumi.Input[str]] = None,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerMonitorHeaderArgs', 'LoadBalancerMonitorHeaderArgsDict']]]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 probe_zone: Optional[pulumi.Input[str]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        If Cloudflare's Load Balancing to load-balance across multiple
        origin servers or data centers, you configure one of these Monitors
        to actively check the availability of those servers over HTTP(S) or
        TCP.

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancerMonitor:LoadBalancerMonitor example <account_id>/<load_balancer_monitor_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] allow_insecure: Do not validate the certificate when monitor use HTTPS.  Only valid if `type` is "http" or "https".
        :param pulumi.Input[int] consecutive_down: To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times. Defaults to `0`.
        :param pulumi.Input[int] consecutive_up: To be marked healthy the monitored origin must pass this healthcheck N consecutive times. Defaults to `0`.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. Only valid if `type` is "http" or "https".
        :param pulumi.Input[str] expected_codes: The expected HTTP response code or code range of the health check. Eg `2xx`. Only valid and required if `type` is "http" or "https".
        :param pulumi.Input[bool] follow_redirects: Follow redirects if returned by the origin. Only valid if `type` is "http" or "https".
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerMonitorHeaderArgs', 'LoadBalancerMonitorHeaderArgsDict']]]] headers: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        :param pulumi.Input[int] interval: The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations. Defaults to `60`.
        :param pulumi.Input[str] method: The method to use for the health check.
        :param pulumi.Input[str] path: The endpoint path to health check against.
        :param pulumi.Input[int] port: The port number to use for the healthcheck, required when creating a TCP monitor.
        :param pulumi.Input[str] probe_zone: Assign this monitor to emulate the specified zone while probing. Only valid if `type` is "http" or "https".
        :param pulumi.Input[int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        :param pulumi.Input[int] timeout: The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        :param pulumi.Input[str] type: The protocol to use for the healthcheck. Available values: `http`, `https`, `tcp`, `udp_icmp`, `icmp_ping`, `smtp`. Defaults to `http`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        If Cloudflare's Load Balancing to load-balance across multiple
        origin servers or data centers, you configure one of these Monitors
        to actively check the availability of those servers over HTTP(S) or
        TCP.

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancerMonitor:LoadBalancerMonitor example <account_id>/<load_balancer_monitor_id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 consecutive_down: Optional[pulumi.Input[int]] = None,
                 consecutive_up: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expected_body: Optional[pulumi.Input[str]] = None,
                 expected_codes: Optional[pulumi.Input[str]] = None,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerMonitorHeaderArgs', 'LoadBalancerMonitorHeaderArgsDict']]]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 probe_zone: Optional[pulumi.Input[str]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerMonitorArgs.__new__(LoadBalancerMonitorArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["allow_insecure"] = allow_insecure
            __props__.__dict__["consecutive_down"] = consecutive_down
            __props__.__dict__["consecutive_up"] = consecutive_up
            __props__.__dict__["description"] = description
            __props__.__dict__["expected_body"] = expected_body
            __props__.__dict__["expected_codes"] = expected_codes
            __props__.__dict__["follow_redirects"] = follow_redirects
            __props__.__dict__["headers"] = headers
            __props__.__dict__["interval"] = interval
            __props__.__dict__["method"] = method
            __props__.__dict__["path"] = path
            __props__.__dict__["port"] = port
            __props__.__dict__["probe_zone"] = probe_zone
            __props__.__dict__["retries"] = retries
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["type"] = type
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(LoadBalancerMonitor, __self__).__init__(
            'cloudflare:index/loadBalancerMonitor:LoadBalancerMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            allow_insecure: Optional[pulumi.Input[bool]] = None,
            consecutive_down: Optional[pulumi.Input[int]] = None,
            consecutive_up: Optional[pulumi.Input[int]] = None,
            created_on: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expected_body: Optional[pulumi.Input[str]] = None,
            expected_codes: Optional[pulumi.Input[str]] = None,
            follow_redirects: Optional[pulumi.Input[bool]] = None,
            headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerMonitorHeaderArgs', 'LoadBalancerMonitorHeaderArgsDict']]]]] = None,
            interval: Optional[pulumi.Input[int]] = None,
            method: Optional[pulumi.Input[str]] = None,
            modified_on: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            probe_zone: Optional[pulumi.Input[str]] = None,
            retries: Optional[pulumi.Input[int]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'LoadBalancerMonitor':
        """
        Get an existing LoadBalancerMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] allow_insecure: Do not validate the certificate when monitor use HTTPS.  Only valid if `type` is "http" or "https".
        :param pulumi.Input[int] consecutive_down: To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times. Defaults to `0`.
        :param pulumi.Input[int] consecutive_up: To be marked healthy the monitored origin must pass this healthcheck N consecutive times. Defaults to `0`.
        :param pulumi.Input[str] created_on: The RFC3339 timestamp of when the load balancer monitor was created.
        :param pulumi.Input[str] description: Free text description.
        :param pulumi.Input[str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. Only valid if `type` is "http" or "https".
        :param pulumi.Input[str] expected_codes: The expected HTTP response code or code range of the health check. Eg `2xx`. Only valid and required if `type` is "http" or "https".
        :param pulumi.Input[bool] follow_redirects: Follow redirects if returned by the origin. Only valid if `type` is "http" or "https".
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerMonitorHeaderArgs', 'LoadBalancerMonitorHeaderArgsDict']]]] headers: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        :param pulumi.Input[int] interval: The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations. Defaults to `60`.
        :param pulumi.Input[str] method: The method to use for the health check.
        :param pulumi.Input[str] modified_on: The RFC3339 timestamp of when the load balancer monitor was last modified.
        :param pulumi.Input[str] path: The endpoint path to health check against.
        :param pulumi.Input[int] port: The port number to use for the healthcheck, required when creating a TCP monitor.
        :param pulumi.Input[str] probe_zone: Assign this monitor to emulate the specified zone while probing. Only valid if `type` is "http" or "https".
        :param pulumi.Input[int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        :param pulumi.Input[int] timeout: The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        :param pulumi.Input[str] type: The protocol to use for the healthcheck. Available values: `http`, `https`, `tcp`, `udp_icmp`, `icmp_ping`, `smtp`. Defaults to `http`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerMonitorState.__new__(_LoadBalancerMonitorState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allow_insecure"] = allow_insecure
        __props__.__dict__["consecutive_down"] = consecutive_down
        __props__.__dict__["consecutive_up"] = consecutive_up
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["expected_body"] = expected_body
        __props__.__dict__["expected_codes"] = expected_codes
        __props__.__dict__["follow_redirects"] = follow_redirects
        __props__.__dict__["headers"] = headers
        __props__.__dict__["interval"] = interval
        __props__.__dict__["method"] = method
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["path"] = path
        __props__.__dict__["port"] = port
        __props__.__dict__["probe_zone"] = probe_zone
        __props__.__dict__["retries"] = retries
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        return LoadBalancerMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> pulumi.Output[Optional[bool]]:
        """
        Do not validate the certificate when monitor use HTTPS.  Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter(name="consecutiveDown")
    def consecutive_down(self) -> pulumi.Output[Optional[int]]:
        """
        To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times. Defaults to `0`.
        """
        return pulumi.get(self, "consecutive_down")

    @property
    @pulumi.getter(name="consecutiveUp")
    def consecutive_up(self) -> pulumi.Output[Optional[int]]:
        """
        To be marked healthy the monitored origin must pass this healthcheck N consecutive times. Defaults to `0`.
        """
        return pulumi.get(self, "consecutive_up")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[str]:
        """
        The RFC3339 timestamp of when the load balancer monitor was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Free text description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> pulumi.Output[Optional[str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "expected_body")

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> pulumi.Output[Optional[str]]:
        """
        The expected HTTP response code or code range of the health check. Eg `2xx`. Only valid and required if `type` is "http" or "https".
        """
        return pulumi.get(self, "expected_codes")

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> pulumi.Output[Optional[bool]]:
        """
        Follow redirects if returned by the origin. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "follow_redirects")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerMonitorHeader']]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[int]]:
        """
        The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations. Defaults to `60`.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[str]:
        """
        The method to use for the health check.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[str]:
        """
        The RFC3339 timestamp of when the load balancer monitor was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        The endpoint path to health check against.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        The port number to use for the healthcheck, required when creating a TCP monitor.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="probeZone")
    def probe_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Assign this monitor to emulate the specified zone while probing. Only valid if `type` is "http" or "https".
        """
        return pulumi.get(self, "probe_zone")

    @property
    @pulumi.getter
    def retries(self) -> pulumi.Output[Optional[int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately. Defaults to `2`.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The timeout (in seconds) before marking the health check as failed. Defaults to `5`.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The protocol to use for the healthcheck. Available values: `http`, `https`, `tcp`, `udp_icmp`, `icmp_ping`, `smtp`. Defaults to `http`.
        """
        return pulumi.get(self, "type")

