# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnippetArgs', 'Snippet']

@pulumi.input_type
class SnippetArgs:
    def __init__(__self__, *,
                 main_module: pulumi.Input[str],
                 name: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 files: Optional[pulumi.Input[Sequence[pulumi.Input['SnippetFileArgs']]]] = None):
        """
        The set of arguments for constructing a Snippet resource.
        :param pulumi.Input[str] main_module: Main module file name of the snippet.
        :param pulumi.Input[str] name: Name of the snippet.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        :param pulumi.Input[Sequence[pulumi.Input['SnippetFileArgs']]] files: List of Snippet Files
        """
        pulumi.set(__self__, "main_module", main_module)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "zone_id", zone_id)
        if files is not None:
            pulumi.set(__self__, "files", files)

    @property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> pulumi.Input[str]:
        """
        Main module file name of the snippet.
        """
        return pulumi.get(self, "main_module")

    @main_module.setter
    def main_module(self, value: pulumi.Input[str]):
        pulumi.set(self, "main_module", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the snippet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SnippetFileArgs']]]]:
        """
        List of Snippet Files
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SnippetFileArgs']]]]):
        pulumi.set(self, "files", value)


@pulumi.input_type
class _SnippetState:
    def __init__(__self__, *,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input['SnippetFileArgs']]]] = None,
                 main_module: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Snippet resources.
        :param pulumi.Input[Sequence[pulumi.Input['SnippetFileArgs']]] files: List of Snippet Files
        :param pulumi.Input[str] main_module: Main module file name of the snippet.
        :param pulumi.Input[str] name: Name of the snippet.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        if files is not None:
            pulumi.set(__self__, "files", files)
        if main_module is not None:
            pulumi.set(__self__, "main_module", main_module)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SnippetFileArgs']]]]:
        """
        List of Snippet Files
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SnippetFileArgs']]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> Optional[pulumi.Input[str]]:
        """
        Main module file name of the snippet.
        """
        return pulumi.get(self, "main_module")

    @main_module.setter
    def main_module(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_module", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the snippet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Snippet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SnippetFileArgs', 'SnippetFileArgsDict']]]]] = None,
                 main_module: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The [Snippet](https://developers.cloudflare.com/rules/snippets/) resource allows you to create and manage snippet for a zone.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SnippetFileArgs', 'SnippetFileArgsDict']]]] files: List of Snippet Files
        :param pulumi.Input[str] main_module: Main module file name of the snippet.
        :param pulumi.Input[str] name: Name of the snippet.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnippetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The [Snippet](https://developers.cloudflare.com/rules/snippets/) resource allows you to create and manage snippet for a zone.

        :param str resource_name: The name of the resource.
        :param SnippetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnippetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SnippetFileArgs', 'SnippetFileArgsDict']]]]] = None,
                 main_module: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnippetArgs.__new__(SnippetArgs)

            __props__.__dict__["files"] = files
            if main_module is None and not opts.urn:
                raise TypeError("Missing required property 'main_module'")
            __props__.__dict__["main_module"] = main_module
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(Snippet, __self__).__init__(
            'cloudflare:index/snippet:Snippet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SnippetFileArgs', 'SnippetFileArgsDict']]]]] = None,
            main_module: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Snippet':
        """
        Get an existing Snippet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SnippetFileArgs', 'SnippetFileArgsDict']]]] files: List of Snippet Files
        :param pulumi.Input[str] main_module: Main module file name of the snippet.
        :param pulumi.Input[str] name: Name of the snippet.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnippetState.__new__(_SnippetState)

        __props__.__dict__["files"] = files
        __props__.__dict__["main_module"] = main_module
        __props__.__dict__["name"] = name
        __props__.__dict__["zone_id"] = zone_id
        return Snippet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def files(self) -> pulumi.Output[Optional[Sequence['outputs.SnippetFile']]]:
        """
        List of Snippet Files
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> pulumi.Output[str]:
        """
        Main module file name of the snippet.
        """
        return pulumi.get(self, "main_module")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the snippet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource.
        """
        return pulumi.get(self, "zone_id")

