# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TeamsLocationArgs', 'TeamsLocation']

@pulumi.input_type
class TeamsLocationArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 client_default: Optional[pulumi.Input[bool]] = None,
                 dns_destination_ips_id: Optional[pulumi.Input[str]] = None,
                 dns_destination_ipv6_block_id: Optional[pulumi.Input[str]] = None,
                 ecs_support: Optional[pulumi.Input[bool]] = None,
                 endpoints: Optional[pulumi.Input['TeamsLocationEndpointsArgs']] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['TeamsLocationNetworkArgs']]]] = None):
        """
        The set of arguments for constructing a TeamsLocation resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] name: Name of the teams location.
        :param pulumi.Input[bool] client_default: Indicator that this is the default location.
        :param pulumi.Input[str] dns_destination_ips_id: IPv4 binding assigned to this location.
        :param pulumi.Input[str] dns_destination_ipv6_block_id: IPv6 block binding assigned to this location.
        :param pulumi.Input[bool] ecs_support: Indicator that this location needs to resolve EDNS queries.
        :param pulumi.Input['TeamsLocationEndpointsArgs'] endpoints: Endpoints assigned to this location.
        :param pulumi.Input[Sequence[pulumi.Input['TeamsLocationNetworkArgs']]] networks: The networks CIDRs that comprise the location.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if client_default is not None:
            pulumi.set(__self__, "client_default", client_default)
        if dns_destination_ips_id is not None:
            pulumi.set(__self__, "dns_destination_ips_id", dns_destination_ips_id)
        if dns_destination_ipv6_block_id is not None:
            pulumi.set(__self__, "dns_destination_ipv6_block_id", dns_destination_ipv6_block_id)
        if ecs_support is not None:
            pulumi.set(__self__, "ecs_support", ecs_support)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the teams location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="clientDefault")
    def client_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that this is the default location.
        """
        return pulumi.get(self, "client_default")

    @client_default.setter
    def client_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_default", value)

    @property
    @pulumi.getter(name="dnsDestinationIpsId")
    def dns_destination_ips_id(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 binding assigned to this location.
        """
        return pulumi.get(self, "dns_destination_ips_id")

    @dns_destination_ips_id.setter
    def dns_destination_ips_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_destination_ips_id", value)

    @property
    @pulumi.getter(name="dnsDestinationIpv6BlockId")
    def dns_destination_ipv6_block_id(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 block binding assigned to this location.
        """
        return pulumi.get(self, "dns_destination_ipv6_block_id")

    @dns_destination_ipv6_block_id.setter
    def dns_destination_ipv6_block_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_destination_ipv6_block_id", value)

    @property
    @pulumi.getter(name="ecsSupport")
    def ecs_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that this location needs to resolve EDNS queries.
        """
        return pulumi.get(self, "ecs_support")

    @ecs_support.setter
    def ecs_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ecs_support", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input['TeamsLocationEndpointsArgs']]:
        """
        Endpoints assigned to this location.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input['TeamsLocationEndpointsArgs']]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TeamsLocationNetworkArgs']]]]:
        """
        The networks CIDRs that comprise the location.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TeamsLocationNetworkArgs']]]]):
        pulumi.set(self, "networks", value)


@pulumi.input_type
class _TeamsLocationState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 anonymized_logs_enabled: Optional[pulumi.Input[bool]] = None,
                 client_default: Optional[pulumi.Input[bool]] = None,
                 dns_destination_ips_id: Optional[pulumi.Input[str]] = None,
                 dns_destination_ipv6_block_id: Optional[pulumi.Input[str]] = None,
                 doh_subdomain: Optional[pulumi.Input[str]] = None,
                 ecs_support: Optional[pulumi.Input[bool]] = None,
                 endpoints: Optional[pulumi.Input['TeamsLocationEndpointsArgs']] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 ipv4_destination: Optional[pulumi.Input[str]] = None,
                 ipv4_destination_backup: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['TeamsLocationNetworkArgs']]]] = None):
        """
        Input properties used for looking up and filtering TeamsLocation resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] anonymized_logs_enabled: Indicator that anonymized logs are enabled.
        :param pulumi.Input[bool] client_default: Indicator that this is the default location.
        :param pulumi.Input[str] dns_destination_ips_id: IPv4 binding assigned to this location.
        :param pulumi.Input[str] dns_destination_ipv6_block_id: IPv6 block binding assigned to this location.
        :param pulumi.Input[str] doh_subdomain: The FQDN that DoH clients should be pointed at.
        :param pulumi.Input[bool] ecs_support: Indicator that this location needs to resolve EDNS queries.
        :param pulumi.Input['TeamsLocationEndpointsArgs'] endpoints: Endpoints assigned to this location.
        :param pulumi.Input[str] ip: Client IP address.
        :param pulumi.Input[str] ipv4_destination: IPv4 to direct all IPv4 DNS queries to.
        :param pulumi.Input[str] ipv4_destination_backup: Backup IPv4 to direct all IPv4 DNS queries to.
        :param pulumi.Input[str] name: Name of the teams location.
        :param pulumi.Input[Sequence[pulumi.Input['TeamsLocationNetworkArgs']]] networks: The networks CIDRs that comprise the location.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if anonymized_logs_enabled is not None:
            pulumi.set(__self__, "anonymized_logs_enabled", anonymized_logs_enabled)
        if client_default is not None:
            pulumi.set(__self__, "client_default", client_default)
        if dns_destination_ips_id is not None:
            pulumi.set(__self__, "dns_destination_ips_id", dns_destination_ips_id)
        if dns_destination_ipv6_block_id is not None:
            pulumi.set(__self__, "dns_destination_ipv6_block_id", dns_destination_ipv6_block_id)
        if doh_subdomain is not None:
            pulumi.set(__self__, "doh_subdomain", doh_subdomain)
        if ecs_support is not None:
            pulumi.set(__self__, "ecs_support", ecs_support)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ipv4_destination is not None:
            pulumi.set(__self__, "ipv4_destination", ipv4_destination)
        if ipv4_destination_backup is not None:
            pulumi.set(__self__, "ipv4_destination_backup", ipv4_destination_backup)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="anonymizedLogsEnabled")
    def anonymized_logs_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that anonymized logs are enabled.
        """
        return pulumi.get(self, "anonymized_logs_enabled")

    @anonymized_logs_enabled.setter
    def anonymized_logs_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "anonymized_logs_enabled", value)

    @property
    @pulumi.getter(name="clientDefault")
    def client_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that this is the default location.
        """
        return pulumi.get(self, "client_default")

    @client_default.setter
    def client_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_default", value)

    @property
    @pulumi.getter(name="dnsDestinationIpsId")
    def dns_destination_ips_id(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 binding assigned to this location.
        """
        return pulumi.get(self, "dns_destination_ips_id")

    @dns_destination_ips_id.setter
    def dns_destination_ips_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_destination_ips_id", value)

    @property
    @pulumi.getter(name="dnsDestinationIpv6BlockId")
    def dns_destination_ipv6_block_id(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 block binding assigned to this location.
        """
        return pulumi.get(self, "dns_destination_ipv6_block_id")

    @dns_destination_ipv6_block_id.setter
    def dns_destination_ipv6_block_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_destination_ipv6_block_id", value)

    @property
    @pulumi.getter(name="dohSubdomain")
    def doh_subdomain(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN that DoH clients should be pointed at.
        """
        return pulumi.get(self, "doh_subdomain")

    @doh_subdomain.setter
    def doh_subdomain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "doh_subdomain", value)

    @property
    @pulumi.getter(name="ecsSupport")
    def ecs_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that this location needs to resolve EDNS queries.
        """
        return pulumi.get(self, "ecs_support")

    @ecs_support.setter
    def ecs_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ecs_support", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input['TeamsLocationEndpointsArgs']]:
        """
        Endpoints assigned to this location.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input['TeamsLocationEndpointsArgs']]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Client IP address.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipv4Destination")
    def ipv4_destination(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 to direct all IPv4 DNS queries to.
        """
        return pulumi.get(self, "ipv4_destination")

    @ipv4_destination.setter
    def ipv4_destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_destination", value)

    @property
    @pulumi.getter(name="ipv4DestinationBackup")
    def ipv4_destination_backup(self) -> Optional[pulumi.Input[str]]:
        """
        Backup IPv4 to direct all IPv4 DNS queries to.
        """
        return pulumi.get(self, "ipv4_destination_backup")

    @ipv4_destination_backup.setter
    def ipv4_destination_backup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_destination_backup", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the teams location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TeamsLocationNetworkArgs']]]]:
        """
        The networks CIDRs that comprise the location.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TeamsLocationNetworkArgs']]]]):
        pulumi.set(self, "networks", value)


class TeamsLocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 client_default: Optional[pulumi.Input[bool]] = None,
                 dns_destination_ips_id: Optional[pulumi.Input[str]] = None,
                 dns_destination_ipv6_block_id: Optional[pulumi.Input[str]] = None,
                 ecs_support: Optional[pulumi.Input[bool]] = None,
                 endpoints: Optional[pulumi.Input[Union['TeamsLocationEndpointsArgs', 'TeamsLocationEndpointsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TeamsLocationNetworkArgs', 'TeamsLocationNetworkArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Teams Location resource. Teams Locations are
        referenced when creating secure web gateway policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.TeamsLocation("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="office",
            client_default=True,
            ecs_support=False,
            networks=[
                {
                    "network": "203.0.113.1/32",
                },
                {
                    "network": "203.0.113.2/32",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/teamsLocation:TeamsLocation example <account_id>/<teams_location_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] client_default: Indicator that this is the default location.
        :param pulumi.Input[str] dns_destination_ips_id: IPv4 binding assigned to this location.
        :param pulumi.Input[str] dns_destination_ipv6_block_id: IPv6 block binding assigned to this location.
        :param pulumi.Input[bool] ecs_support: Indicator that this location needs to resolve EDNS queries.
        :param pulumi.Input[Union['TeamsLocationEndpointsArgs', 'TeamsLocationEndpointsArgsDict']] endpoints: Endpoints assigned to this location.
        :param pulumi.Input[str] name: Name of the teams location.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TeamsLocationNetworkArgs', 'TeamsLocationNetworkArgsDict']]]] networks: The networks CIDRs that comprise the location.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamsLocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Teams Location resource. Teams Locations are
        referenced when creating secure web gateway policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.TeamsLocation("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="office",
            client_default=True,
            ecs_support=False,
            networks=[
                {
                    "network": "203.0.113.1/32",
                },
                {
                    "network": "203.0.113.2/32",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/teamsLocation:TeamsLocation example <account_id>/<teams_location_id>
        ```

        :param str resource_name: The name of the resource.
        :param TeamsLocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamsLocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 client_default: Optional[pulumi.Input[bool]] = None,
                 dns_destination_ips_id: Optional[pulumi.Input[str]] = None,
                 dns_destination_ipv6_block_id: Optional[pulumi.Input[str]] = None,
                 ecs_support: Optional[pulumi.Input[bool]] = None,
                 endpoints: Optional[pulumi.Input[Union['TeamsLocationEndpointsArgs', 'TeamsLocationEndpointsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TeamsLocationNetworkArgs', 'TeamsLocationNetworkArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamsLocationArgs.__new__(TeamsLocationArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["client_default"] = client_default
            __props__.__dict__["dns_destination_ips_id"] = dns_destination_ips_id
            __props__.__dict__["dns_destination_ipv6_block_id"] = dns_destination_ipv6_block_id
            __props__.__dict__["ecs_support"] = ecs_support
            __props__.__dict__["endpoints"] = endpoints
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["anonymized_logs_enabled"] = None
            __props__.__dict__["doh_subdomain"] = None
            __props__.__dict__["ip"] = None
            __props__.__dict__["ipv4_destination"] = None
            __props__.__dict__["ipv4_destination_backup"] = None
        super(TeamsLocation, __self__).__init__(
            'cloudflare:index/teamsLocation:TeamsLocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            anonymized_logs_enabled: Optional[pulumi.Input[bool]] = None,
            client_default: Optional[pulumi.Input[bool]] = None,
            dns_destination_ips_id: Optional[pulumi.Input[str]] = None,
            dns_destination_ipv6_block_id: Optional[pulumi.Input[str]] = None,
            doh_subdomain: Optional[pulumi.Input[str]] = None,
            ecs_support: Optional[pulumi.Input[bool]] = None,
            endpoints: Optional[pulumi.Input[Union['TeamsLocationEndpointsArgs', 'TeamsLocationEndpointsArgsDict']]] = None,
            ip: Optional[pulumi.Input[str]] = None,
            ipv4_destination: Optional[pulumi.Input[str]] = None,
            ipv4_destination_backup: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TeamsLocationNetworkArgs', 'TeamsLocationNetworkArgsDict']]]]] = None) -> 'TeamsLocation':
        """
        Get an existing TeamsLocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] anonymized_logs_enabled: Indicator that anonymized logs are enabled.
        :param pulumi.Input[bool] client_default: Indicator that this is the default location.
        :param pulumi.Input[str] dns_destination_ips_id: IPv4 binding assigned to this location.
        :param pulumi.Input[str] dns_destination_ipv6_block_id: IPv6 block binding assigned to this location.
        :param pulumi.Input[str] doh_subdomain: The FQDN that DoH clients should be pointed at.
        :param pulumi.Input[bool] ecs_support: Indicator that this location needs to resolve EDNS queries.
        :param pulumi.Input[Union['TeamsLocationEndpointsArgs', 'TeamsLocationEndpointsArgsDict']] endpoints: Endpoints assigned to this location.
        :param pulumi.Input[str] ip: Client IP address.
        :param pulumi.Input[str] ipv4_destination: IPv4 to direct all IPv4 DNS queries to.
        :param pulumi.Input[str] ipv4_destination_backup: Backup IPv4 to direct all IPv4 DNS queries to.
        :param pulumi.Input[str] name: Name of the teams location.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TeamsLocationNetworkArgs', 'TeamsLocationNetworkArgsDict']]]] networks: The networks CIDRs that comprise the location.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamsLocationState.__new__(_TeamsLocationState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["anonymized_logs_enabled"] = anonymized_logs_enabled
        __props__.__dict__["client_default"] = client_default
        __props__.__dict__["dns_destination_ips_id"] = dns_destination_ips_id
        __props__.__dict__["dns_destination_ipv6_block_id"] = dns_destination_ipv6_block_id
        __props__.__dict__["doh_subdomain"] = doh_subdomain
        __props__.__dict__["ecs_support"] = ecs_support
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["ip"] = ip
        __props__.__dict__["ipv4_destination"] = ipv4_destination
        __props__.__dict__["ipv4_destination_backup"] = ipv4_destination_backup
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        return TeamsLocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="anonymizedLogsEnabled")
    def anonymized_logs_enabled(self) -> pulumi.Output[bool]:
        """
        Indicator that anonymized logs are enabled.
        """
        return pulumi.get(self, "anonymized_logs_enabled")

    @property
    @pulumi.getter(name="clientDefault")
    def client_default(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicator that this is the default location.
        """
        return pulumi.get(self, "client_default")

    @property
    @pulumi.getter(name="dnsDestinationIpsId")
    def dns_destination_ips_id(self) -> pulumi.Output[str]:
        """
        IPv4 binding assigned to this location.
        """
        return pulumi.get(self, "dns_destination_ips_id")

    @property
    @pulumi.getter(name="dnsDestinationIpv6BlockId")
    def dns_destination_ipv6_block_id(self) -> pulumi.Output[str]:
        """
        IPv6 block binding assigned to this location.
        """
        return pulumi.get(self, "dns_destination_ipv6_block_id")

    @property
    @pulumi.getter(name="dohSubdomain")
    def doh_subdomain(self) -> pulumi.Output[str]:
        """
        The FQDN that DoH clients should be pointed at.
        """
        return pulumi.get(self, "doh_subdomain")

    @property
    @pulumi.getter(name="ecsSupport")
    def ecs_support(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicator that this location needs to resolve EDNS queries.
        """
        return pulumi.get(self, "ecs_support")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Optional['outputs.TeamsLocationEndpoints']]:
        """
        Endpoints assigned to this location.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[str]:
        """
        Client IP address.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipv4Destination")
    def ipv4_destination(self) -> pulumi.Output[str]:
        """
        IPv4 to direct all IPv4 DNS queries to.
        """
        return pulumi.get(self, "ipv4_destination")

    @property
    @pulumi.getter(name="ipv4DestinationBackup")
    def ipv4_destination_backup(self) -> pulumi.Output[str]:
        """
        Backup IPv4 to direct all IPv4 DNS queries to.
        """
        return pulumi.get(self, "ipv4_destination_backup")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the teams location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.TeamsLocationNetwork']]]:
        """
        The networks CIDRs that comprise the location.
        """
        return pulumi.get(self, "networks")

