# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZeroTrustDeviceProfilesArgs', 'ZeroTrustDeviceProfiles']

@pulumi.input_type
class ZeroTrustDeviceProfilesArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 description: pulumi.Input[str],
                 name: pulumi.Input[str],
                 allow_mode_switch: Optional[pulumi.Input[bool]] = None,
                 allow_updates: Optional[pulumi.Input[bool]] = None,
                 allowed_to_leave: Optional[pulumi.Input[bool]] = None,
                 auto_connect: Optional[pulumi.Input[int]] = None,
                 captive_portal: Optional[pulumi.Input[int]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 disable_auto_fallback: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 exclude_office_ips: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 precedence: Optional[pulumi.Input[int]] = None,
                 service_mode_v2_mode: Optional[pulumi.Input[str]] = None,
                 service_mode_v2_port: Optional[pulumi.Input[int]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 switch_locked: Optional[pulumi.Input[bool]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ZeroTrustDeviceProfiles resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] description: Description of Policy.
        :param pulumi.Input[str] name: Name of the policy.
        :param pulumi.Input[bool] allow_mode_switch: Whether to allow mode switch for this policy.
        :param pulumi.Input[bool] allow_updates: Whether to allow updates under this policy.
        :param pulumi.Input[bool] allowed_to_leave: Whether to allow devices to leave the organization. Defaults to `true`.
        :param pulumi.Input[int] auto_connect: The amount of time in seconds to reconnect after having been disabled.
        :param pulumi.Input[int] captive_portal: The captive portal value for this policy. Defaults to `180`.
        :param pulumi.Input[bool] default: Whether the policy refers to the default account policy.
        :param pulumi.Input[bool] disable_auto_fallback: Whether to disable auto fallback for this policy.
        :param pulumi.Input[bool] enabled: Whether the policy is enabled (cannot be set for default policies). Defaults to `true`.
        :param pulumi.Input[bool] exclude_office_ips: Whether to add Microsoft IPs to split tunnel exclusions.
        :param pulumi.Input[str] match: Wirefilter expression to match a device against when evaluating whether this policy should take effect for that device.
        :param pulumi.Input[int] precedence: The precedence of the policy. Lower values indicate higher precedence.
        :param pulumi.Input[str] service_mode_v2_mode: The service mode. Available values: `1dot1`, `warp`, `proxy`, `posture_only`, `warp_tunnel_only`. Defaults to `warp`.
        :param pulumi.Input[int] service_mode_v2_port: The port to use for the proxy service mode. Required when using `service_mode_v2_mode`.
        :param pulumi.Input[str] support_url: The support URL that will be opened when sending feedback.
        :param pulumi.Input[bool] switch_locked: Enablement of the ZT client switch lock.
        :param pulumi.Input[str] tunnel_protocol: Determines which tunnel protocol to use. Available values: `""`, `wireguard`, `masque`. Defaults to `wireguard`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        if allow_mode_switch is not None:
            pulumi.set(__self__, "allow_mode_switch", allow_mode_switch)
        if allow_updates is not None:
            pulumi.set(__self__, "allow_updates", allow_updates)
        if allowed_to_leave is not None:
            pulumi.set(__self__, "allowed_to_leave", allowed_to_leave)
        if auto_connect is not None:
            pulumi.set(__self__, "auto_connect", auto_connect)
        if captive_portal is not None:
            pulumi.set(__self__, "captive_portal", captive_portal)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if disable_auto_fallback is not None:
            pulumi.set(__self__, "disable_auto_fallback", disable_auto_fallback)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_office_ips is not None:
            pulumi.set(__self__, "exclude_office_ips", exclude_office_ips)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if precedence is not None:
            pulumi.set(__self__, "precedence", precedence)
        if service_mode_v2_mode is not None:
            pulumi.set(__self__, "service_mode_v2_mode", service_mode_v2_mode)
        if service_mode_v2_port is not None:
            pulumi.set(__self__, "service_mode_v2_port", service_mode_v2_port)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if switch_locked is not None:
            pulumi.set(__self__, "switch_locked", switch_locked)
        if tunnel_protocol is not None:
            pulumi.set(__self__, "tunnel_protocol", tunnel_protocol)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Description of Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="allowModeSwitch")
    def allow_mode_switch(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow mode switch for this policy.
        """
        return pulumi.get(self, "allow_mode_switch")

    @allow_mode_switch.setter
    def allow_mode_switch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_mode_switch", value)

    @property
    @pulumi.getter(name="allowUpdates")
    def allow_updates(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow updates under this policy.
        """
        return pulumi.get(self, "allow_updates")

    @allow_updates.setter
    def allow_updates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_updates", value)

    @property
    @pulumi.getter(name="allowedToLeave")
    def allowed_to_leave(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow devices to leave the organization. Defaults to `true`.
        """
        return pulumi.get(self, "allowed_to_leave")

    @allowed_to_leave.setter
    def allowed_to_leave(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allowed_to_leave", value)

    @property
    @pulumi.getter(name="autoConnect")
    def auto_connect(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time in seconds to reconnect after having been disabled.
        """
        return pulumi.get(self, "auto_connect")

    @auto_connect.setter
    def auto_connect(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_connect", value)

    @property
    @pulumi.getter(name="captivePortal")
    def captive_portal(self) -> Optional[pulumi.Input[int]]:
        """
        The captive portal value for this policy. Defaults to `180`.
        """
        return pulumi.get(self, "captive_portal")

    @captive_portal.setter
    def captive_portal(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "captive_portal", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the policy refers to the default account policy.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="disableAutoFallback")
    def disable_auto_fallback(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable auto fallback for this policy.
        """
        return pulumi.get(self, "disable_auto_fallback")

    @disable_auto_fallback.setter
    def disable_auto_fallback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_auto_fallback", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the policy is enabled (cannot be set for default policies). Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="excludeOfficeIps")
    def exclude_office_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to add Microsoft IPs to split tunnel exclusions.
        """
        return pulumi.get(self, "exclude_office_ips")

    @exclude_office_ips.setter
    def exclude_office_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_office_ips", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[str]]:
        """
        Wirefilter expression to match a device against when evaluating whether this policy should take effect for that device.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def precedence(self) -> Optional[pulumi.Input[int]]:
        """
        The precedence of the policy. Lower values indicate higher precedence.
        """
        return pulumi.get(self, "precedence")

    @precedence.setter
    def precedence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "precedence", value)

    @property
    @pulumi.getter(name="serviceModeV2Mode")
    def service_mode_v2_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The service mode. Available values: `1dot1`, `warp`, `proxy`, `posture_only`, `warp_tunnel_only`. Defaults to `warp`.
        """
        return pulumi.get(self, "service_mode_v2_mode")

    @service_mode_v2_mode.setter
    def service_mode_v2_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_mode_v2_mode", value)

    @property
    @pulumi.getter(name="serviceModeV2Port")
    def service_mode_v2_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to use for the proxy service mode. Required when using `service_mode_v2_mode`.
        """
        return pulumi.get(self, "service_mode_v2_port")

    @service_mode_v2_port.setter
    def service_mode_v2_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_mode_v2_port", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[str]]:
        """
        The support URL that will be opened when sending feedback.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter(name="switchLocked")
    def switch_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Enablement of the ZT client switch lock.
        """
        return pulumi.get(self, "switch_locked")

    @switch_locked.setter
    def switch_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "switch_locked", value)

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Determines which tunnel protocol to use. Available values: `""`, `wireguard`, `masque`. Defaults to `wireguard`.
        """
        return pulumi.get(self, "tunnel_protocol")

    @tunnel_protocol.setter
    def tunnel_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_protocol", value)


@pulumi.input_type
class _ZeroTrustDeviceProfilesState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_mode_switch: Optional[pulumi.Input[bool]] = None,
                 allow_updates: Optional[pulumi.Input[bool]] = None,
                 allowed_to_leave: Optional[pulumi.Input[bool]] = None,
                 auto_connect: Optional[pulumi.Input[int]] = None,
                 captive_portal: Optional[pulumi.Input[int]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_auto_fallback: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 exclude_office_ips: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 precedence: Optional[pulumi.Input[int]] = None,
                 service_mode_v2_mode: Optional[pulumi.Input[str]] = None,
                 service_mode_v2_port: Optional[pulumi.Input[int]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 switch_locked: Optional[pulumi.Input[bool]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDeviceProfiles resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] allow_mode_switch: Whether to allow mode switch for this policy.
        :param pulumi.Input[bool] allow_updates: Whether to allow updates under this policy.
        :param pulumi.Input[bool] allowed_to_leave: Whether to allow devices to leave the organization. Defaults to `true`.
        :param pulumi.Input[int] auto_connect: The amount of time in seconds to reconnect after having been disabled.
        :param pulumi.Input[int] captive_portal: The captive portal value for this policy. Defaults to `180`.
        :param pulumi.Input[bool] default: Whether the policy refers to the default account policy.
        :param pulumi.Input[str] description: Description of Policy.
        :param pulumi.Input[bool] disable_auto_fallback: Whether to disable auto fallback for this policy.
        :param pulumi.Input[bool] enabled: Whether the policy is enabled (cannot be set for default policies). Defaults to `true`.
        :param pulumi.Input[bool] exclude_office_ips: Whether to add Microsoft IPs to split tunnel exclusions.
        :param pulumi.Input[str] match: Wirefilter expression to match a device against when evaluating whether this policy should take effect for that device.
        :param pulumi.Input[str] name: Name of the policy.
        :param pulumi.Input[int] precedence: The precedence of the policy. Lower values indicate higher precedence.
        :param pulumi.Input[str] service_mode_v2_mode: The service mode. Available values: `1dot1`, `warp`, `proxy`, `posture_only`, `warp_tunnel_only`. Defaults to `warp`.
        :param pulumi.Input[int] service_mode_v2_port: The port to use for the proxy service mode. Required when using `service_mode_v2_mode`.
        :param pulumi.Input[str] support_url: The support URL that will be opened when sending feedback.
        :param pulumi.Input[bool] switch_locked: Enablement of the ZT client switch lock.
        :param pulumi.Input[str] tunnel_protocol: Determines which tunnel protocol to use. Available values: `""`, `wireguard`, `masque`. Defaults to `wireguard`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_mode_switch is not None:
            pulumi.set(__self__, "allow_mode_switch", allow_mode_switch)
        if allow_updates is not None:
            pulumi.set(__self__, "allow_updates", allow_updates)
        if allowed_to_leave is not None:
            pulumi.set(__self__, "allowed_to_leave", allowed_to_leave)
        if auto_connect is not None:
            pulumi.set(__self__, "auto_connect", auto_connect)
        if captive_portal is not None:
            pulumi.set(__self__, "captive_portal", captive_portal)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_auto_fallback is not None:
            pulumi.set(__self__, "disable_auto_fallback", disable_auto_fallback)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_office_ips is not None:
            pulumi.set(__self__, "exclude_office_ips", exclude_office_ips)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if precedence is not None:
            pulumi.set(__self__, "precedence", precedence)
        if service_mode_v2_mode is not None:
            pulumi.set(__self__, "service_mode_v2_mode", service_mode_v2_mode)
        if service_mode_v2_port is not None:
            pulumi.set(__self__, "service_mode_v2_port", service_mode_v2_port)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if switch_locked is not None:
            pulumi.set(__self__, "switch_locked", switch_locked)
        if tunnel_protocol is not None:
            pulumi.set(__self__, "tunnel_protocol", tunnel_protocol)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowModeSwitch")
    def allow_mode_switch(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow mode switch for this policy.
        """
        return pulumi.get(self, "allow_mode_switch")

    @allow_mode_switch.setter
    def allow_mode_switch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_mode_switch", value)

    @property
    @pulumi.getter(name="allowUpdates")
    def allow_updates(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow updates under this policy.
        """
        return pulumi.get(self, "allow_updates")

    @allow_updates.setter
    def allow_updates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_updates", value)

    @property
    @pulumi.getter(name="allowedToLeave")
    def allowed_to_leave(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow devices to leave the organization. Defaults to `true`.
        """
        return pulumi.get(self, "allowed_to_leave")

    @allowed_to_leave.setter
    def allowed_to_leave(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allowed_to_leave", value)

    @property
    @pulumi.getter(name="autoConnect")
    def auto_connect(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time in seconds to reconnect after having been disabled.
        """
        return pulumi.get(self, "auto_connect")

    @auto_connect.setter
    def auto_connect(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_connect", value)

    @property
    @pulumi.getter(name="captivePortal")
    def captive_portal(self) -> Optional[pulumi.Input[int]]:
        """
        The captive portal value for this policy. Defaults to `180`.
        """
        return pulumi.get(self, "captive_portal")

    @captive_portal.setter
    def captive_portal(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "captive_portal", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the policy refers to the default account policy.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableAutoFallback")
    def disable_auto_fallback(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable auto fallback for this policy.
        """
        return pulumi.get(self, "disable_auto_fallback")

    @disable_auto_fallback.setter
    def disable_auto_fallback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_auto_fallback", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the policy is enabled (cannot be set for default policies). Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="excludeOfficeIps")
    def exclude_office_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to add Microsoft IPs to split tunnel exclusions.
        """
        return pulumi.get(self, "exclude_office_ips")

    @exclude_office_ips.setter
    def exclude_office_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_office_ips", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[str]]:
        """
        Wirefilter expression to match a device against when evaluating whether this policy should take effect for that device.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def precedence(self) -> Optional[pulumi.Input[int]]:
        """
        The precedence of the policy. Lower values indicate higher precedence.
        """
        return pulumi.get(self, "precedence")

    @precedence.setter
    def precedence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "precedence", value)

    @property
    @pulumi.getter(name="serviceModeV2Mode")
    def service_mode_v2_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The service mode. Available values: `1dot1`, `warp`, `proxy`, `posture_only`, `warp_tunnel_only`. Defaults to `warp`.
        """
        return pulumi.get(self, "service_mode_v2_mode")

    @service_mode_v2_mode.setter
    def service_mode_v2_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_mode_v2_mode", value)

    @property
    @pulumi.getter(name="serviceModeV2Port")
    def service_mode_v2_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to use for the proxy service mode. Required when using `service_mode_v2_mode`.
        """
        return pulumi.get(self, "service_mode_v2_port")

    @service_mode_v2_port.setter
    def service_mode_v2_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_mode_v2_port", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[str]]:
        """
        The support URL that will be opened when sending feedback.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter(name="switchLocked")
    def switch_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Enablement of the ZT client switch lock.
        """
        return pulumi.get(self, "switch_locked")

    @switch_locked.setter
    def switch_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "switch_locked", value)

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Determines which tunnel protocol to use. Available values: `""`, `wireguard`, `masque`. Defaults to `wireguard`.
        """
        return pulumi.get(self, "tunnel_protocol")

    @tunnel_protocol.setter
    def tunnel_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_protocol", value)


class ZeroTrustDeviceProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_mode_switch: Optional[pulumi.Input[bool]] = None,
                 allow_updates: Optional[pulumi.Input[bool]] = None,
                 allowed_to_leave: Optional[pulumi.Input[bool]] = None,
                 auto_connect: Optional[pulumi.Input[int]] = None,
                 captive_portal: Optional[pulumi.Input[int]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_auto_fallback: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 exclude_office_ips: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 precedence: Optional[pulumi.Input[int]] = None,
                 service_mode_v2_mode: Optional[pulumi.Input[str]] = None,
                 service_mode_v2_port: Optional[pulumi.Input[int]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 switch_locked: Optional[pulumi.Input[bool]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Device Settings Policy resource. Device policies configure settings applied to WARP devices.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        developer_warp_policy = cloudflare.ZeroTrustDeviceProfiles("developer_warp_policy",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="Developers WARP settings policy",
            description="Developers WARP settings policy description",
            precedence=10,
            match="any(identity.groups.name[*] in {\\"Developers\\"})",
            default=False,
            enabled=True,
            allow_mode_switch=True,
            allow_updates=True,
            allowed_to_leave=True,
            auto_connect=0,
            captive_portal=5,
            disable_auto_fallback=True,
            support_url="https://cloudflare.com",
            switch_locked=True,
            service_mode_v2_mode="warp",
            service_mode_v2_port=3000,
            exclude_office_ips=False)
        ```

        ## Import

        For default device settings policies you must use "default" as the policy ID.

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDeviceProfiles:ZeroTrustDeviceProfiles example <account_id>/<device_policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] allow_mode_switch: Whether to allow mode switch for this policy.
        :param pulumi.Input[bool] allow_updates: Whether to allow updates under this policy.
        :param pulumi.Input[bool] allowed_to_leave: Whether to allow devices to leave the organization. Defaults to `true`.
        :param pulumi.Input[int] auto_connect: The amount of time in seconds to reconnect after having been disabled.
        :param pulumi.Input[int] captive_portal: The captive portal value for this policy. Defaults to `180`.
        :param pulumi.Input[bool] default: Whether the policy refers to the default account policy.
        :param pulumi.Input[str] description: Description of Policy.
        :param pulumi.Input[bool] disable_auto_fallback: Whether to disable auto fallback for this policy.
        :param pulumi.Input[bool] enabled: Whether the policy is enabled (cannot be set for default policies). Defaults to `true`.
        :param pulumi.Input[bool] exclude_office_ips: Whether to add Microsoft IPs to split tunnel exclusions.
        :param pulumi.Input[str] match: Wirefilter expression to match a device against when evaluating whether this policy should take effect for that device.
        :param pulumi.Input[str] name: Name of the policy.
        :param pulumi.Input[int] precedence: The precedence of the policy. Lower values indicate higher precedence.
        :param pulumi.Input[str] service_mode_v2_mode: The service mode. Available values: `1dot1`, `warp`, `proxy`, `posture_only`, `warp_tunnel_only`. Defaults to `warp`.
        :param pulumi.Input[int] service_mode_v2_port: The port to use for the proxy service mode. Required when using `service_mode_v2_mode`.
        :param pulumi.Input[str] support_url: The support URL that will be opened when sending feedback.
        :param pulumi.Input[bool] switch_locked: Enablement of the ZT client switch lock.
        :param pulumi.Input[str] tunnel_protocol: Determines which tunnel protocol to use. Available values: `""`, `wireguard`, `masque`. Defaults to `wireguard`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDeviceProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Device Settings Policy resource. Device policies configure settings applied to WARP devices.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        developer_warp_policy = cloudflare.ZeroTrustDeviceProfiles("developer_warp_policy",
            account_id="f037e56e89293a057740de681ac9abbe",
            name="Developers WARP settings policy",
            description="Developers WARP settings policy description",
            precedence=10,
            match="any(identity.groups.name[*] in {\\"Developers\\"})",
            default=False,
            enabled=True,
            allow_mode_switch=True,
            allow_updates=True,
            allowed_to_leave=True,
            auto_connect=0,
            captive_portal=5,
            disable_auto_fallback=True,
            support_url="https://cloudflare.com",
            switch_locked=True,
            service_mode_v2_mode="warp",
            service_mode_v2_port=3000,
            exclude_office_ips=False)
        ```

        ## Import

        For default device settings policies you must use "default" as the policy ID.

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDeviceProfiles:ZeroTrustDeviceProfiles example <account_id>/<device_policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDeviceProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDeviceProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 allow_mode_switch: Optional[pulumi.Input[bool]] = None,
                 allow_updates: Optional[pulumi.Input[bool]] = None,
                 allowed_to_leave: Optional[pulumi.Input[bool]] = None,
                 auto_connect: Optional[pulumi.Input[int]] = None,
                 captive_portal: Optional[pulumi.Input[int]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_auto_fallback: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 exclude_office_ips: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 precedence: Optional[pulumi.Input[int]] = None,
                 service_mode_v2_mode: Optional[pulumi.Input[str]] = None,
                 service_mode_v2_port: Optional[pulumi.Input[int]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 switch_locked: Optional[pulumi.Input[bool]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDeviceProfilesArgs.__new__(ZeroTrustDeviceProfilesArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["allow_mode_switch"] = allow_mode_switch
            __props__.__dict__["allow_updates"] = allow_updates
            __props__.__dict__["allowed_to_leave"] = allowed_to_leave
            __props__.__dict__["auto_connect"] = auto_connect
            __props__.__dict__["captive_portal"] = captive_portal
            __props__.__dict__["default"] = default
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_auto_fallback"] = disable_auto_fallback
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["exclude_office_ips"] = exclude_office_ips
            __props__.__dict__["match"] = match
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["precedence"] = precedence
            __props__.__dict__["service_mode_v2_mode"] = service_mode_v2_mode
            __props__.__dict__["service_mode_v2_port"] = service_mode_v2_port
            __props__.__dict__["support_url"] = support_url
            __props__.__dict__["switch_locked"] = switch_locked
            __props__.__dict__["tunnel_protocol"] = tunnel_protocol
        super(ZeroTrustDeviceProfiles, __self__).__init__(
            'cloudflare:index/zeroTrustDeviceProfiles:ZeroTrustDeviceProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            allow_mode_switch: Optional[pulumi.Input[bool]] = None,
            allow_updates: Optional[pulumi.Input[bool]] = None,
            allowed_to_leave: Optional[pulumi.Input[bool]] = None,
            auto_connect: Optional[pulumi.Input[int]] = None,
            captive_portal: Optional[pulumi.Input[int]] = None,
            default: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disable_auto_fallback: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            exclude_office_ips: Optional[pulumi.Input[bool]] = None,
            match: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            precedence: Optional[pulumi.Input[int]] = None,
            service_mode_v2_mode: Optional[pulumi.Input[str]] = None,
            service_mode_v2_port: Optional[pulumi.Input[int]] = None,
            support_url: Optional[pulumi.Input[str]] = None,
            switch_locked: Optional[pulumi.Input[bool]] = None,
            tunnel_protocol: Optional[pulumi.Input[str]] = None) -> 'ZeroTrustDeviceProfiles':
        """
        Get an existing ZeroTrustDeviceProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] allow_mode_switch: Whether to allow mode switch for this policy.
        :param pulumi.Input[bool] allow_updates: Whether to allow updates under this policy.
        :param pulumi.Input[bool] allowed_to_leave: Whether to allow devices to leave the organization. Defaults to `true`.
        :param pulumi.Input[int] auto_connect: The amount of time in seconds to reconnect after having been disabled.
        :param pulumi.Input[int] captive_portal: The captive portal value for this policy. Defaults to `180`.
        :param pulumi.Input[bool] default: Whether the policy refers to the default account policy.
        :param pulumi.Input[str] description: Description of Policy.
        :param pulumi.Input[bool] disable_auto_fallback: Whether to disable auto fallback for this policy.
        :param pulumi.Input[bool] enabled: Whether the policy is enabled (cannot be set for default policies). Defaults to `true`.
        :param pulumi.Input[bool] exclude_office_ips: Whether to add Microsoft IPs to split tunnel exclusions.
        :param pulumi.Input[str] match: Wirefilter expression to match a device against when evaluating whether this policy should take effect for that device.
        :param pulumi.Input[str] name: Name of the policy.
        :param pulumi.Input[int] precedence: The precedence of the policy. Lower values indicate higher precedence.
        :param pulumi.Input[str] service_mode_v2_mode: The service mode. Available values: `1dot1`, `warp`, `proxy`, `posture_only`, `warp_tunnel_only`. Defaults to `warp`.
        :param pulumi.Input[int] service_mode_v2_port: The port to use for the proxy service mode. Required when using `service_mode_v2_mode`.
        :param pulumi.Input[str] support_url: The support URL that will be opened when sending feedback.
        :param pulumi.Input[bool] switch_locked: Enablement of the ZT client switch lock.
        :param pulumi.Input[str] tunnel_protocol: Determines which tunnel protocol to use. Available values: `""`, `wireguard`, `masque`. Defaults to `wireguard`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDeviceProfilesState.__new__(_ZeroTrustDeviceProfilesState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allow_mode_switch"] = allow_mode_switch
        __props__.__dict__["allow_updates"] = allow_updates
        __props__.__dict__["allowed_to_leave"] = allowed_to_leave
        __props__.__dict__["auto_connect"] = auto_connect
        __props__.__dict__["captive_portal"] = captive_portal
        __props__.__dict__["default"] = default
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_auto_fallback"] = disable_auto_fallback
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["exclude_office_ips"] = exclude_office_ips
        __props__.__dict__["match"] = match
        __props__.__dict__["name"] = name
        __props__.__dict__["precedence"] = precedence
        __props__.__dict__["service_mode_v2_mode"] = service_mode_v2_mode
        __props__.__dict__["service_mode_v2_port"] = service_mode_v2_port
        __props__.__dict__["support_url"] = support_url
        __props__.__dict__["switch_locked"] = switch_locked
        __props__.__dict__["tunnel_protocol"] = tunnel_protocol
        return ZeroTrustDeviceProfiles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowModeSwitch")
    def allow_mode_switch(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow mode switch for this policy.
        """
        return pulumi.get(self, "allow_mode_switch")

    @property
    @pulumi.getter(name="allowUpdates")
    def allow_updates(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow updates under this policy.
        """
        return pulumi.get(self, "allow_updates")

    @property
    @pulumi.getter(name="allowedToLeave")
    def allowed_to_leave(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow devices to leave the organization. Defaults to `true`.
        """
        return pulumi.get(self, "allowed_to_leave")

    @property
    @pulumi.getter(name="autoConnect")
    def auto_connect(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time in seconds to reconnect after having been disabled.
        """
        return pulumi.get(self, "auto_connect")

    @property
    @pulumi.getter(name="captivePortal")
    def captive_portal(self) -> pulumi.Output[Optional[int]]:
        """
        The captive portal value for this policy. Defaults to `180`.
        """
        return pulumi.get(self, "captive_portal")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the policy refers to the default account policy.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of Policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableAutoFallback")
    def disable_auto_fallback(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to disable auto fallback for this policy.
        """
        return pulumi.get(self, "disable_auto_fallback")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the policy is enabled (cannot be set for default policies). Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="excludeOfficeIps")
    def exclude_office_ips(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to add Microsoft IPs to split tunnel exclusions.
        """
        return pulumi.get(self, "exclude_office_ips")

    @property
    @pulumi.getter
    def match(self) -> pulumi.Output[Optional[str]]:
        """
        Wirefilter expression to match a device against when evaluating whether this policy should take effect for that device.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def precedence(self) -> pulumi.Output[Optional[int]]:
        """
        The precedence of the policy. Lower values indicate higher precedence.
        """
        return pulumi.get(self, "precedence")

    @property
    @pulumi.getter(name="serviceModeV2Mode")
    def service_mode_v2_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The service mode. Available values: `1dot1`, `warp`, `proxy`, `posture_only`, `warp_tunnel_only`. Defaults to `warp`.
        """
        return pulumi.get(self, "service_mode_v2_mode")

    @property
    @pulumi.getter(name="serviceModeV2Port")
    def service_mode_v2_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port to use for the proxy service mode. Required when using `service_mode_v2_mode`.
        """
        return pulumi.get(self, "service_mode_v2_port")

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> pulumi.Output[Optional[str]]:
        """
        The support URL that will be opened when sending feedback.
        """
        return pulumi.get(self, "support_url")

    @property
    @pulumi.getter(name="switchLocked")
    def switch_locked(self) -> pulumi.Output[Optional[bool]]:
        """
        Enablement of the ZT client switch lock.
        """
        return pulumi.get(self, "switch_locked")

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Determines which tunnel protocol to use. Available values: `""`, `wireguard`, `masque`. Defaults to `wireguard`.
        """
        return pulumi.get(self, "tunnel_protocol")

