# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustGatewaySettingsArgs', 'ZeroTrustGatewaySettings']

@pulumi.input_type
class ZeroTrustGatewaySettingsArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 activity_log_enabled: Optional[pulumi.Input[bool]] = None,
                 antivirus: Optional[pulumi.Input['ZeroTrustGatewaySettingsAntivirusArgs']] = None,
                 block_page: Optional[pulumi.Input['ZeroTrustGatewaySettingsBlockPageArgs']] = None,
                 body_scanning: Optional[pulumi.Input['ZeroTrustGatewaySettingsBodyScanningArgs']] = None,
                 certificate: Optional[pulumi.Input['ZeroTrustGatewaySettingsCertificateArgs']] = None,
                 custom_certificate: Optional[pulumi.Input['ZeroTrustGatewaySettingsCustomCertificateArgs']] = None,
                 extended_email_matching: Optional[pulumi.Input['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs']] = None,
                 fips: Optional[pulumi.Input['ZeroTrustGatewaySettingsFipsArgs']] = None,
                 logging: Optional[pulumi.Input['ZeroTrustGatewaySettingsLoggingArgs']] = None,
                 non_identity_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 payload_log: Optional[pulumi.Input['ZeroTrustGatewaySettingsPayloadLogArgs']] = None,
                 protocol_detection_enabled: Optional[pulumi.Input[bool]] = None,
                 proxy: Optional[pulumi.Input['ZeroTrustGatewaySettingsProxyArgs']] = None,
                 ssh_session_log: Optional[pulumi.Input['ZeroTrustGatewaySettingsSshSessionLogArgs']] = None,
                 tls_decrypt_enabled: Optional[pulumi.Input[bool]] = None,
                 url_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ZeroTrustGatewaySettings resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] activity_log_enabled: Whether to enable the activity log.
        :param pulumi.Input['ZeroTrustGatewaySettingsAntivirusArgs'] antivirus: Configuration block for antivirus traffic scanning.
        :param pulumi.Input['ZeroTrustGatewaySettingsBlockPageArgs'] block_page: Configuration for a custom block page.
        :param pulumi.Input['ZeroTrustGatewaySettingsBodyScanningArgs'] body_scanning: Configuration for body scanning.
        :param pulumi.Input['ZeroTrustGatewaySettingsCertificateArgs'] certificate: Configuration for TLS interception certificate. This will be required starting Feb 2025.
        :param pulumi.Input['ZeroTrustGatewaySettingsCustomCertificateArgs'] custom_certificate: Configuration for custom certificates / BYO-PKI. Conflicts with `certificate`.
        :param pulumi.Input['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs'] extended_email_matching: Configuration for extended e-mail matching.
        :param pulumi.Input['ZeroTrustGatewaySettingsFipsArgs'] fips: Configure compliance with Federal Information Processing Standards.
        :param pulumi.Input[bool] non_identity_browser_isolation_enabled: Enable non-identity onramp for Browser Isolation. Defaults to `false`.
        :param pulumi.Input['ZeroTrustGatewaySettingsPayloadLogArgs'] payload_log: Configuration for DLP Payload Logging.
        :param pulumi.Input[bool] protocol_detection_enabled: Indicator that protocol detection is enabled.
        :param pulumi.Input['ZeroTrustGatewaySettingsProxyArgs'] proxy: Configuration block for specifying which protocols are proxied.
        :param pulumi.Input['ZeroTrustGatewaySettingsSshSessionLogArgs'] ssh_session_log: Configuration for SSH Session Logging.
        :param pulumi.Input[bool] tls_decrypt_enabled: Indicator that decryption of TLS traffic is enabled.
        :param pulumi.Input[bool] url_browser_isolation_enabled: Safely browse websites in Browser Isolation through a URL. Defaults to `false`.
        """
        pulumi.set(__self__, "account_id", account_id)
        if activity_log_enabled is not None:
            pulumi.set(__self__, "activity_log_enabled", activity_log_enabled)
        if antivirus is not None:
            pulumi.set(__self__, "antivirus", antivirus)
        if block_page is not None:
            pulumi.set(__self__, "block_page", block_page)
        if body_scanning is not None:
            pulumi.set(__self__, "body_scanning", body_scanning)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if custom_certificate is not None:
            warnings.warn("""Use `certificate` instead. Continuing to use custom_certificate may result in inconsistent configuration.""", DeprecationWarning)
            pulumi.log.warn("""custom_certificate is deprecated: Use `certificate` instead. Continuing to use custom_certificate may result in inconsistent configuration.""")
        if custom_certificate is not None:
            pulumi.set(__self__, "custom_certificate", custom_certificate)
        if extended_email_matching is not None:
            pulumi.set(__self__, "extended_email_matching", extended_email_matching)
        if fips is not None:
            pulumi.set(__self__, "fips", fips)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if non_identity_browser_isolation_enabled is not None:
            pulumi.set(__self__, "non_identity_browser_isolation_enabled", non_identity_browser_isolation_enabled)
        if payload_log is not None:
            pulumi.set(__self__, "payload_log", payload_log)
        if protocol_detection_enabled is not None:
            pulumi.set(__self__, "protocol_detection_enabled", protocol_detection_enabled)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if ssh_session_log is not None:
            pulumi.set(__self__, "ssh_session_log", ssh_session_log)
        if tls_decrypt_enabled is not None:
            pulumi.set(__self__, "tls_decrypt_enabled", tls_decrypt_enabled)
        if url_browser_isolation_enabled is not None:
            pulumi.set(__self__, "url_browser_isolation_enabled", url_browser_isolation_enabled)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="activityLogEnabled")
    def activity_log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the activity log.
        """
        return pulumi.get(self, "activity_log_enabled")

    @activity_log_enabled.setter
    def activity_log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activity_log_enabled", value)

    @property
    @pulumi.getter
    def antivirus(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsAntivirusArgs']]:
        """
        Configuration block for antivirus traffic scanning.
        """
        return pulumi.get(self, "antivirus")

    @antivirus.setter
    def antivirus(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsAntivirusArgs']]):
        pulumi.set(self, "antivirus", value)

    @property
    @pulumi.getter(name="blockPage")
    def block_page(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsBlockPageArgs']]:
        """
        Configuration for a custom block page.
        """
        return pulumi.get(self, "block_page")

    @block_page.setter
    def block_page(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsBlockPageArgs']]):
        pulumi.set(self, "block_page", value)

    @property
    @pulumi.getter(name="bodyScanning")
    def body_scanning(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsBodyScanningArgs']]:
        """
        Configuration for body scanning.
        """
        return pulumi.get(self, "body_scanning")

    @body_scanning.setter
    def body_scanning(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsBodyScanningArgs']]):
        pulumi.set(self, "body_scanning", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsCertificateArgs']]:
        """
        Configuration for TLS interception certificate. This will be required starting Feb 2025.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="customCertificate")
    @_utilities.deprecated("""Use `certificate` instead. Continuing to use custom_certificate may result in inconsistent configuration.""")
    def custom_certificate(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsCustomCertificateArgs']]:
        """
        Configuration for custom certificates / BYO-PKI. Conflicts with `certificate`.
        """
        return pulumi.get(self, "custom_certificate")

    @custom_certificate.setter
    def custom_certificate(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsCustomCertificateArgs']]):
        pulumi.set(self, "custom_certificate", value)

    @property
    @pulumi.getter(name="extendedEmailMatching")
    def extended_email_matching(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs']]:
        """
        Configuration for extended e-mail matching.
        """
        return pulumi.get(self, "extended_email_matching")

    @extended_email_matching.setter
    def extended_email_matching(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs']]):
        pulumi.set(self, "extended_email_matching", value)

    @property
    @pulumi.getter
    def fips(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsFipsArgs']]:
        """
        Configure compliance with Federal Information Processing Standards.
        """
        return pulumi.get(self, "fips")

    @fips.setter
    def fips(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsFipsArgs']]):
        pulumi.set(self, "fips", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsLoggingArgs']]:
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="nonIdentityBrowserIsolationEnabled")
    def non_identity_browser_isolation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable non-identity onramp for Browser Isolation. Defaults to `false`.
        """
        return pulumi.get(self, "non_identity_browser_isolation_enabled")

    @non_identity_browser_isolation_enabled.setter
    def non_identity_browser_isolation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "non_identity_browser_isolation_enabled", value)

    @property
    @pulumi.getter(name="payloadLog")
    def payload_log(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsPayloadLogArgs']]:
        """
        Configuration for DLP Payload Logging.
        """
        return pulumi.get(self, "payload_log")

    @payload_log.setter
    def payload_log(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsPayloadLogArgs']]):
        pulumi.set(self, "payload_log", value)

    @property
    @pulumi.getter(name="protocolDetectionEnabled")
    def protocol_detection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that protocol detection is enabled.
        """
        return pulumi.get(self, "protocol_detection_enabled")

    @protocol_detection_enabled.setter
    def protocol_detection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protocol_detection_enabled", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsProxyArgs']]:
        """
        Configuration block for specifying which protocols are proxied.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="sshSessionLog")
    def ssh_session_log(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsSshSessionLogArgs']]:
        """
        Configuration for SSH Session Logging.
        """
        return pulumi.get(self, "ssh_session_log")

    @ssh_session_log.setter
    def ssh_session_log(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsSshSessionLogArgs']]):
        pulumi.set(self, "ssh_session_log", value)

    @property
    @pulumi.getter(name="tlsDecryptEnabled")
    def tls_decrypt_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that decryption of TLS traffic is enabled.
        """
        return pulumi.get(self, "tls_decrypt_enabled")

    @tls_decrypt_enabled.setter
    def tls_decrypt_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_decrypt_enabled", value)

    @property
    @pulumi.getter(name="urlBrowserIsolationEnabled")
    def url_browser_isolation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Safely browse websites in Browser Isolation through a URL. Defaults to `false`.
        """
        return pulumi.get(self, "url_browser_isolation_enabled")

    @url_browser_isolation_enabled.setter
    def url_browser_isolation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "url_browser_isolation_enabled", value)


@pulumi.input_type
class _ZeroTrustGatewaySettingsState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 activity_log_enabled: Optional[pulumi.Input[bool]] = None,
                 antivirus: Optional[pulumi.Input['ZeroTrustGatewaySettingsAntivirusArgs']] = None,
                 block_page: Optional[pulumi.Input['ZeroTrustGatewaySettingsBlockPageArgs']] = None,
                 body_scanning: Optional[pulumi.Input['ZeroTrustGatewaySettingsBodyScanningArgs']] = None,
                 certificate: Optional[pulumi.Input['ZeroTrustGatewaySettingsCertificateArgs']] = None,
                 custom_certificate: Optional[pulumi.Input['ZeroTrustGatewaySettingsCustomCertificateArgs']] = None,
                 extended_email_matching: Optional[pulumi.Input['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs']] = None,
                 fips: Optional[pulumi.Input['ZeroTrustGatewaySettingsFipsArgs']] = None,
                 logging: Optional[pulumi.Input['ZeroTrustGatewaySettingsLoggingArgs']] = None,
                 non_identity_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 payload_log: Optional[pulumi.Input['ZeroTrustGatewaySettingsPayloadLogArgs']] = None,
                 protocol_detection_enabled: Optional[pulumi.Input[bool]] = None,
                 proxy: Optional[pulumi.Input['ZeroTrustGatewaySettingsProxyArgs']] = None,
                 ssh_session_log: Optional[pulumi.Input['ZeroTrustGatewaySettingsSshSessionLogArgs']] = None,
                 tls_decrypt_enabled: Optional[pulumi.Input[bool]] = None,
                 url_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustGatewaySettings resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] activity_log_enabled: Whether to enable the activity log.
        :param pulumi.Input['ZeroTrustGatewaySettingsAntivirusArgs'] antivirus: Configuration block for antivirus traffic scanning.
        :param pulumi.Input['ZeroTrustGatewaySettingsBlockPageArgs'] block_page: Configuration for a custom block page.
        :param pulumi.Input['ZeroTrustGatewaySettingsBodyScanningArgs'] body_scanning: Configuration for body scanning.
        :param pulumi.Input['ZeroTrustGatewaySettingsCertificateArgs'] certificate: Configuration for TLS interception certificate. This will be required starting Feb 2025.
        :param pulumi.Input['ZeroTrustGatewaySettingsCustomCertificateArgs'] custom_certificate: Configuration for custom certificates / BYO-PKI. Conflicts with `certificate`.
        :param pulumi.Input['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs'] extended_email_matching: Configuration for extended e-mail matching.
        :param pulumi.Input['ZeroTrustGatewaySettingsFipsArgs'] fips: Configure compliance with Federal Information Processing Standards.
        :param pulumi.Input[bool] non_identity_browser_isolation_enabled: Enable non-identity onramp for Browser Isolation. Defaults to `false`.
        :param pulumi.Input['ZeroTrustGatewaySettingsPayloadLogArgs'] payload_log: Configuration for DLP Payload Logging.
        :param pulumi.Input[bool] protocol_detection_enabled: Indicator that protocol detection is enabled.
        :param pulumi.Input['ZeroTrustGatewaySettingsProxyArgs'] proxy: Configuration block for specifying which protocols are proxied.
        :param pulumi.Input['ZeroTrustGatewaySettingsSshSessionLogArgs'] ssh_session_log: Configuration for SSH Session Logging.
        :param pulumi.Input[bool] tls_decrypt_enabled: Indicator that decryption of TLS traffic is enabled.
        :param pulumi.Input[bool] url_browser_isolation_enabled: Safely browse websites in Browser Isolation through a URL. Defaults to `false`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if activity_log_enabled is not None:
            pulumi.set(__self__, "activity_log_enabled", activity_log_enabled)
        if antivirus is not None:
            pulumi.set(__self__, "antivirus", antivirus)
        if block_page is not None:
            pulumi.set(__self__, "block_page", block_page)
        if body_scanning is not None:
            pulumi.set(__self__, "body_scanning", body_scanning)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if custom_certificate is not None:
            warnings.warn("""Use `certificate` instead. Continuing to use custom_certificate may result in inconsistent configuration.""", DeprecationWarning)
            pulumi.log.warn("""custom_certificate is deprecated: Use `certificate` instead. Continuing to use custom_certificate may result in inconsistent configuration.""")
        if custom_certificate is not None:
            pulumi.set(__self__, "custom_certificate", custom_certificate)
        if extended_email_matching is not None:
            pulumi.set(__self__, "extended_email_matching", extended_email_matching)
        if fips is not None:
            pulumi.set(__self__, "fips", fips)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if non_identity_browser_isolation_enabled is not None:
            pulumi.set(__self__, "non_identity_browser_isolation_enabled", non_identity_browser_isolation_enabled)
        if payload_log is not None:
            pulumi.set(__self__, "payload_log", payload_log)
        if protocol_detection_enabled is not None:
            pulumi.set(__self__, "protocol_detection_enabled", protocol_detection_enabled)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if ssh_session_log is not None:
            pulumi.set(__self__, "ssh_session_log", ssh_session_log)
        if tls_decrypt_enabled is not None:
            pulumi.set(__self__, "tls_decrypt_enabled", tls_decrypt_enabled)
        if url_browser_isolation_enabled is not None:
            pulumi.set(__self__, "url_browser_isolation_enabled", url_browser_isolation_enabled)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="activityLogEnabled")
    def activity_log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the activity log.
        """
        return pulumi.get(self, "activity_log_enabled")

    @activity_log_enabled.setter
    def activity_log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activity_log_enabled", value)

    @property
    @pulumi.getter
    def antivirus(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsAntivirusArgs']]:
        """
        Configuration block for antivirus traffic scanning.
        """
        return pulumi.get(self, "antivirus")

    @antivirus.setter
    def antivirus(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsAntivirusArgs']]):
        pulumi.set(self, "antivirus", value)

    @property
    @pulumi.getter(name="blockPage")
    def block_page(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsBlockPageArgs']]:
        """
        Configuration for a custom block page.
        """
        return pulumi.get(self, "block_page")

    @block_page.setter
    def block_page(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsBlockPageArgs']]):
        pulumi.set(self, "block_page", value)

    @property
    @pulumi.getter(name="bodyScanning")
    def body_scanning(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsBodyScanningArgs']]:
        """
        Configuration for body scanning.
        """
        return pulumi.get(self, "body_scanning")

    @body_scanning.setter
    def body_scanning(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsBodyScanningArgs']]):
        pulumi.set(self, "body_scanning", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsCertificateArgs']]:
        """
        Configuration for TLS interception certificate. This will be required starting Feb 2025.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="customCertificate")
    @_utilities.deprecated("""Use `certificate` instead. Continuing to use custom_certificate may result in inconsistent configuration.""")
    def custom_certificate(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsCustomCertificateArgs']]:
        """
        Configuration for custom certificates / BYO-PKI. Conflicts with `certificate`.
        """
        return pulumi.get(self, "custom_certificate")

    @custom_certificate.setter
    def custom_certificate(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsCustomCertificateArgs']]):
        pulumi.set(self, "custom_certificate", value)

    @property
    @pulumi.getter(name="extendedEmailMatching")
    def extended_email_matching(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs']]:
        """
        Configuration for extended e-mail matching.
        """
        return pulumi.get(self, "extended_email_matching")

    @extended_email_matching.setter
    def extended_email_matching(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs']]):
        pulumi.set(self, "extended_email_matching", value)

    @property
    @pulumi.getter
    def fips(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsFipsArgs']]:
        """
        Configure compliance with Federal Information Processing Standards.
        """
        return pulumi.get(self, "fips")

    @fips.setter
    def fips(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsFipsArgs']]):
        pulumi.set(self, "fips", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsLoggingArgs']]:
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="nonIdentityBrowserIsolationEnabled")
    def non_identity_browser_isolation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable non-identity onramp for Browser Isolation. Defaults to `false`.
        """
        return pulumi.get(self, "non_identity_browser_isolation_enabled")

    @non_identity_browser_isolation_enabled.setter
    def non_identity_browser_isolation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "non_identity_browser_isolation_enabled", value)

    @property
    @pulumi.getter(name="payloadLog")
    def payload_log(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsPayloadLogArgs']]:
        """
        Configuration for DLP Payload Logging.
        """
        return pulumi.get(self, "payload_log")

    @payload_log.setter
    def payload_log(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsPayloadLogArgs']]):
        pulumi.set(self, "payload_log", value)

    @property
    @pulumi.getter(name="protocolDetectionEnabled")
    def protocol_detection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that protocol detection is enabled.
        """
        return pulumi.get(self, "protocol_detection_enabled")

    @protocol_detection_enabled.setter
    def protocol_detection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protocol_detection_enabled", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsProxyArgs']]:
        """
        Configuration block for specifying which protocols are proxied.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="sshSessionLog")
    def ssh_session_log(self) -> Optional[pulumi.Input['ZeroTrustGatewaySettingsSshSessionLogArgs']]:
        """
        Configuration for SSH Session Logging.
        """
        return pulumi.get(self, "ssh_session_log")

    @ssh_session_log.setter
    def ssh_session_log(self, value: Optional[pulumi.Input['ZeroTrustGatewaySettingsSshSessionLogArgs']]):
        pulumi.set(self, "ssh_session_log", value)

    @property
    @pulumi.getter(name="tlsDecryptEnabled")
    def tls_decrypt_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicator that decryption of TLS traffic is enabled.
        """
        return pulumi.get(self, "tls_decrypt_enabled")

    @tls_decrypt_enabled.setter
    def tls_decrypt_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_decrypt_enabled", value)

    @property
    @pulumi.getter(name="urlBrowserIsolationEnabled")
    def url_browser_isolation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Safely browse websites in Browser Isolation through a URL. Defaults to `false`.
        """
        return pulumi.get(self, "url_browser_isolation_enabled")

    @url_browser_isolation_enabled.setter
    def url_browser_isolation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "url_browser_isolation_enabled", value)


class ZeroTrustGatewaySettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 activity_log_enabled: Optional[pulumi.Input[bool]] = None,
                 antivirus: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsAntivirusArgs', 'ZeroTrustGatewaySettingsAntivirusArgsDict']]] = None,
                 block_page: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsBlockPageArgs', 'ZeroTrustGatewaySettingsBlockPageArgsDict']]] = None,
                 body_scanning: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsBodyScanningArgs', 'ZeroTrustGatewaySettingsBodyScanningArgsDict']]] = None,
                 certificate: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsCertificateArgs', 'ZeroTrustGatewaySettingsCertificateArgsDict']]] = None,
                 custom_certificate: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsCustomCertificateArgs', 'ZeroTrustGatewaySettingsCustomCertificateArgsDict']]] = None,
                 extended_email_matching: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs', 'ZeroTrustGatewaySettingsExtendedEmailMatchingArgsDict']]] = None,
                 fips: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsFipsArgs', 'ZeroTrustGatewaySettingsFipsArgsDict']]] = None,
                 logging: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsLoggingArgs', 'ZeroTrustGatewaySettingsLoggingArgsDict']]] = None,
                 non_identity_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 payload_log: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsPayloadLogArgs', 'ZeroTrustGatewaySettingsPayloadLogArgsDict']]] = None,
                 protocol_detection_enabled: Optional[pulumi.Input[bool]] = None,
                 proxy: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsProxyArgs', 'ZeroTrustGatewaySettingsProxyArgsDict']]] = None,
                 ssh_session_log: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsSshSessionLogArgs', 'ZeroTrustGatewaySettingsSshSessionLogArgsDict']]] = None,
                 tls_decrypt_enabled: Optional[pulumi.Input[bool]] = None,
                 url_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Teams Account resource. The Teams Account
        resource defines configuration for secure web gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.ZeroTrustGatewaySettings("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            tls_decrypt_enabled=True,
            protocol_detection_enabled=True,
            block_page={
                "footer_text": "hello",
                "header_text": "hello",
                "logo_path": "https://example.com/logo.jpg",
                "background_color": "#000000",
            },
            body_scanning={
                "inspection_mode": "deep",
            },
            antivirus={
                "enabled_download_phase": True,
                "enabled_upload_phase": False,
                "fail_closed": True,
                "notification_settings": {
                    "enabled": True,
                    "message": "you are blocked",
                    "support_url": "https://example.com/blocked",
                },
            },
            fips={
                "tls": True,
            },
            proxy={
                "tcp": True,
                "udp": True,
                "root_ca": True,
                "virtual_ip": False,
                "disable_for_time": 3600,
            },
            url_browser_isolation_enabled=True,
            logging={
                "redact_pii": True,
                "settings_by_rule_type": {
                    "dns": {
                        "log_all": False,
                        "log_blocks": True,
                    },
                    "http": {
                        "log_all": True,
                        "log_blocks": True,
                    },
                    "l4": {
                        "log_all": False,
                        "log_blocks": True,
                    },
                },
            },
            extended_email_matching={
                "enabled": True,
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustGatewaySettings:ZeroTrustGatewaySettings example <account_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] activity_log_enabled: Whether to enable the activity log.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsAntivirusArgs', 'ZeroTrustGatewaySettingsAntivirusArgsDict']] antivirus: Configuration block for antivirus traffic scanning.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsBlockPageArgs', 'ZeroTrustGatewaySettingsBlockPageArgsDict']] block_page: Configuration for a custom block page.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsBodyScanningArgs', 'ZeroTrustGatewaySettingsBodyScanningArgsDict']] body_scanning: Configuration for body scanning.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsCertificateArgs', 'ZeroTrustGatewaySettingsCertificateArgsDict']] certificate: Configuration for TLS interception certificate. This will be required starting Feb 2025.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsCustomCertificateArgs', 'ZeroTrustGatewaySettingsCustomCertificateArgsDict']] custom_certificate: Configuration for custom certificates / BYO-PKI. Conflicts with `certificate`.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs', 'ZeroTrustGatewaySettingsExtendedEmailMatchingArgsDict']] extended_email_matching: Configuration for extended e-mail matching.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsFipsArgs', 'ZeroTrustGatewaySettingsFipsArgsDict']] fips: Configure compliance with Federal Information Processing Standards.
        :param pulumi.Input[bool] non_identity_browser_isolation_enabled: Enable non-identity onramp for Browser Isolation. Defaults to `false`.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsPayloadLogArgs', 'ZeroTrustGatewaySettingsPayloadLogArgsDict']] payload_log: Configuration for DLP Payload Logging.
        :param pulumi.Input[bool] protocol_detection_enabled: Indicator that protocol detection is enabled.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsProxyArgs', 'ZeroTrustGatewaySettingsProxyArgsDict']] proxy: Configuration block for specifying which protocols are proxied.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsSshSessionLogArgs', 'ZeroTrustGatewaySettingsSshSessionLogArgsDict']] ssh_session_log: Configuration for SSH Session Logging.
        :param pulumi.Input[bool] tls_decrypt_enabled: Indicator that decryption of TLS traffic is enabled.
        :param pulumi.Input[bool] url_browser_isolation_enabled: Safely browse websites in Browser Isolation through a URL. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustGatewaySettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Teams Account resource. The Teams Account
        resource defines configuration for secure web gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.ZeroTrustGatewaySettings("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            tls_decrypt_enabled=True,
            protocol_detection_enabled=True,
            block_page={
                "footer_text": "hello",
                "header_text": "hello",
                "logo_path": "https://example.com/logo.jpg",
                "background_color": "#000000",
            },
            body_scanning={
                "inspection_mode": "deep",
            },
            antivirus={
                "enabled_download_phase": True,
                "enabled_upload_phase": False,
                "fail_closed": True,
                "notification_settings": {
                    "enabled": True,
                    "message": "you are blocked",
                    "support_url": "https://example.com/blocked",
                },
            },
            fips={
                "tls": True,
            },
            proxy={
                "tcp": True,
                "udp": True,
                "root_ca": True,
                "virtual_ip": False,
                "disable_for_time": 3600,
            },
            url_browser_isolation_enabled=True,
            logging={
                "redact_pii": True,
                "settings_by_rule_type": {
                    "dns": {
                        "log_all": False,
                        "log_blocks": True,
                    },
                    "http": {
                        "log_all": True,
                        "log_blocks": True,
                    },
                    "l4": {
                        "log_all": False,
                        "log_blocks": True,
                    },
                },
            },
            extended_email_matching={
                "enabled": True,
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustGatewaySettings:ZeroTrustGatewaySettings example <account_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustGatewaySettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustGatewaySettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 activity_log_enabled: Optional[pulumi.Input[bool]] = None,
                 antivirus: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsAntivirusArgs', 'ZeroTrustGatewaySettingsAntivirusArgsDict']]] = None,
                 block_page: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsBlockPageArgs', 'ZeroTrustGatewaySettingsBlockPageArgsDict']]] = None,
                 body_scanning: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsBodyScanningArgs', 'ZeroTrustGatewaySettingsBodyScanningArgsDict']]] = None,
                 certificate: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsCertificateArgs', 'ZeroTrustGatewaySettingsCertificateArgsDict']]] = None,
                 custom_certificate: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsCustomCertificateArgs', 'ZeroTrustGatewaySettingsCustomCertificateArgsDict']]] = None,
                 extended_email_matching: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs', 'ZeroTrustGatewaySettingsExtendedEmailMatchingArgsDict']]] = None,
                 fips: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsFipsArgs', 'ZeroTrustGatewaySettingsFipsArgsDict']]] = None,
                 logging: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsLoggingArgs', 'ZeroTrustGatewaySettingsLoggingArgsDict']]] = None,
                 non_identity_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 payload_log: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsPayloadLogArgs', 'ZeroTrustGatewaySettingsPayloadLogArgsDict']]] = None,
                 protocol_detection_enabled: Optional[pulumi.Input[bool]] = None,
                 proxy: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsProxyArgs', 'ZeroTrustGatewaySettingsProxyArgsDict']]] = None,
                 ssh_session_log: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsSshSessionLogArgs', 'ZeroTrustGatewaySettingsSshSessionLogArgsDict']]] = None,
                 tls_decrypt_enabled: Optional[pulumi.Input[bool]] = None,
                 url_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustGatewaySettingsArgs.__new__(ZeroTrustGatewaySettingsArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["activity_log_enabled"] = activity_log_enabled
            __props__.__dict__["antivirus"] = antivirus
            __props__.__dict__["block_page"] = block_page
            __props__.__dict__["body_scanning"] = body_scanning
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["custom_certificate"] = custom_certificate
            __props__.__dict__["extended_email_matching"] = extended_email_matching
            __props__.__dict__["fips"] = fips
            __props__.__dict__["logging"] = logging
            __props__.__dict__["non_identity_browser_isolation_enabled"] = non_identity_browser_isolation_enabled
            __props__.__dict__["payload_log"] = payload_log
            __props__.__dict__["protocol_detection_enabled"] = protocol_detection_enabled
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["ssh_session_log"] = ssh_session_log
            __props__.__dict__["tls_decrypt_enabled"] = tls_decrypt_enabled
            __props__.__dict__["url_browser_isolation_enabled"] = url_browser_isolation_enabled
        super(ZeroTrustGatewaySettings, __self__).__init__(
            'cloudflare:index/zeroTrustGatewaySettings:ZeroTrustGatewaySettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            activity_log_enabled: Optional[pulumi.Input[bool]] = None,
            antivirus: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsAntivirusArgs', 'ZeroTrustGatewaySettingsAntivirusArgsDict']]] = None,
            block_page: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsBlockPageArgs', 'ZeroTrustGatewaySettingsBlockPageArgsDict']]] = None,
            body_scanning: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsBodyScanningArgs', 'ZeroTrustGatewaySettingsBodyScanningArgsDict']]] = None,
            certificate: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsCertificateArgs', 'ZeroTrustGatewaySettingsCertificateArgsDict']]] = None,
            custom_certificate: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsCustomCertificateArgs', 'ZeroTrustGatewaySettingsCustomCertificateArgsDict']]] = None,
            extended_email_matching: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs', 'ZeroTrustGatewaySettingsExtendedEmailMatchingArgsDict']]] = None,
            fips: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsFipsArgs', 'ZeroTrustGatewaySettingsFipsArgsDict']]] = None,
            logging: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsLoggingArgs', 'ZeroTrustGatewaySettingsLoggingArgsDict']]] = None,
            non_identity_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None,
            payload_log: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsPayloadLogArgs', 'ZeroTrustGatewaySettingsPayloadLogArgsDict']]] = None,
            protocol_detection_enabled: Optional[pulumi.Input[bool]] = None,
            proxy: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsProxyArgs', 'ZeroTrustGatewaySettingsProxyArgsDict']]] = None,
            ssh_session_log: Optional[pulumi.Input[Union['ZeroTrustGatewaySettingsSshSessionLogArgs', 'ZeroTrustGatewaySettingsSshSessionLogArgsDict']]] = None,
            tls_decrypt_enabled: Optional[pulumi.Input[bool]] = None,
            url_browser_isolation_enabled: Optional[pulumi.Input[bool]] = None) -> 'ZeroTrustGatewaySettings':
        """
        Get an existing ZeroTrustGatewaySettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] activity_log_enabled: Whether to enable the activity log.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsAntivirusArgs', 'ZeroTrustGatewaySettingsAntivirusArgsDict']] antivirus: Configuration block for antivirus traffic scanning.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsBlockPageArgs', 'ZeroTrustGatewaySettingsBlockPageArgsDict']] block_page: Configuration for a custom block page.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsBodyScanningArgs', 'ZeroTrustGatewaySettingsBodyScanningArgsDict']] body_scanning: Configuration for body scanning.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsCertificateArgs', 'ZeroTrustGatewaySettingsCertificateArgsDict']] certificate: Configuration for TLS interception certificate. This will be required starting Feb 2025.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsCustomCertificateArgs', 'ZeroTrustGatewaySettingsCustomCertificateArgsDict']] custom_certificate: Configuration for custom certificates / BYO-PKI. Conflicts with `certificate`.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsExtendedEmailMatchingArgs', 'ZeroTrustGatewaySettingsExtendedEmailMatchingArgsDict']] extended_email_matching: Configuration for extended e-mail matching.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsFipsArgs', 'ZeroTrustGatewaySettingsFipsArgsDict']] fips: Configure compliance with Federal Information Processing Standards.
        :param pulumi.Input[bool] non_identity_browser_isolation_enabled: Enable non-identity onramp for Browser Isolation. Defaults to `false`.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsPayloadLogArgs', 'ZeroTrustGatewaySettingsPayloadLogArgsDict']] payload_log: Configuration for DLP Payload Logging.
        :param pulumi.Input[bool] protocol_detection_enabled: Indicator that protocol detection is enabled.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsProxyArgs', 'ZeroTrustGatewaySettingsProxyArgsDict']] proxy: Configuration block for specifying which protocols are proxied.
        :param pulumi.Input[Union['ZeroTrustGatewaySettingsSshSessionLogArgs', 'ZeroTrustGatewaySettingsSshSessionLogArgsDict']] ssh_session_log: Configuration for SSH Session Logging.
        :param pulumi.Input[bool] tls_decrypt_enabled: Indicator that decryption of TLS traffic is enabled.
        :param pulumi.Input[bool] url_browser_isolation_enabled: Safely browse websites in Browser Isolation through a URL. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustGatewaySettingsState.__new__(_ZeroTrustGatewaySettingsState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["activity_log_enabled"] = activity_log_enabled
        __props__.__dict__["antivirus"] = antivirus
        __props__.__dict__["block_page"] = block_page
        __props__.__dict__["body_scanning"] = body_scanning
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["custom_certificate"] = custom_certificate
        __props__.__dict__["extended_email_matching"] = extended_email_matching
        __props__.__dict__["fips"] = fips
        __props__.__dict__["logging"] = logging
        __props__.__dict__["non_identity_browser_isolation_enabled"] = non_identity_browser_isolation_enabled
        __props__.__dict__["payload_log"] = payload_log
        __props__.__dict__["protocol_detection_enabled"] = protocol_detection_enabled
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["ssh_session_log"] = ssh_session_log
        __props__.__dict__["tls_decrypt_enabled"] = tls_decrypt_enabled
        __props__.__dict__["url_browser_isolation_enabled"] = url_browser_isolation_enabled
        return ZeroTrustGatewaySettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="activityLogEnabled")
    def activity_log_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable the activity log.
        """
        return pulumi.get(self, "activity_log_enabled")

    @property
    @pulumi.getter
    def antivirus(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsAntivirus']]:
        """
        Configuration block for antivirus traffic scanning.
        """
        return pulumi.get(self, "antivirus")

    @property
    @pulumi.getter(name="blockPage")
    def block_page(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsBlockPage']]:
        """
        Configuration for a custom block page.
        """
        return pulumi.get(self, "block_page")

    @property
    @pulumi.getter(name="bodyScanning")
    def body_scanning(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsBodyScanning']]:
        """
        Configuration for body scanning.
        """
        return pulumi.get(self, "body_scanning")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsCertificate']]:
        """
        Configuration for TLS interception certificate. This will be required starting Feb 2025.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="customCertificate")
    @_utilities.deprecated("""Use `certificate` instead. Continuing to use custom_certificate may result in inconsistent configuration.""")
    def custom_certificate(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsCustomCertificate']]:
        """
        Configuration for custom certificates / BYO-PKI. Conflicts with `certificate`.
        """
        return pulumi.get(self, "custom_certificate")

    @property
    @pulumi.getter(name="extendedEmailMatching")
    def extended_email_matching(self) -> pulumi.Output['outputs.ZeroTrustGatewaySettingsExtendedEmailMatching']:
        """
        Configuration for extended e-mail matching.
        """
        return pulumi.get(self, "extended_email_matching")

    @property
    @pulumi.getter
    def fips(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsFips']]:
        """
        Configure compliance with Federal Information Processing Standards.
        """
        return pulumi.get(self, "fips")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsLogging']]:
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="nonIdentityBrowserIsolationEnabled")
    def non_identity_browser_isolation_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable non-identity onramp for Browser Isolation. Defaults to `false`.
        """
        return pulumi.get(self, "non_identity_browser_isolation_enabled")

    @property
    @pulumi.getter(name="payloadLog")
    def payload_log(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsPayloadLog']]:
        """
        Configuration for DLP Payload Logging.
        """
        return pulumi.get(self, "payload_log")

    @property
    @pulumi.getter(name="protocolDetectionEnabled")
    def protocol_detection_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicator that protocol detection is enabled.
        """
        return pulumi.get(self, "protocol_detection_enabled")

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsProxy']]:
        """
        Configuration block for specifying which protocols are proxied.
        """
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter(name="sshSessionLog")
    def ssh_session_log(self) -> pulumi.Output[Optional['outputs.ZeroTrustGatewaySettingsSshSessionLog']]:
        """
        Configuration for SSH Session Logging.
        """
        return pulumi.get(self, "ssh_session_log")

    @property
    @pulumi.getter(name="tlsDecryptEnabled")
    def tls_decrypt_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicator that decryption of TLS traffic is enabled.
        """
        return pulumi.get(self, "tls_decrypt_enabled")

    @property
    @pulumi.getter(name="urlBrowserIsolationEnabled")
    def url_browser_isolation_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Safely browse websites in Browser Isolation through a URL. Defaults to `false`.
        """
        return pulumi.get(self, "url_browser_isolation_enabled")

