# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustInfrastructureAccessTargetArgs', 'ZeroTrustInfrastructureAccessTarget']

@pulumi.input_type
class ZeroTrustInfrastructureAccessTargetArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 hostname: pulumi.Input[str],
                 ip: pulumi.Input['ZeroTrustInfrastructureAccessTargetIpArgs']):
        """
        The set of arguments for constructing a ZeroTrustInfrastructureAccessTarget resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] hostname: A non-unique field that refers to a target.
        :param pulumi.Input['ZeroTrustInfrastructureAccessTargetIpArgs'] ip: The IPv4/IPv6 address that identifies where to reach a target.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        A non-unique field that refers to a target.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input['ZeroTrustInfrastructureAccessTargetIpArgs']:
        """
        The IPv4/IPv6 address that identifies where to reach a target.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input['ZeroTrustInfrastructureAccessTargetIpArgs']):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class _ZeroTrustInfrastructureAccessTargetState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input['ZeroTrustInfrastructureAccessTargetIpArgs']] = None,
                 modified_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustInfrastructureAccessTarget resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] created_at: The date and time at which the target was created.
        :param pulumi.Input[str] hostname: A non-unique field that refers to a target.
        :param pulumi.Input['ZeroTrustInfrastructureAccessTargetIpArgs'] ip: The IPv4/IPv6 address that identifies where to reach a target.
        :param pulumi.Input[str] modified_at: The date and time at which the target was last modified.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which the target was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        A non-unique field that refers to a target.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['ZeroTrustInfrastructureAccessTargetIpArgs']]:
        """
        The IPv4/IPv6 address that identifies where to reach a target.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['ZeroTrustInfrastructureAccessTargetIpArgs']]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which the target was last modified.
        """
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_at", value)


class ZeroTrustInfrastructureAccessTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[Union['ZeroTrustInfrastructureAccessTargetIpArgs', 'ZeroTrustInfrastructureAccessTargetIpArgsDict']]] = None,
                 __props__=None):
        """
        The [Infrastructure Access Target](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/use-cases/ssh/ssh-infrastructure-access/#4-add-a-target) resource allows you to configure Infrastructure Access Targets for an account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.ZeroTrustInfrastructureAccessTarget("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            hostname="example-target",
            ip={
                "ipv4": {
                    "ip_addr": "198.51.100.1",
                    "virtual_network_id": "238dccd1-149b-463d-8228-560ab83a54fd",
                },
                "ipv6": {
                    "ip_addr": "2001:db8::",
                    "virtual_network_id": "238dccd1-149b-463d-8228-560ab83a54fd",
                },
            })
        ipv4_only_example = cloudflare.ZeroTrustInfrastructureAccessTarget("ipv4_only_example",
            account_id="f037e56e89293a057740de681ac9abbe",
            hostname="example-ipv4-only",
            ip={
                "ipv4": {
                    "ip_addr": "198.51.100.1",
                    "virtual_network_id": "238dccd1-149b-463d-8228-560ab83a54fd",
                },
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustInfrastructureAccessTarget:ZeroTrustInfrastructureAccessTarget example <account_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] hostname: A non-unique field that refers to a target.
        :param pulumi.Input[Union['ZeroTrustInfrastructureAccessTargetIpArgs', 'ZeroTrustInfrastructureAccessTargetIpArgsDict']] ip: The IPv4/IPv6 address that identifies where to reach a target.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustInfrastructureAccessTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The [Infrastructure Access Target](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/use-cases/ssh/ssh-infrastructure-access/#4-add-a-target) resource allows you to configure Infrastructure Access Targets for an account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example = cloudflare.ZeroTrustInfrastructureAccessTarget("example",
            account_id="f037e56e89293a057740de681ac9abbe",
            hostname="example-target",
            ip={
                "ipv4": {
                    "ip_addr": "198.51.100.1",
                    "virtual_network_id": "238dccd1-149b-463d-8228-560ab83a54fd",
                },
                "ipv6": {
                    "ip_addr": "2001:db8::",
                    "virtual_network_id": "238dccd1-149b-463d-8228-560ab83a54fd",
                },
            })
        ipv4_only_example = cloudflare.ZeroTrustInfrastructureAccessTarget("ipv4_only_example",
            account_id="f037e56e89293a057740de681ac9abbe",
            hostname="example-ipv4-only",
            ip={
                "ipv4": {
                    "ip_addr": "198.51.100.1",
                    "virtual_network_id": "238dccd1-149b-463d-8228-560ab83a54fd",
                },
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustInfrastructureAccessTarget:ZeroTrustInfrastructureAccessTarget example <account_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustInfrastructureAccessTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustInfrastructureAccessTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[Union['ZeroTrustInfrastructureAccessTargetIpArgs', 'ZeroTrustInfrastructureAccessTargetIpArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustInfrastructureAccessTargetArgs.__new__(ZeroTrustInfrastructureAccessTargetArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if ip is None and not opts.urn:
                raise TypeError("Missing required property 'ip'")
            __props__.__dict__["ip"] = ip
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
        super(ZeroTrustInfrastructureAccessTarget, __self__).__init__(
            'cloudflare:index/zeroTrustInfrastructureAccessTarget:ZeroTrustInfrastructureAccessTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            ip: Optional[pulumi.Input[Union['ZeroTrustInfrastructureAccessTargetIpArgs', 'ZeroTrustInfrastructureAccessTargetIpArgsDict']]] = None,
            modified_at: Optional[pulumi.Input[str]] = None) -> 'ZeroTrustInfrastructureAccessTarget':
        """
        Get an existing ZeroTrustInfrastructureAccessTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] created_at: The date and time at which the target was created.
        :param pulumi.Input[str] hostname: A non-unique field that refers to a target.
        :param pulumi.Input[Union['ZeroTrustInfrastructureAccessTargetIpArgs', 'ZeroTrustInfrastructureAccessTargetIpArgsDict']] ip: The IPv4/IPv6 address that identifies where to reach a target.
        :param pulumi.Input[str] modified_at: The date and time at which the target was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustInfrastructureAccessTargetState.__new__(_ZeroTrustInfrastructureAccessTargetState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ip"] = ip
        __props__.__dict__["modified_at"] = modified_at
        return ZeroTrustInfrastructureAccessTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time at which the target was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        A non-unique field that refers to a target.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output['outputs.ZeroTrustInfrastructureAccessTargetIp']:
        """
        The IPv4/IPv6 address that identifies where to reach a target.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[str]:
        """
        The date and time at which the target was last modified.
        """
        return pulumi.get(self, "modified_at")

